/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.FinalUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MakeFieldStaticFinalFix
extends PsiUpdateModCommandQuickFix {
    private final String fieldName;

    private MakeFieldStaticFinalFix(String fieldName) {
        this.fieldName = fieldName;
    }

    @NotNull
    public static LocalQuickFix buildFixUnconditional(@NotNull PsiField field) {
        if (field == null) {
            MakeFieldStaticFinalFix.$$$reportNull$$$0(0);
        }
        return new MakeFieldStaticFinalFix(field.getName());
    }

    @Nullable
    public static LocalQuickFix buildFix(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer == null) {
            return null;
        }
        if (!FinalUtils.canBeFinal((PsiVariable)field)) {
            return null;
        }
        return new MakeFieldStaticFinalFix(field.getName());
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("make.static.final.quickfix", this.fieldName);
        if (string == null) {
            MakeFieldStaticFinalFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("make.field.static.final.fix.family.name", new Object[0]);
        if (string == null) {
            MakeFieldStaticFinalFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiElement parent;
        if (project == null) {
            MakeFieldStaticFinalFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            MakeFieldStaticFinalFix.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            MakeFieldStaticFinalFix.$$$reportNull$$$0(5);
        }
        if (!((parent = element.getParent()) instanceof PsiField)) {
            return;
        }
        PsiField field = (PsiField)parent;
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList == null) {
            return;
        }
        modifierList.setModifierProperty("final", true);
        modifierList.setModifierProperty("static", true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/MakeFieldStaticFinalFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/MakeFieldStaticFinalFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFixUnconditional";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

