/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.stream.IntStream;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;

public class RemoveRedundantPolyadicOperandFix
extends PsiUpdateModCommandQuickFix {
    private final String myExpressionText;

    public RemoveRedundantPolyadicOperandFix(String expressionText) {
        this.myExpressionText = expressionText;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("remove.redundant.polyadic.operand.fix.name", this.myExpressionText);
        if (string == null) {
            RemoveRedundantPolyadicOperandFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("remove.redundant.polyadic.operand.fix.family.name", new Object[0]);
        if (string == null) {
            RemoveRedundantPolyadicOperandFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiPolyadicExpression polyadicExpression;
        if (project == null) {
            RemoveRedundantPolyadicOperandFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            RemoveRedundantPolyadicOperandFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            RemoveRedundantPolyadicOperandFix.$$$reportNull$$$0(4);
        }
        if ((polyadicExpression = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiPolyadicExpression.class)) == null) {
            return;
        }
        Object[] children = polyadicExpression.getChildren();
        int start = IntStreamEx.ofIndices((Object[])children, child -> PsiTreeUtil.isAncestor((PsiElement)child, (PsiElement)element, (boolean)false)).findFirst().orElse(-1);
        if (start == -1) {
            return;
        }
        int end = IntStreamEx.range((int)(start + 1), (int)children.length).findFirst(arg_0 -> RemoveRedundantPolyadicOperandFix.lambda$applyFix$1((PsiElement[])children, arg_0)).orElse(-1);
        if (end == -1) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        String replacement = IntStreamEx.range((int)0, (int)start).append((IntStream)IntStreamEx.range((int)end, (int)children.length)).elements(children).map(ct::text).joining();
        ct.replaceAndRestoreComments((PsiElement)polyadicExpression, replacement);
    }

    private static /* synthetic */ boolean lambda$applyFix$1(PsiElement[] children, int idx) {
        return children[idx] instanceof PsiExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/fixes/RemoveRedundantPolyadicOperandFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/fixes/RemoveRedundantPolyadicOperandFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

