/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiForeachStatementBase;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeParameterExtendsFinalClassInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer problemType = (Integer)infos[1];
        PsiClass aClass = (PsiClass)infos[0];
        String name = aClass.getName();
        if (problemType == 1) {
            String string = InspectionGadgetsBundle.message(aClass.isEnum() ? "type.parameter.extends.enum.type.parameter.problem.descriptor" : "type.parameter.extends.final.class.type.parameter.problem.descriptor", name);
            if (string == null) {
                TypeParameterExtendsFinalClassInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message(aClass.isEnum() ? "type.parameter.extends.enum.wildcard.problem.descriptor" : "type.parameter.extends.final.class.wildcard.problem.descriptor", name);
        if (string == null) {
            TypeParameterExtendsFinalClassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new TypeParameterExtendsFinalClassFix();
    }

    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.GENERICS);
        if (set == null) {
            TypeParameterExtendsFinalClassInspection.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new TypeParameterExtendsFinalClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class TypeParameterExtendsFinalClassFix
    extends PsiUpdateModCommandQuickFix {
        private TypeParameterExtendsFinalClassFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("type.parameter.extends.final.class.quickfix", new Object[0]);
            if (string == null) {
                TypeParameterExtendsFinalClassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                TypeParameterExtendsFinalClassFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                TypeParameterExtendsFinalClassFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                TypeParameterExtendsFinalClassFix.$$$reportNull$$$0(3);
            }
            if ((parent = element.getParent()) instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)parent;
                TypeParameterExtendsFinalClassFix.replaceTypeParameterUsagesWithType(typeParameter);
                new CommentTracker().deleteAndRestoreComments((PsiElement)typeParameter);
            } else if (parent instanceof PsiTypeElement) {
                PsiTypeElement typeElement = (PsiTypeElement)parent;
                PsiElement lastChild = typeElement.getLastChild();
                if (lastChild == null) {
                    return;
                }
                new CommentTracker().replaceAndRestoreComments((PsiElement)typeElement, lastChild);
            }
        }

        private static void replaceTypeParameterUsagesWithType(PsiTypeParameter typeParameter) {
            PsiClassType[] types = typeParameter.getExtendsList().getReferencedTypes();
            if (types.length < 1) {
                return;
            }
            Project project = typeParameter.getProject();
            PsiJavaCodeReferenceElement classReference = JavaPsiFacade.getElementFactory((Project)project).createReferenceElementByType(types[0]);
            Query query = ReferencesSearch.search((PsiElement)typeParameter, (SearchScope)typeParameter.getUseScope());
            for (PsiReference reference : query.asIterable()) {
                PsiElement referenceElement = reference.getElement();
                referenceElement.replace((PsiElement)classReference);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection$TypeParameterExtendsFinalClassFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection$TypeParameterExtendsFinalClassFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class TypeParameterExtendsFinalClassVisitor
    extends BaseInspectionVisitor {
        private TypeParameterExtendsFinalClassVisitor() {
        }

        public void visitTypeParameter(@NotNull PsiTypeParameter classParameter) {
            if (classParameter == null) {
                TypeParameterExtendsFinalClassVisitor.$$$reportNull$$$0(0);
            }
            super.visitTypeParameter(classParameter);
            PsiClassType[] extendsListTypes = classParameter.getExtendsListTypes();
            if (extendsListTypes.length < 1) {
                return;
            }
            PsiClassType extendsType = extendsListTypes[0];
            PsiClass aClass = extendsType.resolve();
            if (aClass == null) {
                return;
            }
            if (!aClass.hasModifierProperty("final") && !aClass.isEnum()) {
                return;
            }
            PsiIdentifier nameIdentifier = classParameter.getNameIdentifier();
            if (nameIdentifier != null) {
                this.registerError((PsiElement)nameIdentifier, aClass, 1);
            }
        }

        public void visitTypeElement(@NotNull PsiTypeElement typeElement) {
            if (typeElement == null) {
                TypeParameterExtendsFinalClassVisitor.$$$reportNull$$$0(1);
            }
            super.visitTypeElement(typeElement);
            PsiType type = typeElement.getType();
            if (!(type instanceof PsiWildcardType)) {
                return;
            }
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            PsiType extendsBound = wildcardType.getExtendsBound();
            if (!(extendsBound instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)extendsBound;
            for (PsiType typeParameter : classType.getParameters()) {
                if (!(typeParameter instanceof PsiWildcardType)) continue;
                return;
            }
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return;
            }
            if (!aClass.hasModifierProperty("final") && !aClass.isEnum()) {
                return;
            }
            if (aClass.hasTypeParameters() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)typeElement)) {
                PsiType[] parameters = classType.getParameters();
                if (parameters.length == 0) {
                    return;
                }
                for (PsiType parameter : parameters) {
                    if (!(parameter instanceof PsiWildcardType)) continue;
                    return;
                }
            }
            if (TypeParameterExtendsFinalClassVisitor.isWildcardRequired(typeElement)) {
                return;
            }
            this.registerError(typeElement.getFirstChild(), aClass, 2);
        }

        private static boolean isWildcardRequired(PsiTypeElement typeElement) {
            PsiElement ancestor = PsiTreeUtil.skipParentsOfType((PsiElement)typeElement, (Class[])new Class[]{PsiTypeElement.class, PsiJavaCodeReferenceElement.class, PsiReferenceParameterList.class});
            if (ancestor instanceof PsiDeconstructionPattern) {
                PsiDeconstructionPattern deconstructionPattern = (PsiDeconstructionPattern)ancestor;
                PsiForeachStatementBase parentForEach = (PsiForeachStatementBase)PsiTreeUtil.getParentOfType((PsiElement)deconstructionPattern, PsiForeachStatementBase.class, (boolean)false, (Class[])new Class[]{PsiStatement.class});
                if (parentForEach == null) {
                    return false;
                }
                PsiElement psiElement = ancestor.getParent();
                if (psiElement instanceof PsiForeachStatementBase) {
                    PsiForeachStatementBase foreachStatement = (PsiForeachStatementBase)psiElement;
                    PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                    if (iteratedValue == null) {
                        return false;
                    }
                    return TypeParameterExtendsFinalClassVisitor.isWildcardRequired(typeElement, deconstructionPattern.getTypeElement(), JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue));
                }
                if (deconstructionPattern.getParent() instanceof PsiDeconstructionList) {
                    PsiType type = JavaPsiPatternUtil.getDeconstructedImplicitPatternType((PsiPattern)deconstructionPattern);
                    if (type == null) {
                        return false;
                    }
                    return TypeParameterExtendsFinalClassVisitor.isWildcardRequired(typeElement, deconstructionPattern.getTypeElement(), type);
                }
            } else if (ancestor instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)ancestor;
                PsiElement scope = parameter.getDeclarationScope();
                if (scope instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)scope;
                    if (MethodUtils.hasSuper(method)) {
                        return true;
                    }
                } else {
                    if (scope instanceof PsiLambdaExpression) {
                        return true;
                    }
                    if (scope instanceof PsiForeachStatementBase) {
                        PsiForeachStatementBase foreachStatement = (PsiForeachStatementBase)scope;
                        PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                        if (iteratedValue == null) {
                            return true;
                        }
                        if (scope instanceof PsiForeachStatement) {
                            PsiForeachStatement normalForeach = (PsiForeachStatement)scope;
                            PsiParameter iterationParameter = normalForeach.getIterationParameter();
                            PsiTypeElement foreachTypeElement = iterationParameter.getTypeElement();
                            assert (foreachTypeElement != null);
                            return TypeParameterExtendsFinalClassVisitor.isWildcardRequired(typeElement, foreachTypeElement, JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue));
                        }
                        if (ancestor instanceof PsiPatternVariable) {
                            PsiPatternVariable patternVariable = (PsiPatternVariable)ancestor;
                            PsiType type = JavaPsiPatternUtil.getDeconstructedImplicitPatternVariableType((PsiPatternVariable)patternVariable);
                            if (type == null) {
                                return true;
                            }
                            return TypeParameterExtendsFinalClassVisitor.isWildcardRequired(typeElement, patternVariable.getTypeElement(), type);
                        }
                    }
                }
            } else if (ancestor instanceof PsiLocalVariable) {
                PsiLocalVariable localVariable = (PsiLocalVariable)ancestor;
                PsiExpression initializer = localVariable.getInitializer();
                return initializer != null && TypeParameterExtendsFinalClassVisitor.isWildcardRequired(typeElement, localVariable.getTypeElement(), initializer.getType());
            }
            return false;
        }

        private static boolean isWildcardRequired(PsiTypeElement innerTypeElement, PsiTypeElement completeTypeElement, PsiType rhsType) {
            PsiType lhsType = completeTypeElement.getType();
            if (lhsType.equals(rhsType) || rhsType == null || !TypeConversionUtil.isAssignable((PsiType)lhsType, (PsiType)rhsType)) {
                return true;
            }
            Object marker = new Object();
            PsiTreeUtil.mark((PsiElement)innerTypeElement, (Object)marker);
            PsiTypeElement copy = (PsiTypeElement)completeTypeElement.copy();
            PsiElement markedElement = PsiTreeUtil.releaseMark((PsiElement)copy, (Object)marker);
            assert (markedElement != null);
            markedElement.replace(markedElement.getLastChild());
            return !TypeConversionUtil.isAssignable((PsiType)copy.getType(), (PsiType)rhsType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classParameter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeElement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/inheritance/TypeParameterExtendsFinalClassInspection$TypeParameterExtendsFinalClassVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeParameter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

