/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PrivateMemberAccessBetweenOuterAndInnerClassInspection
extends BaseInspection {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "SyntheticAccessorCall";
    }

    @Nullable
    public String getAlternativeID() {
        return "PrivateMemberAccessBetweenOuterAndInnerClass";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.problem.descriptor", aClass.getName());
        if (string == null) {
            PrivateMemberAccessBetweenOuterAndInnerClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String className = aClass.getName();
        if (infos.length == 1) {
            return new MakePackagePrivateFix(className, true);
        }
        PsiMember member = (PsiMember)infos[1];
        @NonNls Object memberName = member instanceof PsiMethod ? member.getName() + "()" : member.getName();
        @NonNls String elementName = className + "." + (String)memberName;
        return new MakePackagePrivateFix(elementName, false);
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            PrivateMemberAccessBetweenOuterAndInnerClassInspection.$$$reportNull$$$0(1);
        }
        if (FileTypeUtils.isInServerPageFile((PsiElement)file)) {
            return false;
        }
        return !PsiUtil.isAvailable((JavaFeature)JavaFeature.NESTMATES, (PsiElement)file);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new PrivateMemberAccessFromInnerClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static final class MakePackagePrivateFix
    extends PsiUpdateModCommandQuickFix {
        private final String elementName;
        private final boolean constructor;

        private MakePackagePrivateFix(String elementName, boolean constructor) {
            this.elementName = elementName;
            this.constructor = constructor;
        }

        @NotNull
        public String getName() {
            if (this.constructor) {
                String string = InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.make.constructor.package.local.quickfix", this.elementName);
                if (string == null) {
                    MakePackagePrivateFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.make.local.quickfix", this.elementName);
            if (string == null) {
                MakePackagePrivateFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("make.package.private.fix.family.name", new Object[0]);
            if (string == null) {
                MakePackagePrivateFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                MakePackagePrivateFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                MakePackagePrivateFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                MakePackagePrivateFix.$$$reportNull$$$0(5);
            }
            if (this.constructor) {
                MakePackagePrivateFix.makeConstructorPackageLocal(project, element);
            } else {
                MakePackagePrivateFix.makeMemberPackageLocal(element);
            }
        }

        private static void makeMemberPackageLocal(PsiElement element) {
            PsiElement parent = element.getParent();
            PsiReferenceExpression reference = (PsiReferenceExpression)parent;
            PsiModifierListOwner member = (PsiModifierListOwner)reference.resolve();
            if (member == null) {
                return;
            }
            PsiModifierList modifiers = member.getModifierList();
            if (modifiers == null) {
                return;
            }
            modifiers.setModifierProperty("public", false);
            modifiers.setModifierProperty("protected", false);
            modifiers.setModifierProperty("private", false);
        }

        private static void makeConstructorPackageLocal(Project project, PsiElement element) {
            PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
            if (newExpression == null) {
                return;
            }
            PsiMethod constructor = newExpression.resolveConstructor();
            if (constructor != null) {
                PsiModifierList modifierList = constructor.getModifierList();
                modifierList.setModifierProperty("private", false);
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
            PsiElement target = referenceElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiMethod newConstructor = elementFactory.createConstructor();
            PsiModifierList modifierList = newConstructor.getModifierList();
            modifierList.setModifierProperty("packageLocal", true);
            aClass.add((PsiElement)newConstructor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection$MakePackagePrivateFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection$MakePackagePrivateFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PrivateMemberAccessFromInnerClassVisitor
    extends BaseInspectionVisitor {
        private PrivateMemberAccessFromInnerClassVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiClass aClass;
            if (expression == null) {
                PrivateMemberAccessFromInnerClassVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression);
            if (expression.getType() instanceof PsiArrayType) {
                return;
            }
            PsiMethod constructor = expression.resolveMethod();
            if (constructor == null) {
                PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
                if (classReference == null) {
                    return;
                }
                PsiElement target = classReference.resolve();
                if (!(target instanceof PsiClass)) {
                    return;
                }
                aClass = (PsiClass)target;
                if (aClass.isInterface() || !aClass.hasModifierProperty("private")) {
                    return;
                }
            } else {
                if (!constructor.hasModifierProperty("private")) {
                    return;
                }
                aClass = constructor.getContainingClass();
            }
            if (!PrivateMemberAccessFromInnerClassVisitor.isInnerClassAccess((PsiExpression)expression, aClass)) {
                return;
            }
            this.registerNewExpressionError(expression, aClass);
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                PrivateMemberAccessFromInnerClassVisitor.$$$reportNull$$$0(1);
            }
            super.visitReferenceExpression(expression);
            PsiElement referenceNameElement = expression.getReferenceNameElement();
            if (referenceNameElement == null) {
                return;
            }
            JavaResolveResult resolveResult = expression.advancedResolve(false);
            if (!resolveResult.isAccessible()) {
                return;
            }
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiMethod) && !(element instanceof PsiField)) {
                return;
            }
            PsiMember member = (PsiMember)element;
            if (!member.hasModifierProperty("private")) {
                return;
            }
            Object value = ExpressionUtils.computeConstantExpression((PsiExpression)expression);
            if (value != null) {
                return;
            }
            PsiClass memberClass = member.getContainingClass();
            if (!PrivateMemberAccessFromInnerClassVisitor.isInnerClassAccess((PsiExpression)expression, memberClass)) {
                return;
            }
            this.registerError(referenceNameElement, memberClass, member);
        }

        private static boolean isInnerClassAccess(PsiExpression reference, PsiClass targetClass) {
            PsiClass sourceClass = PsiUtil.getContainingClass((PsiElement)reference);
            return sourceClass != null && targetClass != null && sourceClass != targetClass && PsiUtil.getTopLevelClass((PsiElement)sourceClass) == PsiUtil.getTopLevelClass((PsiElement)targetClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/j2me/PrivateMemberAccessBetweenOuterAndInnerClassInspection$PrivateMemberAccessFromInnerClassVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

