/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javabeans;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtilBase;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class FieldHasSetterButNoGetterInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("field.has.setter.but.no.getter.problem.descriptor", new Object[0]);
        if (string == null) {
            FieldHasSetterButNoGetterInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new FieldHasSetterButNoGetterVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javabeans/FieldHasSetterButNoGetterInspection", "buildErrorString"));
    }

    private static class FieldHasSetterButNoGetterVisitor
    extends BaseInspectionVisitor {
        private FieldHasSetterButNoGetterVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                FieldHasSetterButNoGetterVisitor.$$$reportNull$$$0(0);
            }
            String propertyName = PropertyUtilBase.suggestPropertyName((PsiField)field);
            boolean isStatic = field.hasModifierProperty("static");
            PsiClass containingClass = field.getContainingClass();
            PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)containingClass, (String)propertyName, (boolean)isStatic, (boolean)false);
            if (setter == null) {
                return;
            }
            PsiMethod getter = PropertyUtilBase.findPropertyGetter((PsiClass)containingClass, (String)propertyName, (boolean)isStatic, (boolean)false);
            if (getter != null) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/javabeans/FieldHasSetterButNoGetterInspection$FieldHasSetterButNoGetterVisitor", "visitField"));
        }
    }
}

