/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandBatchQuickFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class HtmlTagCanBeJavadocTagInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("html.tag.can.be.javadoc.tag.problem.descriptor", new Object[0]);
        if (string == null) {
            HtmlTagCanBeJavadocTagInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new HtmlTagCanBeJavaDocTagFix();
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            HtmlTagCanBeJavadocTagInspection.$$$reportNull$$$0(1);
        }
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new HtmlTagCanBeJavaDocTagVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/javadoc/HtmlTagCanBeJavadocTagInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/javadoc/HtmlTagCanBeJavadocTagInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class HtmlTagCanBeJavaDocTagFix
    extends ModCommandBatchQuickFix {
        private HtmlTagCanBeJavaDocTagFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"{@code ...}"});
            if (string == null) {
                HtmlTagCanBeJavaDocTagFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public ModCommand perform(@NotNull Project project, @NotNull List<ProblemDescriptor> descriptors) {
            if (project == null) {
                HtmlTagCanBeJavaDocTagFix.$$$reportNull$$$0(1);
            }
            if (descriptors == null) {
                HtmlTagCanBeJavaDocTagFix.$$$reportNull$$$0(2);
            }
            ModCommand modCommand = ModCommand.psiUpdate((ActionContext)ActionContext.from((ProblemDescriptor)descriptors.get(0)), updater -> {
                record FixData(PsiElement element, TextRange textRange) {
                }
                List data = ContainerUtil.map((Collection)descriptors, d -> new FixData(updater.getWritable(d.getPsiElement()), d.getTextRangeInElement()));
                data.forEach(d -> HtmlTagCanBeJavaDocTagFix.applyFix(updater.getWritable(d.element), d.textRange));
            });
            if (modCommand == null) {
                HtmlTagCanBeJavaDocTagFix.$$$reportNull$$$0(3);
            }
            return modCommand;
        }

        private static void applyFix(@NotNull PsiElement element, @NotNull TextRange range) {
            if (element == null) {
                HtmlTagCanBeJavaDocTagFix.$$$reportNull$$$0(4);
            }
            if (range == null) {
                HtmlTagCanBeJavaDocTagFix.$$$reportNull$$$0(5);
            }
            PsiFile file = element.getContainingFile();
            Document document = file.getFileDocument();
            int startOffset = range.getStartOffset();
            int replaceStartOffset = element.getTextOffset() + startOffset;
            int startTag = range.getEndOffset();
            @NonNls String text = element.getText();
            if (!"<code>".equalsIgnoreCase(text.substring(startOffset, startTag))) {
                return;
            }
            @NonNls StringBuilder newCommentText = new StringBuilder("{@code");
            int endTag = StringUtil.indexOfIgnoreCase((String)text, (String)"</code>", (int)startTag);
            while (endTag < 0) {
                HtmlTagCanBeJavaDocTagFix.appendElementText(text, startTag, text.length(), newCommentText);
                element = element.getNextSibling();
                if (element == null) {
                    return;
                }
                startTag = 0;
                text = element.getText();
                endTag = StringUtil.indexOfIgnoreCase((String)text, (String)"</code>", (int)0);
            }
            HtmlTagCanBeJavaDocTagFix.appendElementText(text, startTag, endTag, newCommentText);
            newCommentText.append('}');
            int replaceEndOffset = element.getTextOffset() + endTag + 7;
            String oldText = document.getText(new TextRange(replaceStartOffset, replaceEndOffset));
            if (!StringUtil.startsWithIgnoreCase((String)oldText, (String)"<code>") || !StringUtil.endsWithIgnoreCase((String)oldText, (String)"</code>")) {
                return;
            }
            document.replaceString(replaceStartOffset, replaceEndOffset, (CharSequence)newCommentText);
        }

        private static void appendElementText(String text, int startOffset, int endOffset, StringBuilder out) {
            if (out.length() == "{@code".length() && endOffset - startOffset > 0 && !Character.isWhitespace(text.charAt(startOffset))) {
                out.append(' ');
            }
            String s = text.substring(startOffset, endOffset);
            out.append(StringUtil.unescapeXmlEntities((String)s));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/javadoc/HtmlTagCanBeJavadocTagInspection$HtmlTagCanBeJavaDocTagFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/javadoc/HtmlTagCanBeJavadocTagInspection$HtmlTagCanBeJavaDocTagFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class HtmlTagCanBeJavaDocTagVisitor
    extends BaseInspectionVisitor {
        private static final Pattern START_TAG_PATTERN = Pattern.compile("<([a-zA-Z])+([^>])*>");

        private HtmlTagCanBeJavaDocTagVisitor() {
        }

        public void visitDocToken(@NotNull PsiDocToken token) {
            if (token == null) {
                HtmlTagCanBeJavaDocTagVisitor.$$$reportNull$$$0(0);
            }
            super.visitDocToken(token);
            IElementType tokenType = token.getTokenType();
            if (!JavaDocTokenType.DOC_COMMENT_DATA.equals(tokenType) || !JavaDocUtil.shouldRunInspectionOnOldMarkdownComment((PsiElement)token)) {
                return;
            }
            @NonNls String text = token.getText();
            int startIndex = 0;
            while ((startIndex = StringUtil.indexOfIgnoreCase((String)text, (String)"<code>", (int)startIndex)) >= 0) {
                if (HtmlTagCanBeJavaDocTagVisitor.hasMatchingCloseTag((PsiElement)token, startIndex + 6)) {
                    this.registerErrorAtOffset((PsiElement)token, startIndex, 6, new Object[0]);
                }
                ++startIndex;
            }
            return;
        }

        private static boolean hasMatchingCloseTag(PsiElement element, int offset) {
            int balance = 0;
            while (element != null) {
                int end;
                @NonNls String text = element.getText();
                int endIndex = StringUtil.indexOfIgnoreCase((String)text, (String)"</code>", (int)offset);
                int n = end = endIndex >= 0 ? endIndex : text.length();
                if (text.equals("{")) {
                    ++balance;
                } else if (text.equals("}") && --balance < 0) {
                    return false;
                }
                if (HtmlTagCanBeJavaDocTagVisitor.containsHtmlTag(text, offset, end)) {
                    return false;
                }
                if (endIndex >= 0) {
                    return balance == 0;
                }
                offset = 0;
                if (!((element = element.getNextSibling()) instanceof PsiInlineDocTag)) continue;
                return false;
            }
            return false;
        }

        private static boolean containsHtmlTag(String text, int startIndex, int endIndex) {
            Matcher matcher = START_TAG_PATTERN.matcher(text);
            return matcher.find(startIndex) && matcher.start() < endIndex;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/siyeh/ig/javadoc/HtmlTagCanBeJavadocTagInspection$HtmlTagCanBeJavaDocTagVisitor", "visitDocToken"));
        }
    }
}

