/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryJavaDocLinkInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    private static final int THIS_METHOD = 1;
    private static final int THIS_CLASS = 2;
    private static final int SUPER_METHOD = 3;
    public boolean ignoreInlineLinkToSuper = false;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        int n = (Integer)infos[1];
        if (n == 1) {
            String string = InspectionGadgetsBundle.message("unnecessary.javadoc.link.this.method.problem.descriptor", new Object[0]);
            if (string == null) {
                UnnecessaryJavaDocLinkInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (n == 2) {
            String string = InspectionGadgetsBundle.message("unnecessary.javadoc.link.this.class.problem.descriptor", new Object[0]);
            if (string == null) {
                UnnecessaryJavaDocLinkInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.javadoc.link.super.method.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryJavaDocLinkInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreInlineLinkToSuper", (String)InspectionGadgetsBundle.message("unnecessary.javadoc.link.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessaryJavaDocLinkInspection.$$$reportNull$$$0(3);
        }
        return optPane;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessaryJavaDocLinkFix((String)infos[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryJavaDocLinkVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/javadoc/UnnecessaryJavaDocLinkInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryJavaDocLinkFix
    extends PsiUpdateModCommandQuickFix {
        private final String tagName;

        UnnecessaryJavaDocLinkFix(String tagName) {
            this.tagName = tagName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.javadoc.link.quickfix", this.tagName);
            if (string == null) {
                UnnecessaryJavaDocLinkFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.java.doc.link.fix.family.name", new Object[0]);
            if (string == null) {
                UnnecessaryJavaDocLinkFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                UnnecessaryJavaDocLinkFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                UnnecessaryJavaDocLinkFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                UnnecessaryJavaDocLinkFix.$$$reportNull$$$0(4);
            }
            if (!((parent = element.getParent()) instanceof PsiDocTag)) {
                return;
            }
            PsiDocTag docTag = (PsiDocTag)parent;
            PsiDocComment docComment = docTag.getContainingComment();
            if (docComment != null && UnnecessaryJavaDocLinkFix.shouldDeleteEntireComment(docComment)) {
                docComment.delete();
                return;
            }
            docTag.delete();
        }

        private static boolean shouldDeleteEntireComment(PsiDocComment docComment) {
            PsiDocToken[] docTokens = (PsiDocToken[])PsiTreeUtil.getChildrenOfType((PsiElement)docComment, PsiDocToken.class);
            if (docTokens == null) {
                return false;
            }
            for (PsiDocToken docToken : docTokens) {
                IElementType tokenType = docToken.getTokenType();
                if (!JavaDocTokenType.DOC_COMMENT_DATA.equals(tokenType) || StringUtil.isEmptyOrSpaces((String)docToken.getText())) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/javadoc/UnnecessaryJavaDocLinkInspection$UnnecessaryJavaDocLinkFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/javadoc/UnnecessaryJavaDocLinkInspection$UnnecessaryJavaDocLinkFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private class UnnecessaryJavaDocLinkVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryJavaDocLinkVisitor() {
        }

        public void visitDocTag(@NotNull PsiDocTag tag) {
            if (tag == null) {
                UnnecessaryJavaDocLinkVisitor.$$$reportNull$$$0(0);
            }
            super.visitDocTag(tag);
            @NonNls String name = tag.getName();
            if ("link".equals(name) || "linkplain".equals(name) ? !(tag instanceof PsiInlineDocTag) : "see".equals(name) && tag instanceof PsiInlineDocTag) {
                return;
            }
            PsiReference reference = UnnecessaryJavaDocLinkVisitor.extractReference(tag);
            if (reference == null) {
                return;
            }
            PsiElement target = reference.resolve();
            if (target == null) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiMethod.class);
            if (containingMethod == null) {
                return;
            }
            if (target.equals((Object)containingMethod)) {
                this.registerError(tag.getNameElement(), "@" + name, 1);
                return;
            }
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)tag, PsiClass.class);
            if (target.equals((Object)containingClass)) {
                this.registerError(tag.getNameElement(), "@" + name, 2);
                return;
            }
            if (!(target instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)target;
            if (!this.isSuperMethod(method, containingMethod)) {
                return;
            }
            if (UnnecessaryJavaDocLinkInspection.this.ignoreInlineLinkToSuper && tag instanceof PsiInlineDocTag) {
                return;
            }
            this.registerError(tag.getNameElement(), "@" + name, 3);
        }

        private static PsiReference extractReference(PsiDocTag tag) {
            PsiDocTagValue valueElement = tag.getValueElement();
            if (valueElement != null) {
                return valueElement.getReference();
            }
            PsiElement[] dataElements = tag.getDataElements();
            if (dataElements.length == 0) {
                return null;
            }
            PsiElement salientElement = null;
            for (PsiElement dataElement : dataElements) {
                if (dataElement instanceof PsiWhiteSpace) continue;
                salientElement = dataElement;
                break;
            }
            if (salientElement == null) {
                return null;
            }
            PsiElement child = salientElement.getFirstChild();
            if (!(child instanceof PsiReference)) {
                return null;
            }
            return (PsiReference)child;
        }

        public boolean isSuperMethod(PsiMethod superMethodCandidate, PsiMethod derivedMethod) {
            PsiClass superClassCandidate = superMethodCandidate.getContainingClass();
            PsiClass derivedClass = derivedMethod.getContainingClass();
            if (derivedClass == null || superClassCandidate == null) {
                return false;
            }
            if (!derivedClass.isInheritor(superClassCandidate, false)) {
                return false;
            }
            PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClassCandidate, (PsiClass)derivedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            MethodSignature superSignature = superMethodCandidate.getSignature(superSubstitutor);
            MethodSignature derivedSignature = derivedMethod.getSignature(PsiSubstitutor.EMPTY);
            return MethodSignatureUtil.isSubsignature((MethodSignature)superSignature, (MethodSignature)derivedSignature);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/siyeh/ig/javadoc/UnnecessaryJavaDocLinkInspection$UnnecessaryJavaDocLinkVisitor", "visitDocTag"));
        }
    }
}

