/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import org.jetbrains.annotations.NotNull;

public final class ParametersPerMethodInspection
extends MethodMetricInspection {
    @NotNull
    public String getID() {
        return "MethodWithTooManyParameters";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer parameterCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("parameters.per.method.problem.descriptor", parameterCount);
        if (string == null) {
            ParametersPerMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("parameter.limit.option", new Object[0]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ParametersPerMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/ParametersPerMethodInspection", "buildErrorString"));
    }

    private class ParametersPerMethodVisitor
    extends BaseInspectionVisitor {
        private ParametersPerMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                ParametersPerMethodVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (method.isConstructor()) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            int parametersCount = parameterList.getParametersCount();
            if (parametersCount <= ParametersPerMethodInspection.this.getLimit()) {
                return;
            }
            if (method.findDeepestSuperMethods().length > 0) {
                return;
            }
            this.registerMethodError(method, parametersCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/ParametersPerMethodInspection$ParametersPerMethodVisitor", "visitMethod"));
        }
    }
}

