/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionsFieldAccessReplaceableByMethodCallInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("collections.field.access.replaceable.by.method.call.problem.descriptor", infos[1]);
        if (string == null) {
            CollectionsFieldAccessReplaceableByMethodCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiReferenceExpression expression = (PsiReferenceExpression)infos[0];
        return new CollectionsFieldAccessReplaceableByMethodCallFix(expression.getReferenceName());
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new CollectionsFieldAccessReplaceableByMethodCallVisitor();
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            CollectionsFieldAccessReplaceableByMethodCallInspection.$$$reportNull$$$0(1);
        }
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/migration/CollectionsFieldAccessReplaceableByMethodCallInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/migration/CollectionsFieldAccessReplaceableByMethodCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class CollectionsFieldAccessReplaceableByMethodCallFix
    extends PsiUpdateModCommandQuickFix {
        private final String replacementText;

        CollectionsFieldAccessReplaceableByMethodCallFix(String referenceName) {
            this.replacementText = CollectionsFieldAccessReplaceableByMethodCallFix.getCollectionsMethodCallName(referenceName);
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("collections.field.access.replaceable.by.method.call.fix.family.name", new Object[0]);
            if (string == null) {
                CollectionsFieldAccessReplaceableByMethodCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.replacementText});
            if (string == null) {
                CollectionsFieldAccessReplaceableByMethodCallFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NonNls
        private static String getCollectionsMethodCallText(PsiReferenceExpression referenceExpression) {
            String referenceName = referenceExpression.getReferenceName();
            PsiElement parent = referenceExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return CollectionsFieldAccessReplaceableByMethodCallFix.getUntypedCollectionsMethodCallText(referenceName);
            }
            PsiType type = ExpectedTypeUtils.findExpectedType((PsiExpression)referenceExpression, false);
            if (!(type instanceof PsiClassType)) {
                return CollectionsFieldAccessReplaceableByMethodCallFix.getUntypedCollectionsMethodCallText(referenceName);
            }
            PsiClassType classType = (PsiClassType)type;
            PsiType[] parameterTypes = classType.getParameters();
            boolean useTypeParameter = false;
            String[] canonicalTexts = new String[parameterTypes.length];
            for (PsiType parameterType : parameterTypes) {
                if (parameterType instanceof PsiWildcardType) {
                    PsiWildcardType wildcardType = (PsiWildcardType)parameterType;
                    PsiType bound = wildcardType.getBound();
                    if (bound != null) {
                        if (!bound.equalsToText("java.lang.Object")) {
                            useTypeParameter = true;
                        }
                        canonicalTexts[i] = bound.getCanonicalText();
                        continue;
                    }
                    canonicalTexts[i] = "java.lang.Object";
                    continue;
                }
                if (!parameterType.equalsToText("java.lang.Object")) {
                    useTypeParameter = true;
                }
                canonicalTexts[i] = parameterType.getCanonicalText();
            }
            return useTypeParameter ? "Collections.<" + StringUtil.join((String[])canonicalTexts, (String)",") + ">" + CollectionsFieldAccessReplaceableByMethodCallFix.getCollectionsMethodCallName(referenceName) : CollectionsFieldAccessReplaceableByMethodCallFix.getUntypedCollectionsMethodCallText(referenceName);
        }

        @NonNls
        private static String getUntypedCollectionsMethodCallText(String referenceName) {
            return "Collections." + CollectionsFieldAccessReplaceableByMethodCallFix.getCollectionsMethodCallName(referenceName);
        }

        @NonNls
        private static String getCollectionsMethodCallName(@NonNls String referenceName) {
            if ("EMPTY_LIST".equals(referenceName)) {
                return "emptyList()";
            }
            if ("EMPTY_MAP".equals(referenceName)) {
                return "emptyMap()";
            }
            if ("EMPTY_SET".equals(referenceName)) {
                return "emptySet()";
            }
            throw new AssertionError((Object)("unknown collections field name: " + referenceName));
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                CollectionsFieldAccessReplaceableByMethodCallFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                CollectionsFieldAccessReplaceableByMethodCallFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                CollectionsFieldAccessReplaceableByMethodCallFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            String newMethodCallText = CollectionsFieldAccessReplaceableByMethodCallFix.getCollectionsMethodCallText(referenceExpression);
            PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, "java.util." + newMethodCallText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/migration/CollectionsFieldAccessReplaceableByMethodCallInspection$CollectionsFieldAccessReplaceableByMethodCallFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/migration/CollectionsFieldAccessReplaceableByMethodCallInspection$CollectionsFieldAccessReplaceableByMethodCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class CollectionsFieldAccessReplaceableByMethodCallVisitor
    extends BaseInspectionVisitor {
        private CollectionsFieldAccessReplaceableByMethodCallVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            String replacement;
            if (expression == null) {
                CollectionsFieldAccessReplaceableByMethodCallVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression);
            @NonNls String name = expression.getReferenceName();
            if ("EMPTY_LIST".equals(name)) {
                replacement = "emptyList()";
            } else if ("EMPTY_MAP".equals(name)) {
                replacement = "emptyMap()";
            } else if ("EMPTY_SET".equals(name)) {
                replacement = "emptySet()";
            } else {
                return;
            }
            PsiElement target = expression.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (!"java.util.Collections".equals(qualifiedName)) {
                return;
            }
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
            if (parent instanceof PsiExpression && ComparisonUtils.isEqualityComparison((PsiExpression)parent)) {
                return;
            }
            this.registerError((PsiElement)expression, expression, replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/CollectionsFieldAccessReplaceableByMethodCallInspection$CollectionsFieldAccessReplaceableByMethodCallVisitor", "visitReferenceExpression"));
        }
    }
}

