/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiBoxingUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnnecessaryBoxingInspection
extends BaseInspection {
    public boolean onlyReportSuperfluouslyBoxed = false;

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"onlyReportSuperfluouslyBoxed", (String)InspectionGadgetsBundle.message("unnecessary.boxing.superfluous.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessaryBoxingInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (infos.length == 0) {
            String string = InspectionGadgetsBundle.message("unnecessary.boxing.problem.descriptor", new Object[0]);
            if (string == null) {
                UnnecessaryBoxingInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        PsiType type = (PsiType)infos[0];
        String parseMethod = (String)infos[1];
        String string = InspectionGadgetsBundle.message("unnecessary.boxing.inside.value.of.problem.descriptor", type.getPresentableText(), parseMethod);
        if (string == null) {
            UnnecessaryBoxingInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return infos.length == 0 ? new UnnecessaryBoxingFix() : new UnnecessaryBoxingFix((PsiType)infos[0], (String)infos[1]);
    }

    @Override
    public boolean shouldInspect(@NotNull PsiFile file) {
        if (file == null) {
            UnnecessaryBoxingInspection.$$$reportNull$$$0(3);
        }
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryBoxingVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/migration/UnnecessaryBoxingInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/migration/UnnecessaryBoxingInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }

    private static final class UnnecessaryBoxingFix
    extends PsiUpdateModCommandQuickFix {
        @IntentionFamilyName
        private final String name;

        private UnnecessaryBoxingFix() {
            this.name = InspectionGadgetsBundle.message("unnecessary.boxing.remove.quickfix", new Object[0]);
        }

        private UnnecessaryBoxingFix(PsiType retType, String parseMethod) {
            this.name = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{retType.getPresentableText() + "." + parseMethod + "()"});
        }

        @NotNull
        public String getFamilyName() {
            String string = this.name;
            if (string == null) {
                UnnecessaryBoxingFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            String replacementText;
            PsiCallExpression expression;
            if (project == null) {
                UnnecessaryBoxingFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                UnnecessaryBoxingFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessaryBoxingFix.$$$reportNull$$$0(3);
            }
            if ((expression = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCallExpression.class)) == null) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression unboxedExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
            if (unboxedExpression == null) {
                return;
            }
            PsiType unboxedExpressionType = unboxedExpression.getType();
            if (unboxedExpressionType == null) {
                return;
            }
            CommentTracker commentTracker = new CommentTracker();
            if (unboxedExpressionType.getCanonicalText().equals("java.lang.String")) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression;
                String parseMethodName = JavaPsiBoxingUtils.getParseMethod(methodCall.getType());
                if (parseMethodName == null) {
                    return;
                }
                ExpressionUtils.bindCallTo(methodCall, parseMethodName);
                return;
            }
            Object value = ExpressionUtils.computeConstantExpression(unboxedExpression);
            if (value != null && !(unboxedExpression instanceof PsiReferenceExpression)) {
                if (value == Boolean.TRUE) {
                    PsiReplacementUtil.replaceExpression((PsiExpression)expression, "java.lang.Boolean.TRUE", commentTracker);
                    return;
                }
                if (value == Boolean.FALSE) {
                    PsiReplacementUtil.replaceExpression((PsiExpression)expression, "java.lang.Boolean.FALSE", commentTracker);
                    return;
                }
            }
            if ((replacementText = UnnecessaryBoxingFix.getUnboxedExpressionText(unboxedExpression, (PsiExpression)expression, commentTracker)) == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, replacementText, commentTracker);
        }

        @Nullable
        private static String getUnboxedExpressionText(@NotNull PsiExpression unboxedExpression, @NotNull PsiExpression boxedExpression, CommentTracker commentTracker) {
            String newLiteral;
            PsiType boxedType;
            if (unboxedExpression == null) {
                UnnecessaryBoxingFix.$$$reportNull$$$0(4);
            }
            if (boxedExpression == null) {
                UnnecessaryBoxingFix.$$$reportNull$$$0(5);
            }
            if ((boxedType = boxedExpression.getType()) == null) {
                return null;
            }
            PsiType expressionType = unboxedExpression.getType();
            if (expressionType == null) {
                return null;
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)boxedType);
            if (unboxedType == null) {
                return null;
            }
            String text = commentTracker.text((PsiElement)unboxedExpression);
            if (expressionType.equals(unboxedType)) {
                PsiElement parent = boxedExpression.getParent();
                if (parent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(unboxedExpression, (PsiExpression)parent, false)) {
                    return "(" + text + ")";
                }
                return text;
            }
            if (unboxedExpression instanceof PsiLiteralExpression && (newLiteral = PsiLiteralUtil.tryConvertNumericLiteral((PsiLiteralExpression)((PsiLiteralExpression)unboxedExpression), (PsiType)unboxedType)) != null) {
                return newLiteral;
            }
            if (ParenthesesUtils.getPrecedence(unboxedExpression) > 4) {
                return "(" + unboxedType.getCanonicalText() + ")(" + text + ")";
            }
            return "(" + unboxedType.getCanonicalText() + ")" + text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unboxedExpression";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "boxedExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getUnboxedExpressionText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    private class UnnecessaryBoxingVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryBoxingVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiType expectedType;
            if (expression == null) {
                UnnecessaryBoxingVisitor.$$$reportNull$$$0(0);
            }
            super.visitNewExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiType constructorType = expression.getType();
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)constructorType);
            if (unboxedType == null) {
                return;
            }
            PsiMethod constructor = expression.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression boxedExpression = arguments[0];
            PsiType argumentType = boxedExpression.getType();
            if (!(argumentType instanceof PsiPrimitiveType) || UnnecessaryBoxingVisitor.isBoxingNecessary((PsiExpression)expression, boxedExpression)) {
                return;
            }
            if (UnnecessaryBoxingInspection.this.onlyReportSuperfluouslyBoxed && !((expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression, false, true)) instanceof PsiPrimitiveType)) {
                return;
            }
            this.registerNewExpressionError(expression, new Object[0]);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiType expectedType;
            if (expression == null) {
                UnnecessaryBoxingVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethodCallExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression boxedExpression = arguments[0];
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            @NonNls String referenceName = methodExpression.getReferenceName();
            if (!"valueOf".equals(referenceName)) {
                return;
            }
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)methodExpression.resolve(), PsiMethod.class);
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String canonicalText = aClass.getQualifiedName();
            if (canonicalText == null || !TypeConversionUtil.isPrimitiveWrapper((String)canonicalText)) {
                return;
            }
            PsiType boxedExpressionType = boxedExpression.getType();
            if (TypeUtils.isJavaLangString(boxedExpressionType)) {
                String parseMethod;
                PsiType expectedType2 = ExpectedTypeUtils.findExpectedType((PsiExpression)expression, false, true);
                PsiType methodReturnType = method.getReturnType();
                if (expectedType2 instanceof PsiPrimitiveType && (parseMethod = JavaPsiBoxingUtils.getParseMethod(methodReturnType)) != null) {
                    this.registerMethodCallError(expression, methodReturnType, parseMethod);
                }
                return;
            }
            if (!(boxedExpressionType instanceof PsiPrimitiveType)) {
                return;
            }
            if (UnnecessaryBoxingVisitor.isBoxingNecessary((PsiExpression)expression, boxedExpression)) {
                return;
            }
            if (UnnecessaryBoxingInspection.this.onlyReportSuperfluouslyBoxed && !((expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression, false, true)) instanceof PsiPrimitiveType)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean isBoxingNecessary(PsiExpression boxingExpression, PsiExpression boxedExpression) {
            PsiSwitchBlock switchBlock;
            if (ExpressionUtils.isVoidContext(boxingExpression)) {
                return true;
            }
            PsiElement parent = boxingExpression.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                boxingExpression = (PsiExpression)parent;
                parent = parent.getParent();
            }
            if (parent instanceof PsiReferenceExpression || parent instanceof PsiSynchronizedStatement) {
                return true;
            }
            if (parent instanceof PsiSwitchBlock && ExpressionUtil.isEnhancedSwitch((PsiSwitchBlock)(switchBlock = (PsiSwitchBlock)parent))) {
                return true;
            }
            if (parent instanceof PsiVariable) {
                PsiTypeElement typeElement = ((PsiVariable)parent).getTypeElement();
                if (typeElement != null && typeElement.isInferredType()) {
                    return true;
                }
            } else {
                if (parent instanceof PsiTypeCastExpression) {
                    PsiTypeCastExpression castExpression = (PsiTypeCastExpression)parent;
                    return TypeUtils.isTypeParameter(castExpression.getType());
                }
                if (parent instanceof PsiConditionalExpression) {
                    PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
                    PsiExpression thenExpression = conditionalExpression.getThenExpression();
                    PsiExpression elseExpression = conditionalExpression.getElseExpression();
                    if (elseExpression == null || thenExpression == null) {
                        return true;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)thenExpression, (PsiElement)boxingExpression, (boolean)false)) {
                        PsiType type = elseExpression.getType();
                        return !(type instanceof PsiPrimitiveType);
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)elseExpression, (PsiElement)boxingExpression, (boolean)false)) {
                        PsiType type = thenExpression.getType();
                        return !(type instanceof PsiPrimitiveType);
                    }
                    return false;
                }
                if (parent instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
                    return UnnecessaryBoxingVisitor.isPossibleObjectComparison(boxingExpression, polyadicExpression);
                }
            }
            return MethodCallUtils.isNecessaryForSurroundingMethodCall(boxingExpression, boxedExpression) || !LambdaUtil.isSafeLambdaReturnValueReplacement((PsiExpression)boxingExpression, (PsiExpression)boxedExpression);
        }

        private static boolean isPossibleObjectComparison(PsiExpression expression, PsiPolyadicExpression polyadicExpression) {
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)polyadicExpression)) {
                return false;
            }
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (operand == expression || operand.getType() instanceof PsiPrimitiveType) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

