/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public final class OverloadedVarargsMethodInspection
extends BaseInspection {
    public boolean ignoreInconvertibleTypes = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreInconvertibleTypes", (String)InspectionGadgetsBundle.message("overloaded.vararg.method.problem.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            OverloadedVarargsMethodInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiMethod element = (PsiMethod)infos[0];
        if (element.isConstructor()) {
            String string = InspectionGadgetsBundle.message("overloaded.vararg.constructor.problem.descriptor", new Object[0]);
            if (string == null) {
                OverloadedVarargsMethodInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("overloaded.vararg.method.problem.descriptor", new Object[0]);
        if (string == null) {
            OverloadedVarargsMethodInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new OverloadedVarargMethodVisitor();
    }

    private static PsiType getTypeForComparison(PsiParameter parameter) {
        PsiType psiType;
        PsiType type = parameter.getType();
        if (type instanceof PsiEllipsisType) {
            PsiEllipsisType ellipsisType = (PsiEllipsisType)type;
            psiType = ellipsisType.getComponentType();
        } else {
            psiType = type;
        }
        return psiType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/naming/OverloadedVarargsMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class OverloadedVarargMethodVisitor
    extends BaseInspectionVisitor {
        private OverloadedVarargMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] sameNameMethods;
            if (method == null) {
                OverloadedVarargMethodVisitor.$$$reportNull$$$0(0);
            }
            if (!method.isVarArgs()) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String methodName = method.getName();
            for (PsiMethod sameNameMethod : sameNameMethods = aClass.findMethodsByName(methodName, true)) {
                PsiSubstitutor substitutor;
                PsiClass superClass = sameNameMethod.getContainingClass();
                PsiSubstitutor psiSubstitutor = substitutor = superClass != null ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
                if (MethodSignatureUtil.areSignaturesEqual((MethodSignature)sameNameMethod.getSignature(substitutor), (MethodSignature)method.getSignature(PsiSubstitutor.EMPTY)) || OverloadedVarargsMethodInspection.this.ignoreInconvertibleTypes && !OverloadedVarargMethodVisitor.areConvertibleTypesWithVarArgs(method.getParameterList(), sameNameMethod.getParameterList())) continue;
                this.registerMethodError(method, method);
                return;
            }
        }

        private static boolean areConvertibleTypesWithVarArgs(@NotNull PsiParameterList parameterListWithVarArgs, @NotNull PsiParameterList otherParameterList) {
            PsiParameter[] otherParameters;
            int otherLength;
            PsiParameter[] parametersWithVarArgs;
            int lengthForVarArgs;
            if (parameterListWithVarArgs == null) {
                OverloadedVarargMethodVisitor.$$$reportNull$$$0(1);
            }
            if (otherParameterList == null) {
                OverloadedVarargMethodVisitor.$$$reportNull$$$0(2);
            }
            if ((lengthForVarArgs = (parametersWithVarArgs = parameterListWithVarArgs.getParameters()).length) > (otherLength = (otherParameters = otherParameterList.getParameters()).length) + 1) {
                return false;
            }
            for (int i = 0; i < otherLength; ++i) {
                PsiType otherType;
                PsiType type = i < lengthForVarArgs ? OverloadedVarargsMethodInspection.getTypeForComparison(parametersWithVarArgs[i]) : OverloadedVarargsMethodInspection.getTypeForComparison(parametersWithVarArgs[lengthForVarArgs - 1]);
                if (type.isAssignableFrom(otherType = OverloadedVarargsMethodInspection.getTypeForComparison(otherParameters[i])) || otherType.isAssignableFrom(type)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterListWithVarArgs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherParameterList";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/naming/OverloadedVarargsMethodInspection$OverloadedVarargMethodVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "areConvertibleTypesWithVarArgs";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

