/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;

public final class BigDecimalMethodWithoutRoundingCalledInspection
extends BaseInspection {
    static final CallMatcher JAVA_MATH_BIG_DECIMAL = CallMatcher.instanceCall("java.math.BigDecimal", "setScale", "divide").parameterCount(1);

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("big.decimal.method.without.rounding.called.problem.descriptor", new Object[0]);
        if (string == null) {
            BigDecimalMethodWithoutRoundingCalledInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new BigDecimalMethodWithoutRoundingCalledVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/BigDecimalMethodWithoutRoundingCalledInspection", "buildErrorString"));
    }

    private static class BigDecimalMethodWithoutRoundingCalledVisitor
    extends BaseInspectionVisitor {
        private BigDecimalMethodWithoutRoundingCalledVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                BigDecimalMethodWithoutRoundingCalledVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (JAVA_MATH_BIG_DECIMAL.test(expression)) {
                this.registerMethodCallError(expression, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/BigDecimalMethodWithoutRoundingCalledInspection$BigDecimalMethodWithoutRoundingCalledVisitor", "visitMethodCallExpression"));
        }
    }
}

