/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public final class CastThatLosesPrecisionInspection
extends BaseInspection {
    public boolean ignoreIntegerCharCasts = false;
    public boolean ignoreOverflowingByteCasts = false;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "NumericCastThatLosesPrecision";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType operandType = (PsiType)infos[0];
        boolean negativeOnly = (Boolean)infos[1];
        String string = InspectionGadgetsBundle.message(negativeOnly ? "cast.that.loses.precision.negative.problem.descriptor" : "cast.that.loses.precision.problem.descriptor", operandType.getPresentableText());
        if (string == null) {
            CastThatLosesPrecisionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreIntegerCharCasts", (String)InspectionGadgetsBundle.message("cast.that.loses.precision.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"ignoreOverflowingByteCasts", (String)InspectionGadgetsBundle.message("ignore.overflowing.byte.casts.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            CastThatLosesPrecisionInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new CastThatLosesPrecisionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/numeric/CastThatLosesPrecisionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class CastThatLosesPrecisionVisitor
    extends BaseInspectionVisitor {
        private CastThatLosesPrecisionVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            LongRangeSet valueRange;
            PsiTypeElement castTypeElement;
            PsiMethod method;
            PsiType castType;
            if (expression == null) {
                CastThatLosesPrecisionVisitor.$$$reportNull$$$0(0);
            }
            if (!ClassUtils.isPrimitiveNumericType(castType = expression.getType())) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType operandType = operand.getType();
            if (!ClassUtils.isPrimitiveNumericType(operandType) || !TypeUtils.isNarrowingConversion(operandType, castType)) {
                return;
            }
            if (CastThatLosesPrecisionInspection.this.ignoreIntegerCharCasts && PsiTypes.intType().equals((Object)operandType) && PsiTypes.charType().equals((Object)castType)) {
                return;
            }
            if (PsiTypes.longType().equals((Object)operandType) && PsiTypes.intType().equals((Object)castType) && MethodUtils.isHashCode(method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class}))) {
                return;
            }
            Object result = ExpressionUtils.computeConstantExpression(operand);
            if (result instanceof Character) {
                result = (int)((Character)result).charValue();
            }
            if (result instanceof Number) {
                int i;
                Number number = (Number)result;
                if (CastThatLosesPrecisionInspection.this.ignoreOverflowingByteCasts && PsiTypes.intType().equals((Object)operandType) && PsiTypes.byteType().equals((Object)castType) && (i = number.intValue()) > -128 && i <= 255) {
                    return;
                }
                if (CastThatLosesPrecisionVisitor.valueIsContainableInType(number, castType)) {
                    return;
                }
            }
            if ((castTypeElement = expression.getCastType()) == null) {
                return;
            }
            LongRangeSet targetRange = JvmPsiRangeSetUtil.typeRange(castType);
            LongRangeSet lostRange = LongRangeSet.all();
            if (targetRange != null && JvmPsiRangeSetUtil.typeRange(operandType) != null && (lostRange = (valueRange = DfLongType.extractRange(CommonDataflow.getDfType(operand))).subtract(targetRange)).isEmpty()) {
                return;
            }
            this.registerError((PsiElement)castTypeElement, operandType, lostRange.max() < 0L);
        }

        private static boolean valueIsContainableInType(Number value, PsiType type) {
            long longValue = value.longValue();
            double doubleValue = value.doubleValue();
            if (PsiTypes.byteType().equals((Object)type)) {
                return longValue >= -128L && longValue <= 127L && doubleValue >= -128.0 && doubleValue <= 127.0;
            }
            if (PsiTypes.charType().equals((Object)type)) {
                return longValue >= 0L && longValue <= 65535L && doubleValue >= 0.0 && doubleValue <= 65535.0;
            }
            if (PsiTypes.shortType().equals((Object)type)) {
                return longValue >= -32768L && longValue <= 32767L && doubleValue >= -32768.0 && doubleValue <= 32767.0;
            }
            if (PsiTypes.intType().equals((Object)type)) {
                return longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE && doubleValue >= -2.147483648E9 && doubleValue <= 2.147483647E9;
            }
            if (PsiTypes.longType().equals((Object)type)) {
                return doubleValue >= -9.223372036854776E18 && doubleValue <= 9.223372036854776E18;
            }
            if (PsiTypes.floatType().equals((Object)type)) {
                return doubleValue == (double)value.floatValue();
            }
            return PsiTypes.doubleType().equals((Object)type);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/CastThatLosesPrecisionInspection$CastThatLosesPrecisionVisitor", "visitTypeCastExpression"));
        }
    }
}

