/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public final class ComparisonOfShortAndCharInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("comparison.of.short.and.char.problem.descriptor", new Object[0]);
        if (string == null) {
            ComparisonOfShortAndCharInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ComparisonOfShortAndCharVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ComparisonOfShortAndCharInspection", "buildErrorString"));
    }

    private static class ComparisonOfShortAndCharVisitor
    extends BaseInspectionVisitor {
        private ComparisonOfShortAndCharVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                ComparisonOfShortAndCharVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiType lhsType = lhs.getType();
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiType rhsType = rhs.getType();
            if (PsiTypes.shortType().equals((Object)lhsType) && PsiTypes.charType().equals((Object)rhsType)) {
                this.registerError((PsiElement)expression, new Object[0]);
            } else if (PsiTypes.charType().equals((Object)lhsType) && PsiTypes.shortType().equals((Object)rhsType)) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/ComparisonOfShortAndCharInspection$ComparisonOfShortAndCharVisitor", "visitBinaryExpression"));
        }
    }
}

