/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ComparisonToNaNInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiBinaryExpression comparison = (PsiBinaryExpression)infos[0];
        IElementType tokenType = comparison.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.NE)) {
            String string = InspectionGadgetsBundle.message("comparison.to.nan.problem.descriptor2", new Object[0]);
            if (string == null) {
                ComparisonToNaNInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("comparison.to.nan.problem.descriptor1", new Object[0]);
        if (string == null) {
            ComparisonToNaNInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ComparisonToNaNVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        PsiBinaryExpression comparison = (PsiBinaryExpression)infos[0];
        return ComparisonUtils.isEqualityComparison((PsiExpression)comparison) ? new ComparisonToNaNFix() : null;
    }

    public static PsiExpression extractNaNFromComparison(PsiBinaryExpression expression) {
        if (!ComparisonUtils.isComparison((PsiExpression)expression)) {
            return null;
        }
        PsiExpression lhs = expression.getLOperand();
        PsiExpression rhs = expression.getROperand();
        if (rhs == null || !TypeUtils.hasFloatingPointType(lhs) && !TypeUtils.hasFloatingPointType(rhs)) {
            return null;
        }
        if (ComparisonToNaNInspection.isNaN(lhs)) {
            return lhs;
        }
        if (ComparisonToNaNInspection.isNaN(rhs)) {
            return rhs;
        }
        return null;
    }

    private static boolean isNaN(PsiExpression expression) {
        if (!(expression instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        @NonNls String referenceName = referenceExpression.getReferenceName();
        if (!"NaN".equals(referenceName)) {
            return false;
        }
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)target;
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        return "java.lang.Double".equals(qualifiedName) || "java.lang.Float".equals(qualifiedName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ComparisonToNaNInspection", "buildErrorString"));
    }

    private static class ComparisonToNaNVisitor
    extends BaseInspectionVisitor {
        private ComparisonToNaNVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                ComparisonToNaNVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            PsiExpression nan = ComparisonToNaNInspection.extractNaNFromComparison(expression);
            if (nan != null) {
                this.registerError((PsiElement)nan, expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/numeric/ComparisonToNaNInspection$ComparisonToNaNVisitor", "visitBinaryExpression"));
        }
    }

    private static class ComparisonToNaNFix
    extends PsiUpdateModCommandQuickFix {
        private ComparisonToNaNFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"isNaN()"});
            if (string == null) {
                ComparisonToNaNFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiReferenceExpression nanExpression;
            PsiElement target;
            if (project == null) {
                ComparisonToNaNFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                ComparisonToNaNFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ComparisonToNaNFix.$$$reportNull$$$0(3);
            }
            if (!((target = (nanExpression = (PsiReferenceExpression)startElement).resolve()) instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String typeText = containingClass.getQualifiedName();
            PsiBinaryExpression comparison = (PsiBinaryExpression)nanExpression.getParent();
            PsiExpression lhs = comparison.getLOperand();
            PsiExpression rhs = comparison.getROperand();
            PsiExpression operand = nanExpression.equals((Object)lhs) ? rhs : lhs;
            assert (operand != null);
            CommentTracker commentTracker = new CommentTracker();
            String operandText = commentTracker.text((PsiElement)operand);
            IElementType tokenType = comparison.getOperationTokenType();
            String negationText = tokenType.equals(JavaTokenType.EQEQ) ? "" : "!";
            @NonNls String newExpressionText = negationText + typeText + ".isNaN(" + operandText + ")";
            PsiReplacementUtil.replaceExpression((PsiExpression)comparison, newExpressionText, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/ComparisonToNaNInspection$ComparisonToNaNFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/ComparisonToNaNInspection$ComparisonToNaNFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

