/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntegerMultiplicationImplicitCastToLongInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    private static final CallMatcher JUNIT4_ASSERT_EQUALS = CallMatcher.anyOf(CallMatcher.staticCall("org.junit.Assert", "assertEquals").parameterTypes("long", "long"), CallMatcher.staticCall("org.junit.Assert", "assertEquals").parameterTypes("java.lang.String", "long", "long"));
    @NonNls
    private static final Set<String> s_typesToCheck = Set.of("int", "short", "byte", "char", "java.lang.Integer", "java.lang.Short", "java.lang.Byte", "java.lang.Character");
    public boolean ignoreNonOverflowingCompileTimeConstants = true;

    @Override
    @NotNull
    protected LocalQuickFix buildFix(Object ... infos) {
        return new IntegerMultiplicationImplicitCastToLongInspectionFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        IElementType tokenType = (IElementType)infos[0];
        if (JavaTokenType.ASTERISK.equals(tokenType)) {
            String string = InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.problem.descriptor", new Object[0]);
            if (string == null) {
                IntegerMultiplicationImplicitCastToLongInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("integer.shift.implicit.cast.to.long.problem.descriptor", new Object[0]);
        if (string == null) {
            IntegerMultiplicationImplicitCastToLongInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreNonOverflowingCompileTimeConstants", (String)InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            IntegerMultiplicationImplicitCastToLongInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new IntegerMultiplicationImplicitlyCastToLongVisitor();
    }

    private static boolean isNonLongInteger(PsiType type) {
        if (type == null) {
            return false;
        }
        String text = type.getCanonicalText();
        return s_typesToCheck.contains(text);
    }

    private static boolean hasInnerMultiplication(@NotNull PsiPolyadicExpression expression) {
        IElementType tokenType;
        if (expression == null) {
            IntegerMultiplicationImplicitCastToLongInspection.$$$reportNull$$$0(3);
        }
        if (IntegerMultiplicationImplicitCastToLongInspection.isShiftToken(tokenType = expression.getOperationTokenType())) {
            return IntegerMultiplicationImplicitCastToLongInspection.hasMultiplication(expression.getOperands()[0]);
        }
        return ContainerUtil.exists((Object[])expression.getOperands(), operand -> IntegerMultiplicationImplicitCastToLongInspection.hasMultiplication(operand));
    }

    private static boolean hasMultiplication(PsiExpression expression) {
        if ((expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression)) instanceof PsiPrefixExpression) {
            return IntegerMultiplicationImplicitCastToLongInspection.hasMultiplication(((PsiPrefixExpression)expression).getOperand());
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyExpr = (PsiPolyadicExpression)expression;
            IElementType tokenType = polyExpr.getOperationTokenType();
            if (tokenType == JavaTokenType.ASTERISK) {
                return true;
            }
            return IntegerMultiplicationImplicitCastToLongInspection.hasInnerMultiplication(polyExpr);
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression ternary = (PsiConditionalExpression)expression;
            return IntegerMultiplicationImplicitCastToLongInspection.hasMultiplication(ternary.getThenExpression()) || IntegerMultiplicationImplicitCastToLongInspection.hasMultiplication(ternary.getElseExpression());
        }
        return false;
    }

    private static boolean isShiftToken(IElementType tokenType) {
        return ElementType.SHIFT_OPS.contains(tokenType);
    }

    private static boolean isShiftEqToken(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            IntegerMultiplicationImplicitCastToLongInspection.$$$reportNull$$$0(4);
        }
        return tokenType.equals(JavaTokenType.LTLTEQ) || tokenType.equals(JavaTokenType.GTGTEQ) || tokenType.equals(JavaTokenType.GTGTGTEQ);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/numeric/IntegerMultiplicationImplicitCastToLongInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/numeric/IntegerMultiplicationImplicitCastToLongInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasInnerMultiplication";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isShiftEqToken";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4 -> new IllegalArgumentException(string);
        };
    }

    private static class IntegerMultiplicationImplicitCastToLongInspectionFix
    extends PsiUpdateModCommandQuickFix {
        private IntegerMultiplicationImplicitCastToLongInspectionFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.quickfix", new Object[0]);
            if (string == null) {
                IntegerMultiplicationImplicitCastToLongInspectionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            PsiPolyadicExpression expression;
            PsiExpression[] operands;
            if (project == null) {
                IntegerMultiplicationImplicitCastToLongInspectionFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                IntegerMultiplicationImplicitCastToLongInspectionFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                IntegerMultiplicationImplicitCastToLongInspectionFix.$$$reportNull$$$0(3);
            }
            if ((operands = (expression = (PsiPolyadicExpression)startElement).getOperands()).length < 2) {
                return;
            }
            PsiExpression exprToCast = operands.length > 2 || expression.getOperationTokenType() == JavaTokenType.LTLT ? operands[0] : Arrays.stream(operands).map(operand -> PsiUtil.deparenthesizeExpression((PsiExpression)operand)).filter(operand -> {
                PsiPrefixExpression prefixExpr;
                return IntegerMultiplicationImplicitCastToLongInspectionFix.isIntegerLiteral(operand) || operand instanceof PsiPrefixExpression && IntegerMultiplicationImplicitCastToLongInspectionFix.isIntegerLiteral((prefixExpr = (PsiPrefixExpression)operand).getOperand());
            }).findFirst().orElse(operands[0]);
            IntegerMultiplicationImplicitCastToLongInspectionFix.addCast(exprToCast);
        }

        private static boolean isIntegerLiteral(@Nullable PsiExpression operand) {
            PsiLiteralExpression literal;
            return operand instanceof PsiLiteralExpression && (literal = (PsiLiteralExpression)operand).getValue() instanceof Integer;
        }

        private static void addCast(@NotNull PsiExpression expression) {
            PsiExpression operand;
            if (expression == null) {
                IntegerMultiplicationImplicitCastToLongInspectionFix.$$$reportNull$$$0(4);
            }
            if (expression instanceof PsiPrefixExpression && (operand = ((PsiPrefixExpression)expression).getOperand()) instanceof PsiLiteralExpression) {
                expression = operand;
            }
            String replacementText = IntegerMultiplicationImplicitCastToLongInspectionFix.isIntegerLiteral(expression) ? expression.getText() + "L" : "(long)" + expression.getText();
            PsiReplacementUtil.replaceExpression(expression, replacementText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/numeric/IntegerMultiplicationImplicitCastToLongInspection$IntegerMultiplicationImplicitCastToLongInspectionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/numeric/IntegerMultiplicationImplicitCastToLongInspection$IntegerMultiplicationImplicitCastToLongInspectionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addCast";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private class IntegerMultiplicationImplicitlyCastToLongVisitor
    extends BaseInspectionVisitor {
        private IntegerMultiplicationImplicitlyCastToLongVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            PsiAssignmentExpression assignment;
            if (expression == null) {
                IntegerMultiplicationImplicitlyCastToLongVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.ASTERISK) && !tokenType.equals(JavaTokenType.LTLT)) {
                return;
            }
            PsiType type = expression.getType();
            if (!IntegerMultiplicationImplicitCastToLongInspection.isNonLongInteger(type)) {
                return;
            }
            if (IntegerMultiplicationImplicitCastToLongInspection.hasInnerMultiplication(expression)) {
                return;
            }
            if (IntegerMultiplicationImplicitlyCastToLongVisitor.insideAssertEquals((PsiExpression)expression)) {
                return;
            }
            PsiExpression[] operands = expression.getOperands();
            if (operands.length < 2 || expression.getLastChild() instanceof PsiErrorElement) {
                return;
            }
            PsiExpression context = IntegerMultiplicationImplicitlyCastToLongVisitor.getContainingExpression((PsiExpression)expression);
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)context.getParent());
            if (parent instanceof PsiAssignmentExpression && IntegerMultiplicationImplicitCastToLongInspection.isShiftEqToken((assignment = (PsiAssignmentExpression)parent).getOperationTokenType()) && PsiTreeUtil.isAncestor((PsiElement)assignment.getRExpression(), (PsiElement)context, (boolean)false)) {
                return;
            }
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression cast = (PsiTypeCastExpression)parent;
                PsiType castType = cast.getType();
                if (IntegerMultiplicationImplicitCastToLongInspection.isNonLongInteger(castType)) {
                    return;
                }
                if (PsiTypes.longType().equals((Object)castType)) {
                    context = cast;
                }
            }
            if (!PsiTypes.longType().equals((Object)context.getType()) && !PsiTypes.longType().equals((Object)ExpectedTypeUtils.findExpectedType(context, true))) {
                return;
            }
            if (IntegerMultiplicationImplicitCastToLongInspection.this.ignoreNonOverflowingCompileTimeConstants) {
                try {
                    if (ExpressionUtils.computeConstantExpression((PsiExpression)expression, true) != null) {
                        return;
                    }
                }
                catch (ConstantEvaluationOverflowException constantEvaluationOverflowException) {
                    // empty catch block
                }
                if (IntegerMultiplicationImplicitlyCastToLongVisitor.cannotOverflow(expression, operands, tokenType.equals(JavaTokenType.LTLT))) {
                    return;
                }
            }
            this.registerError((PsiElement)expression, tokenType);
        }

        private static boolean insideAssertEquals(PsiExpression expression) {
            PsiElement parent = ExpressionUtils.getPassThroughParent(expression);
            if (parent instanceof PsiExpressionList) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
                return JUNIT4_ASSERT_EQUALS.matches((PsiExpression)call);
            }
            return false;
        }

        private static boolean cannotOverflow(@NotNull PsiPolyadicExpression expression, PsiExpression[] operands, boolean shift) {
            CommonDataflow.DataflowResult dfr;
            if (expression == null) {
                IntegerMultiplicationImplicitlyCastToLongVisitor.$$$reportNull$$$0(1);
            }
            if ((dfr = CommonDataflow.getDataflowResult((PsiElement)expression)) != null) {
                long min = 1L;
                long max = 1L;
                for (PsiExpression operand : operands) {
                    long r4;
                    long r3;
                    long r2;
                    long r1;
                    DfType type = dfr.getDfType(PsiUtil.skipParenthesizedExprDown((PsiExpression)operand));
                    if (type instanceof DfReferenceType) {
                        type = SpecialField.UNBOX.getFromQualifier(type);
                    }
                    LongRangeSet set = DfLongType.extractRange(type);
                    if (operand == operands[0]) {
                        min = set.min();
                        max = set.max();
                        continue;
                    }
                    if (shift) {
                        set = set.bitwiseAnd(LongRangeSet.point((long)63L));
                        nextMin = set.min();
                        nextMax = set.max();
                        if (nextMax >= 32L) {
                            return false;
                        }
                        r1 = min << (int)nextMin;
                        r2 = max << (int)nextMin;
                        r3 = min << (int)nextMax;
                        r4 = max << (int)nextMax;
                    } else {
                        nextMin = set.min();
                        nextMax = set.max();
                        if (IntegerMultiplicationImplicitlyCastToLongVisitor.intOverflow(nextMin) || IntegerMultiplicationImplicitlyCastToLongVisitor.intOverflow(nextMax)) {
                            return false;
                        }
                        r1 = min * nextMin;
                        r2 = max * nextMin;
                        r3 = min * nextMax;
                        r4 = max * nextMax;
                    }
                    if (IntegerMultiplicationImplicitlyCastToLongVisitor.intOverflow(r1) || IntegerMultiplicationImplicitlyCastToLongVisitor.intOverflow(r2) || IntegerMultiplicationImplicitlyCastToLongVisitor.intOverflow(r3) || IntegerMultiplicationImplicitlyCastToLongVisitor.intOverflow(r4)) {
                        return false;
                    }
                    min = Math.min(Math.min(r1, r2), Math.min(r3, r4));
                    max = Math.max(Math.max(r1, r2), Math.max(r3, r4));
                }
            }
            return true;
        }

        private static boolean intOverflow(long l) {
            return (long)((int)l) != l && l != 0x80000000L;
        }

        private static PsiExpression getContainingExpression(PsiExpression expression) {
            IElementType tokenType;
            PsiPolyadicExpression polyParent;
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiPolyadicExpression && TypeConversionUtil.isNumericType((PsiType)(polyParent = (PsiPolyadicExpression)parent).getType()) && (!IntegerMultiplicationImplicitCastToLongInspection.isShiftToken(tokenType = polyParent.getOperationTokenType()) || expression == polyParent.getOperands()[0])) {
                return IntegerMultiplicationImplicitlyCastToLongVisitor.getContainingExpression((PsiExpression)polyParent);
            }
            if (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPrefixExpression || parent instanceof PsiConditionalExpression) {
                return IntegerMultiplicationImplicitlyCastToLongVisitor.getContainingExpression((PsiExpression)parent);
            }
            return expression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/numeric/IntegerMultiplicationImplicitCastToLongInspection$IntegerMultiplicationImplicitlyCastToLongVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPolyadicExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cannotOverflow";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

