/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.PackageGlobalInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExceptionPackageInspection
extends PackageGlobalInspection {
    @Override
    public CommonProblemDescriptor @Nullable [] checkPackage(@NotNull RefPackage refPackage, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        boolean isExceptionPackage;
        if (refPackage == null) {
            ExceptionPackageInspection.$$$reportNull$$$0(0);
        }
        if (analysisScope == null) {
            ExceptionPackageInspection.$$$reportNull$$$0(1);
        }
        if (inspectionManager == null) {
            ExceptionPackageInspection.$$$reportNull$$$0(2);
        }
        if (globalInspectionContext == null) {
            ExceptionPackageInspection.$$$reportNull$$$0(3);
        }
        if (!(isExceptionPackage = ((Boolean)ReadAction.nonBlocking(() -> {
            String packageName = refPackage.getQualifiedName();
            Project project = globalInspectionContext.getProject();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
            if (aPackage == null || aPackage.getSubPackages().length > 0) {
                return false;
            }
            PsiClass[] classes = aPackage.getClasses(GlobalSearchScope.projectScope((Project)project));
            if (classes.length == 0) {
                return false;
            }
            for (PsiClass aClass : classes) {
                if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Throwable") || TestFrameworks.getInstance().isTestClass(aClass)) continue;
                return false;
            }
            return true;
        }).executeSynchronously()).booleanValue())) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("exception.package.problem.descriptor", refPackage.getQualifiedName());
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "refPackage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "analysisScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "inspectionManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "globalInspectionContext";
                break;
            }
        }
        objectArray[1] = "com/siyeh/ig/packaging/ExceptionPackageInspection";
        objectArray[2] = "checkPackage";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

