/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class MethodReferenceVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean m_referencesStaticallyAccessible = true;
    private final PsiMember m_method;

    public MethodReferenceVisitor(PsiMember method) {
        this.m_method = method;
    }

    public boolean areReferencesStaticallyAccessible() {
        return this.m_referencesStaticallyAccessible;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            MethodReferenceVisitor.$$$reportNull$$$0(0);
        }
        if (!this.m_referencesStaticallyAccessible) {
            return;
        }
        super.visitElement(element);
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            MethodReferenceVisitor.$$$reportNull$$$0(1);
        }
        super.visitReferenceElement(reference);
        PsiClass aClass = (PsiClass)ObjectUtils.tryCast((Object)reference.resolve(), PsiClass.class);
        if (aClass != null && !aClass.hasModifierProperty("static") && aClass.getScope() instanceof PsiClass) {
            this.m_referencesStaticallyAccessible = false;
        }
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        if (expression == null) {
            MethodReferenceVisitor.$$$reportNull$$$0(2);
        }
        super.visitReferenceExpression(expression);
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier == null || qualifier instanceof PsiQualifiedExpression) {
            PsiElement element = expression.resolve();
            if (element != null) {
                PsiClass aClass;
                if ((element instanceof PsiLocalVariable || element instanceof PsiParameter) && PsiTreeUtil.isAncestor((PsiElement)PsiUtil.getVariableCodeBlock((PsiVariable)((PsiVariable)element), null), (PsiElement)this.m_method, (boolean)true)) {
                    this.m_referencesStaticallyAccessible = false;
                    return;
                }
                if (!(element instanceof PsiMember)) {
                    return;
                }
                PsiMember member = (PsiMember)element;
                if (member == this.m_method || member.hasModifierProperty("static") || member instanceof PsiClass && member.getContainingClass() == null) {
                    return;
                }
                PsiExpression effectiveQualifier = ExpressionUtils.getEffectiveQualifier(expression);
                if (effectiveQualifier != null && (aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)effectiveQualifier.getType())) != null && PsiTreeUtil.isAncestor((PsiElement)this.m_method, (PsiElement)aClass, (boolean)false)) {
                    return;
                }
            }
            this.m_referencesStaticallyAccessible = false;
        }
    }

    public void visitThisExpression(@NotNull PsiThisExpression expression) {
        if (expression == null) {
            MethodReferenceVisitor.$$$reportNull$$$0(3);
        }
        super.visitThisExpression(expression);
        this.m_referencesStaticallyAccessible = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/performance/MethodReferenceVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitThisExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

