/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.portability.mediatype.ApplicationMediaType;
import com.siyeh.ig.portability.mediatype.AudioMediaType;
import com.siyeh.ig.portability.mediatype.ImageMediaType;
import com.siyeh.ig.portability.mediatype.MessageMediaType;
import com.siyeh.ig.portability.mediatype.ModelMediaType;
import com.siyeh.ig.portability.mediatype.MultipartMediaType;
import com.siyeh.ig.portability.mediatype.TextMediaType;
import com.siyeh.ig.portability.mediatype.VideoMediaType;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class HardcodedFileSeparatorsInspection
extends BaseInspection {
    private static final char BACKSLASH = '\\';
    private static final char SLASH = '/';
    private final MethodMatcher myMethodMatcher = HardcodedFileSeparatorsInspection.getMatcherByDefault();
    public boolean m_recognizeExampleMediaType = false;

    private static MethodMatcher getMatcherByDefault() {
        return new MethodMatcher(false, "ignoredCalls").add("java.lang.Class", "getResource|getResourceAsStream").add("java.lang.ClassLoader", "findResource|getResource|getResources|resources|getSystemResource|getSystemResources|getSystemResourceAsStream").finishDefault();
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            HardcodedFileSeparatorsInspection.$$$reportNull$$$0(0);
        }
        super.readSettings(element);
        this.myMethodMatcher.readSettings(element);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            HardcodedFileSeparatorsInspection.$$$reportNull$$$0(1);
        }
        super.writeSettings(element);
        this.myMethodMatcher.writeSettings(element);
    }

    @NotNull
    public String getID() {
        return "HardcodedFileSeparator";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("hardcoded.file.separator.problem.descriptor", new Object[0]);
        if (string == null) {
            HardcodedFileSeparatorsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"m_recognizeExampleMediaType", (String)InspectionGadgetsBundle.message("hardcoded.file.separator.include.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), this.myMethodMatcher.getTable(InspectionGadgetsBundle.message("hardcoded.file.separator.ignore.methods.option", new Object[0])).prefix("myMethodMatcher")});
        if (optPane == null) {
            HardcodedFileSeparatorsInspection.$$$reportNull$$$0(3);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new HardcodedFileSeparatorsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/portability/HardcodedFileSeparatorsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/portability/HardcodedFileSeparatorsInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private class HardcodedFileSeparatorsVisitor
    extends BaseInspectionVisitor {
        private HardcodedFileSeparatorsVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                HardcodedFileSeparatorsVisitor.$$$reportNull$$$0(0);
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (TypeUtils.isJavaLangString(type)) {
                PsiNewExpression newExpression;
                PsiMethodCallExpression methodCallExpression;
                PsiElement grandParent;
                String value = (String)expression.getValue();
                if (!this.isHardcodedFilenameString(value)) {
                    return;
                }
                PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
                if (parent != null && ((grandParent = parent.getParent()) instanceof PsiMethodCallExpression ? MethodCallUtils.isCallToRegexMethod(methodCallExpression = (PsiMethodCallExpression)grandParent) || HardcodedFileSeparatorsInspection.this.myMethodMatcher.matches((PsiCall)methodCallExpression) : grandParent instanceof PsiNewExpression && TypeUtils.expressionHasTypeOrSubtype((PsiExpression)(newExpression = (PsiNewExpression)grandParent), "javax.swing.ImageIcon"))) {
                    return;
                }
                this.registerErrorInString(expression);
            } else if (type != null && type.equals(PsiTypes.charType())) {
                Character value = (Character)expression.getValue();
                if (value == null) {
                    return;
                }
                char unboxedValue = value.charValue();
                if (unboxedValue == '\\' || unboxedValue == '/') {
                    this.registerErrorAtOffset((PsiElement)expression, 1, expression.getTextLength() - 2, new Object[0]);
                }
            }
        }

        private boolean isHardcodedFilenameString(String string) {
            if (string == null) {
                return false;
            }
            if (string.indexOf(47) == -1 && string.indexOf(92) == -1) {
                return false;
            }
            int length = string.length();
            for (int i = 0; i < length; ++i) {
                char c = string.charAt(i);
                if (c != '\b' && c != '\n' && c != '\t' && c != '\r' && c != '\f') continue;
                return false;
            }
            if (OSAgnosticPathUtil.startsWithWindowsDrive((String)string)) {
                return true;
            }
            if (HardcodedFileSeparatorsVisitor.isXMLString(string)) {
                return false;
            }
            if (HardcodedFileSeparatorsVisitor.isDateFormatString(string)) {
                return false;
            }
            if (HardcodedFileSeparatorsVisitor.isURLString(string)) {
                return false;
            }
            if (this.isMediaTypeString(string)) {
                return false;
            }
            return !HardcodedFileSeparatorsVisitor.isTimeZoneIdString(string);
        }

        private void registerErrorInString(@NotNull PsiLiteralExpression expression) {
            int[] offsets;
            String text;
            CharSequence result;
            if (expression == null) {
                HardcodedFileSeparatorsVisitor.$$$reportNull$$$0(1);
            }
            if ((result = CodeInsightUtilCore.parseStringCharacters((String)(text = expression.getText()), (int[])(offsets = new int[text.length() + 1]))) == null) {
                return;
            }
            int length = result.length();
            for (int i = 0; i < length; ++i) {
                char c = result.charAt(i);
                if (c != '/' && c != '\\') continue;
                this.registerErrorAtOffset((PsiElement)expression, offsets[i], offsets[i + 1] - offsets[i], new Object[0]);
            }
        }

        private static boolean isXMLString(String string) {
            return string.contains("</") || string.contains("/>");
        }

        private static boolean isDateFormatString(String string) {
            if (string.length() < 3) {
                return false;
            }
            int strLength = string.length();
            char startChar = string.charAt(0);
            char endChar = string.charAt(strLength - 1);
            if (startChar == '/' || endChar == '/') {
                return false;
            }
            if (OSAgnosticPathUtil.startsWithWindowsDrive((String)string)) {
                return false;
            }
            Matcher dateFormatMatcher = Holder.DATE_FORMAT_PATTERN.matcher(string);
            return dateFormatMatcher.find();
        }

        private static boolean isURLString(String string) {
            Matcher urlMatcher = Holder.URL_PATTERN.matcher(string);
            return urlMatcher.find();
        }

        private boolean isMediaTypeString(String string) {
            if (HardcodedFileSeparatorsInspection.this.m_recognizeExampleMediaType && string.matches("example/\\p{Alnum}+(?:[.\\-\\\\+]\\p{Alnum}+)*")) {
                return true;
            }
            return Holder.mimeTypes.contains(string);
        }

        private static boolean isTimeZoneIdString(String string) {
            return Holder.timeZoneIds.contains(string);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/siyeh/ig/portability/HardcodedFileSeparatorsInspection$HardcodedFileSeparatorsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLiteralExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerErrorInString";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Holder {
        @NonNls
        private static final Pattern DATE_FORMAT_PATTERN = Pattern.compile("\\b[dDmM]+/[dDmM]+(/[yY]+)?");
        @NonNls
        private static final String EXAMPLE_MIME_MEDIA_TYPE_PATTERN = "example/\\p{Alnum}+(?:[.\\-\\\\+]\\p{Alnum}+)*";
        @NonNls
        private static final Pattern URL_PATTERN = Pattern.compile("^[a-z][a-z0-9+\\-:]+://.*$");
        private static final Set<String> mimeTypes = new HashSet<String>();
        private static final Set<String> timeZoneIds;

        private Holder() {
        }

        static {
            for (ImageMediaType imageMediaType : ImageMediaType.values()) {
                mimeTypes.add(imageMediaType.toString());
            }
            for (Enum enum_ : ApplicationMediaType.values()) {
                mimeTypes.add(((ApplicationMediaType)enum_).toString());
            }
            for (Enum enum_ : AudioMediaType.values()) {
                mimeTypes.add(((AudioMediaType)enum_).toString());
            }
            for (Enum enum_ : MessageMediaType.values()) {
                mimeTypes.add(((MessageMediaType)enum_).toString());
            }
            for (Enum enum_ : ModelMediaType.values()) {
                mimeTypes.add(((ModelMediaType)enum_).toString());
            }
            for (Enum enum_ : MultipartMediaType.values()) {
                mimeTypes.add(((MultipartMediaType)enum_).toString());
            }
            for (Enum enum_ : TextMediaType.values()) {
                mimeTypes.add(((TextMediaType)enum_).toString());
            }
            for (Enum enum_ : VideoMediaType.values()) {
                mimeTypes.add(((VideoMediaType)enum_).toString());
            }
            timeZoneIds = new HashSet<String>();
            ContainerUtil.addAll(timeZoneIds, (Object[])TimeZone.getAvailableIDs());
        }
    }
}

