/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class ConstructionUtils {
    private static final Set<String> GUAVA_UTILITY_CLASSES = Set.of("com.google.common.collect.Maps", "com.google.common.collect.Lists", "com.google.common.collect.Sets");
    private static final CallMatcher ENUM_SET_NONE_OF = CallMatcher.staticCall("java.util.EnumSet", "noneOf").parameterCount(1);

    @Contract(value="null -> false")
    public static boolean isEmptyStringBuilderInitializer(PsiExpression initializer) {
        return "\"\"".equals(ConstructionUtils.getStringBuilderInitializerText(initializer));
    }

    @Contract(value="null -> null")
    public static String getStringBuilderInitializerText(PsiExpression construction) {
        if (!((construction = PsiUtil.skipParenthesizedExprDown((PsiExpression)construction)) instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression newExpression = (PsiNewExpression)construction;
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        if (!ConstructionUtils.isReferenceTo(classReference, "java.lang.StringBuilder", "java.lang.StringBuffer")) {
            return null;
        }
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length == 0) {
            return "\"\"";
        }
        if (arguments.length != 1) {
            return null;
        }
        PsiExpression argument = arguments[0];
        PsiType argumentType = argument.getType();
        if (PsiTypes.intType().equals((Object)argumentType)) {
            return "\"\"";
        }
        return argument.getText();
    }

    @Contract(value="null -> false")
    public static boolean isEmptyCollectionInitializer(PsiExpression expression) {
        PsiNewExpression newExpression;
        PsiExpressionList argumentList;
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiNewExpression && (argumentList = (newExpression = (PsiNewExpression)expression).getArgumentList()) != null && argumentList.isEmpty() && newExpression.getAnonymousClass() == null) {
            PsiClassType type = (PsiClassType)ObjectUtils.tryCast((Object)expression.getType(), PsiClassType.class);
            if (type == null) {
                return false;
            }
            PsiClass aClass = type.resolve();
            if (aClass == null) {
                return false;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.startsWith("java.util.")) {
                return false;
            }
            return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Map");
        }
        if (expression instanceof PsiMethodCallExpression) {
            String qualifiedName;
            PsiClass aClass;
            PsiMethod method;
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            @NonNls String name = call.getMethodExpression().getReferenceName();
            PsiExpressionList argumentList2 = call.getArgumentList();
            if (name != null && name.startsWith("new") && argumentList2.isEmpty() && (method = call.resolveMethod()) != null && method.getParameterList().isEmpty() && (aClass = method.getContainingClass()) != null && (qualifiedName = aClass.getQualifiedName()) != null && GUAVA_UTILITY_CLASSES.contains(qualifiedName)) {
                return true;
            }
        }
        return ConstructionUtils.isCustomizedEmptyCollectionInitializer(expression);
    }

    public static boolean isPrepopulatedCollectionInitializer(PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiNewExpression) {
            PsiExpressionList args = ((PsiNewExpression)expression).getArgumentList();
            if (args == null || args.isEmpty()) {
                return false;
            }
            PsiMethod ctor = ((PsiNewExpression)expression).resolveMethod();
            if (ctor == null) {
                return false;
            }
            PsiClass aClass = ctor.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String name = aClass.getQualifiedName();
            if (name == null || !name.startsWith("java.util.")) {
                return false;
            }
            for (PsiParameter parameter : ctor.getParameterList().getParameters()) {
                PsiType type = parameter.getType();
                if (!PsiTypesUtil.classNameEquals((PsiType)type, (String)"java.util.Collection") && !PsiTypesUtil.classNameEquals((PsiType)type, (String)"java.util.Map")) continue;
                return true;
            }
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            @NonNls String name = call.getMethodExpression().getReferenceName();
            PsiExpressionList argumentList = call.getArgumentList();
            if (name != null && name.startsWith("new") && !argumentList.isEmpty()) {
                PsiMethod method = call.resolveMethod();
                if (method == null) {
                    return false;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return false;
                }
                String qualifiedName = aClass.getQualifiedName();
                if (qualifiedName == null || !GUAVA_UTILITY_CLASSES.contains(qualifiedName)) {
                    return false;
                }
                for (PsiParameter parameter : method.getParameterList().getParameters()) {
                    PsiType type = parameter.getType();
                    if (type instanceof PsiEllipsisType) {
                        return true;
                    }
                    if (!PsiTypesUtil.classNameEquals((PsiType)type, (String)"java.lang.Iterable") && !PsiTypesUtil.classNameEquals((PsiType)type, (String)"java.util.Iterator")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isCustomizedEmptyCollectionInitializer(PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiNewExpression) {
            PsiExpressionList argumentList = ((PsiNewExpression)expression).getArgumentList();
            if (argumentList == null || argumentList.isEmpty() || ((PsiNewExpression)expression).getAnonymousClass() != null) {
                return false;
            }
            PsiMethod constructor = ((PsiNewExpression)expression).resolveConstructor();
            if (constructor == null) {
                return false;
            }
            PsiClass aClass = constructor.getContainingClass();
            if (!(aClass == null || aClass.getQualifiedName() != null && aClass.getQualifiedName().startsWith("java.util."))) {
                return false;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Collection") && !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Map")) {
                return false;
            }
            Predicate<PsiType> allowedParameterType = t -> t instanceof PsiPrimitiveType || InheritanceUtil.isInheritor((PsiType)t, (String)"java.lang.Class");
            return Stream.of(constructor.getParameterList().getParameters()).map(PsiParameter::getType).allMatch(allowedParameterType);
        }
        if (expression instanceof PsiMethodCallExpression) {
            String qualifiedName;
            PsiClass aClass;
            PsiMethod method;
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            if (ENUM_SET_NONE_OF.test(call)) {
                return true;
            }
            @NonNls String name = call.getMethodExpression().getReferenceName();
            PsiExpressionList argumentList = call.getArgumentList();
            if (name != null && name.startsWith("new") && !argumentList.isEmpty() && (method = call.resolveMethod()) != null && !method.getParameterList().isEmpty() && (aClass = method.getContainingClass()) != null && (qualifiedName = aClass.getQualifiedName()) != null && GUAVA_UTILITY_CLASSES.contains(qualifiedName)) {
                return ContainerUtil.and((Object[])method.getParameterList().getParameters(), p -> p.getType() instanceof PsiPrimitiveType);
            }
        }
        return false;
    }

    public static boolean isEmptyArrayInitializer(@Nullable PsiExpression expression) {
        if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)expression;
        PsiExpression[] dimensions = newExpression.getArrayDimensions();
        if (dimensions.length == 0) {
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            return arrayInitializer != null && arrayInitializer.isEmpty();
        }
        for (PsiExpression dimension : dimensions) {
            if (ExpressionUtils.isZero(dimension)) continue;
            return false;
        }
        return true;
    }

    public static boolean isReferenceTo(PsiJavaCodeReferenceElement ref, String ... classNames) {
        if (ref == null) {
            return false;
        }
        String name = ref.getReferenceName();
        if (name == null) {
            return false;
        }
        String qualifiedName = null;
        for (String className : classNames) {
            if (!StringUtil.getShortName((String)className).equals(name)) continue;
            if (qualifiedName == null) {
                qualifiedName = ref.getQualifiedName();
            }
            if (!className.equals(qualifiedName)) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isCollectionWithCopyConstructor(PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        String name = aClass.getQualifiedName();
        return name != null && name.startsWith("java.util.") && ContainerUtil.or((Object[])aClass.getConstructors(), ConstructionUtils::isCollectionConstructor);
    }

    @Contract(value="null -> false")
    public static boolean isCollectionConstructor(PsiMethod ctor) {
        if (ctor == null || !ctor.isConstructor() || !ctor.getModifierList().hasExplicitModifier("public")) {
            return false;
        }
        PsiParameterList list = ctor.getParameterList();
        if (list.getParametersCount() != 1) {
            return false;
        }
        PsiType type = Objects.requireNonNull(list.getParameter(0)).getType();
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        return aClass != null && ("java.util.Collection".equals(aClass.getQualifiedName()) || "java.util.Map".equals(aClass.getQualifiedName()));
    }
}

