/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.java.codeserver.core.JavaPsiReferenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class ExpressionUtils {
    @NonNls
    private static final Set<String> IMPLICIT_TO_STRING_METHOD_NAMES = Set.of("append", "format", "print", "printf", "println", "valueOf");
    @NonNls
    private static final @Unmodifiable Set<String> convertableBoxedClassNames = Set.of("java.lang.Byte", "java.lang.Character", "java.lang.Short");
    private static final CallMatcher KNOWN_SIMPLE_CALLS = CallMatcher.staticCall("java.util.Collections", "emptyList", "emptySet", "emptyIterator", "emptyMap", "emptySortedMap", "emptySortedSet", "emptyListIterator").parameterCount(0);
    private static final CallMatcher GET_OR_DEFAULT = CallMatcher.instanceCall("java.util.Map", "getOrDefault").parameterCount(2);

    private ExpressionUtils() {
    }

    @Nullable
    public static Object computeConstantExpression(@Nullable PsiExpression expression) {
        return ExpressionUtils.computeConstantExpression(expression, false);
    }

    @Nullable
    public static Object computeConstantExpression(@Nullable PsiExpression expression, boolean throwConstantEvaluationOverflowException) {
        if (expression == null) {
            return null;
        }
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiConstantEvaluationHelper constantEvaluationHelper = psiFacade.getConstantEvaluationHelper();
        return constantEvaluationHelper.computeConstantExpression((PsiElement)expression, throwConstantEvaluationOverflowException);
    }

    public static boolean isConstant(PsiField field) {
        if (!field.hasModifierProperty("final")) {
            return false;
        }
        if (CollectionUtils.isEmptyArray((PsiVariable)field)) {
            return true;
        }
        PsiType type = field.getType();
        return ClassUtils.isImmutable(type);
    }

    public static boolean hasExpressionCount(@Nullable PsiExpressionList expressionList, int count) {
        return ControlFlowUtils.hasChildrenOfTypeCount((PsiElement)expressionList, count, PsiExpression.class);
    }

    @Nullable
    public static PsiExpression getFirstExpressionInList(@Nullable PsiExpressionList expressionList) {
        return (PsiExpression)PsiTreeUtil.getChildOfType((PsiElement)expressionList, PsiExpression.class);
    }

    @Nullable
    public static PsiExpression getOnlyExpressionInList(@Nullable PsiExpressionList expressionList) {
        return ControlFlowUtils.getOnlyChildOfType((PsiElement)expressionList, PsiExpression.class);
    }

    public static boolean isDeclaredConstant(PsiExpression expression) {
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiField.class);
        if (field == null) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiAssignmentExpression.class);
            if (assignmentExpression == null) {
                return false;
            }
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return false;
            }
            PsiField f = (PsiField)target;
            field = f;
        }
        return field.hasModifierProperty("static") && field.hasModifierProperty("final");
    }

    @Contract(value="null -> false")
    public static boolean isEvaluatedAtCompileTime(@Nullable PsiExpression expression) {
        if (expression instanceof PsiLiteralExpression) {
            return true;
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (ExpressionUtils.isEvaluatedAtCompileTime(operand)) continue;
                return false;
            }
            return true;
        }
        if (expression instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            return ExpressionUtils.isEvaluatedAtCompileTime(prefixExpression.getOperand());
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement qualifier = referenceExpression.getQualifier();
            if (qualifier instanceof PsiThisExpression) {
                return false;
            }
            PsiElement element = referenceExpression.resolve();
            if (element instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)element;
                return !PsiTreeUtil.isAncestor((PsiElement)variable, (PsiElement)expression, (boolean)true) && variable.hasModifierProperty("final") && ExpressionUtils.isEvaluatedAtCompileTime(PsiFieldImpl.getDetachedInitializer((PsiVariable)variable));
            }
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            return ExpressionUtils.isEvaluatedAtCompileTime(parenthesizedExpression.getExpression());
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            return ExpressionUtils.isEvaluatedAtCompileTime(conditionalExpression.getCondition()) && ExpressionUtils.isEvaluatedAtCompileTime(conditionalExpression.getThenExpression()) && ExpressionUtils.isEvaluatedAtCompileTime(conditionalExpression.getElseExpression());
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
            return ExpressionUtils.hasStringType((PsiExpression)typeCastExpression) && ExpressionUtils.isEvaluatedAtCompileTime(typeCastExpression.getOperand());
        }
        return false;
    }

    @Nullable
    public static PsiLiteralExpression getLiteral(@Nullable PsiExpression expression) {
        PsiLiteralExpression literal;
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiLiteralExpression) {
            PsiLiteralExpression literal2 = (PsiLiteralExpression)expression;
            return literal2;
        }
        if (!(expression instanceof PsiTypeCastExpression)) {
            return null;
        }
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
        PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)typeCastExpression.getOperand());
        return operand instanceof PsiLiteralExpression ? (literal = (PsiLiteralExpression)operand) : null;
    }

    public static boolean isLiteral(@Nullable PsiExpression expression) {
        return ExpressionUtils.getLiteral(expression) != null;
    }

    public static boolean isEmptyStringLiteral(@Nullable PsiExpression expression) {
        PsiLiteralExpression literal;
        PsiExpression psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        return psiExpression instanceof PsiLiteralExpression && "\"\"".equals((literal = (PsiLiteralExpression)psiExpression).getText());
    }

    @Contract(value="null -> false")
    public static boolean isNullLiteral(@Nullable PsiExpression expression) {
        PsiLiteralExpression literal;
        PsiExpression psiExpression = PsiUtil.deparenthesizeExpression((PsiExpression)expression);
        return psiExpression instanceof PsiLiteralExpression && PsiUtil.isJavaToken((PsiElement)(literal = (PsiLiteralExpression)psiExpression).getFirstChild(), (IElementType)JavaTokenType.NULL_KEYWORD);
    }

    public static Stream<PsiExpression> nonStructuralChildren(@NotNull PsiExpression expression) {
        if (expression == null) {
            ExpressionUtils.$$$reportNull$$$0(0);
        }
        return ((StreamEx)StreamEx.ofTree((Object)expression, e -> {
            if (e instanceof PsiConditionalExpression) {
                PsiConditionalExpression ternary = (PsiConditionalExpression)e;
                return StreamEx.of((Object[])new PsiExpression[]{ternary.getThenExpression(), ternary.getElseExpression()}).nonNull();
            }
            if (e instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parens = (PsiParenthesizedExpression)e;
                return StreamEx.ofNullable((Object)parens.getExpression());
            }
            if (e instanceof PsiSwitchExpression) {
                PsiStatement[] statements;
                PsiSwitchExpression switchExpression = (PsiSwitchExpression)e;
                PsiCodeBlock switchBody = switchExpression.getBody();
                if (switchBody == null) {
                    return StreamEx.empty();
                }
                ArrayList<PsiExpression> result = new ArrayList<PsiExpression>();
                for (PsiStatement statement : statements = switchBody.getStatements()) {
                    if (statement instanceof PsiSwitchLabeledRuleStatement) {
                        PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)statement;
                        PsiStatement ruleBody = rule.getBody();
                        if (ruleBody instanceof PsiBlockStatement) {
                            PsiBlockStatement blockStatement = (PsiBlockStatement)ruleBody;
                            ExpressionUtils.collectYieldExpressions((PsiStatement)blockStatement, switchExpression, result);
                            continue;
                        }
                        if (!(ruleBody instanceof PsiExpressionStatement)) continue;
                        PsiExpressionStatement expr = (PsiExpressionStatement)ruleBody;
                        result.add(expr.getExpression());
                        continue;
                    }
                    ExpressionUtils.collectYieldExpressions(statement, switchExpression, result);
                }
                return StreamEx.of(result);
            }
            return null;
        }).remove(e -> e instanceof PsiConditionalExpression || e instanceof PsiParenthesizedExpression || e instanceof PsiSwitchExpression)).map(e -> {
            PsiTypeCastExpression cast;
            PsiExpression operand;
            if (e instanceof PsiTypeCastExpression && (operand = (cast = (PsiTypeCastExpression)e).getOperand()) != null && !(e.getType() instanceof PsiPrimitiveType) && (!(operand.getType() instanceof PsiPrimitiveType) || PsiTypes.nullType().equals(operand.getType()))) {
                return PsiUtil.skipParenthesizedExprDown((PsiExpression)operand);
            }
            return e;
        }).nonNull().flatMap(e -> {
            PsiMethodCallExpression call;
            if (e instanceof PsiMethodCallExpression && GET_OR_DEFAULT.test(call = (PsiMethodCallExpression)e)) {
                return StreamEx.of((Object[])new PsiExpression[]{e, call.getArgumentList().getExpressions()[1]});
            }
            return StreamEx.of((Object)e);
        });
    }

    private static void collectYieldExpressions(@NotNull PsiStatement statement, @NotNull PsiSwitchExpression switchExpression, @NotNull Collection<PsiExpression> result) {
        Set<PsiYieldStatement> set;
        if (statement == null) {
            ExpressionUtils.$$$reportNull$$$0(1);
        }
        if (switchExpression == null) {
            ExpressionUtils.$$$reportNull$$$0(2);
        }
        if (result == null) {
            ExpressionUtils.$$$reportNull$$$0(3);
        }
        if (statement instanceof PsiYieldStatement) {
            PsiYieldStatement yieldStatement = (PsiYieldStatement)statement;
            set = Collections.singleton(yieldStatement);
        } else {
            set = PsiTreeUtil.findChildrenOfType((PsiElement)statement, PsiYieldStatement.class);
        }
        Set<PsiYieldStatement> yields = set;
        List myYields = ContainerUtil.filter(yields, st -> st.findEnclosingExpression() == switchExpression);
        for (PsiYieldStatement yield : myYields) {
            ContainerUtil.addIfNotNull(result, (Object)yield.getExpression());
        }
    }

    public static boolean isZero(@Nullable PsiExpression expression) {
        Byte bValue;
        Character cValue;
        Short sValue;
        Long lValue;
        Integer iValue;
        Float fValue;
        Double dValue;
        if (expression == null) {
            return false;
        }
        Object value = ExpressionUtils.computeConstantExpression(expression);
        if (value == null) {
            return false;
        }
        return value instanceof Double && (dValue = (Double)value) == 0.0 || value instanceof Float && (fValue = (Float)value).floatValue() == 0.0f || value instanceof Integer && (iValue = (Integer)value) == 0 || value instanceof Long && (lValue = (Long)value) == 0L || value instanceof Short && (sValue = (Short)value) == 0 || value instanceof Character && (cValue = (Character)value).charValue() == '\u0000' || value instanceof Byte && (bValue = (Byte)value) == 0;
    }

    public static boolean isOne(@Nullable PsiExpression expression) {
        Byte bValue;
        Character cValue;
        Short sValue;
        Long lValue;
        Integer iValue;
        Float fValue;
        Double dValue;
        if (expression == null) {
            return false;
        }
        Object value = ExpressionUtils.computeConstantExpression(expression);
        if (value == null) {
            return false;
        }
        return value instanceof Double && (dValue = (Double)value) == 1.0 || value instanceof Float && (fValue = (Float)value).floatValue() == 1.0f || value instanceof Integer && (iValue = (Integer)value) == 1 || value instanceof Long && (lValue = (Long)value) == 1L || value instanceof Short && (sValue = (Short)value) == 1 || value instanceof Character && (cValue = (Character)value).charValue() == '\u0001' || value instanceof Byte && (bValue = (Byte)value) == 1;
    }

    public static boolean isNegation(@Nullable PsiExpression condition, boolean ignoreNegatedNullComparison, boolean ignoreNegatedZeroComparison) {
        if ((condition = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition)) instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            return tokenType.equals(JavaTokenType.EXCL);
        }
        if (condition instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getLOperand());
            PsiExpression rhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)binaryExpression.getROperand());
            if (lhs == null || rhs == null) {
                return false;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.NE)) {
                if (ignoreNegatedNullComparison) {
                    String lhsText = lhs.getText();
                    String rhsText = rhs.getText();
                    if ("null".equals(lhsText) || "null".equals(rhsText)) {
                        return false;
                    }
                }
                return !ignoreNegatedZeroComparison || !ExpressionUtils.isZeroLiteral(lhs) && !ExpressionUtils.isZeroLiteral(rhs);
            }
        }
        return false;
    }

    private static boolean isZeroLiteral(PsiExpression expression) {
        Long lValue;
        Integer iValue;
        if (!(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literal = (PsiLiteralExpression)expression;
        Object value = literal.getValue();
        return value instanceof Integer && (iValue = (Integer)value) == 0 || value instanceof Long && (lValue = (Long)value) == 0L;
    }

    public static boolean isOffsetArrayAccess(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        PsiExpression strippedExpression;
        if (variable == null) {
            ExpressionUtils.$$$reportNull$$$0(4);
        }
        if (!((strippedExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiArrayAccessExpression)) {
            return false;
        }
        PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)strippedExpression;
        PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)arrayExpression)) {
            return false;
        }
        PsiExpression index = arrayAccessExpression.getIndexExpression();
        if (index == null) {
            return false;
        }
        return ExpressionUtils.expressionIsOffsetVariableLookup(index, variable);
    }

    private static boolean expressionIsOffsetVariableLookup(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            ExpressionUtils.$$$reportNull$$$0(5);
        }
        if (ExpressionUtils.isReferenceTo(expression, variable)) {
            return true;
        }
        PsiExpression psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        if (!(psiExpression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)psiExpression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (!JavaTokenType.PLUS.equals(tokenType) && !JavaTokenType.MINUS.equals(tokenType)) {
            return false;
        }
        if (ExpressionUtils.expressionIsOffsetVariableLookup(binaryExpression.getLOperand(), variable)) {
            return true;
        }
        return ExpressionUtils.expressionIsOffsetVariableLookup(binaryExpression.getROperand(), variable) && !JavaTokenType.MINUS.equals(tokenType);
    }

    public static boolean isVariableLessThanComparison(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        PsiExpression psiExpression;
        if (variable == null) {
            ExpressionUtils.$$$reportNull$$$0(6);
        }
        if (!((psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)psiExpression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE)) {
            return ExpressionUtils.isReferenceTo(binaryExpression.getLOperand(), variable);
        }
        if (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE)) {
            return ExpressionUtils.isReferenceTo(binaryExpression.getROperand(), variable);
        }
        return false;
    }

    public static boolean isStringConcatenationOperand(PsiExpression expression) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
        if (!(parent instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        if (!JavaTokenType.PLUS.equals(polyadicExpression.getOperationTokenType())) {
            return false;
        }
        PsiExpression[] operands = polyadicExpression.getOperands();
        if (operands.length < 2) {
            return false;
        }
        for (int i = 0; i < operands.length; ++i) {
            PsiExpression operand = operands[i];
            if (PsiUtil.skipParenthesizedExprDown((PsiExpression)operand) == expression) {
                return i == 0 && TypeUtils.isJavaLangString(operands[1].getType());
            }
            PsiType type = operand.getType();
            if (!TypeUtils.isJavaLangString(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasType(@Nullable PsiExpression expression, @NonNls @NotNull String typeName) {
        if (typeName == null) {
            ExpressionUtils.$$$reportNull$$$0(7);
        }
        if (expression == null) {
            return false;
        }
        if (typeName.equals("java.lang.String")) {
            PsiPolyadicExpression poly;
            IElementType tokenType;
            if (expression instanceof PsiUnaryExpression || expression instanceof PsiInstanceOfExpression || expression instanceof PsiFunctionalExpression) {
                return false;
            }
            if (expression instanceof PsiPolyadicExpression && !(tokenType = (poly = (PsiPolyadicExpression)expression).getOperationTokenType()).equals(JavaTokenType.PLUS)) {
                return false;
            }
        }
        PsiType type = expression.getType();
        return TypeUtils.typeEquals(typeName, type);
    }

    public static boolean hasStringType(@Nullable PsiExpression expression) {
        return ExpressionUtils.hasType(expression, "java.lang.String");
    }

    public static boolean isConversionToStringNecessary(PsiExpression expression, boolean throwable) {
        return ExpressionUtils.isConversionToStringNecessary(expression, throwable, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isConversionToStringNecessary(PsiExpression expression, boolean throwable, @Nullable PsiType type) {
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
        if (parent instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            if (!TypeUtils.typeEquals("java.lang.String", polyadicExpression.getType())) {
                return true;
            }
            PsiExpression[] operands = polyadicExpression.getOperands();
            boolean expressionSeen = false;
            int i = 0;
            int length = operands.length;
            while (i < length) {
                PsiExpression operand = operands[i];
                if (PsiTreeUtil.isAncestor((PsiElement)operand, (PsiElement)expression, (boolean)false)) {
                    if (i > 0) {
                        return true;
                    }
                    expressionSeen = true;
                } else if ((!expressionSeen || i == 1) && TypeUtils.isJavaLangString(operand.getType())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (!(parent instanceof PsiExpressionList)) return true;
        PsiExpressionList expressionList = (PsiExpressionList)parent;
        PsiElement grandParent = expressionList.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) return true;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiReferenceExpression methodExpression1 = methodCallExpression.getMethodExpression();
        @NonNls String name = methodExpression1.getReferenceName();
        PsiExpression[] expressions = expressionList.getExpressions();
        if ("insert".equals(name)) {
            if (expressions.length < 2) return true;
            if (!expression.equals((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expressions[1]))) {
                return true;
            }
            if (ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.lang.StringBuilder", "java.lang.StringBuffer")) return false;
            return true;
        }
        if ("append".equals(name)) {
            if (!expression.equals((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expressions[0]))) return true;
            if (!ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.lang.StringBuilder", "java.lang.StringBuffer")) return true;
            if (expressions.length == 1) {
                return false;
            }
            if (expressions.length != 3) return true;
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.CharSequence")) return false;
            return true;
        }
        if ("print".equals(name) || "println".equals(name)) {
            if (ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.io.PrintStream", "java.io.PrintWriter")) return false;
            return true;
        }
        if ("trace".equals(name) || "debug".equals(name) || "info".equals(name) || "warn".equals(name) || "error".equals(name)) {
            if (!ExpressionUtils.isCallToMethodIn(methodCallExpression, "org.slf4j.Logger")) {
                return true;
            }
            int l = 1;
            int i = 0;
            while (i < expressions.length) {
                PsiExpression expression1 = expressions[i];
                if (i == 0 && TypeUtils.expressionHasTypeOrSubtype(expression1, "org.slf4j.Marker")) {
                    l = 2;
                }
                if (expression1 == expression) {
                    if (i < l) return true;
                    if (throwable && i == expressions.length - 1) {
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }
        if (!FormatUtils.isFormatCall(methodCallExpression)) return true;
        return ExpressionUtils.isConversionToStringNecessary(expression, methodCallExpression);
    }

    private static boolean isConversionToStringNecessary(PsiExpression expression, PsiMethodCallExpression formatCall) {
        PsiTypeParameter returnTypeParameter;
        PsiClassType type;
        PsiType psiType;
        PsiExpressionList expressionList = formatCall.getArgumentList();
        PsiExpression formatArgument = FormatUtils.getFormatArgument(expressionList);
        if (PsiTreeUtil.isAncestor((PsiElement)formatArgument, (PsiElement)expression, (boolean)false)) {
            return true;
        }
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression;
        Object[] expressions = formatCall.getArgumentList().getExpressions();
        int formatArgumentIndex = ArrayUtil.find((Object[])expressions, (Object)formatArgument);
        if (formatArgumentIndex == -1) {
            return false;
        }
        int expressionIndex = ArrayUtil.find((Object[])expressions, (Object)expression);
        if (expressionIndex != formatArgumentIndex + 1 || expressionIndex != expressions.length - 1) {
            return false;
        }
        PsiMethodCallExpression qualifierCall = MethodCallUtils.getQualifierMethodCall(callExpression);
        if (qualifierCall == null || qualifierCall.getTypeArguments().length > 0) {
            return false;
        }
        PsiExpression qualifier = qualifierCall.getMethodExpression().getQualifierExpression();
        if (qualifier == null || !((psiType = qualifier.getType()) instanceof PsiClassType) || (type = (PsiClassType)psiType).isRaw()) {
            return false;
        }
        PsiMethod method = qualifierCall.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)returnType);
        return psiClass instanceof PsiTypeParameter && (returnTypeParameter = (PsiTypeParameter)psiClass).getOwner() == method && !ContainerUtil.map((Object[])method.getParameterList().getParameters(), PsiParameter::getType).contains(returnType);
    }

    private static boolean isCallToMethodIn(PsiMethodCallExpression methodCallExpression, String ... classNames) {
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return ArrayUtil.contains((String)containingClass.getQualifiedName(), (String[])classNames);
    }

    public static boolean isNegative(@NotNull PsiExpression expression) {
        PsiPrefixExpression prefix;
        PsiElement psiElement;
        if (expression == null) {
            ExpressionUtils.$$$reportNull$$$0(8);
        }
        return (psiElement = expression.getParent()) instanceof PsiPrefixExpression && JavaTokenType.MINUS.equals((prefix = (PsiPrefixExpression)psiElement).getOperationTokenType());
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiVariable getVariableFromNullComparison(PsiExpression expression, boolean equals) {
        PsiVariable variable;
        PsiReferenceExpression referenceExpression = ExpressionUtils.getReferenceExpressionFromNullComparison(expression, equals);
        if (referenceExpression == null) {
            return null;
        }
        PsiElement psiElement = referenceExpression.resolve();
        return psiElement instanceof PsiVariable ? (variable = (PsiVariable)psiElement) : null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiReferenceExpression getReferenceExpressionFromNullComparison(PsiExpression expression, boolean equals) {
        PsiReferenceExpression ref;
        if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        if (equals ? !JavaTokenType.EQEQ.equals(tokenType) : !JavaTokenType.NE.equals(tokenType)) {
            return null;
        }
        PsiExpression[] operands = polyadicExpression.getOperands();
        if (operands.length != 2) {
            return null;
        }
        PsiExpression comparedToNull = null;
        if (PsiTypes.nullType().equals(operands[0].getType())) {
            comparedToNull = operands[1];
        } else if (PsiTypes.nullType().equals(operands[1].getType())) {
            comparedToNull = operands[0];
        }
        comparedToNull = PsiUtil.skipParenthesizedExprDown((PsiExpression)comparedToNull);
        return comparedToNull instanceof PsiReferenceExpression ? (ref = (PsiReferenceExpression)comparedToNull) : null;
    }

    @Nullable
    public static PsiExpression getValueComparedWithNull(@NotNull PsiBinaryExpression binOp) {
        IElementType tokenType;
        if (binOp == null) {
            ExpressionUtils.$$$reportNull$$$0(9);
        }
        if (!(tokenType = binOp.getOperationTokenType()).equals(JavaTokenType.EQEQ) && !tokenType.equals(JavaTokenType.NE)) {
            return null;
        }
        PsiExpression left = binOp.getLOperand();
        PsiExpression right = binOp.getROperand();
        if (ExpressionUtils.isNullLiteral(right)) {
            return left;
        }
        if (ExpressionUtils.isNullLiteral(left)) {
            return right;
        }
        return null;
    }

    @Nullable
    public static PsiExpression getValueComparedWithZero(@NotNull PsiBinaryExpression binOp) {
        if (binOp == null) {
            ExpressionUtils.$$$reportNull$$$0(10);
        }
        return ExpressionUtils.getValueComparedWithZero(binOp, JavaTokenType.EQEQ);
    }

    @Nullable
    public static PsiExpression getValueComparedWithZero(@NotNull PsiBinaryExpression binOp, IElementType opType) {
        if (binOp == null) {
            ExpressionUtils.$$$reportNull$$$0(11);
        }
        if (!binOp.getOperationTokenType().equals(opType)) {
            return null;
        }
        PsiExpression rOperand = binOp.getROperand();
        if (rOperand == null) {
            return null;
        }
        PsiExpression lOperand = binOp.getLOperand();
        if (ExpressionUtils.isZero(lOperand)) {
            return rOperand;
        }
        if (ExpressionUtils.isZero(rOperand)) {
            return lOperand;
        }
        return null;
    }

    public static boolean isStringConcatenation(PsiElement element) {
        if (!(element instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression = (PsiPolyadicExpression)element;
        PsiType type = expression.getType();
        return type != null && type.equalsToText("java.lang.String");
    }

    @Contract(value="null -> false")
    public static boolean isSafelyRecomputableExpression(@Nullable PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiLiteralExpression || expression instanceof PsiThisExpression || expression instanceof PsiClassObjectAccessExpression || ExpressionUtils.isEvaluatedAtCompileTime(expression)) {
            return true;
        }
        if (expression instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression initializer = (PsiArrayInitializerExpression)expression;
            return ContainerUtil.all((Object[])initializer.getInitializers(), e -> ExpressionUtils.isSafelyRecomputableExpression(e));
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression cond = (PsiConditionalExpression)expression;
            return ExpressionUtils.isSafelyRecomputableExpression(cond.getCondition()) && ExpressionUtils.isSafelyRecomputableExpression(cond.getThenExpression()) && ExpressionUtils.isSafelyRecomputableExpression(cond.getElseExpression());
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)expression;
            PsiElement target = ref.resolve();
            if (target instanceof PsiLocalVariable || target instanceof PsiParameter) {
                return true;
            }
            PsiExpression qualifier = ref.getQualifierExpression();
            if (target == null && qualifier == null) {
                return true;
            }
            if (target instanceof PsiField) {
                PsiField field = (PsiField)target;
                if (!field.hasModifierProperty("final")) {
                    return false;
                }
                return qualifier == null || qualifier instanceof PsiThisExpression || field.hasModifierProperty("static");
            }
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            return KNOWN_SIMPLE_CALLS.test(call);
        }
        return false;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiAssignmentExpression getAssignment(PsiElement element) {
        PsiAssignmentExpression assignment;
        PsiExpression expression;
        if (element instanceof PsiExpressionStatement) {
            PsiExpressionStatement statement = (PsiExpressionStatement)element;
            element = statement.getExpression();
        }
        if (element instanceof PsiExpression && (element = PsiUtil.skipParenthesizedExprDown((PsiExpression)(expression = (PsiExpression)element))) instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)element).getOperationTokenType().equals(JavaTokenType.EQ)) {
            return assignment;
        }
        return null;
    }

    @Contract(value="null, _ -> null; _, null -> null")
    public static PsiExpression getAssignmentTo(PsiElement element, PsiVariable target) {
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(element);
        if (assignment != null && ExpressionUtils.isReferenceTo(assignment.getLExpression(), target)) {
            return assignment.getRExpression();
        }
        return null;
    }

    @Contract(value="null, _ -> false")
    public static boolean isLiteral(PsiElement element, Object value) {
        PsiLiteralExpression expression;
        return element instanceof PsiLiteralExpression && value.equals((expression = (PsiLiteralExpression)element).getValue());
    }

    public static boolean isAutoBoxed(@NotNull PsiExpression expression) {
        block11: {
            PsiClassType classType;
            PsiType expressionType;
            block13: {
                block12: {
                    PsiMethodCallExpression call;
                    PsiMethod method;
                    PsiElement grandParent;
                    PsiElement parent;
                    if (expression == null) {
                        ExpressionUtils.$$$reportNull$$$0(12);
                    }
                    if ((parent = expression.getParent()) instanceof PsiParenthesizedExpression) {
                        return false;
                    }
                    if (parent instanceof PsiExpressionList && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression && (method = (call = (PsiMethodCallExpression)grandParent).resolveMethod()) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"java.lang.invoke.MethodHandle.PolymorphicSignature", (int)0)) {
                        return false;
                    }
                    expressionType = expression.getType();
                    if (PsiPrimitiveType.getUnboxedType((PsiType)expressionType) != null && parent instanceof PsiUnaryExpression) {
                        PsiUnaryExpression unary = (PsiUnaryExpression)parent;
                        IElementType sign = unary.getOperationTokenType();
                        return sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS;
                    }
                    if (expressionType == null || expressionType.equals(PsiTypes.voidType()) || !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expressionType)) {
                        return false;
                    }
                    PsiPrimitiveType primitiveType = (PsiPrimitiveType)expressionType;
                    PsiClassType boxedType = primitiveType.getBoxedType((PsiElement)expression);
                    if (boxedType == null) {
                        return false;
                    }
                    PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, false, true);
                    if (expectedType == null || ClassUtils.isPrimitive(expectedType)) {
                        return false;
                    }
                    if (expectedType.isAssignableFrom((PsiType)boxedType)) break block11;
                    if (!(expectedType instanceof PsiClassType)) break block12;
                    classType = (PsiClassType)expectedType;
                    if (PsiUtil.isConstantExpression((PsiExpression)expression)) break block13;
                }
                return false;
            }
            String className = classType.getCanonicalText();
            if (!convertableBoxedClassNames.contains(className)) {
                return false;
            }
            return PsiTypes.byteType().equals((Object)expressionType) || PsiTypes.charType().equals((Object)expressionType) || PsiTypes.shortType().equals((Object)expressionType) || PsiTypes.intType().equals((Object)expressionType);
        }
        return true;
    }

    @Contract(value="null, _ -> null; !null, null -> null")
    public static PsiExpression getOtherOperand(@Nullable PsiBinaryExpression binOp, @Nullable PsiVariable variable) {
        if (binOp == null || variable == null) {
            return null;
        }
        if (ExpressionUtils.isReferenceTo(binOp.getLOperand(), variable)) {
            return binOp.getROperand();
        }
        if (ExpressionUtils.isReferenceTo(binOp.getROperand(), variable)) {
            return binOp.getLOperand();
        }
        return null;
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean isReferenceTo(PsiExpression expression, PsiVariable variable) {
        if (variable == null) {
            return false;
        }
        if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)expression;
        if ((variable instanceof PsiLocalVariable || variable instanceof PsiParameter) && ref.isQualified()) {
            return false;
        }
        return ref.isReferenceTo((PsiElement)variable);
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiMethodCallExpression getCallForQualifier(PsiExpression qualifier) {
        PsiReferenceExpression methodExpr;
        PsiElement psiElement;
        if (qualifier != null && (psiElement = PsiUtil.skipParenthesizedExprUp((PsiElement)qualifier.getParent())) instanceof PsiReferenceExpression && PsiTreeUtil.isAncestor((PsiElement)(methodExpr = (PsiReferenceExpression)psiElement).getQualifierExpression(), (PsiElement)qualifier, (boolean)false) && (psiElement = methodExpr.getParent()) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)psiElement;
            return call;
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiExpression getArrayFromLengthExpression(@Nullable PsiExpression expression) {
        if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)expression;
        String referenceName = reference.getReferenceName();
        if (!"length".equals(referenceName)) {
            return null;
        }
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiType type = qualifier.getType();
        if (type == null || type.getArrayDimensions() <= 0) {
            return null;
        }
        return qualifier;
    }

    @Nullable
    public static PsiExpression getEffectiveQualifier(@NotNull PsiReferenceExpression ref) {
        PsiExpression psiExpression;
        PsiExpression qualifier;
        if (ref == null) {
            ExpressionUtils.$$$reportNull$$$0(13);
        }
        if ((qualifier = ref.getQualifierExpression()) != null) {
            return qualifier;
        }
        PsiElement psiElement = ref.resolve();
        if (psiElement instanceof PsiMember) {
            PsiMember member = (PsiMember)psiElement;
            psiExpression = ExpressionUtils.getEffectiveQualifier(ref, member);
        } else {
            psiExpression = null;
        }
        return psiExpression;
    }

    public static PsiExpression getEffectiveQualifier(@NotNull PsiReferenceExpression ref, @NotNull PsiMember member) {
        if (ref == null) {
            ExpressionUtils.$$$reportNull$$$0(14);
        }
        if (member == null) {
            ExpressionUtils.$$$reportNull$$$0(15);
        }
        PsiMember containingMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class, PsiField.class});
        if (!member.hasModifierProperty("static") && ExpressionUtils.isStaticMember(containingMember)) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)ref.getProject());
        PsiClass memberClass = member.getContainingClass();
        if (memberClass != null) {
            if (member.hasModifierProperty("static")) {
                if (memberClass.getName() == null || memberClass instanceof PsiImplicitClass) {
                    return null;
                }
                return factory.createReferenceExpression(memberClass);
            }
            PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)ref);
            if (containingClass == null) {
                containingClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)ref, (Class[])new Class[]{PsiClass.class});
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
                do {
                    if (member.hasModifierProperty("static") || !ExpressionUtils.isStaticMember((PsiMember)containingClass)) continue;
                    return null;
                } while ((containingClass = PsiUtil.getContainingClass((PsiElement)containingClass)) != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true));
                if (containingClass != null) {
                    String thisQualifier = containingClass.getQualifiedName();
                    if (thisQualifier == null) {
                        if (PsiUtil.isLocalClass((PsiClass)containingClass)) {
                            thisQualifier = containingClass.getName();
                        } else {
                            return null;
                        }
                    }
                    return factory.createExpressionFromText(thisQualifier + ".this", (PsiElement)ref);
                }
            }
        }
        return factory.createExpressionFromText("this", (PsiElement)ref);
    }

    private static boolean isStaticMember(@Nullable PsiMember member) {
        return member != null && member.hasModifierProperty("static");
    }

    public static void bindReferenceTo(@NotNull PsiReferenceExpression ref, @NotNull String newName) {
        PsiMember member;
        PsiElement psiElement;
        PsiMember member2;
        PsiElement psiElement2;
        PsiElement nameElement;
        if (ref == null) {
            ExpressionUtils.$$$reportNull$$$0(16);
        }
        if (newName == null) {
            ExpressionUtils.$$$reportNull$$$0(17);
        }
        if ((nameElement = ref.getReferenceNameElement()) == null) {
            throw new IllegalStateException("Name element is null: " + String.valueOf(ref));
        }
        if (newName.equals(nameElement.getText())) {
            return;
        }
        PsiClass aClass = null;
        if (ref.getQualifierExpression() == null && (psiElement2 = ref.resolve()) instanceof PsiMember && ImportUtils.isStaticallyImported(member2 = (PsiMember)psiElement2, (PsiElement)ref)) {
            aClass = member2.getContainingClass();
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)ref.getProject());
        PsiIdentifier identifier = factory.createIdentifier(newName);
        nameElement.replace((PsiElement)identifier);
        if (!(aClass == null || (psiElement = ref.resolve()) instanceof PsiMember && (member = (PsiMember)psiElement).getContainingClass() == aClass)) {
            ref.setQualifierExpression((PsiExpression)factory.createReferenceExpression(aClass));
        }
    }

    public static void bindCallTo(@NotNull PsiMethodCallExpression call, @NotNull @NonNls String newName) {
        if (call == null) {
            ExpressionUtils.$$$reportNull$$$0(18);
        }
        if (newName == null) {
            ExpressionUtils.$$$reportNull$$$0(19);
        }
        ExpressionUtils.bindReferenceTo(call.getMethodExpression(), newName);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiExpression resolveExpression(@Nullable PsiExpression expression) {
        PsiExpression initializer;
        PsiLocalVariable variable;
        PsiReferenceExpression reference;
        PsiElement psiElement;
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiReferenceExpression && (psiElement = (reference = (PsiReferenceExpression)expression).resolve()) instanceof PsiLocalVariable && !((variable = (PsiLocalVariable)psiElement) instanceof PsiResourceVariable) && (initializer = variable.getInitializer()) != null && List.of(reference).equals(VariableAccessUtils.getVariableReferences((PsiVariable)variable))) {
            return initializer;
        }
        return expression;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiLocalVariable resolveLocalVariable(@Nullable PsiExpression expression) {
        PsiLocalVariable var;
        PsiExpression psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        if (!(psiExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)psiExpression;
        PsiElement psiElement = ref.resolve();
        return psiElement instanceof PsiLocalVariable ? (var = (PsiLocalVariable)psiElement) : null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiVariable resolveVariable(@Nullable PsiExpression expression) {
        PsiVariable var;
        PsiExpression psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        if (!(psiExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)psiExpression;
        PsiElement psiElement = ref.resolve();
        return psiElement instanceof PsiVariable ? (var = (PsiVariable)psiElement) : null;
    }

    public static boolean isOctalLiteral(PsiLiteralExpression literal) {
        PsiType type = literal.getType();
        if (!PsiTypes.intType().equals((Object)type) && !PsiTypes.longType().equals((Object)type)) {
            return false;
        }
        if (literal.getValue() == null) {
            return false;
        }
        return ExpressionUtils.isOctalLiteralText(literal.getText());
    }

    public static boolean isOctalLiteralText(String literalText) {
        if (literalText.charAt(0) != '0' || literalText.length() < 2) {
            return false;
        }
        char c1 = literalText.charAt(1);
        return c1 == '_' || c1 >= '0' && c1 <= '7';
    }

    @Contract(value="null, _ -> false")
    public static boolean isMatchingChildAlwaysExecuted(@Nullable PsiExpression root, final @NotNull Predicate<? super PsiExpression> matcher) {
        if (matcher == null) {
            ExpressionUtils.$$$reportNull$$$0(20);
        }
        if (root == null) {
            return false;
        }
        final AtomicBoolean result = new AtomicBoolean(false);
        root.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitExpression(@NotNull PsiExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitExpression(expression);
                if (matcher.test(expression)) {
                    result.set(true);
                    this.stopWalking();
                }
            }

            public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ExpressionUtils.isMatchingChildAlwaysExecuted(expression.getCondition(), matcher) || ExpressionUtils.isMatchingChildAlwaysExecuted(expression.getThenExpression(), matcher) && ExpressionUtils.isMatchingChildAlwaysExecuted(expression.getElseExpression(), matcher)) {
                    result.set(true);
                    this.stopWalking();
                }
            }

            public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
                IElementType type;
                if (expression == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((type = expression.getOperationTokenType()).equals(JavaTokenType.OROR) || type.equals(JavaTokenType.ANDAND)) {
                    PsiExpression firstOperand = (PsiExpression)ArrayUtil.getFirstElement((Object[])expression.getOperands());
                    if (ExpressionUtils.isMatchingChildAlwaysExecuted(firstOperand, matcher)) {
                        result.set(true);
                        this.stopWalking();
                    }
                } else {
                    super.visitPolyadicExpression(expression);
                }
            }

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(3);
                }
            }

            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(4);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/psiutils/ExpressionUtils$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitConditionalExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPolyadicExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return result.get();
    }

    @Contract(value="null -> false")
    public static boolean isNewObject(@Nullable PsiExpression expression) {
        return expression != null && ExpressionUtils.nonStructuralChildren(expression).allMatch(call -> {
            if (call instanceof PsiNewExpression) {
                return true;
            }
            if (call instanceof PsiArrayInitializerExpression) {
                return true;
            }
            if (call instanceof PsiMethodCallExpression) {
                ContractReturnValue returnValue = JavaMethodContractUtil.getNonFailingReturnValue(JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)call));
                return ContractReturnValue.returnNew().equals(returnValue);
            }
            return false;
        });
    }

    public static boolean isDifference(@NotNull PsiExpression from, @NotNull PsiExpression to, @NotNull PsiExpression diff) {
        Object right;
        Object left;
        PsiBinaryExpression bin;
        if (from == null) {
            ExpressionUtils.$$$reportNull$$$0(21);
        }
        if (to == null) {
            ExpressionUtils.$$$reportNull$$$0(22);
        }
        if (diff == null) {
            ExpressionUtils.$$$reportNull$$$0(23);
        }
        if ((diff = PsiUtil.skipParenthesizedExprDown((PsiExpression)diff)) == null) {
            return false;
        }
        EquivalenceChecker eq = EquivalenceChecker.getCanonicalPsiEquivalence();
        if (ExpressionUtils.isZero(from) && eq.expressionsAreEquivalent(to, diff)) {
            return true;
        }
        if (ExpressionUtils.isZero(diff) && eq.expressionsAreEquivalent(to, from)) {
            return true;
        }
        if (to instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression toPoly = (PsiPolyadicExpression)to;
            if (from instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression fromPoly = (PsiPolyadicExpression)from;
                Pair<@NotNull PsiExpression, @NotNull PsiExpression> polyadicDiff = ExpressionUtils.getPolyadicDiff(fromPoly, toPoly);
                from = (PsiExpression)polyadicDiff.first;
                to = (PsiExpression)polyadicDiff.second;
            }
        }
        if (diff instanceof PsiBinaryExpression && (bin = (PsiBinaryExpression)diff).getOperationTokenType().equals(JavaTokenType.MINUS)) {
            left = bin.getLOperand();
            right = bin.getROperand();
            if (right != null && eq.expressionsAreEquivalent(to, (PsiExpression)left) && eq.expressionsAreEquivalent(from, (PsiExpression)right)) {
                return true;
            }
        }
        if (from instanceof PsiBinaryExpression && (bin = (PsiBinaryExpression)from).getOperationTokenType().equals(JavaTokenType.MINUS)) {
            left = bin.getLOperand();
            right = bin.getROperand();
            if (right != null && eq.expressionsAreEquivalent(to, (PsiExpression)left) && eq.expressionsAreEquivalent(diff, (PsiExpression)right)) {
                return true;
            }
        }
        if (to instanceof PsiBinaryExpression && (bin = (PsiBinaryExpression)to).getOperationTokenType().equals(JavaTokenType.PLUS)) {
            left = bin.getLOperand();
            right = bin.getROperand();
            if (right != null && eq.expressionsAreEquivalent((PsiExpression)left, from) && eq.expressionsAreEquivalent((PsiExpression)right, diff) || eq.expressionsAreEquivalent((PsiExpression)right, from) && eq.expressionsAreEquivalent((PsiExpression)left, diff)) {
                return true;
            }
        }
        if (!((left = ExpressionUtils.computeConstantExpression(from)) instanceof Integer)) {
            return false;
        }
        Integer fromConstant = (Integer)left;
        right = ExpressionUtils.computeConstantExpression(to);
        if (!(right instanceof Integer)) {
            return false;
        }
        Integer toConstant = (Integer)right;
        Object object = ExpressionUtils.computeConstantExpression(diff);
        if (!(object instanceof Integer)) {
            return false;
        }
        Integer diffConstant = (Integer)object;
        return diffConstant == toConstant - fromConstant;
    }

    @NotNull
    private static @NotNull Pair<@NotNull PsiExpression, @NotNull PsiExpression> getPolyadicDiff(@NotNull PsiPolyadicExpression from, @NotNull PsiPolyadicExpression to) {
        EquivalenceChecker eq;
        EquivalenceChecker.Match match;
        if (from == null) {
            ExpressionUtils.$$$reportNull$$$0(24);
        }
        if (to == null) {
            ExpressionUtils.$$$reportNull$$$0(25);
        }
        if ((match = (eq = EquivalenceChecker.getCanonicalPsiEquivalence()).expressionsMatch((PsiExpression)from, (PsiExpression)to)).isPartialMatch()) {
            PsiExpression leftDiff = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)match.getLeftDiff()));
            PsiExpression rightDiff = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)match.getRightDiff()));
            if (leftDiff == null || rightDiff == null) {
                Pair pair = Pair.create((Object)from, (Object)to);
                if (pair == null) {
                    ExpressionUtils.$$$reportNull$$$0(26);
                }
                return pair;
            }
            PsiPolyadicExpression leftParent = (PsiPolyadicExpression)PsiTreeUtil.getParentOfType((PsiElement)leftDiff, PsiPolyadicExpression.class);
            assert (leftParent != null);
            IElementType op = leftParent.getOperationTokenType();
            if (op == JavaTokenType.MINUS || op == JavaTokenType.PLUS) {
                if (ExpressionUtils.shouldBeInverted((PsiElement)leftDiff, (PsiElement)from)) {
                    Pair pair = Pair.create((Object)rightDiff, (Object)leftDiff);
                    if (pair == null) {
                        ExpressionUtils.$$$reportNull$$$0(27);
                    }
                    return pair;
                }
                Pair pair = Pair.create((Object)leftDiff, (Object)rightDiff);
                if (pair == null) {
                    ExpressionUtils.$$$reportNull$$$0(28);
                }
                return pair;
            }
        }
        Pair pair = Pair.create((Object)from, (Object)to);
        if (pair == null) {
            ExpressionUtils.$$$reportNull$$$0(29);
        }
        return pair;
    }

    private static boolean shouldBeInverted(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            ExpressionUtils.$$$reportNull$$$0(30);
        }
        if (end == null) {
            ExpressionUtils.$$$reportNull$$$0(31);
        }
        boolean result = false;
        PsiElement parent = start;
        while (parent != end) {
            PsiPolyadicExpression poly;
            IElementType op;
            start = parent;
            if (!((parent = parent.getParent()) instanceof PsiPolyadicExpression) || (op = (poly = (PsiPolyadicExpression)parent).getOperationTokenType()) != JavaTokenType.MINUS || parent.getFirstChild() == start) continue;
            result = !result;
        }
        return result;
    }

    @Nullable
    public static PsiExpression getConstantArrayElement(PsiVariable array, int index) {
        if (index < 0) {
            return null;
        }
        PsiExpression[] elements = ExpressionUtils.getConstantArrayElements(array);
        if (elements == null || index >= elements.length) {
            return null;
        }
        return elements[index];
    }

    public static PsiExpression @Nullable [] getConstantArrayElements(PsiVariable array) {
        PsiNewExpression expression;
        PsiExpression initializer = array.getInitializer();
        if (initializer instanceof PsiNewExpression) {
            expression = (PsiNewExpression)initializer;
            initializer = expression.getArrayInitializer();
        }
        if (!(initializer instanceof PsiArrayInitializerExpression)) {
            return null;
        }
        expression = (PsiArrayInitializerExpression)initializer;
        if (!(!(array instanceof PsiField) || array.hasModifierProperty("private") && array.hasModifierProperty("static"))) {
            return null;
        }
        if (!ExpressionUtils.isConstantContent(array)) {
            return null;
        }
        PsiExpression[] initializers = expression.getInitializers();
        Arrays.asList(initializers).replaceAll(expr -> ExpressionUtils.isIllegalReference(array, expr) ? null : expr);
        return initializers;
    }

    private static boolean isConstantContent(PsiVariable array) {
        Boolean isConstantArray = (Boolean)CachedValuesManager.getCachedValue((PsiElement)array, () -> CachedValueProvider.Result.create((Object)(!ContainerUtil.exists(VariableAccessUtils.getVariableReferences(array), ExpressionUtils::canBeMutated) ? 1 : 0), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        return Boolean.TRUE.equals(isConstantArray);
    }

    private static boolean isIllegalReference(PsiVariable array, PsiExpression expr) {
        return SyntaxTraverser.psiTraverser((PsiElement)expr).filter(PsiReferenceExpression.class).find(ref -> {
            PsiField field;
            PsiElement target = ref.resolve();
            return target == array || target instanceof PsiField && JavaPsiReferenceUtil.checkForwardReference((PsiReferenceExpression)ref, (PsiField)(field = (PsiField)target), (boolean)true) != JavaPsiReferenceUtil.ForwardReferenceProblem.LEGAL;
        }) != null;
    }

    private static boolean canBeMutated(@NotNull PsiExpression expr) {
        PsiExpressionList list;
        PsiMethodCallExpression call;
        PsiElement psiElement;
        PsiForeachStatement forEach;
        PsiParenthesizedExpression parent;
        PsiElement psiElement2;
        if (expr == null) {
            ExpressionUtils.$$$reportNull$$$0(32);
        }
        while ((psiElement2 = expr.getParent()) instanceof PsiParenthesizedExpression) {
            parent = (PsiParenthesizedExpression)psiElement2;
            expr = parent;
        }
        if (ExpressionUtils.isVoidContext(expr)) {
            return false;
        }
        if (PsiUtil.isAccessedForWriting((PsiExpression)expr)) {
            return true;
        }
        parent = expr.getParent();
        if (parent instanceof PsiForeachStatement && PsiTreeUtil.isAncestor((PsiElement)(forEach = (PsiForeachStatement)parent).getIteratedValue(), (PsiElement)expr, (boolean)false)) {
            return false;
        }
        if (parent instanceof PsiReferenceExpression) {
            PsiReferenceExpression refParent = (PsiReferenceExpression)parent;
            if (ExpressionUtils.getArrayFromLengthExpression((PsiExpression)refParent) != null) {
                return false;
            }
            psiElement = parent.getParent();
            if (psiElement instanceof PsiMethodCallExpression && MethodCallUtils.isCallToMethod(call = (PsiMethodCallExpression)psiElement, "java.lang.Object", null, "clone", PsiType.EMPTY_ARRAY)) {
                return false;
            }
        }
        if (parent instanceof PsiExpressionList && (psiElement = (list = (PsiExpressionList)parent).getParent()) instanceof PsiMethodCallExpression) {
            call = (PsiMethodCallExpression)psiElement;
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return true;
            }
            MutationSignature signature = MutationSignature.fromCall((PsiCall)call);
            if (!signature.isPure()) {
                return true;
            }
            PsiType type = method.getReturnType();
            if (type instanceof PsiPrimitiveType || TypeUtils.isJavaLangString(type)) {
                return false;
            }
            return ExpressionUtils.canBeMutated((PsiExpression)call);
        }
        if (parent instanceof PsiLocalVariable) {
            PsiLocalVariable variable = (PsiLocalVariable)parent;
            return !ExpressionUtils.isConstantContent((PsiVariable)variable);
        }
        if (parent instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)parent;
            return PsiUtil.isAccessedForWriting((PsiExpression)arrayAccess);
        }
        return true;
    }

    public static boolean isLocallyDefinedExpression(PsiExpression expression) {
        return PsiTreeUtil.processElements((PsiElement)expression, e -> {
            PsiReferenceExpression ref;
            PsiElement patt0$temp;
            if (e instanceof PsiCallExpression) {
                return false;
            }
            if (e instanceof PsiReferenceExpression && (patt0$temp = (ref = (PsiReferenceExpression)e).resolve()) instanceof PsiField) {
                PsiField field = (PsiField)patt0$temp;
                return field.hasModifierProperty("final");
            }
            return !(e instanceof PsiArrayAccessExpression);
        });
    }

    @Contract(value="null, _, _ -> null", pure=true)
    @Nullable
    public static TextRange findStringLiteralRange(PsiExpression expression, int from, int to) {
        if (to < 0 || from > to) {
            return null;
        }
        if (expression == null || !TypeUtils.isJavaLangString(expression.getType())) {
            return null;
        }
        if (expression instanceof PsiLiteralExpression) {
            String value;
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
            Object object = literalExpression.getValue();
            if (!(object instanceof String) || (value = (String)object).length() < from || value.length() < to) {
                return null;
            }
            String text = expression.getText();
            if (literalExpression.isTextBlock()) {
                int indent = PsiLiteralUtil.getTextBlockIndent((PsiLiteralExpression)literalExpression);
                if (indent == -1) {
                    return null;
                }
                return PsiLiteralUtil.mapBackTextBlockRange((String)text, (int)from, (int)to, (int)indent);
            }
            return PsiLiteralUtil.mapBackStringRange((String)expression.getText(), (int)from, (int)to);
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesized = (PsiParenthesizedExpression)expression;
            PsiExpression operand = parenthesized.getExpression();
            TextRange range = ExpressionUtils.findStringLiteralRange(operand, from, to);
            return range == null ? null : range.shiftRight(operand.getStartOffsetInParent());
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiExpression[] operands;
            PsiPolyadicExpression concatenation = (PsiPolyadicExpression)expression;
            if (concatenation.getOperationTokenType() != JavaTokenType.PLUS) {
                return null;
            }
            for (PsiExpression operand : operands = concatenation.getOperands()) {
                Object constantValue = ExpressionUtils.computeConstantExpression(operand);
                if (constantValue == null) {
                    return null;
                }
                String stringValue = constantValue.toString();
                if (from < stringValue.length()) {
                    if (to > stringValue.length()) {
                        return null;
                    }
                    TextRange range = ExpressionUtils.findStringLiteralRange(operand, from, to);
                    return range == null ? null : range.shiftRight(operand.getStartOffsetInParent());
                }
                from -= stringValue.length();
                to -= stringValue.length();
            }
        }
        return null;
    }

    public static boolean isVoidContext(PsiExpression expression) {
        PsiElement element = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
        if (element instanceof PsiExpressionStatement) {
            PsiSwitchLabeledRuleStatement ruleStatement;
            if (element.getParent() instanceof PsiCodeFragment && PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element) == null) {
                return false;
            }
            PsiElement psiElement = element.getParent();
            return !(psiElement instanceof PsiSwitchLabeledRuleStatement) || !((ruleStatement = (PsiSwitchLabeledRuleStatement)psiElement).getEnclosingSwitchBlock() instanceof PsiSwitchExpression);
        }
        if (element instanceof PsiExpressionList && element.getParent() instanceof PsiExpressionListStatement) {
            return true;
        }
        if (element instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda = (PsiLambdaExpression)element;
            return PsiTypes.voidType().equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda));
        }
        return false;
    }

    @Nullable
    public static PsiExpression getExpressionComparedTo(@NotNull PsiExpression expression) {
        PsiMethodCallExpression call;
        PsiElement psiElement;
        PsiBinaryExpression binOp;
        PsiElement parent;
        if (expression == null) {
            ExpressionUtils.$$$reportNull$$$0(33);
        }
        if ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent())) instanceof PsiBinaryExpression && ComparisonUtils.isEqualityComparison((PsiExpression)(binOp = (PsiBinaryExpression)parent))) {
            PsiExpression leftOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
            PsiExpression rightOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
            return PsiTreeUtil.isAncestor((PsiElement)leftOperand, (PsiElement)expression, (boolean)false) ? rightOperand : leftOperand;
        }
        if (parent instanceof PsiExpressionList && (psiElement = parent.getParent()) instanceof PsiMethodCallExpression && MethodCallUtils.isEqualsCall(call = (PsiMethodCallExpression)psiElement)) {
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
        }
        call = ExpressionUtils.getCallForQualifier(expression);
        if (call != null && MethodCallUtils.isEqualsCall(call)) {
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions())));
        }
        return null;
    }

    @NotNull
    public static PsiExpression getTopLevelExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            ExpressionUtils.$$$reportNull$$$0(34);
        }
        while (true) {
            PsiExpression e;
            PsiElement psiElement;
            PsiElement parent;
            if ((parent = expression.getParent()) instanceof PsiExpression) {
                PsiExpression e2 = (PsiExpression)parent;
                if (!(parent instanceof PsiLambdaExpression)) {
                    expression = e2;
                    continue;
                }
            }
            if (!(parent instanceof PsiExpressionList) || !((psiElement = parent.getParent()) instanceof PsiExpression)) break;
            expression = e = (PsiExpression)psiElement;
        }
        PsiExpression psiExpression = expression;
        if (psiExpression == null) {
            ExpressionUtils.$$$reportNull$$$0(35);
        }
        return psiExpression;
    }

    public static PsiElement getPassThroughParent(@NotNull PsiExpression expression) {
        if (expression == null) {
            ExpressionUtils.$$$reportNull$$$0(36);
        }
        return ExpressionUtils.getPassThroughExpression(expression).getParent();
    }

    @NotNull
    public static PsiExpression getPassThroughExpression(@NotNull PsiExpression expression) {
        if (expression == null) {
            ExpressionUtils.$$$reportNull$$$0(37);
        }
        while (true) {
            PsiYieldStatement statement;
            PsiSwitchExpression enclosing;
            PsiConditionalExpression conditional;
            PsiElement parent;
            if ((parent = expression.getParent()) instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression) {
                expression = (PsiExpression)parent;
                continue;
            }
            if (parent instanceof PsiConditionalExpression && (conditional = (PsiConditionalExpression)parent).getCondition() != expression) {
                expression = (PsiExpression)parent;
                continue;
            }
            if (parent instanceof PsiExpressionStatement) {
                PsiSwitchLabeledRuleStatement statement2;
                PsiSwitchBlock block;
                PsiElement grandParent = parent.getParent();
                if (!(grandParent instanceof PsiSwitchLabeledRuleStatement) || !((block = (statement2 = (PsiSwitchLabeledRuleStatement)grandParent).getEnclosingSwitchBlock()) instanceof PsiSwitchExpression)) break;
                expression = (PsiExpression)block;
                continue;
            }
            if (!(parent instanceof PsiYieldStatement) || (enclosing = (statement = (PsiYieldStatement)parent).findEnclosingExpression()) == null) break;
            expression = enclosing;
        }
        PsiExpression psiExpression = expression;
        if (psiExpression == null) {
            ExpressionUtils.$$$reportNull$$$0(38);
        }
        return psiExpression;
    }

    public static boolean isImplicitToStringCall(PsiExpression expression) {
        PsiMethodCallExpression call;
        PsiExpressionList expressionList;
        PsiElement psiElement;
        PsiConditionalExpression conditional;
        if (ExpressionUtils.isStringConcatenationOperand(expression)) {
            return true;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
        while (parent instanceof PsiConditionalExpression && !PsiTreeUtil.isAncestor((PsiElement)(conditional = (PsiConditionalExpression)parent).getCondition(), (PsiElement)expression, (boolean)false)) {
            parent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
        }
        if (parent instanceof PsiExpressionList && (psiElement = (expressionList = (PsiExpressionList)parent).getParent()) instanceof PsiMethodCallExpression && IMPLICIT_TO_STRING_METHOD_NAMES.contains((call = (PsiMethodCallExpression)psiElement).getMethodExpression().getReferenceName())) {
            PsiExpression[] arguments = expressionList.getExpressions();
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            @NonNls String methodName = method.getName();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String className = containingClass.getQualifiedName();
            if (className == null) {
                return false;
            }
            return switch (methodName) {
                case "append" -> {
                    if (arguments.length != 1) {
                        yield false;
                    }
                    if (!className.equals("java.lang.StringBuilder") && !className.equals("java.lang.StringBuffer")) {
                        yield false;
                    }
                    if (!ExpressionUtils.hasCharArrayParameter(method)) {
                        yield true;
                    }
                    yield false;
                }
                case "valueOf" -> {
                    if (arguments.length != 1 || !"java.lang.String".equals(className)) {
                        yield false;
                    }
                    if (!ExpressionUtils.hasCharArrayParameter(method)) {
                        yield true;
                    }
                    yield false;
                }
                case "print", "println" -> {
                    if (arguments.length != 1) {
                        yield false;
                    }
                    if (!ExpressionUtils.hasCharArrayParameter(method) && ("java.util.Formatter".equals(className) || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.io.PrintStream") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.io.PrintWriter")) || "java.lang.IO".equals(className)) {
                        yield true;
                    }
                    yield false;
                }
                case "printf", "format" -> {
                    int minArguments;
                    if (arguments.length < 1) {
                        yield false;
                    }
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    if (parameters.length == 0) {
                        yield false;
                    }
                    PsiParameter parameter = parameters[0];
                    PsiType firstParameterType = parameter.getType();
                    int v1 = minArguments = firstParameterType.equalsToText("java.util.Locale") ? 4 : 3;
                    if (arguments.length < minArguments) {
                        yield false;
                    }
                    if ("java.lang.String".equals(className) || "java.util.Formatter".equals(className) || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.io.PrintStream") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.io.PrintWriter")) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }

    private static boolean hasCharArrayParameter(PsiMethod method) {
        @NonNls PsiParameter parameter = (PsiParameter)ArrayUtil.getFirstElement((Object[])method.getParameterList().getParameters());
        return parameter == null || parameter.getType().equalsToText("char[]");
    }

    @Contract(value="null, _, _ -> null")
    public static PsiExpression convertInitializerToExpression(@Nullable PsiExpression initializer, @NotNull PsiElementFactory factory, @Nullable PsiType type) {
        if (factory == null) {
            ExpressionUtils.$$$reportNull$$$0(39);
        }
        if (initializer instanceof PsiArrayInitializerExpression && type instanceof PsiArrayType) {
            PsiNewExpression result = (PsiNewExpression)factory.createExpressionFromText("new " + type.getCanonicalText() + "{}", null);
            Objects.requireNonNull(result.getArrayInitializer()).replace((PsiElement)initializer);
            return result;
        }
        return initializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PsiAssignmentExpression splitDeclaration(@NotNull PsiDeclarationStatement declaration, @NotNull Project project) {
        if (declaration == null) {
            ExpressionUtils.$$$reportNull$$$0(40);
        }
        if (project == null) {
            ExpressionUtils.$$$reportNull$$$0(41);
        }
        if (declaration.getDeclaredElements().length == 1) {
            PsiLocalVariable var = (PsiLocalVariable)declaration.getDeclaredElements()[0];
            var.normalizeDeclaration();
            PsiTypeElement typeElement = var.getTypeElement();
            if (typeElement.isInferredType()) {
                PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)typeElement);
            }
            String name = var.getName();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(name + "=xxx;", (PsiElement)declaration);
            statement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)statement);
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)statement.getExpression();
            PsiExpression initializer = var.getInitializer();
            assert (initializer != null);
            PsiExpression rExpression = ExpressionUtils.convertInitializerToExpression(initializer, factory, var.getType());
            PsiExpression expression = assignment.getRExpression();
            assert (expression != null);
            expression.replace((PsiElement)rExpression);
            PsiElement block = declaration.getParent();
            if (block instanceof PsiForStatement) {
                PsiDeclarationStatement varDeclStatement = factory.createVariableDeclarationStatement(name, var.getType(), null);
                for (PsiElement varDecl : varDeclStatement.getDeclaredElements()) {
                    if (!(varDecl instanceof PsiModifierListOwner)) continue;
                    PsiModifierListOwner owner = (PsiModifierListOwner)varDecl;
                    PsiModifierList modList = owner.getModifierList();
                    assert (modList != null);
                    modList.setModifierProperty("final", false);
                }
                PsiElement parent = block.getParent();
                PsiExpressionStatement replaced = (PsiExpressionStatement)new CommentTracker().replaceAndRestoreComments((PsiElement)declaration, (PsiElement)statement);
                if (!(parent instanceof PsiCodeBlock)) {
                    PsiBlockStatement blockStatement = (PsiBlockStatement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("{}", block);
                    PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                    codeBlock.add((PsiElement)varDeclStatement);
                    codeBlock.add(block);
                    block.replace((PsiElement)blockStatement);
                } else {
                    parent.addBefore((PsiElement)varDeclStatement, block);
                }
                return (PsiAssignmentExpression)replaced.getExpression();
            }
            try {
                PsiElement declaredElement = declaration.getDeclaredElements()[0];
                if (!PsiUtil.isJavaToken((PsiElement)declaredElement.getLastChild(), (IElementType)JavaTokenType.SEMICOLON)) {
                    LeafElement semicolon = Factory.createSingleLeafElement((IElementType)JavaTokenType.SEMICOLON, (CharSequence)";", (int)0, (int)1, null, (PsiManager)declaration.getManager());
                    CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)declaration.addAfter(semicolon.getPsi(), declaredElement));
                }
                PsiAssignmentExpression psiAssignmentExpression = (PsiAssignmentExpression)((PsiExpressionStatement)block.addAfter((PsiElement)statement, (PsiElement)declaration)).getExpression();
                return psiAssignmentExpression;
            }
            finally {
                initializer = ((PsiLocalVariable)declaration.getDeclaredElements()[0]).getInitializer();
                if (initializer != null) {
                    initializer.delete();
                }
            }
        }
        ((PsiLocalVariable)declaration.getDeclaredElements()[0]).normalizeDeclaration();
        return null;
    }

    public static boolean isLoopInvariant(PsiExpression expression, PsiLoopStatement loopStatement) {
        if (PsiUtil.isConstantExpression((PsiExpression)expression)) {
            return true;
        }
        if (SideEffectChecker.mayHaveSideEffects(expression)) {
            return false;
        }
        Collection refs = PsiTreeUtil.collectElementsOfType((PsiElement)expression, (Class[])new Class[]{PsiReferenceExpression.class});
        for (PsiReferenceExpression ref : refs) {
            PsiVariable var;
            PsiField field;
            PsiElement target = ref.resolve();
            if (target instanceof PsiField && (field = (PsiField)target).hasModifierProperty("final") || (target instanceof PsiLocalVariable || target instanceof PsiParameter) && ((var = (PsiVariable)target).hasModifierProperty("final") || ControlFlowUtil.isEffectivelyFinal((PsiVariable)var, (PsiElement)PsiUtil.getVariableCodeBlock((PsiVariable)var, null)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isOnlyExpressionInMethod(@NotNull PsiExpression expression) {
        PsiCodeBlock codeBlock;
        block6: {
            block5: {
                PsiElement parent;
                if (expression == null) {
                    ExpressionUtils.$$$reportNull$$$0(42);
                }
                if (!((parent = expression.getParent()) instanceof PsiReturnStatement)) {
                    return false;
                }
                PsiElement grandParent = parent.getParent();
                if (!(grandParent instanceof PsiCodeBlock)) break block5;
                codeBlock = (PsiCodeBlock)grandParent;
                if (grandParent.getParent() instanceof PsiMethod) break block6;
            }
            return false;
        }
        return codeBlock.getStatementCount() == 1;
    }

    public static boolean isNullFilteringFunction(@NotNull PsiExpression expression) {
        PsiMethodReferenceExpression methodRef;
        PsiElement psiElement;
        if (expression == null) {
            ExpressionUtils.$$$reportNull$$$0(43);
        }
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiLambdaExpression) {
            PsiInstanceOfExpression instanceOf;
            PsiLambdaExpression lambda = (PsiLambdaExpression)expression;
            PsiParameter[] parameters = lambda.getParameterList().getParameters();
            if (parameters.length != 1) {
                return false;
            }
            PsiParameter parameter = parameters[0];
            PsiExpression expr = PsiUtil.skipParenthesizedExprDown((PsiExpression)LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambda.getBody()));
            while (expr instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expr;
                if (polyadicExpression.getOperationTokenType() == JavaTokenType.ANDAND) {
                    expr = polyadicExpression.getOperands()[0];
                    continue;
                }
                return ExpressionUtils.getVariableFromNullComparison(expr, false) == parameter;
            }
            PsiExpression negated = BoolUtils.getNegated(expr);
            boolean nullTrue = false;
            if (negated != null) {
                expr = negated;
                nullTrue = true;
            }
            if (expr instanceof PsiInstanceOfExpression && ExpressionUtils.isReferenceTo((instanceOf = (PsiInstanceOfExpression)expr).getOperand(), (PsiVariable)parameter)) {
                return !nullTrue;
            }
            if (expr instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)expr;
                PsiMethod method = call.resolveMethod();
                PsiExpression[] args = call.getArgumentList().getExpressions();
                if (args.length == 0) {
                    return false;
                }
                return ExpressionUtils.isNullFilteringMethod(method, nullTrue, arg -> ExpressionUtils.isReferenceTo(args[arg], (PsiVariable)parameter));
            }
        }
        if (expression instanceof PsiMethodReferenceExpression && (psiElement = (methodRef = (PsiMethodReferenceExpression)expression).resolve()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)psiElement;
            return ExpressionUtils.isNullFilteringMethod(method, false, arg -> arg == 0);
        }
        return false;
    }

    private static boolean isNullFilteringMethod(@Nullable PsiMethod method, boolean nullTrue, @NotNull IntPredicate isWantedArg) {
        if (isWantedArg == null) {
            ExpressionUtils.$$$reportNull$$$0(44);
        }
        if (method == null || !JavaMethodContractUtil.isPure(method)) {
            return false;
        }
        List<? extends MethodContract> contracts = JavaMethodContractUtil.getMethodCallContracts(method, null);
        for (MethodContract methodContract : contracts) {
            Object object = ContainerUtil.getOnlyItem(methodContract.getConditions());
            if (!(object instanceof ContractValue.Condition)) {
                return false;
            }
            ContractValue.Condition condition = (ContractValue.Condition)object;
            int argEqNull = condition.getArgumentComparedTo(ContractValue.nullValue(), true).orElse(-1);
            if (argEqNull == -1 || !isWantedArg.test(argEqNull)) continue;
            ContractReturnValue value = methodContract.getReturnValue();
            return value.equals(ContractReturnValue.returnBoolean(nullTrue));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 26, 27, 28, 29, 35, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binOp";
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diff";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/ExpressionUtils";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isWantedArg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/ExpressionUtils";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolyadicDiff";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelExpression";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPassThroughExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nonStructuralChildren";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectYieldExpressions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isOffsetArrayAccess";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "expressionIsOffsetVariableLookup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isVariableLessThanComparison";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isNegative";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValueComparedWithNull";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getValueComparedWithZero";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isAutoBoxed";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveQualifier";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "bindReferenceTo";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "bindCallTo";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingChildAlwaysExecuted";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDifference";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPolyadicDiff";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 35: 
            case 38: {
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeInverted";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "canBeMutated";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionComparedTo";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelExpression";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPassThroughParent";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getPassThroughExpression";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "convertInitializerToExpression";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "splitDeclaration";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isOnlyExpressionInMethod";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isNullFilteringFunction";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isNullFilteringMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 26, 27, 28, 29, 35, 38 -> new IllegalStateException(string);
        };
    }
}

