/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiType;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JavaPsiBoxingUtils {
    @NonNls
    private static final @Unmodifiable Map<String, String> parseMethodsMap = Map.ofEntries(Map.entry("java.lang.Integer", "parseInt"), Map.entry("java.lang.Long", "parseLong"), Map.entry("java.lang.Float", "parseFloat"), Map.entry("java.lang.Boolean", "parseBoolean"), Map.entry("java.lang.Double", "parseDouble"), Map.entry("java.lang.Short", "parseShort"), Map.entry("java.lang.Byte", "parseByte"));

    @Nullable
    public static String getParseMethod(@Nullable PsiType type) {
        if (type == null) {
            return null;
        }
        String typeText = type.getCanonicalText();
        return parseMethodsMap.get(typeText);
    }
}

