/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrderedBinaryExpression<F extends PsiExpression, S extends PsiExpression> {
    private static final List<IElementType> COMMUTATIVE_OPERATORS = List.of(JavaTokenType.AND, JavaTokenType.ANDAND, JavaTokenType.OROR, JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.OR, JavaTokenType.PLUS, JavaTokenType.ASTERISK, JavaTokenType.XOR);
    @NotNull
    private final F firstOperand;
    @NotNull
    private final IElementType tokenType;
    @NotNull
    private final S secondOperand;

    private OrderedBinaryExpression(@NotNull F firstOperand, @NotNull IElementType tokenType, @NotNull S secondOperand) {
        if (firstOperand == null) {
            OrderedBinaryExpression.$$$reportNull$$$0(0);
        }
        if (tokenType == null) {
            OrderedBinaryExpression.$$$reportNull$$$0(1);
        }
        if (secondOperand == null) {
            OrderedBinaryExpression.$$$reportNull$$$0(2);
        }
        this.firstOperand = firstOperand;
        this.tokenType = tokenType;
        this.secondOperand = secondOperand;
    }

    @NotNull
    public F getFirstOperand() {
        F f = this.firstOperand;
        if (f == null) {
            OrderedBinaryExpression.$$$reportNull$$$0(3);
        }
        return f;
    }

    @NotNull
    public IElementType getTokenType() {
        IElementType iElementType = this.tokenType;
        if (iElementType == null) {
            OrderedBinaryExpression.$$$reportNull$$$0(4);
        }
        return iElementType;
    }

    @NotNull
    public S getSecondOperand() {
        S s = this.secondOperand;
        if (s == null) {
            OrderedBinaryExpression.$$$reportNull$$$0(5);
        }
        return s;
    }

    @Nullable
    public static <O extends PsiExpression> OrderedBinaryExpression<O, PsiExpression> from(@Nullable PsiExpression node, @Nullable Class<O> firstClass) {
        PsiBinaryExpression expression = OrderedBinaryExpression.as(node, PsiBinaryExpression.class);
        if (expression == null || firstClass == null) {
            return null;
        }
        O leftOperand = OrderedBinaryExpression.as(expression.getLOperand(), firstClass);
        O rightOperand = OrderedBinaryExpression.as(expression.getROperand(), firstClass);
        PsiExpression unparenthesizedRightOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getROperand());
        if (leftOperand != null && rightOperand == null && unparenthesizedRightOperand != null) {
            return new OrderedBinaryExpression<O, PsiExpression>(leftOperand, expression.getOperationTokenType(), unparenthesizedRightOperand);
        }
        if (leftOperand == null && rightOperand != null) {
            IElementType mirroredOperator = OrderedBinaryExpression.mirrorOperator(expression);
            PsiExpression unparenthesizedLeftOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLOperand());
            if (mirroredOperator != null && unparenthesizedLeftOperand != null) {
                return new OrderedBinaryExpression<O, PsiExpression>(rightOperand, mirroredOperator, unparenthesizedLeftOperand);
            }
        }
        return null;
    }

    @Nullable
    public static <F extends PsiExpression, S extends PsiExpression> OrderedBinaryExpression<F, S> from(@Nullable PsiExpression node, @Nullable Class<F> firstClass, @Nullable Class<S> secondClass) {
        PsiBinaryExpression expression = OrderedBinaryExpression.as(node, PsiBinaryExpression.class);
        if (expression == null || firstClass == null || secondClass == null) {
            return null;
        }
        F leftFirst = OrderedBinaryExpression.as(expression.getLOperand(), firstClass);
        S rightSecond = OrderedBinaryExpression.as(expression.getROperand(), secondClass);
        if (leftFirst != null && rightSecond != null) {
            return new OrderedBinaryExpression<F, S>(leftFirst, expression.getOperationTokenType(), rightSecond);
        }
        IElementType mirroredOperator = OrderedBinaryExpression.mirrorOperator(expression);
        if (mirroredOperator != null) {
            F rightFirst = OrderedBinaryExpression.as(expression.getROperand(), firstClass);
            S leftSecond = OrderedBinaryExpression.as(expression.getLOperand(), secondClass);
            if (rightFirst != null && leftSecond != null) {
                return new OrderedBinaryExpression<F, S>(rightFirst, mirroredOperator, leftSecond);
            }
        }
        return null;
    }

    private static <T extends PsiExpression> T as(PsiExpression input, Class<T> aClass) {
        return (T)((PsiExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)input), aClass));
    }

    private static IElementType mirrorOperator(PsiBinaryExpression binaryExpression) {
        IElementType operationTokenType = binaryExpression.getOperationTokenType();
        if (COMMUTATIVE_OPERATORS.contains(operationTokenType)) {
            return operationTokenType;
        }
        if (JavaTokenType.GT.equals(operationTokenType)) {
            return JavaTokenType.LT;
        }
        if (JavaTokenType.GE.equals(operationTokenType)) {
            return JavaTokenType.LE;
        }
        if (JavaTokenType.LT.equals(operationTokenType)) {
            return JavaTokenType.GT;
        }
        if (JavaTokenType.LE.equals(operationTokenType)) {
            return JavaTokenType.GE;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstOperand";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondOperand";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/OrderedBinaryExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/OrderedBinaryExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstOperand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondOperand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

