/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class SideEffectChecker {
    private SideEffectChecker() {
    }

    public static boolean mayHaveSideEffects(@NotNull PsiExpression exp) {
        if (exp == null) {
            SideEffectChecker.$$$reportNull$$$0(0);
        }
        SideEffectsVisitor visitor2 = new SideEffectsVisitor(null, (PsiElement)exp);
        exp.accept((PsiElementVisitor)visitor2);
        return visitor2.mayHaveSideEffects();
    }

    @NotNull
    public static ThreeState getSideEffectStatus(@NotNull PsiExpression exp) {
        if (exp == null) {
            SideEffectChecker.$$$reportNull$$$0(1);
        }
        SideEffectsVisitor visitor2 = new SideEffectsVisitor(null, (PsiElement)exp);
        exp.accept((PsiElementVisitor)visitor2);
        ThreeState threeState = visitor2.getSideEffectStatus();
        if (threeState == null) {
            SideEffectChecker.$$$reportNull$$$0(2);
        }
        return threeState;
    }

    public static boolean mayHaveSideEffects(@NotNull PsiElement element, @NotNull Predicate<? super PsiElement> shouldIgnoreElement) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(3);
        }
        if (shouldIgnoreElement == null) {
            SideEffectChecker.$$$reportNull$$$0(4);
        }
        SideEffectsVisitor visitor2 = new SideEffectsVisitor(null, element, shouldIgnoreElement);
        element.accept((PsiElementVisitor)visitor2);
        return visitor2.mayHaveSideEffects();
    }

    public static boolean mayHaveNonLocalSideEffects(@NotNull PsiElement element, @NotNull Predicate<PsiElement> shouldIgnoreElement) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(5);
        }
        if (shouldIgnoreElement == null) {
            SideEffectChecker.$$$reportNull$$$0(6);
        }
        return SideEffectChecker.mayHaveSideEffects(element, shouldIgnoreElement.or(e -> SideEffectChecker.isLocalSideEffect(e)));
    }

    public static boolean mayHaveNonLocalSideEffects(@NotNull PsiElement element) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(7);
        }
        return SideEffectChecker.mayHaveSideEffects(element, SideEffectChecker::isLocalSideEffect);
    }

    private static boolean isLocalSideEffect(PsiElement e) {
        PsiElement target;
        if (e instanceof PsiContinueStatement || e instanceof PsiReturnStatement || e instanceof PsiThrowStatement) {
            return true;
        }
        if (e instanceof PsiLocalVariable) {
            return true;
        }
        PsiReferenceExpression ref = null;
        if (e instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)e;
            ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression()), PsiReferenceExpression.class);
        }
        if (e instanceof PsiUnaryExpression) {
            PsiExpression operand = ((PsiUnaryExpression)e).getOperand();
            ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)operand), PsiReferenceExpression.class);
        }
        return ref != null && ((target = ref.resolve()) instanceof PsiLocalVariable || target instanceof PsiParameter);
    }

    public static boolean checkSideEffects(@NotNull PsiExpression element, @Nullable List<? super PsiElement> sideEffects) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(8);
        }
        return SideEffectChecker.checkSideEffects(element, sideEffects, e -> false);
    }

    public static boolean checkSideEffects(@NotNull PsiExpression element, @Nullable List<? super PsiElement> sideEffects, @NotNull Predicate<? super PsiElement> ignoreElement) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(9);
        }
        if (ignoreElement == null) {
            SideEffectChecker.$$$reportNull$$$0(10);
        }
        SideEffectsVisitor visitor2 = new SideEffectsVisitor(sideEffects, (PsiElement)element, ignoreElement);
        element.accept((PsiElementVisitor)visitor2);
        return visitor2.mayHaveSideEffects();
    }

    public static @Unmodifiable List<PsiExpression> extractSideEffectExpressions(@NotNull PsiExpression element) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(11);
        }
        return SideEffectChecker.extractSideEffectExpressions(element, e -> false);
    }

    public static @Unmodifiable List<PsiExpression> extractSideEffectExpressions(@NotNull PsiExpression element, @NotNull Predicate<? super PsiElement> ignoreElement) {
        if (element == null) {
            SideEffectChecker.$$$reportNull$$$0(12);
        }
        if (ignoreElement == null) {
            SideEffectChecker.$$$reportNull$$$0(13);
        }
        SmartList list = new SmartList();
        element.accept((PsiElementVisitor)new SideEffectsVisitor((List<? super PsiElement>)list, (PsiElement)element, ignoreElement));
        return ContainerUtil.filterIsInstance((Collection)list, PsiExpression.class);
    }

    public static boolean mayHaveExceptionalSideEffect(PsiMethod method) {
        String name = method.getName();
        if (name.startsWith("assert") || name.startsWith("check") || name.startsWith("require")) {
            return true;
        }
        PsiClass aClass = method.getContainingClass();
        if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"org.assertj.core.api.Descriptable")) {
            return true;
        }
        return ContainerUtil.exists(JavaMethodContractUtil.getMethodCallContracts(method, null), mc -> !ContainerUtil.exists(mc.getConditions(), ContractValue::isBoundCheckingCondition) && mc.getReturnValue().isFail());
    }

    @NotNull
    private static ThreeState getConstructorSideEffect(@NotNull PsiNewExpression newExpression) {
        MutationSignature signature;
        if (newExpression == null) {
            SideEffectChecker.$$$reportNull$$$0(14);
        }
        if ((signature = MutationSignature.fromCall((PsiCall)newExpression)).isPure()) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                SideEffectChecker.$$$reportNull$$$0(15);
            }
            return threeState;
        }
        if (signature.mutatesAnything()) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                SideEffectChecker.$$$reportNull$$$0(16);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            SideEffectChecker.$$$reportNull$$$0(17);
        }
        return threeState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
            case 2: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/SideEffectChecker";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldIgnoreElement";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/SideEffectChecker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSideEffectStatus";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorSideEffect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveSideEffects";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSideEffectStatus";
                break;
            }
            case 2: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveNonLocalSideEffects";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkSideEffects";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractSideEffectExpressions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorSideEffect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 15, 16, 17 -> new IllegalStateException(string);
        };
    }

    private static class SideEffectsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        @Nullable
        private final List<? super PsiElement> mySideEffects;
        @NotNull
        private final PsiElement myStartElement;
        @NotNull
        private final Predicate<? super PsiElement> myIgnorePredicate;
        @NotNull
        private ThreeState found;

        SideEffectsVisitor(@Nullable List<? super PsiElement> sideEffects, @NotNull PsiElement startElement) {
            if (startElement == null) {
                SideEffectsVisitor.$$$reportNull$$$0(0);
            }
            this(sideEffects, startElement, call -> false);
        }

        SideEffectsVisitor(@Nullable List<? super PsiElement> sideEffects, @NotNull PsiElement startElement, @NotNull Predicate<? super PsiElement> predicate) {
            if (startElement == null) {
                SideEffectsVisitor.$$$reportNull$$$0(1);
            }
            if (predicate == null) {
                SideEffectsVisitor.$$$reportNull$$$0(2);
            }
            this.found = ThreeState.NO;
            this.myStartElement = startElement;
            this.myIgnorePredicate = predicate;
            this.mySideEffects = sideEffects;
        }

        private boolean addSideEffect(PsiElement element) {
            return this.addSideEffect(element, ThreeState.YES);
        }

        private boolean addSideEffect(PsiElement element, ThreeState state) {
            if (state == ThreeState.NO || this.myIgnorePredicate.test((PsiElement)element)) {
                return false;
            }
            if (state == ThreeState.YES || state == ThreeState.UNSURE && this.found == ThreeState.NO) {
                this.found = state;
            }
            if (this.mySideEffects != null) {
                this.mySideEffects.add((PsiElement)element);
            } else if (this.found == ThreeState.YES) {
                this.stopWalking();
            }
            return true;
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(3);
            }
            if (this.addSideEffect((PsiElement)expression)) {
                return;
            }
            super.visitAssignmentExpression(expression);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiMethod method;
            ThreeState sideEffect;
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(4);
            }
            if (this.addSideEffect((PsiElement)expression, sideEffect = SideEffectsVisitor.getMethodSideEffect(method = expression.resolveMethod()))) {
                return;
            }
            super.visitMethodCallExpression(expression);
        }

        @NotNull
        private static ThreeState getMethodSideEffect(PsiMethod method) {
            if (method == null) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    SideEffectsVisitor.$$$reportNull$$$0(5);
                }
                return threeState;
            }
            PsiField field = PropertyUtil.getFieldOfGetter(method);
            if (field != null) {
                ThreeState threeState = ThreeState.fromBoolean((boolean)field.hasModifierProperty("volatile"));
                if (threeState == null) {
                    SideEffectsVisitor.$$$reportNull$$$0(6);
                }
                return threeState;
            }
            if (SideEffectChecker.mayHaveExceptionalSideEffect(method)) {
                ThreeState threeState = ThreeState.UNSURE;
                if (threeState == null) {
                    SideEffectsVisitor.$$$reportNull$$$0(7);
                }
                return threeState;
            }
            MutationSignature mutationSignature = MutationSignature.fromMethod(method);
            if (mutationSignature.isPure()) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    SideEffectsVisitor.$$$reportNull$$$0(8);
                }
                return threeState;
            }
            if (mutationSignature.mutatesAnything() || PropertyUtil.getFieldOfSetter(method) != null) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    SideEffectsVisitor.$$$reportNull$$$0(9);
                }
                return threeState;
            }
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                SideEffectsVisitor.$$$reportNull$$$0(10);
            }
            return threeState;
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(11);
            }
            if (this.addSideEffect((PsiElement)expression, SideEffectChecker.getConstructorSideEffect(expression))) {
                return;
            }
            super.visitNewExpression(expression);
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression) {
            IElementType tokenType;
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(12);
            }
            if (((tokenType = expression.getOperationTokenType()).equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) && this.addSideEffect((PsiElement)expression)) {
                return;
            }
            super.visitUnaryExpression(expression);
        }

        public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
            List variables;
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(13);
            }
            if (!(variables = JavaPsiPatternUtil.getExposedPatternVariables((PsiExpression)expression)).isEmpty() && !PsiTreeUtil.isAncestor((PsiElement)this.myStartElement, (PsiElement)((PsiPatternVariable)variables.get(0)).getDeclarationScope(), (boolean)false) && this.addSideEffect((PsiElement)expression)) {
                return;
            }
            super.visitInstanceOfExpression(expression);
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                SideEffectsVisitor.$$$reportNull$$$0(14);
            }
            if (variable instanceof PsiPatternVariable) {
                return;
            }
            if (this.addSideEffect((PsiElement)variable)) {
                return;
            }
            super.visitVariable(variable);
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
            PsiStatement exitedStatement;
            if (statement == null) {
                SideEffectsVisitor.$$$reportNull$$$0(15);
            }
            if (((exitedStatement = statement.findExitedStatement()) == null || !PsiTreeUtil.isAncestor((PsiElement)this.myStartElement, (PsiElement)exitedStatement, (boolean)false)) && this.addSideEffect((PsiElement)statement)) {
                return;
            }
            super.visitBreakStatement(statement);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                SideEffectsVisitor.$$$reportNull$$$0(16);
            }
        }

        public void visitContinueStatement(@NotNull PsiContinueStatement statement) {
            PsiStatement exitedStatement;
            if (statement == null) {
                SideEffectsVisitor.$$$reportNull$$$0(17);
            }
            if ((exitedStatement = statement.findContinuedStatement()) != null && PsiTreeUtil.isAncestor((PsiElement)this.myStartElement, (PsiElement)exitedStatement, (boolean)false)) {
                return;
            }
            if (this.addSideEffect((PsiElement)statement)) {
                return;
            }
            super.visitContinueStatement(statement);
        }

        public void visitYieldStatement(@NotNull PsiYieldStatement statement) {
            PsiSwitchExpression enclosingExpression;
            if (statement == null) {
                SideEffectsVisitor.$$$reportNull$$$0(18);
            }
            if (((enclosingExpression = statement.findEnclosingExpression()) == null || !PsiTreeUtil.isAncestor((PsiElement)this.myStartElement, (PsiElement)enclosingExpression, (boolean)false)) && this.addSideEffect((PsiElement)statement)) {
                return;
            }
            super.visitYieldStatement(statement);
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                SideEffectsVisitor.$$$reportNull$$$0(19);
            }
            if (!(this.myStartElement.getParent() instanceof PsiParameterListOwner) && this.addSideEffect((PsiElement)statement)) {
                return;
            }
            super.visitReturnStatement(statement);
        }

        public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
            if (statement == null) {
                SideEffectsVisitor.$$$reportNull$$$0(20);
            }
            if (this.addSideEffect((PsiElement)statement)) {
                return;
            }
            super.visitThrowStatement(statement);
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            if (expression == null) {
                SideEffectsVisitor.$$$reportNull$$$0(21);
            }
        }

        public boolean mayHaveSideEffects() {
            return this.found != ThreeState.NO;
        }

        @NotNull
        public ThreeState getSideEffectStatus() {
            ThreeState threeState = this.found;
            if (threeState == null) {
                SideEffectsVisitor.$$$reportNull$$$0(22);
            }
            return threeState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 8, 9, 10, 22 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 3: 
                case 4: 
                case 11: 
                case 12: 
                case 13: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 15: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/psiutils/SideEffectChecker$SideEffectsVisitor";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethodSideEffect";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSideEffectStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitAssignmentExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitMethodCallExpression";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 22: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "visitNewExpression";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "visitUnaryExpression";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "visitInstanceOfExpression";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "visitVariable";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "visitBreakStatement";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClass";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "visitContinueStatement";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "visitYieldStatement";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "visitReturnStatement";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "visitThrowStatement";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLambdaExpression";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7, 8, 9, 10, 22 -> new IllegalStateException(string);
            };
        }
    }
}

