/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WeakestTypeFinder {
    private WeakestTypeFinder() {
    }

    @NotNull
    public static Collection<PsiClass> calculateWeakestClassesNecessary(@NotNull PsiElement variableOrMethod, boolean useRighthandTypeAsWeakestTypeInAssignments) {
        PsiType variableOrMethodType;
        if (variableOrMethod == null) {
            WeakestTypeFinder.$$$reportNull$$$0(0);
        }
        if (variableOrMethod instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)variableOrMethod;
            variableOrMethodType = variable.getType();
        } else if (variableOrMethod instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)variableOrMethod;
            variableOrMethodType = method.getReturnType();
            if (PsiTypes.voidType().equals((Object)variableOrMethodType)) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    WeakestTypeFinder.$$$reportNull$$$0(1);
                }
                return list;
            }
        } else {
            throw new IllegalArgumentException("PsiMethod or PsiVariable expected: " + String.valueOf(variableOrMethod));
        }
        PsiClass variableOrMethodClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)variableOrMethodType);
        if (variableOrMethodClass == null || variableOrMethodClass instanceof PsiTypeParameter) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                WeakestTypeFinder.$$$reportNull$$$0(2);
            }
            return list;
        }
        HashSet<PsiClass> weakestTypeClasses = new HashSet<PsiClass>();
        GlobalSearchScope scope = variableOrMethod.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)variableOrMethod.getProject());
        if (variableOrMethod instanceof PsiResourceVariable) {
            PsiResourceVariable resourceVariable = (PsiResourceVariable)variableOrMethod;
            lowerBoundClass = facade.findClass("java.lang.AutoCloseable", scope);
            if (lowerBoundClass == null || variableOrMethodClass.equals((Object)lowerBoundClass)) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    WeakestTypeFinder.$$$reportNull$$$0(3);
                }
                return list;
            }
            weakestTypeClasses.add(lowerBoundClass);
            @NonNls String methodCallText = resourceVariable.getName() + ".close()";
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)facade.getElementFactory().createExpressionFromText(methodCallText, resourceVariable.getParent());
            if (!WeakestTypeFinder.findWeakestType(methodCallExpression, weakestTypeClasses)) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    WeakestTypeFinder.$$$reportNull$$$0(4);
                }
                return list;
            }
            if (weakestTypeClasses.isEmpty()) {
                weakestTypeClasses.add(lowerBoundClass);
            }
        } else {
            lowerBoundClass = facade.findClass("java.lang.Object", scope);
            if (lowerBoundClass == null || variableOrMethodClass.equals((Object)lowerBoundClass)) {
                List<PsiClass> list = Collections.emptyList();
                if (list == null) {
                    WeakestTypeFinder.$$$reportNull$$$0(5);
                }
                return list;
            }
            weakestTypeClasses.add(lowerBoundClass);
        }
        Query query = ReferencesSearch.search((PsiElement)variableOrMethod, (SearchScope)variableOrMethod.getUseScope());
        boolean hasUsages = false;
        for (PsiReference reference : query.asIterable()) {
            ProgressManager.checkCanceled();
            hasUsages = true;
            PsiElement referenceElement = reference.getElement();
            PsiElement referenceParent = PsiUtil.skipParenthesizedExprUp((PsiElement)referenceElement.getParent());
            if (referenceParent instanceof PsiMethodCallExpression) {
                referenceElement = referenceParent;
                referenceParent = PsiUtil.skipParenthesizedExprUp((PsiElement)referenceElement.getParent());
            }
            PsiElement referenceGrandParent = referenceParent.getParent();
            if (referenceElement instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)referenceElement;
                type = methodReferenceExpression.getFunctionalInterfaceType();
                PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)type);
                if (!PsiTypes.voidType().equals((Object)returnType) && !WeakestTypeFinder.checkType(returnType, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(6);
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiExpressionList) {
                if (!(referenceGrandParent instanceof PsiMethodCallExpression)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(7);
                    }
                    return list;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)referenceGrandParent;
                if (!WeakestTypeFinder.findWeakestType(referenceElement, methodCallExpression, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(8);
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda = (PsiLambdaExpression)referenceParent;
                PsiClassType returnType = (PsiClassType)ObjectUtils.tryCast((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambda), PsiClassType.class);
                WeakestTypeFinder.checkType((PsiType)returnType, weakestTypeClasses);
            } else if (referenceGrandParent instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)referenceGrandParent;
                if (PsiUtil.skipParenthesizedExprUp((PsiElement)methodCallExpression.getParent()) instanceof PsiTypeCastExpression || !WeakestTypeFinder.findWeakestType(methodCallExpression, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(9);
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiResourceExpression) {
                PsiClass closeable = facade.findClass("java.lang.AutoCloseable", scope);
                WeakestTypeFinder.checkClass(closeable, weakestTypeClasses);
            } else if (referenceParent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)referenceParent;
                if (!WeakestTypeFinder.findWeakestType(referenceElement, assignmentExpression, useRighthandTypeAsWeakestTypeInAssignments, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(10);
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiNameValuePair) {
                type = ExpectedTypeUtils.findExpectedType((PsiExpression)referenceElement, true);
                if (!WeakestTypeFinder.checkType(type, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(11);
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)referenceParent;
                type = variable.getType();
                if (!type.isAssignableFrom(variableOrMethodType) || !WeakestTypeFinder.checkType(type, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(12);
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiForeachStatement) {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)referenceParent;
                if (!Comparing.equal((Object)foreachStatement.getIteratedValue(), (Object)referenceElement)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(13);
                    }
                    return list;
                }
                PsiClass javaLangIterableClass = facade.findClass("java.lang.Iterable", scope);
                if (javaLangIterableClass == null) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(14);
                    }
                    return list;
                }
                WeakestTypeFinder.checkClass(javaLangIterableClass, weakestTypeClasses);
            } else if (referenceParent instanceof PsiReturnStatement) {
                type = PsiTypesUtil.getMethodReturnType((PsiElement)referenceParent);
                if (!WeakestTypeFinder.checkType(type, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(15);
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)referenceParent;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiField)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(16);
                    }
                    return list;
                }
                PsiField field = (PsiField)target;
                PsiClass containingClass = field.getContainingClass();
                WeakestTypeFinder.checkClass(containingClass, weakestTypeClasses);
            } else if (referenceParent instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)referenceParent;
                if (!WeakestTypeFinder.findWeakestType(arrayInitializerExpression, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(17);
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiThrowStatement) {
                PsiThrowStatement throwStatement = (PsiThrowStatement)referenceParent;
                if (!WeakestTypeFinder.findWeakestType(throwStatement, variableOrMethodClass, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(18);
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)referenceParent;
                PsiExpression condition = conditionalExpression.getCondition();
                if (referenceElement.equals((Object)condition)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(19);
                    }
                    return list;
                }
                PsiType type = ExpectedTypeUtils.findExpectedType((PsiExpression)conditionalExpression, true);
                if (!WeakestTypeFinder.checkType(type, weakestTypeClasses)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(20);
                    }
                    return list;
                }
            } else if (referenceParent instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)referenceParent;
                type = polyadicExpression.getType();
                if (TypeUtils.isJavaLangString(type)) {
                    if (ExpressionUtils.hasStringType((PsiExpression)referenceElement)) {
                        PsiExpression[] operands = polyadicExpression.getOperands();
                        boolean first = true;
                        boolean stringSeen = false;
                        for (PsiExpression operand : operands) {
                            if (operand == reference) break;
                            first = false;
                            if (!ExpressionUtils.hasStringType(operand)) continue;
                            stringSeen = true;
                            break;
                        }
                        if (!(stringSeen || first && ExpressionUtils.hasStringType(operands[1]) || WeakestTypeFinder.checkType(type, weakestTypeClasses))) {
                            List<PsiClass> list = Collections.emptyList();
                            if (list == null) {
                                WeakestTypeFinder.$$$reportNull$$$0(21);
                            }
                            return list;
                        }
                    }
                } else if (!ComparisonUtils.isEqualityComparison((PsiExpression)polyadicExpression)) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(22);
                    }
                    return list;
                }
            } else {
                PsiNewExpression newExpression;
                PsiExpression qualifier;
                if (referenceParent instanceof PsiSwitchBlock) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(23);
                    }
                    return list;
                }
                if (referenceParent instanceof PsiUnaryExpression) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(24);
                    }
                    return list;
                }
                if (referenceParent instanceof PsiIfStatement) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(25);
                    }
                    return list;
                }
                if (referenceParent instanceof PsiForStatement) {
                    List<PsiClass> list = Collections.emptyList();
                    if (list == null) {
                        WeakestTypeFinder.$$$reportNull$$$0(26);
                    }
                    return list;
                }
                if (referenceParent instanceof PsiNewExpression && (qualifier = (newExpression = (PsiNewExpression)referenceParent).getQualifier()) != null) {
                    PsiClass innerClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)newExpression.getType());
                    if (innerClass == null) {
                        List<PsiClass> list = Collections.emptyList();
                        if (list == null) {
                            WeakestTypeFinder.$$$reportNull$$$0(27);
                        }
                        return list;
                    }
                    PsiClass outerClass = innerClass.getContainingClass();
                    if (outerClass != null) {
                        WeakestTypeFinder.checkClass(outerClass, weakestTypeClasses);
                    }
                }
            }
            if (!weakestTypeClasses.contains(variableOrMethodClass) && !weakestTypeClasses.isEmpty()) continue;
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                WeakestTypeFinder.$$$reportNull$$$0(28);
            }
            return list;
        }
        if (!hasUsages) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                WeakestTypeFinder.$$$reportNull$$$0(29);
            }
            return list;
        }
        Set<PsiClass> set = WeakestTypeFinder.filterAccessibleClasses(weakestTypeClasses, variableOrMethodClass, variableOrMethod);
        if (set == null) {
            WeakestTypeFinder.$$$reportNull$$$0(30);
        }
        return set;
    }

    private static boolean findWeakestType(PsiElement referenceElement, PsiMethodCallExpression methodCallExpression, Set<PsiClass> weakestTypeClasses) {
        PsiClassType classType;
        PsiType[] parameterTypes;
        PsiType qualifierType;
        PsiReferenceExpression methodExpression;
        PsiExpression qualifier;
        PsiClass containingClass;
        PsiType type;
        if (!(referenceElement instanceof PsiExpression)) {
            return false;
        }
        JavaResolveResult resolveResult = methodCallExpression.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method == null) {
            return false;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiExpressionList expressionList = methodCallExpression.getArgumentList();
        Object[] expressions = expressionList.getExpressions();
        int index = ArrayUtil.indexOf((Object[])expressions, (Object)referenceElement);
        if (index < 0) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.isEmpty()) {
            return false;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        if (index < parameters.length) {
            PsiParameter parameter = parameters[index];
            type = parameter.getType();
        } else {
            PsiParameter parameter = parameters[parameters.length - 1];
            type = parameter.getType();
            if (!(type instanceof PsiEllipsisType)) {
                return false;
            }
        }
        @NonNls String methodName = method.getName();
        if (("remove".equals(methodName) || "get".equals(methodName) || "containsKey".equals(methodName) || "containsValue".equals(methodName) || "contains".equals(methodName) || "indexOf".equals(methodName) || "lastIndexOf".equals(methodName)) && (InheritanceUtil.isInheritor((PsiClass)(containingClass = method.getContainingClass()), (String)"java.util.Map") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Collection")) && (qualifier = (methodExpression = methodCallExpression.getMethodExpression()).getQualifierExpression()) != null && (qualifierType = qualifier.getType()) instanceof PsiClassType && (parameterTypes = (classType = (PsiClassType)qualifierType).getParameters()).length > 0) {
            PsiType parameterType = parameterTypes[0];
            Object expression = expressions[index];
            PsiType expressionType = expression.getType();
            if (expressionType == null || parameterType == null || !parameterType.isAssignableFrom(expressionType)) {
                return false;
            }
            return WeakestTypeFinder.checkType(parameterType, substitutor, weakestTypeClasses);
        }
        return WeakestTypeFinder.checkType(type, substitutor, weakestTypeClasses);
    }

    private static boolean checkType(@Nullable PsiType type, @NotNull PsiSubstitutor substitutor, @NotNull Collection<PsiClass> weakestTypeClasses) {
        PsiClass aClass;
        if (substitutor == null) {
            WeakestTypeFinder.$$$reportNull$$$0(31);
        }
        if (weakestTypeClasses == null) {
            WeakestTypeFinder.$$$reportNull$$$0(32);
        }
        if ((aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type)) == null) {
            return false;
        }
        if (aClass instanceof PsiTypeParameter) {
            PsiType substitution = substitutor.substitute((PsiTypeParameter)aClass);
            return WeakestTypeFinder.checkType(substitution, weakestTypeClasses);
        }
        WeakestTypeFinder.checkClass(aClass, weakestTypeClasses);
        return true;
    }

    private static boolean findWeakestType(PsiMethodCallExpression methodCallExpression, Set<PsiClass> weakestTypeClasses) {
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiReferenceList throwsList = method.getThrowsList();
        Object[] classTypes = throwsList.getReferencedTypes();
        HashSet thrownTypes = ContainerUtil.newHashSet((Object[])classTypes);
        List<PsiMethod> superMethods = WeakestTypeFinder.findAllSuperMethods(method);
        boolean checked = false;
        if (!superMethods.isEmpty()) {
            PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)methodCallExpression, false);
            for (PsiMethod superMethod : superMethods) {
                PsiClass containingClass;
                ProgressManager.checkCanceled();
                PsiType returnType = superMethod.getReturnType();
                if (expectedType instanceof PsiClassType) {
                    PsiClassType expectedClassType = (PsiClassType)expectedType;
                    if (!(returnType instanceof PsiClassType) || !expectedClassType.rawType().isAssignableFrom(returnType)) {
                        continue;
                    }
                } else if (expectedType != null && returnType != null && !expectedType.isAssignableFrom(returnType)) continue;
                if (WeakestTypeFinder.throwsIncompatibleException(superMethod, thrownTypes) || !PsiUtil.isAccessible((PsiMember)superMethod, (PsiElement)methodCallExpression, null) || !WeakestTypeFinder.checkClass(containingClass = superMethod.getContainingClass(), weakestTypeClasses)) continue;
                checked = true;
                break;
            }
        }
        if (!checked) {
            if (TypeUtils.isTypeParameter(method.getReturnType())) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            WeakestTypeFinder.checkClass(containingClass, weakestTypeClasses);
        }
        return true;
    }

    private static List<PsiMethod> findAllSuperMethods(PsiMethod method) {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).forEach(method12 -> {
            ProgressManager.checkCanceled();
            result.add(method12.getMethod());
            return true;
        });
        result.sort((method1, method2) -> {
            PsiClass aClass1 = method1.getContainingClass();
            PsiClass aClass2 = method2.getContainingClass();
            if (aClass1 == null || aClass2 == null || aClass1.equals((Object)aClass2)) {
                return 0;
            }
            if (aClass1.isInterface() && !aClass2.isInterface()) {
                return -1;
            }
            if (!aClass1.isInterface() && aClass2.isInterface()) {
                return 1;
            }
            if (aClass1.isInheritor(aClass2, true)) {
                return 1;
            }
            if (aClass2.isInheritor(aClass1, true)) {
                return -1;
            }
            String name1 = aClass1.getName();
            String name2 = aClass2.getName();
            return StringUtil.compare((String)name1, (String)name2, (boolean)false);
        });
        return result;
    }

    private static boolean findWeakestType(PsiElement referenceElement, PsiAssignmentExpression assignmentExpression, boolean useRighthandTypeAsWeakestTypeInAssignments, Set<PsiClass> weakestTypeClasses) {
        IElementType tokenType = assignmentExpression.getOperationTokenType();
        if (JavaTokenType.EQ != tokenType) {
            return false;
        }
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression rhs = assignmentExpression.getRExpression();
        if (rhs == null) {
            return false;
        }
        PsiType lhsType = lhs.getType();
        PsiType rhsType = rhs.getType();
        if (lhsType == null || rhsType == null || !lhsType.isAssignableFrom(rhsType)) {
            return false;
        }
        if (referenceElement.equals((Object)rhs)) {
            return WeakestTypeFinder.checkType(lhsType, weakestTypeClasses);
        }
        return !useRighthandTypeAsWeakestTypeInAssignments || rhs instanceof PsiNewExpression && rhs instanceof PsiTypeCastExpression || !lhsType.equals(rhsType);
    }

    private static boolean findWeakestType(PsiArrayInitializerExpression arrayInitializerExpression, Set<PsiClass> weakestTypeClasses) {
        PsiType type = arrayInitializerExpression.getType();
        if (!(type instanceof PsiArrayType)) {
            return false;
        }
        PsiArrayType arrayType = (PsiArrayType)type;
        PsiType componentType = arrayType.getComponentType();
        return WeakestTypeFinder.checkType(componentType, weakestTypeClasses);
    }

    private static boolean findWeakestType(PsiThrowStatement throwStatement, PsiClass variableOrMethodClass, Set<PsiClass> weakestTypeClasses) {
        PsiClassType runtimeExceptionType = TypeUtils.getType("java.lang.RuntimeException", (PsiElement)throwStatement);
        PsiClass runtimeExceptionClass = runtimeExceptionType.resolve();
        if (runtimeExceptionClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)variableOrMethodClass, (PsiClass)runtimeExceptionClass, (boolean)true)) {
            return WeakestTypeFinder.checkType((PsiType)runtimeExceptionType, weakestTypeClasses);
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)throwStatement, PsiMethod.class);
        if (method == null) {
            return false;
        }
        PsiReferenceList throwsList = method.getThrowsList();
        PsiClassType[] referencedTypes = throwsList.getReferencedTypes();
        boolean checked = false;
        for (PsiClassType referencedType : referencedTypes) {
            ProgressManager.checkCanceled();
            PsiClass throwableClass = referencedType.resolve();
            if (throwableClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)variableOrMethodClass, (PsiClass)throwableClass, (boolean)true) || !WeakestTypeFinder.checkType((PsiType)referencedType, weakestTypeClasses)) continue;
            checked = true;
            break;
        }
        return checked;
    }

    private static boolean throwsIncompatibleException(PsiMethod method, Collection<? extends PsiClassType> exceptionTypes) {
        PsiClassType[] superThrownTypes;
        PsiReferenceList superThrowsList = method.getThrowsList();
        block0: for (PsiClassType superThrownType : superThrownTypes = superThrowsList.getReferencedTypes()) {
            ProgressManager.checkCanceled();
            if (exceptionTypes.contains(superThrownType)) continue;
            for (PsiClassType psiClassType : exceptionTypes) {
                if (!InheritanceUtil.isInheritor((PsiType)superThrownType, (String)psiClassType.getCanonicalText())) continue;
                continue block0;
            }
            PsiClass aClass = superThrownType.resolve();
            if (aClass == null) {
                return true;
            }
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.RuntimeException") || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Error")) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    private static boolean checkType(@Nullable PsiType type, @NotNull Collection<PsiClass> weakestTypeClasses) {
        PsiClass aClass;
        if (weakestTypeClasses == null) {
            WeakestTypeFinder.$$$reportNull$$$0(33);
        }
        if ((aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type)) == null) {
            return false;
        }
        WeakestTypeFinder.checkClass(aClass, weakestTypeClasses);
        return true;
    }

    private static Set<PsiClass> filterAccessibleClasses(Set<? extends PsiClass> weakestTypeClasses, PsiClass upperBound, PsiElement context) {
        HashSet<PsiClass> result = new HashSet<PsiClass>();
        for (PsiClass psiClass : weakestTypeClasses) {
            ProgressManager.checkCanceled();
            if (PsiUtil.isAccessible((PsiMember)psiClass, (PsiElement)context, null) && !psiClass.isDeprecated()) {
                result.add(psiClass);
                continue;
            }
            PsiClass visibleInheritor = WeakestTypeFinder.getVisibleInheritor(psiClass, upperBound, context);
            if (visibleInheritor == null) continue;
            result.add(visibleInheritor);
        }
        return result;
    }

    @Nullable
    private static PsiClass getVisibleInheritor(@NotNull PsiClass superClass, PsiClass upperBound, PsiElement context) {
        if (superClass == null) {
            WeakestTypeFinder.$$$reportNull$$$0(34);
        }
        Query search = DirectClassInheritorsSearch.search((PsiClass)superClass, (SearchScope)context.getResolveScope());
        Project project = superClass.getProject();
        for (PsiClass aClass : search.asIterable()) {
            ProgressManager.checkCanceled();
            if (!aClass.isInheritor(superClass, true) || !upperBound.isInheritor(aClass, true)) continue;
            if (PsiUtil.isAccessible((Project)project, (PsiMember)aClass, (PsiElement)context, null)) {
                return aClass;
            }
            return WeakestTypeFinder.getVisibleInheritor(aClass, upperBound, context);
        }
        return null;
    }

    private static boolean checkClass(@Nullable PsiClass aClass, @NotNull Collection<PsiClass> weakestTypeClasses) {
        if (weakestTypeClasses == null) {
            WeakestTypeFinder.$$$reportNull$$$0(35);
        }
        if (aClass == null) {
            return false;
        }
        boolean shouldAdd = true;
        Iterator<PsiClass> iterator = weakestTypeClasses.iterator();
        while (iterator.hasNext()) {
            ProgressManager.checkCanceled();
            PsiClass weakestTypeClass = iterator.next();
            if (weakestTypeClass.equals((Object)aClass)) {
                return true;
            }
            if (aClass.isInheritor(weakestTypeClass, true)) {
                iterator.remove();
                continue;
            }
            if (weakestTypeClass.isInheritor(aClass, true)) {
                shouldAdd = false;
                continue;
            }
            iterator.remove();
            shouldAdd = false;
        }
        if (!shouldAdd) {
            return false;
        }
        weakestTypeClasses.add(aClass);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableOrMethod";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/WeakestTypeFinder";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 32: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weakestTypeClasses";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/WeakestTypeFinder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateWeakestClassesNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateWeakestClassesNecessary";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleInheritor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30 -> new IllegalStateException(string);
        };
    }
}

