/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.DelegatingFixFactory;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public final class NonSerializableWithSerializationMethodsInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "NonSerializableClassWithSerializationMethods";
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[2];
        return DelegatingFixFactory.createMakeSerializableFix(aClass);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean hasReadObject = (Boolean)infos[0];
        boolean hasWriteObject = (Boolean)infos[1];
        PsiClass aClass = (PsiClass)infos[2];
        int ordinal = ClassUtils.getTypeOrdinal(aClass);
        if (hasReadObject && hasWriteObject) {
            String string = InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.problem.descriptor.both", ordinal);
            if (string == null) {
                NonSerializableWithSerializationMethodsInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (hasWriteObject) {
            String string = InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.problem.descriptor.write", ordinal);
            if (string == null) {
                NonSerializableWithSerializationMethodsInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.problem.descriptor.read", ordinal);
        if (string == null) {
            NonSerializableWithSerializationMethodsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NonSerializableWithSerializationMethodsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/NonSerializableWithSerializationMethodsInspection", "buildErrorString"));
    }

    private static class NonSerializableWithSerializationMethodsVisitor
    extends BaseInspectionVisitor {
        private NonSerializableWithSerializationMethodsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                NonSerializableWithSerializationMethodsVisitor.$$$reportNull$$$0(0);
            }
            if (aClass.isAnnotationType()) {
                return;
            }
            boolean hasReadObject = SerializationUtils.hasReadObject(aClass);
            boolean hasWriteObject = SerializationUtils.hasWriteObject(aClass);
            if (!hasWriteObject && !hasReadObject) {
                return;
            }
            if (SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerClassError(aClass, hasReadObject, hasWriteObject, aClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/serialization/NonSerializableWithSerializationMethodsInspection$NonSerializableWithSerializationMethodsVisitor", "visitClass"));
        }
    }
}

