/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public final class TransientFieldInNonSerializableClassInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        String string = InspectionGadgetsBundle.message("transient.field.in.non.serializable.class.problem.descriptor", field.getName());
        if (string == null) {
            TransientFieldInNonSerializableClassInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new RemoveModifierFix("transient");
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new TransientFieldInNonSerializableClassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/TransientFieldInNonSerializableClassInspection", "buildErrorString"));
    }

    private static class TransientFieldInNonSerializableClassVisitor
    extends BaseInspectionVisitor {
        private TransientFieldInNonSerializableClassVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                TransientFieldInNonSerializableClassVisitor.$$$reportNull$$$0(0);
            }
            if (!field.hasModifierProperty("transient")) {
                return;
            }
            PsiClass aClass = field.getContainingClass();
            if (SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerModifierError("transient", (PsiModifierListOwner)field, field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/serialization/TransientFieldInNonSerializableClassInspection$TransientFieldInNonSerializableClassVisitor", "visitField"));
        }
    }
}

