/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public final class ChainedEqualityInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ChainedEqualityComparisons";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("chained.equality.comparisons.problem.descriptor", new Object[0]);
        if (string == null) {
            ChainedEqualityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ChainedEqualityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ChainedEqualityInspection", "buildErrorString"));
    }

    private static class ChainedEqualityVisitor
    extends BaseInspectionVisitor {
        private ChainedEqualityVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
            if (expression == null) {
                ChainedEqualityVisitor.$$$reportNull$$$0(0);
            }
            super.visitPolyadicExpression(expression);
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiExpression && ComparisonUtils.isEqualityComparison((PsiExpression)parent)) {
                return;
            }
            PsiExpression[] operands = expression.getOperands();
            if (operands.length >= 3) {
                this.registerError((PsiElement)expression, new Object[0]);
            } else {
                for (PsiExpression operand : operands) {
                    if (!ComparisonUtils.isEqualityComparison(operand)) continue;
                    this.registerError((PsiElement)expression, new Object[0]);
                    break;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/ChainedEqualityInspection$ChainedEqualityVisitor", "visitPolyadicExpression"));
        }
    }
}

