/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ControlFlowStatementVisitorBase
extends BaseInspectionVisitor {
    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            ControlFlowStatementVisitorBase.$$$reportNull$$$0(0);
        }
        super.visitForeachStatement(statement);
        PsiStatement body = statement.getBody();
        if (this.isApplicable(body)) {
            this.registerLoopStatementErrors((PsiLoopStatement)statement, body, "for");
        }
    }

    public void visitForStatement(@NotNull PsiForStatement statement) {
        if (statement == null) {
            ControlFlowStatementVisitorBase.$$$reportNull$$$0(1);
        }
        super.visitForStatement(statement);
        PsiStatement body = statement.getBody();
        if (this.isApplicable(body)) {
            this.registerLoopStatementErrors((PsiLoopStatement)statement, body, "for");
        }
    }

    public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
        if (statement == null) {
            ControlFlowStatementVisitorBase.$$$reportNull$$$0(2);
        }
        super.visitWhileStatement(statement);
        PsiStatement body = statement.getBody();
        if (this.isApplicable(body)) {
            this.registerLoopStatementErrors((PsiLoopStatement)statement, body, "while");
        }
    }

    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
        if (statement == null) {
            ControlFlowStatementVisitorBase.$$$reportNull$$$0(3);
        }
        super.visitDoWhileStatement(statement);
        PsiStatement body = statement.getBody();
        if (this.isApplicable(body)) {
            this.registerLoopStatementErrors((PsiLoopStatement)statement, body, "do");
        }
    }

    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        PsiStatement elseBranch;
        if (statement == null) {
            ControlFlowStatementVisitorBase.$$$reportNull$$$0(4);
        }
        super.visitIfStatement(statement);
        PsiStatement thenBranch = statement.getThenBranch();
        if (this.isApplicable(thenBranch)) {
            this.registerControlFlowStatementErrors(statement.getFirstChild(), thenBranch.getLastChild(), thenBranch, "if");
        }
        if (this.isApplicable(elseBranch = statement.getElseBranch())) {
            this.registerControlFlowStatementErrors((PsiElement)statement.getElseElement(), elseBranch.getLastChild(), elseBranch, "else");
        }
    }

    @Contract(value="null->false")
    protected abstract boolean isApplicable(PsiStatement var1);

    @Nullable
    protected abstract Pair<PsiElement, PsiElement> getOmittedBodyBounds(PsiStatement var1);

    private void registerLoopStatementErrors(@NotNull PsiLoopStatement statement, @NotNull PsiStatement body, @NotNull String keywordText) {
        if (statement == null) {
            ControlFlowStatementVisitorBase.$$$reportNull$$$0(5);
        }
        if (body == null) {
            ControlFlowStatementVisitorBase.$$$reportNull$$$0(6);
        }
        if (keywordText == null) {
            ControlFlowStatementVisitorBase.$$$reportNull$$$0(7);
        }
        this.registerControlFlowStatementErrors(statement.getFirstChild(), statement.getLastChild(), body, keywordText);
    }

    private void registerControlFlowStatementErrors(@Nullable PsiElement rangeStart, @Nullable PsiElement rangeEnd, @NotNull PsiStatement body, @NotNull String keywordText) {
        int length;
        int startOffset;
        int parentStart;
        if (body == null) {
            ControlFlowStatementVisitorBase.$$$reportNull$$$0(8);
        }
        if (keywordText == null) {
            ControlFlowStatementVisitorBase.$$$reportNull$$$0(9);
        }
        if (rangeStart == null || rangeEnd == null) {
            return;
        }
        if (this.isVisibleHighlight((PsiElement)body)) {
            this.registerError(rangeStart, keywordText);
            return;
        }
        Pair<PsiElement, PsiElement> omittedBodyBounds = this.getOmittedBodyBounds(body);
        if (omittedBodyBounds == null) {
            this.registerErrorAtRange(rangeStart, rangeEnd, keywordText);
            return;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)rangeStart, (PsiElement)((PsiElement)omittedBodyBounds.first));
        if (parent != null) {
            parentStart = parent.getTextRange().getStartOffset();
            startOffset = rangeStart.getTextRange().getStartOffset();
            length = ((PsiElement)omittedBodyBounds.first).getTextRange().getStartOffset() - startOffset;
            if (length > 0) {
                this.registerErrorAtOffset(parent, startOffset - parentStart, length, keywordText);
            }
        }
        if (rangeEnd != omittedBodyBounds.second && (parent = PsiTreeUtil.findCommonParent((PsiElement)rangeEnd, (PsiElement)((PsiElement)omittedBodyBounds.second))) != null) {
            parentStart = parent.getTextRange().getStartOffset();
            startOffset = ((PsiElement)omittedBodyBounds.second).getTextRange().getEndOffset();
            length = rangeEnd.getTextRange().getEndOffset() - startOffset;
            if (length > 0) {
                this.registerErrorAtOffset(parent, startOffset - parentStart, length, keywordText);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordText";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/style/ControlFlowStatementVisitorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForeachStatement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitWhileStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDoWhileStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIfStatement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "registerLoopStatementErrors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "registerControlFlowStatementErrors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

