/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryFinalOnLocalVariableOrParameterInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean reportLocalVariables = true;
    public boolean reportPatternVariables = true;
    public boolean reportParameters = true;
    public boolean onlyWarnOnAbstractMethods = false;
    public boolean reportCatchParameters = true;
    public boolean reportForeachParameters = true;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiVariable variable = (PsiVariable)infos[0];
        String variableName = variable.getName();
        if (variable instanceof PsiParameter) {
            String string = InspectionGadgetsBundle.message("unnecessary.final.on.parameter.problem.descriptor", variableName);
            if (string == null) {
                UnnecessaryFinalOnLocalVariableOrParameterInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("unnecessary.final.on.local.variable.problem.descriptor", variableName);
        if (string == null) {
            UnnecessaryFinalOnLocalVariableOrParameterInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"reportLocalVariables", (String)InspectionGadgetsBundle.message("unnecessary.final.report.local.variables.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"reportPatternVariables", (String)InspectionGadgetsBundle.message("unnecessary.final.report.pattern.variables.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"reportParameters", (String)InspectionGadgetsBundle.message("unnecessary.final.report.method.parameters.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"onlyWarnOnAbstractMethods", (String)InspectionGadgetsBundle.message("unnecessary.final.on.parameter.only.interface.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(HtmlChunk.raw((String)InspectionGadgetsBundle.message("unnecessary.final.on.parameter.only.interface.option.description", new Object[0])))}), OptPane.checkbox((String)"reportCatchParameters", (String)InspectionGadgetsBundle.message("unnecessary.final.report.catch.parameters.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"reportForeachParameters", (String)InspectionGadgetsBundle.message("unnecessary.final.report.foreach.parameters.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessaryFinalOnLocalVariableOrParameterInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryFinalOnLocalVariableOrParameterVisitor();
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new RemoveModifierFix("final");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryFinalOnLocalVariableOrParameterInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class UnnecessaryFinalOnLocalVariableOrParameterVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryFinalOnLocalVariableOrParameterVisitor() {
        }

        public void visitDeclarationStatement(@NotNull PsiDeclarationStatement statement) {
            if (statement == null) {
                UnnecessaryFinalOnLocalVariableOrParameterVisitor.$$$reportNull$$$0(0);
            }
            super.visitDeclarationStatement(statement);
            if (!UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportLocalVariables) {
                return;
            }
            PsiElement[] declaredElements = statement.getDeclaredElements();
            if (declaredElements.length == 0) {
                return;
            }
            PsiElement firstElement = declaredElements[0];
            if (!(firstElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable firstVariable = (PsiLocalVariable)firstElement;
            if (!firstVariable.hasModifierProperty("final")) {
                return;
            }
            PsiCodeBlock containingBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiCodeBlock.class);
            if (containingBlock == null) {
                return;
            }
            for (PsiElement declaredElement : declaredElements) {
                PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
                if (!UnnecessaryFinalOnLocalVariableOrParameterVisitor.isNecessaryFinal((PsiVariable)variable, (PsiElement)containingBlock)) continue;
                return;
            }
            this.registerModifierError("final", (PsiModifierListOwner)firstVariable, firstVariable);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiParameter[] parameters;
            if (method == null) {
                UnnecessaryFinalOnLocalVariableOrParameterVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethod(method);
            if (!UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportParameters) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            for (PsiParameter parameter : parameters = parameterList.getParameters()) {
                this.checkParameter(method, parameter);
            }
        }

        private void checkParameter(PsiMethod method, PsiParameter parameter) {
            if (!parameter.hasModifierProperty("final")) {
                return;
            }
            if (method.hasModifierProperty("abstract")) {
                this.registerModifierError("final", (PsiModifierListOwner)parameter, parameter);
            } else if (!UnnecessaryFinalOnLocalVariableOrParameterInspection.this.onlyWarnOnAbstractMethods) {
                this.check(parameter);
            }
        }

        public void visitPatternVariable(@NotNull PsiPatternVariable variable) {
            if (variable == null) {
                UnnecessaryFinalOnLocalVariableOrParameterVisitor.$$$reportNull$$$0(2);
            }
            super.visitPatternVariable(variable);
            if (UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportPatternVariables && variable.hasModifierProperty("final")) {
                this.registerModifierError("final", (PsiModifierListOwner)variable, variable);
            }
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiCatchSection[] catchSections;
            if (statement == null) {
                UnnecessaryFinalOnLocalVariableOrParameterVisitor.$$$reportNull$$$0(3);
            }
            super.visitTryStatement(statement);
            PsiResourceList resourceList = statement.getResourceList();
            if (resourceList != null && UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportLocalVariables) {
                for (PsiResourceListElement element : resourceList) {
                    PsiResourceVariable variable;
                    if (!(element instanceof PsiResourceVariable) || !(variable = (PsiResourceVariable)element).hasModifierProperty("final")) continue;
                    this.registerModifierError("final", (PsiModifierListOwner)variable, variable);
                }
            }
            if (UnnecessaryFinalOnLocalVariableOrParameterInspection.this.onlyWarnOnAbstractMethods || !UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportCatchParameters) {
                return;
            }
            for (PsiCatchSection catchSection : catchSections = statement.getCatchSections()) {
                PsiParameter parameter = catchSection.getParameter();
                PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                if (parameter == null || catchBlock == null || !parameter.hasModifierProperty("final") || !(parameter.getType() instanceof PsiDisjunctionType) && UnnecessaryFinalOnLocalVariableOrParameterVisitor.isNecessaryFinal((PsiVariable)parameter, parameter.getDeclarationScope())) continue;
                this.registerModifierError("final", (PsiModifierListOwner)parameter, parameter);
            }
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                UnnecessaryFinalOnLocalVariableOrParameterVisitor.$$$reportNull$$$0(4);
            }
            super.visitForeachStatement(statement);
            if (!UnnecessaryFinalOnLocalVariableOrParameterInspection.this.reportForeachParameters) {
                return;
            }
            PsiParameter parameter = statement.getIterationParameter();
            if (!parameter.hasModifierProperty("final")) {
                return;
            }
            this.check(parameter);
        }

        private static boolean isNecessaryFinal(PsiVariable variable, PsiElement context) {
            return PsiUtil.isConstantExpression((PsiExpression)variable.getInitializer()) || !PsiUtil.isAvailable((JavaFeature)JavaFeature.EFFECTIVELY_FINAL, (PsiElement)variable) && VariableAccessUtils.variableIsUsedInInnerClass(variable, context);
        }

        private void check(PsiParameter parameter) {
            if (!UnnecessaryFinalOnLocalVariableOrParameterVisitor.isNecessaryFinal((PsiVariable)parameter, parameter.getDeclarationScope())) {
                this.registerModifierError("final", (PsiModifierListOwner)parameter, parameter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/style/UnnecessaryFinalOnLocalVariableOrParameterInspection$UnnecessaryFinalOnLocalVariableOrParameterVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDeclarationStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPatternVariable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTryStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForeachStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

