/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnnecessarySuperQualifierInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreClarification;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.super.qualifier.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessarySuperQualifierInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreClarification", (String)JavaAnalysisBundle.message((String)"inspection.unnecessary.super.qualifier.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UnnecessarySuperQualifierInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @Nullable
    protected LocalQuickFix buildFix(Object ... infos) {
        return new UnnecessarySuperQualifierFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarySuperQualifierVisitor(this.ignoreClarification);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessarySuperQualifierInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessarySuperQualifierFix
    extends PsiUpdateModCommandQuickFix {
        private UnnecessarySuperQualifierFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.super.qualifier.quickfix", new Object[0]);
            if (string == null) {
                UnnecessarySuperQualifierFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                UnnecessarySuperQualifierFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                UnnecessarySuperQualifierFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UnnecessarySuperQualifierFix.$$$reportNull$$$0(3);
            }
            startElement.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/style/UnnecessarySuperQualifierInspection$UnnecessarySuperQualifierFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/style/UnnecessarySuperQualifierInspection$UnnecessarySuperQualifierFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class UnnecessarySuperQualifierVisitor
    extends BaseInspectionVisitor {
        private final boolean myIgnoreClarification;

        UnnecessarySuperQualifierVisitor(boolean ignoreClarification) {
            this.myIgnoreClarification = ignoreClarification;
        }

        public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
            if (expression == null) {
                UnnecessarySuperQualifierVisitor.$$$reportNull$$$0(0);
            }
            super.visitSuperExpression(expression);
            PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
            if (qualifier != null) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
            PsiElement grandParent = referenceExpression.getParent();
            if (grandParent instanceof PsiMethodCallExpression) {
                PsiClass containingClass;
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                if (!UnnecessarySuperQualifierVisitor.hasUnnecessarySuperQualifier(methodCallExpression)) {
                    return;
                }
                if (this.myIgnoreClarification && (containingClass = PsiUtil.getContainingClass((PsiElement)expression)) != null) {
                    PsiExpression copyCall;
                    PsiMethod method;
                    PsiElement classParent = containingClass.getParent();
                    String referenceName = methodCallExpression.getMethodExpression().getReferenceName();
                    if (referenceName != null && (method = ((PsiMethodCallExpression)(copyCall = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(referenceName + methodCallExpression.getArgumentList().getText(), classParent))).resolveMethod()) != null && method != referenceExpression.resolve()) {
                        return;
                    }
                }
            } else {
                PsiClass containingClass;
                if (!UnnecessarySuperQualifierVisitor.hasUnnecessarySuperQualifier(referenceExpression)) {
                    return;
                }
                if (this.myIgnoreClarification && (containingClass = PsiUtil.getContainingClass((PsiElement)expression)) != null) {
                    PsiVariable variable;
                    PsiElement classParent = containingClass.getParent();
                    String referenceText = referenceExpression.getReferenceName();
                    if (referenceText != null && (variable = PsiResolveHelper.getInstance((Project)expression.getProject()).resolveAccessibleReferencedVariable(referenceText, classParent)) != null && variable != referenceExpression.resolve()) {
                        return;
                    }
                }
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static boolean hasUnnecessarySuperQualifier(PsiReferenceExpression referenceExpression) {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiClass.class);
            if (parentClass == null) {
                return false;
            }
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return false;
            }
            PsiField superField = (PsiField)target;
            PsiReferenceExpression copy = (PsiReferenceExpression)referenceExpression.copy();
            PsiElement qualifier = copy.getQualifier();
            if (qualifier == null) {
                return false;
            }
            qualifier.delete();
            JavaResolveResult resolveResult = copy.advancedResolve(false);
            return resolveResult.isValidResult() && superField == resolveResult.getElement();
        }

        private static boolean hasUnnecessarySuperQualifier(PsiMethodCallExpression methodCallExpression) {
            PsiMethod superMethod = methodCallExpression.resolveMethod();
            if (superMethod == null) {
                return false;
            }
            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiClass.class);
            if (aClass != null && MethodUtils.isOverriddenInHierarchy(superMethod, aClass)) {
                return false;
            }
            PsiMethodCallExpression copy = (PsiMethodCallExpression)methodCallExpression.copy();
            PsiReferenceExpression methodExpression = copy.getMethodExpression();
            PsiElement qualifier = methodExpression.getQualifier();
            if (qualifier == null) {
                return false;
            }
            qualifier.delete();
            JavaResolveResult resolveResult = copy.resolveMethodGenerics();
            PsiElement element = resolveResult.getElement();
            return resolveResult.isValidResult() && superMethod.getManager().areElementsEquivalent((PsiElement)superMethod, element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/UnnecessarySuperQualifierInspection$UnnecessarySuperQualifierVisitor", "visitSuperExpression"));
        }
    }
}

