/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.testFrameworks.AssertHint;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class MisorderedAssertEqualsArgumentsInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> methodNames = ContainerUtil.newHashSet((Object[])new String[]{"assertEquals", "assertEqualsNoOrder", "assertNotEquals", "assertArrayEquals", "assertSame", "assertNotSame", "failNotSame", "failNotEquals"});

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("misordered.assert.equals.arguments.problem.descriptor", new Object[0]);
        if (string == null) {
            MisorderedAssertEqualsArgumentsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new FlipArgumentsFix();
    }

    AssertHint createAssertHint(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            MisorderedAssertEqualsArgumentsInspection.$$$reportNull$$$0(1);
        }
        return AssertHint.create(expression, (Function1<? super String, Integer>)((Function1)methodName -> methodNames.contains(methodName) ? Integer.valueOf(2) : null));
    }

    static boolean looksLikeExpectedArgument(PsiExpression expression, ParameterPosition parameterPosition) {
        if (expression == null) {
            return false;
        }
        final Ref expectedArgument = Ref.create((Object)Boolean.TRUE);
        SmartList expressions = new SmartList();
        expressions.add(expression);
        while (!expressions.isEmpty()) {
            ((PsiExpression)expressions.removeLast()).accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((List)expressions, parameterPosition){
                final /* synthetic */ List val$expressions;
                final /* synthetic */ ParameterPosition val$parameterPosition;
                {
                    this.val$expressions = list;
                    this.val$parameterPosition = parameterPosition;
                }

                public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
                    if (referenceExpression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!((Boolean)expectedArgument.get()).booleanValue()) {
                        return;
                    }
                    super.visitReferenceExpression(referenceExpression);
                    PsiElement target = referenceExpression.resolve();
                    if (target instanceof PsiEnumConstant || target instanceof PsiClass) {
                        return;
                    }
                    if (target instanceof PsiField) {
                        PsiField field = (PsiField)target;
                        if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) {
                            return;
                        }
                    } else {
                        if (target instanceof PsiParameter) {
                            PsiParameter parameter = (PsiParameter)target;
                            if ("expected".equals(parameter.getName())) {
                                return;
                            }
                            expectedArgument.set((Object)Boolean.FALSE);
                            return;
                        }
                        if (target instanceof PsiLocalVariable) {
                            PsiLocalVariable variable = (PsiLocalVariable)target;
                            PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
                            if (block == null) {
                                return;
                            }
                            PsiExpression definition = DeclarationSearchUtils.findDefinition(referenceExpression, (PsiVariable)variable);
                            if (definition == null) {
                                expectedArgument.set((Object)Boolean.FALSE);
                                return;
                            }
                            if (PsiUtil.isConstantExpression((PsiExpression)definition) || PsiTypes.nullType().equals(definition.getType())) {
                                return;
                            }
                            PsiElement[] refs = DefUseUtil.getRefs((PsiCodeBlock)block, (PsiVariable)variable, (PsiElement)definition);
                            int offset = referenceExpression.getTextOffset();
                            for (PsiElement ref : refs) {
                                if (ref.getTextOffset() >= offset) continue;
                                expectedArgument.set((Object)Boolean.FALSE);
                                return;
                            }
                            this.val$expressions.add(definition);
                        } else if (target instanceof PsiMethod) {
                            PsiMethod method = (PsiMethod)target;
                            if (this.val$parameterPosition == ParameterPosition.ACTUAL && !"expected".equals(method.getName())) {
                                expectedArgument.set((Object)Boolean.FALSE);
                            }
                        }
                    }
                    if (!(target instanceof PsiCompiledElement)) {
                        expectedArgument.set((Object)Boolean.FALSE);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/siyeh/ig/testFrameworks/MisorderedAssertEqualsArgumentsInspection$1", "visitReferenceExpression"));
                }
            });
        }
        return (Boolean)expectedArgument.get();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new MisorderedAssertEqualsParametersVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/testFrameworks/MisorderedAssertEqualsArgumentsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/testFrameworks/MisorderedAssertEqualsArgumentsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createAssertHint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private class FlipArgumentsFix
    extends PsiUpdateModCommandQuickFix {
        private FlipArgumentsFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("misordered.assert.equals.arguments.flip.quickfix", new Object[0]);
            if (string == null) {
                FlipArgumentsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement methodNameIdentifier, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                FlipArgumentsFix.$$$reportNull$$$0(1);
            }
            if (methodNameIdentifier == null) {
                FlipArgumentsFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                FlipArgumentsFix.$$$reportNull$$$0(3);
            }
            if ((parent = methodNameIdentifier.getParent()) == null) {
                return;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)parent.getParent();
            if (callExpression == null) {
                return;
            }
            AssertHint hint = MisorderedAssertEqualsArgumentsInspection.this.createAssertHint(callExpression);
            if (hint == null) {
                return;
            }
            PsiExpression expectedArgument = (PsiExpression)hint.getExpected();
            PsiExpression actualArgument = (PsiExpression)hint.getActual();
            PsiElement copy = expectedArgument.copy();
            expectedArgument.replace((PsiElement)actualArgument);
            actualArgument.replace(copy);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/testFrameworks/MisorderedAssertEqualsArgumentsInspection$FlipArgumentsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodNameIdentifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/testFrameworks/MisorderedAssertEqualsArgumentsInspection$FlipArgumentsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static enum ParameterPosition {
        EXPECTED,
        ACTUAL;

    }

    private class MisorderedAssertEqualsParametersVisitor
    extends BaseInspectionVisitor {
        private MisorderedAssertEqualsParametersVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                MisorderedAssertEqualsParametersVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            AssertHint hint = MisorderedAssertEqualsArgumentsInspection.this.createAssertHint(expression);
            if (hint == null) {
                return;
            }
            if (MisorderedAssertEqualsArgumentsInspection.looksLikeExpectedArgument((PsiExpression)hint.getExpected(), ParameterPosition.EXPECTED) || !MisorderedAssertEqualsArgumentsInspection.looksLikeExpectedArgument((PsiExpression)hint.getActual(), ParameterPosition.ACTUAL)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/testFrameworks/MisorderedAssertEqualsArgumentsInspection$MisorderedAssertEqualsParametersVisitor", "visitMethodCallExpression"));
        }
    }
}

