/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class NakedNotifyInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("naked.notify.problem.descriptor", new Object[0]);
        if (string == null) {
            NakedNotifyInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NakedNotifyVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/NakedNotifyInspection", "buildErrorString"));
    }

    private static class NakedNotifyVisitor
    extends BaseInspectionVisitor {
        private NakedNotifyVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                NakedNotifyVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (!method.hasModifierProperty("synchronized")) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body != null) {
                this.checkBody(body);
            }
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                NakedNotifyVisitor.$$$reportNull$$$0(1);
            }
            super.visitSynchronizedStatement(statement);
            this.checkBody(statement.getBody());
        }

        private void checkBody(PsiCodeBlock body) {
            PsiStatement firstStatement = ControlFlowUtils.getFirstStatementInBlock(body);
            if (!(firstStatement instanceof PsiExpressionStatement)) {
                return;
            }
            PsiExpression firstExpression = ((PsiExpressionStatement)firstStatement).getExpression();
            if (!(firstExpression instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)firstExpression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            @NonNls String methodName = methodExpression.getReferenceName();
            if (!"notify".equals(methodName) && !"notifyAll".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (!argumentList.isEmpty()) {
                return;
            }
            this.registerMethodCallError(methodCallExpression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/NakedNotifyInspection$NakedNotifyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSynchronizedStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

