/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.lang.manifest.highlighting;

import com.intellij.codeInspection.AddToInspectionOptionListFix;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.spellchecker.engine.Suggestion;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.EditDistance;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.ManifestBundle;
import org.jetbrains.lang.manifest.header.HeaderParserRepository;
import org.jetbrains.lang.manifest.psi.Header;

public final class MisspelledHeaderInspection
extends LocalInspectionTool {
    private static final int MAX_SUGGESTIONS = 5;
    private static final int MAX_DISTANCE = 4;
    private static final int TYPO_DISTANCE = 2;
    @XCollection(elementName="header")
    public final List<String> CUSTOM_HEADERS = new ArrayList<String>();
    private final HeaderParserRepository myRepository = HeaderParserRepository.getInstance();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MisspelledHeaderInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof Header) {
                    Header header = (Header)element;
                    String headerName = header.getName();
                    TreeSet matches = new TreeSet();
                    1.addMatches(headerName, MisspelledHeaderInspection.this.CUSTOM_HEADERS, matches);
                    1.addMatches(headerName, MisspelledHeaderInspection.this.myRepository.getAllHeaderNames(), matches);
                    Suggestion bestMatch = (Suggestion)ContainerUtil.getFirstItem(matches);
                    if (bestMatch != null && headerName.equals(bestMatch.getWord())) {
                        return;
                    }
                    ArrayList<Object> fixes = new ArrayList<Object>();
                    for (Suggestion match : matches) {
                        fixes.add(LocalQuickFix.from((ModCommandAction)new HeaderRenameQuickFix(header, match.getWord())));
                        if (fixes.size() != 5) continue;
                        break;
                    }
                    if (bestMatch == null || bestMatch.getMetrics() > 2) {
                        fixes.add(new AddToInspectionOptionListFix((InspectionProfileEntry)MisspelledHeaderInspection.this, ManifestBundle.message("inspection.header.remember.fix", headerName), headerName, inspection -> inspection.CUSTOM_HEADERS));
                    }
                    holder.registerProblem((PsiElement)header.getNameElement(), ManifestBundle.message("inspection.header.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            }

            private static void addMatches(String headerName, Collection<String> headers, SortedSet<? super Suggestion> matches) {
                for (String candidate : headers) {
                    int distance = EditDistance.optimalAlignment((CharSequence)headerName, (CharSequence)candidate, (boolean)false, (int)4);
                    if (distance > 4) continue;
                    matches.add((Suggestion)new Suggestion(candidate, distance));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$1", "visitElement"));
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"CUSTOM_HEADERS", (String)ManifestBundle.message("inspection.header.ui.label", new Object[0]))});
        if (optPane == null) {
            MisspelledHeaderInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class HeaderRenameQuickFix
    extends PsiUpdateModCommandAction<Header> {
        private final String myNewName;

        private HeaderRenameQuickFix(Header header, String newName) {
            super((PsiElement)header);
            this.myNewName = newName;
        }

        @NotNull
        public String getFamilyName() {
            String string = ManifestBundle.message("inspection.header.rename.fix.family.name", new Object[0]);
            if (string == null) {
                HeaderRenameQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull Header element) {
            if (context == null) {
                HeaderRenameQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                HeaderRenameQuickFix.$$$reportNull$$$0(2);
            }
            Presentation presentation = Presentation.of((String)ManifestBundle.message("inspection.header.rename.fix", this.myNewName));
            if (presentation == null) {
                HeaderRenameQuickFix.$$$reportNull$$$0(3);
            }
            return presentation;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull Header header, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                HeaderRenameQuickFix.$$$reportNull$$$0(4);
            }
            if (header == null) {
                HeaderRenameQuickFix.$$$reportNull$$$0(5);
            }
            if (updater == null) {
                HeaderRenameQuickFix.$$$reportNull$$$0(6);
            }
            header.setName(this.myNewName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderRenameQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "header";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/lang/manifest/highlighting/MisspelledHeaderInspection$HeaderRenameQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

