/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.compiler.options.JavaCompilersTab;
import com.intellij.compiler.server.BuildManager;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfigurable;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfiguration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/groovy/compiler/GroovyCompilerConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "config", "Lorg/jetbrains/plugins/groovy/compiler/GroovyCompilerConfiguration;", "kotlin.jvm.PlatformType", "excludes", "Lcom/intellij/openapi/compiler/options/ExcludedEntriesConfigurable;", "getExcludes", "()Lcom/intellij/openapi/compiler/options/ExcludedEntriesConfigurable;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "disposeUIResources", "", "apply", "normalizePath", "", "path", "createExcludedConfigurable", "intellij.groovy"})
@SourceDebugExtension(value={"SMAP\nGroovyCompilerConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroovyCompilerConfigurable.kt\norg/jetbrains/plugins/groovy/compiler/GroovyCompilerConfigurable\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,107:1\n10574#2:108\n11007#2,5:109\n*S KotlinDebug\n*F\n+ 1 GroovyCompilerConfigurable.kt\norg/jetbrains/plugins/groovy/compiler/GroovyCompilerConfigurable\n*L\n101#1:108\n101#1:109,5\n*E\n"})
public final class GroovyCompilerConfigurable
extends BoundSearchableConfigurable
implements Configurable.NoScroll {
    @NotNull
    private final Project project;
    private final GroovyCompilerConfiguration config;
    @NotNull
    private final ExcludedEntriesConfigurable excludes;

    public GroovyCompilerConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = GroovyBundle.message("configurable.GroovyCompilerConfigurable.display.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, "reference.projectsettings.compiler.groovy", "Groovy compiler");
        this.project = project;
        this.config = GroovyCompilerConfiguration.getInstance(this.project);
        this.excludes = this.createExcludedConfigurable(this.project);
    }

    @NotNull
    public final ExcludedEntriesConfigurable getExcludes() {
        return this.excludes;
    }

    @NotNull
    public DialogPanel createPanel() {
        return BuilderKt.panel(arg_0 -> GroovyCompilerConfigurable.createPanel$lambda$0(this, arg_0));
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        this.excludes.disposeUIResources();
    }

    public void apply() {
        super.apply();
        if (!this.project.isDefault()) {
            BuildManager.getInstance().clearState(this.project);
        }
    }

    private final String normalizePath(String path) {
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final ExcludedEntriesConfigurable createExcludedConfigurable(Project project) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        ExcludesConfiguration configuration = this.config.getExcludeFromStubGeneration();
        ProjectFileIndex index = project.isDefault() ? null : ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module[] moduleArray = ModuleManager.Companion.getInstance(project).getModules();
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, true, false, false, false, true).withFileFilter(arg_0 -> GroovyCompilerConfigurable.createExcludedConfigurable$lambda$1(arg_0 -> GroovyCompilerConfigurable.createExcludedConfigurable$lambda$0(index, arg_0), arg_0));
        boolean $i$f$flatMap = false;
        void var7_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void module = element$iv$iv = $this$flatMapTo$iv$iv[j];
            boolean bl = false;
            List list = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        FileChooserDescriptor descriptor = fileChooserDescriptor.withRoots((List)destination$iv$iv);
        return new ExcludedEntriesConfigurable(project, descriptor, configuration);
    }

    private static final void createPanel$lambda$0$0$0(GroovyCompilerConfigurable this$0, HyperlinkEvent it) {
        JavaCompilersTab javacConfigurable;
        Settings allSettings;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this$0.createComponent());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Settings settings = allSettings = (Settings)Settings.KEY.getData(dataContext);
        JavaCompilersTab javaCompilersTab = javacConfigurable = settings != null ? (JavaCompilersTab)settings.find(JavaCompilersTab.class) : null;
        if (allSettings != null && javacConfigurable != null) {
            allSettings.select((Configurable)javacConfigurable);
        }
    }

    private static final Unit createPanel$lambda$0$1$0(TextFieldWithBrowseButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false).withDescription(GroovyBundle.message("settings.compiler.select.path.to.groovy.compiler.configscript", new Object[0]));
        $this$applyToComponent.addBrowseFolderListener(null, descriptor);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1$1(TextFieldWithBrowseButton $textField, GroovyCompilerConfigurable this$0) {
        String string = this$0.config.getConfigScript();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getConfigScript(...)");
        $textField.setText(this$0.normalizePath(string));
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$0$1$2(GroovyCompilerConfigurable this$0, TextFieldWithBrowseButton $textField) {
        String string = this$0.config.getConfigScript();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getConfigScript(...)");
        String string2 = this$0.normalizePath(string);
        String string3 = $textField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        return !Intrinsics.areEqual((Object)string2, (Object)this$0.normalizePath(string3));
    }

    private static final Unit createPanel$lambda$0$1$3(GroovyCompilerConfigurable this$0, TextFieldWithBrowseButton $textField) {
        GroovyCompilerConfiguration groovyCompilerConfiguration = this$0.config;
        String string = $textField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        groovyCompilerConfiguration.setConfigScript(this$0.normalizePath(string));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3$0(GroovyCompilerConfigurable this$0) {
        this$0.excludes.reset();
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$0$3$1(GroovyCompilerConfigurable this$0) {
        return this$0.excludes.isModified();
    }

    private static final Unit createPanel$lambda$0$3$2(GroovyCompilerConfigurable this$0) {
        this$0.excludes.apply();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(GroovyCompilerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GroovyBundle.message("settings.compiler.alternative", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.text$default((Row)$this$row, (String)string, (int)0, arg_0 -> GroovyCompilerConfigurable.createPanel$lambda$0$0$0(this$0, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(GroovyCompilerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldWithBrowseButton textField = new TextFieldWithBrowseButton();
        $this$row.cell((JComponent)textField).align((Align)AlignX.FILL.INSTANCE).applyToComponent(GroovyCompilerConfigurable::createPanel$lambda$0$1$0).onReset(() -> GroovyCompilerConfigurable.createPanel$lambda$0$1$1(textField, this$0)).onIsModified(() -> GroovyCompilerConfigurable.createPanel$lambda$0$1$2(this$0, textField)).onApply(() -> GroovyCompilerConfigurable.createPanel$lambda$0$1$3(this$0, textField));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(GroovyCompilerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GroovyBundle.message("settings.compiler.invoke.dynamic.support", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = $this$row.checkBox(string);
        GroovyCompilerConfiguration groovyCompilerConfiguration = this$0.config;
        Intrinsics.checkNotNullExpressionValue((Object)groovyCompilerConfiguration, (String)"config");
        Function0 function0 = (Function0)new Function0<Boolean>((Object)groovyCompilerConfiguration){

            public final Boolean invoke() {
                return ((GroovyCompilerConfiguration)this.receiver).isInvokeDynamic();
            }
        };
        GroovyCompilerConfiguration groovyCompilerConfiguration2 = this$0.config;
        Intrinsics.checkNotNullExpressionValue((Object)groovyCompilerConfiguration2, (String)"config");
        ButtonKt.bindSelected((Cell)cell, (Function0)function0, (Function1)((Function1)new Function1<Boolean, Unit>((Object)groovyCompilerConfiguration2){

            public final void invoke(boolean p0) {
                ((GroovyCompilerConfiguration)this.receiver).setInvokeDynamic(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(GroovyCompilerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JComponent jComponent = this$0.excludes.createComponent();
        Intrinsics.checkNotNull((Object)jComponent);
        Cell cell = $this$row.cell(jComponent);
        String string = GroovyBundle.message("settings.compiler.exclude.from.stub.generation", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        cell.label(string, LabelPosition.TOP).align(Align.FILL).onReset(() -> GroovyCompilerConfigurable.createPanel$lambda$0$3$0(this$0)).onIsModified(() -> GroovyCompilerConfigurable.createPanel$lambda$0$3$1(this$0)).onApply(() -> GroovyCompilerConfigurable.createPanel$lambda$0$3$2(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0(GroovyCompilerConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GroovyCompilerConfigurable.createPanel$lambda$0$0(this$0, arg_0), (int)1, null);
        String string = GroovyBundle.message("settings.compiler.path.to.configscript", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> GroovyCompilerConfigurable.createPanel$lambda$0$1(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GroovyCompilerConfigurable.createPanel$lambda$0$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GroovyCompilerConfigurable.createPanel$lambda$0$3(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final boolean createExcludedConfigurable$lambda$0(ProjectFileIndex $index, VirtualFile file) {
        return $index == null || !$index.isExcluded(file);
    }

    private static final boolean createExcludedConfigurable$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

