/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.codehaus.groovy.syntax.Numbers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0003H\u0002\u001a\f\u0010\r\u001a\u00020\t*\u0004\u0018\u00010\u000e\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"parseInteger", "", "literalText", "", "getLiteralType", "Lcom/intellij/psi/PsiType;", "literal", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/literals/GrLiteral;", "hasIntegerSuffix", "", "zeros", "", "", "isZero", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "intellij.groovy.psi"})
public final class LiteralUtilKt {
    @NotNull
    private static final Set<Object> zeros;

    @Nullable
    public static final Number parseInteger(@NotNull String literalText) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)literalText, (String)"literalText");
        try {
            number = Numbers.parseInteger((String)literalText);
        }
        catch (NumberFormatException e) {
            number = null;
        }
        return number;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final PsiType getLiteralType(@NotNull GrLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        elemType = GrLiteralImpl.getLiteralType(literal);
        if (elemType == GroovyElementTypes.KW_NULL) {
            return PsiTypes.nullType();
        }
        if (!Intrinsics.areEqual((Object)elemType, (Object)GroovyElementTypes.NUM_INT)) ** GOTO lbl-1000
        text = literal.getText();
        $i$a$-let-LiteralUtilKt$getLiteralType$integerLiteralWithoutSuffix$1 = false;
        Intrinsics.checkNotNull((Object)text);
        v0 = !LiteralUtilKt.hasIntegerSuffix(text);
        if (v0) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = integerLiteralWithoutSuffix = false;
        }
        if (!integerLiteralWithoutSuffix) ** GOTO lbl26
        var4_2 = literal.getValue();
        if (var4_2 instanceof Integer) {
            v2 = "java.lang.Integer";
        } else if (var4_2 instanceof Long) {
            v2 = "java.lang.Long";
        } else if (var4_2 instanceof BigInteger) {
            v2 = "java.math.BigInteger";
        } else {
            return null;
lbl26:
            // 1 sources

            v2 = TypesUtil.getBoxedTypeName(elemType);
            if (v2 == null) {
                return null;
            }
        }
        fqn = v2;
        return (PsiType)TypesUtil.createTypeByFQClassName(fqn, literal);
    }

    private static final boolean hasIntegerSuffix(String $this$hasIntegerSuffix) {
        return StringsKt.endsWith$default((CharSequence)$this$hasIntegerSuffix, (char)'i', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)$this$hasIntegerSuffix, (char)'I', (boolean)false, (int)2, null);
    }

    public static final boolean isZero(@Nullable GrExpression $this$isZero) {
        if (!($this$isZero instanceof GrLiteral)) {
            return false;
        }
        Object value = ((GrLiteral)$this$isZero).getValue();
        return CollectionsKt.contains((Iterable)zeros, (Object)value) || value instanceof BigDecimal && ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0;
    }

    static {
        Object[] objectArray = new Object[5];
        objectArray[0] = 0;
        objectArray[1] = 0L;
        objectArray[2] = Float.valueOf(0.0f);
        objectArray[3] = 0.0;
        Intrinsics.checkNotNullExpressionValue((Object)BigInteger.valueOf(0L), (String)"valueOf(...)");
        zeros = SetsKt.setOf((Object[])objectArray);
    }
}

