/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.utils;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.utils.EscapeUtilsKt;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0007\u001a\f\u0010\u0002\u001a\u00020\u0001*\u00020\u0001H\u0007\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0001H\u0007\u001a\u0014\u0010\u0002\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u0015"}, d2={"replaceBackslashEscapes", "Lcom/intellij/grazie/text/TextContent;", "replaceBackslashEscapedWhitespace", "replaceEscapedVerticalTab", "separator", "", "getBackslashExcludeRanges", "", "Lcom/intellij/openapi/util/TextRange;", "content", "symbol", "invertExcludedToContentRanges", "excluded", "length", "", "isSeparator", "", "text", "", "index", "mapSeparator", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nEscapeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EscapeUtils.kt\ncom/intellij/grazie/utils/EscapeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1642#2,10:121\n1915#2:131\n1916#2:133\n1652#2:134\n1068#2:135\n1#3:132\n*S KotlinDebug\n*F\n+ 1 EscapeUtils.kt\ncom/intellij/grazie/utils/EscapeUtilsKt\n*L\n58#1:121,10\n58#1:131\n58#1:133\n58#1:134\n104#1:135\n58#1:132\n*E\n"})
public final class EscapeUtilsKt {
    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public static final TextContent replaceBackslashEscapes(@NotNull TextContent $this$replaceBackslashEscapes) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceBackslashEscapes, (String)"<this>");
        TextContent text = EscapeUtilsKt.replaceBackslashEscapedWhitespace($this$replaceBackslashEscapes);
        int[] offsets = new int[text.length() + 1];
        CodeInsightUtilCore.parseStringCharacters((String)((Object)text).toString(), (int[])offsets);
        List exclusions2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)1, (int)offsets.length))), arg_0 -> EscapeUtilsKt.replaceBackslashEscapes$lambda$0(offsets, arg_0)), arg_0 -> EscapeUtilsKt.replaceBackslashEscapes$lambda$1(offsets, arg_0)), (Function1)replaceBackslashEscapes.exclusions.3.INSTANCE));
        TextContent textContent = text.excludeRanges(exclusions2);
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"excludeRanges(...)");
        return textContent;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public static final TextContent replaceBackslashEscapedWhitespace(@NotNull TextContent $this$replaceBackslashEscapedWhitespace) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceBackslashEscapedWhitespace, (String)"<this>");
        return EscapeUtilsKt.replaceBackslashEscapedWhitespace(EscapeUtilsKt.replaceBackslashEscapedWhitespace($this$replaceBackslashEscapedWhitespace, 'n'), 't');
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public static final TextContent replaceEscapedVerticalTab(@NotNull TextContent $this$replaceEscapedVerticalTab) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceEscapedVerticalTab, (String)"<this>");
        return EscapeUtilsKt.replaceBackslashEscapedWhitespace($this$replaceEscapedVerticalTab, 'v');
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public static final TextContent replaceBackslashEscapedWhitespace(@NotNull TextContent $this$replaceBackslashEscapedWhitespace, char separator2) {
        TextContent textContent;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)$this$replaceBackslashEscapedWhitespace, (String)"<this>");
        List<TextRange> excluded = EscapeUtilsKt.getBackslashExcludeRanges($this$replaceBackslashEscapedWhitespace, separator2);
        if (excluded.isEmpty()) {
            return $this$replaceBackslashEscapedWhitespace;
        }
        Iterable iterable = EscapeUtilsKt.invertExcludedToContentRanges(excluded, $this$replaceBackslashEscapedWhitespace.length());
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TextContent it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TextRange it = (TextRange)element$iv$iv;
            boolean bl2 = false;
            if ($this$replaceBackslashEscapedWhitespace.subText(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List components = (List)destination$iv$iv;
        switch (components.size()) {
            case 0: {
                textContent = $this$replaceBackslashEscapedWhitespace;
                break;
            }
            case 1: {
                textContent = (TextContent)CollectionsKt.first((List)components);
                break;
            }
            default: {
                TextContent textContent2 = TextContent.joinWithWhitespace(EscapeUtilsKt.mapSeparator(separator2), components);
                textContent = textContent2;
                Intrinsics.checkNotNull((Object)textContent2);
            }
        }
        return textContent;
    }

    private static final List<TextRange> getBackslashExcludeRanges(TextContent content, char symbol) {
        if (content.length() < 2) {
            return CollectionsKt.emptyList();
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        int i = 0;
        while (i < content.length() - 1) {
            if (EscapeUtilsKt.isSeparator(content, i, symbol)) {
                ranges.add(new TextRange(i, i + 2));
                i += 2;
                continue;
            }
            ++i;
        }
        return ranges;
    }

    private static final List<TextRange> invertExcludedToContentRanges(List<? extends TextRange> excluded, int length) {
        if (excluded.isEmpty()) {
            return CollectionsKt.listOf((Object)new TextRange(0, length));
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>(excluded.size() + 1);
        if (((TextRange)CollectionsKt.first(excluded)).getStartOffset() > 0) {
            result.add(new TextRange(0, ((TextRange)CollectionsKt.first(excluded)).getStartOffset()));
        }
        int n = excluded.size() - 1;
        for (int idx = 0; idx < n; ++idx) {
            TextRange current = excluded.get(idx);
            TextRange next = excluded.get(idx + 1);
            if (next.getStartOffset() <= current.getEndOffset()) continue;
            result.add(new TextRange(current.getEndOffset(), next.getStartOffset()));
        }
        if (length > ((TextRange)CollectionsKt.last(excluded)).getEndOffset()) {
            result.add(new TextRange(((TextRange)CollectionsKt.last(excluded)).getEndOffset(), length));
        }
        Iterable $this$sortedBy$iv = result;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TextRange it = (TextRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStartOffset());
                it = (TextRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStartOffset()));
            }
        });
    }

    private static final boolean isSeparator(CharSequence text, int index, char symbol) {
        return text.charAt(index) == '\\' && text.charAt(index + 1) == symbol;
    }

    private static final char mapSeparator(char symbol) {
        return switch (symbol) {
            case 'n' -> '\n';
            case 't' -> '\t';
            case 'b' -> ' ';
            case 'r' -> '\r';
            case 'f' -> '\f';
            case 'v' -> {
                int var1_1 = 11;
                yield (char)var1_1;
            }
            default -> ' ';
        };
    }

    private static final boolean replaceBackslashEscapes$lambda$0(int[] $offsets, int i) {
        return $offsets[i] != 0 && $offsets[i] - $offsets[i - 1] != 1;
    }

    private static final TextRange replaceBackslashEscapes$lambda$1(int[] $offsets, int index) {
        return new TextRange($offsets[index - 1], $offsets[index]);
    }
}

