/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhasePrerequisites;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmCachedDeclarationsKt;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrCoroutineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.AddContinuationLowering;
import org.jetbrains.kotlin.backend.jvm.lower.AddContinuationLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmLocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.jvm.lower.SuspendLambdaLowering;
import org.jetbrains.kotlin.backend.jvm.lower.SuspendLoweringUtils;
import org.jetbrains.kotlin.backend.jvm.lower.TailCallOptimizationLowering;
import org.jetbrains.kotlin.backend.jvm.mapping.MethodSignatureMapper;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrMutableAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Type;

@PhasePrerequisites(value={SuspendLambdaLowering.class, JvmLocalDeclarationsLowering.class, TailCallOptimizationLowering.class})
@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u0017*\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J6\u0010\u001a\u001a\u00020\b*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00ca\u0001\u001c\b$\u0012\u0018\b%\u0012\u0014\b\fJ\u0004\b\t0&J\u0004\b\t0'J\u0004\b\t0(\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering;", "Lorg/jetbrains/kotlin/backend/jvm/lower/SuspendLoweringUtils;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "addContinuationParameterToSuspendCalls", "generateContinuationClassForNamedFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "dispatchReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "attributeContainer", "Lorg/jetbrains/kotlin/ir/IrElement;", "capturesCrossinline", "", "addConstructorForNamedFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "capturedThisField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "addInvokeSuspendForNamedFunction", "resultField", "labelField", "isStaticSuspendImpl", "toSuspendImplementationName", "Lorg/jetbrains/kotlin/name/Name;", "createStaticSuspendImpl", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "addContinuationObjectAndContinuationParameterToSuspendFunctions", "backend.jvm.lower", "Lorg/jetbrains/kotlin/backend/common/phaser/PhasePrerequisites;", "value", "Lorg/jetbrains/kotlin/backend/jvm/lower/SuspendLambdaLowering;", "Lorg/jetbrains/kotlin/backend/jvm/lower/JvmLocalDeclarationsLowering;", "Lorg/jetbrains/kotlin/backend/jvm/lower/TailCallOptimizationLowering;"})
@SourceDebugExtension(value={"SMAP\nAddContinuationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddContinuationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 7 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,531:1\n51#2,4:532\n81#2:536\n75#2,10:537\n81#2:547\n75#2,10:548\n321#2:558\n315#2,13:559\n1#3:572\n351#4,12:573\n351#4,12:597\n351#4,12:630\n448#5,10:585\n448#5,10:609\n76#6,2:595\n76#6:619\n77#6:629\n418#7,5:620\n423#7:628\n1661#8,3:625\n*S KotlinDebug\n*F\n+ 1 AddContinuationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering\n*L\n100#1:532,4\n110#1:536\n110#1:537,10\n117#1:547\n117#1:548,10\n138#1:558\n138#1:559,13\n146#1:573,12\n168#1:597,12\n183#1:630,12\n149#1:585,10\n274#1:609,10\n149#1:595,2\n274#1:619\n274#1:629\n279#1:620,5\n279#1:628\n279#1:625,3\n*E\n"})
public final class AddContinuationLowering
extends SuspendLoweringUtils
implements FileLoweringPass {
    public AddContinuationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.addContinuationObjectAndContinuationParameterToSuspendFunctions(irFile);
        this.addContinuationParameterToSuspendCalls(irFile);
    }

    private final void addContinuationParameterToSuspendCalls(IrFile irFile) {
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)new IrElementTransformerVoid(this){
            private final List<IrFunction> functionStack;
            final /* synthetic */ AddContinuationLowering this$0;
            {
                this.this$0 = $receiver;
                this.functionStack = new ArrayList<E>();
            }

            public final List<IrFunction> getFunctionStack() {
                return this.functionStack;
            }

            public IrStatement visitFunction(IrFunction declaration) {
                IrStatement irStatement;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                UtilsKt.push(this.functionStack, (Object)declaration);
                IrStatement it = irStatement = super.visitFunction(declaration);
                boolean bl = false;
                UtilsKt.pop(this.functionStack);
                return irStatement;
            }

            public IrExpression visitFunctionReference(IrFunctionReference expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression irExpression = super.visitFunctionReference(expression2);
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
                IrFunctionReference transformed = (IrFunctionReference)irExpression;
                return (IrExpression)AddContinuationLoweringKt.access$retargetToSuspendView((IrMemberAccessExpression)transformed, this.this$0.getContext(), null, addContinuationParameterToSuspendCalls.1::visitFunctionReference$lambda$1);
            }

            public IrExpression visitRawFunctionReference(IrRawFunctionReference expression2) {
                IrRawFunctionReference transformed;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression irExpression = super.visitRawFunctionReference(expression2);
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference");
                IrRawFunctionReference irRawFunctionReference = transformed = (IrRawFunctionReference)irExpression;
                AddContinuationLowering addContinuationLowering = this.this$0;
                IrRawFunctionReference $this$visitRawFunctionReference_u24lambda_u242 = irRawFunctionReference;
                boolean bl = false;
                AddContinuationLoweringKt.access$retargetToSuspendView($this$visitRawFunctionReference_u24lambda_u242, addContinuationLowering.getContext());
                return (IrExpression)irRawFunctionReference;
            }

            public IrExpression visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression irExpression = super.visitCall(expression2);
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                IrCall transformed = (IrCall)irExpression;
                IrFunction irFunction = (IrFunction)UtilsKt.peek(this.functionStack);
                if (irFunction == null) {
                    return (IrExpression)transformed;
                }
                return (IrExpression)AddContinuationLoweringKt.access$retargetToSuspendView((IrMemberAccessExpression)transformed, this.this$0.getContext(), irFunction, addContinuationParameterToSuspendCalls.1::visitCall$lambda$3);
            }

            private static final IrFunctionReference visitFunctionReference$lambda$1(IrFunctionReference $this$retargetToSuspendView, IrSimpleFunctionSymbol it) {
                Intrinsics.checkNotNullParameter((Object)$this$retargetToSuspendView, (String)"$this$retargetToSuspendView");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (IrFunctionReference)BuildersKt.fromSymbolOwner((IrFunctionReferenceImpl.Companion)IrFunctionReferenceImpl.Companion, (int)$this$retargetToSuspendView.getStartOffset(), (int)$this$retargetToSuspendView.getEndOffset(), (IrType)$this$retargetToSuspendView.getType(), (IrFunctionSymbol)((IrFunctionSymbol)it), (int)$this$retargetToSuspendView.getTypeArguments().size(), (IrFunctionSymbol)$this$retargetToSuspendView.getReflectionTarget(), (IrStatementOrigin)$this$retargetToSuspendView.getOrigin());
            }

            private static final IrCall visitCall$lambda$3(IrCall $this$retargetToSuspendView, IrSimpleFunctionSymbol it) {
                Intrinsics.checkNotNullParameter((Object)$this$retargetToSuspendView, (String)"$this$retargetToSuspendView");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (IrCall)BuildersKt.fromSymbolOwner((IrCallImpl.Companion)IrCallImpl.Companion, (int)$this$retargetToSuspendView.getStartOffset(), (int)$this$retargetToSuspendView.getEndOffset(), (IrType)$this$retargetToSuspendView.getType(), (IrSimpleFunctionSymbol)it, (IrStatementOrigin)$this$retargetToSuspendView.getOrigin(), (IrClassSymbol)$this$retargetToSuspendView.getSuperQualifierSymbol());
            }
        });
    }

    private final IrClass generateContinuationClassForNamedFunction(IrFunction irFunction, IrValueParameter dispatchReceiverParameter, IrElement attributeContainer, boolean capturesCrossinline) {
        IrField irField;
        IrClass irClass;
        DescriptorVisibility descriptorVisibility;
        IrFactory $this$buildClass$iv = this.getContext().getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u240 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        Name name = Name.special((String)"<Continuation>");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(...)");
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setName(name);
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getCONTINUATION_CLASS());
        if (capturesCrossinline) {
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
        } else {
            DescriptorVisibility descriptorVisibility3 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility3, (String)"PACKAGE_VISIBILITY");
        }
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setVisibility(descriptorVisibility);
        IrClass $this$generateContinuationClassForNamedFunction_u24lambda_u241 = irClass = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)$this$buildClass_u24lambda_u241$iv);
        boolean bl3 = false;
        IrUtilsKt.createThisReceiverParameter((IrClass)$this$generateContinuationClassForNamedFunction_u24lambda_u241);
        $this$generateContinuationClassForNamedFunction_u24lambda_u241.setSuperTypes(CollectionsKt.plus((Collection)$this$generateContinuationClassForNamedFunction_u24lambda_u241.getSuperTypes(), (Object)IrUtilsKt.getDefaultType((IrClass)((IrClass)this.getContext().getSymbols().getContinuationImplClass().getOwner()))));
        $this$generateContinuationClassForNamedFunction_u24lambda_u241.setParent((IrDeclarationParent)irFunction);
        IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)((IrTypeParametersContainer)$this$generateContinuationClassForNamedFunction_u24lambda_u241), (IrTypeParametersContainer)((IrTypeParametersContainer)irFunction), null, null, (int)6, null);
        IrClass $this$addField$iv = $this$generateContinuationClassForNamedFunction_u24lambda_u241;
        boolean $i$f$addField = false;
        IrFactory $this$buildField$iv$iv = $this$addField$iv.getFactory();
        boolean $i$f$buildField = false;
        IrFieldBuilder $this$buildField_u24lambda_u241$iv$iv = new IrFieldBuilder();
        boolean bl4 = false;
        IrFieldBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u241_u240 = $this$buildField_u24lambda_u241$iv$iv;
        boolean bl5 = false;
        $this$generateContinuationClassForNamedFunction_u24lambda_u241_u240.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getCONTINUATION_CLASS_RESULT_FIELD());
        Name name2 = Name.identifier((String)"result");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        $this$generateContinuationClassForNamedFunction_u24lambda_u241_u240.setName(name2);
        $this$generateContinuationClassForNamedFunction_u24lambda_u241_u240.setType(this.getContext().getSymbols().getResultOfAnyType());
        DescriptorVisibility descriptorVisibility4 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility4, (String)"PACKAGE_VISIBILITY");
        $this$generateContinuationClassForNamedFunction_u24lambda_u241_u240.setVisibility(descriptorVisibility4);
        IrFactory field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, (IrFieldBuilder)$this$buildField_u24lambda_u241$iv$iv);
        boolean bl6 = false;
        field$iv.setParent((IrDeclarationParent)$this$addField$iv);
        $this$addField$iv.getDeclarations().add(field$iv);
        IrFactory resultField = $this$buildField$iv$iv;
        IrValueParameter irValueParameter = dispatchReceiverParameter;
        if (irValueParameter != null) {
            IrField irField2;
            IrValueParameter it = irValueParameter;
            boolean bl7 = false;
            IrClass $this$addField$iv2 = $this$generateContinuationClassForNamedFunction_u24lambda_u241;
            boolean $i$f$addField2 = false;
            IrFactory $this$buildField$iv$iv2 = $this$addField$iv2.getFactory();
            boolean $i$f$buildField2 = false;
            IrFieldBuilder $this$buildField_u24lambda_u241$iv$iv2 = new IrFieldBuilder();
            $i$a$-run-DeclarationBuildersKt$buildField$2$iv$iv = false;
            IrFieldBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u241_u241_u240 = $this$buildField_u24lambda_u241$iv$iv2;
            boolean bl8 = false;
            Name name3 = Name.identifier((String)"this$0");
            Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
            $this$generateContinuationClassForNamedFunction_u24lambda_u241_u241_u240.setName(name3);
            $this$generateContinuationClassForNamedFunction_u24lambda_u241_u241_u240.setType(it.getType());
            $this$generateContinuationClassForNamedFunction_u24lambda_u241_u241_u240.setOrigin(IrDeclarationOrigin.Companion.getFIELD_FOR_OUTER_THIS());
            DescriptorVisibility descriptorVisibility5 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility5, (String)"PACKAGE_VISIBILITY");
            $this$generateContinuationClassForNamedFunction_u24lambda_u241_u241_u240.setVisibility(descriptorVisibility5);
            $this$generateContinuationClassForNamedFunction_u24lambda_u241_u241_u240.setFinal(true);
            IrField field$iv2 = irField2 = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv2, (IrFieldBuilder)$this$buildField_u24lambda_u241$iv$iv2);
            $i$a$-also-DeclarationBuildersKt$addField$1$iv = false;
            field$iv2.setParent((IrDeclarationParent)$this$addField$iv2);
            $this$addField$iv2.getDeclarations().add(field$iv2);
            irField = irField2;
        } else {
            irField = null;
        }
        IrField capturedThisField = irField;
        IrType irType = this.getContext().getIrBuiltIns().getIntType();
        DescriptorVisibility descriptorVisibility6 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility6, (String)"PACKAGE_VISIBILITY");
        IrField labelField = DeclarationBuildersKt.addField((IrClass)$this$generateContinuationClassForNamedFunction_u24lambda_u241, (String)"label", (IrType)irType, (DescriptorVisibility)descriptorVisibility6);
        this.addConstructorForNamedFunction($this$generateContinuationClassForNamedFunction_u24lambda_u241, capturedThisField, capturesCrossinline);
        this.addInvokeSuspendForNamedFunction($this$generateContinuationClassForNamedFunction_u24lambda_u241, irFunction, (IrField)resultField, labelField, capturedThisField, Intrinsics.areEqual((Object)irFunction.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSUSPEND_IMPL_STATIC_FUNCTION()));
        IrDeclarationsKt.copyAttributes$default((IrElement)((IrElement)$this$generateContinuationClassForNamedFunction_u24lambda_u241), (IrElement)attributeContainer, (boolean)false, (int)2, null);
        return irClass;
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor addConstructorForNamedFunction(IrClass $this$addConstructorForNamedFunction, IrField capturedThisField, boolean capturesCrossinline) {
        void it;
        IrDelegatingConstructorCall irDelegatingConstructorCall;
        void $this$addConstructorForNamedFunction_u24lambda_u241_u242;
        void this_$iv$iv;
        IrConstructor it2;
        IrValueParameter irValueParameter;
        IrFactory irFactory;
        DescriptorVisibility descriptorVisibility;
        IrClass $this$addConstructor$iv = $this$addConstructorForNamedFunction;
        boolean $i$f$addConstructor = false;
        IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u241$iv$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u240$iv = $this$buildConstructor_u24lambda_u241$iv$iv;
        boolean bl2 = false;
        IrFunctionBuilder $this$addConstructorForNamedFunction_u24lambda_u240 = $this$addConstructor_u24lambda_u240$iv;
        boolean bl3 = false;
        $this$addConstructorForNamedFunction_u24lambda_u240.setPrimary(true);
        $this$addConstructorForNamedFunction_u24lambda_u240.setReturnType((IrType)IrUtilsKt.getDefaultType((IrClass)$this$addConstructorForNamedFunction));
        if (capturesCrossinline) {
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
        } else {
            DescriptorVisibility descriptorVisibility3 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility3, (String)"PACKAGE_VISIBILITY");
        }
        $this$addConstructorForNamedFunction_u24lambda_u240.setVisibility(descriptorVisibility);
        $this$addConstructor_u24lambda_u240$iv.setReturnType((IrType)IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        IrFactory constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u241$iv$iv);
        boolean bl4 = false;
        $this$addConstructor$iv.getDeclarations().add(constructor$iv);
        constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
        IrFactory constructor = irFactory = $this$buildConstructor$iv$iv;
        boolean bl5 = false;
        IrField irField = capturedThisField;
        if (irField != null) {
            IrField it3 = irField;
            boolean bl6 = false;
            IrFunction irFunction = (IrFunction)constructor;
            String string = it3.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            irValueParameter = DeclarationBuildersKt.addValueParameter$default((IrFunction)irFunction, (String)string, (IrType)it3.getType(), null, (int)4, null);
        } else {
            irValueParameter = null;
        }
        IrValueParameter capturedThisParameter = irValueParameter;
        IrValueParameter completionParameterSymbol = this.addCompletionValueParameter((IrFunction)constructor);
        Sequence $this$single$iv = IrUtilsKt.getConstructors((IrClass)((IrClass)this.getContext().getSymbols().getContinuationImplClass().getOwner()));
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it2 = (IrConstructor)element$iv;
            boolean bl7 = false;
            if (!IrUtilsKt.hasShape$default((IrFunction)((IrFunction)it2), (boolean)false, (boolean)false, (int)0, (int)1, null, (int)23, null)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrConstructor superClassConstructor = single$iv;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((LoweringContext)((LoweringContext)this.getContext()), (IrSymbol)((IrSymbol)constructor.getSymbol()), (int)0, (int)0, (int)6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        Iterator iterator2 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        it2 = this_$iv$iv;
        IrFactory irFactory2 = constructor;
        boolean bl8 = false;
        if (capturedThisField != null) {
            IrBuilder irBuilder = (IrBuilder)$this$addConstructorForNamedFunction_u24lambda_u241_u242;
            IrBuilder irBuilder2 = (IrBuilder)$this$addConstructorForNamedFunction_u24lambda_u241_u242;
            IrValueParameter irValueParameter2 = $this$addConstructorForNamedFunction.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter2);
            IrExpression irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilder)irBuilder2, (IrValueDeclaration)((IrValueDeclaration)irValueParameter2));
            IrBuilder irBuilder3 = (IrBuilder)$this$addConstructorForNamedFunction_u24lambda_u241_u242;
            IrValueParameter irValueParameter3 = capturedThisParameter;
            Intrinsics.checkNotNull((Object)irValueParameter3);
            $this$addConstructorForNamedFunction_u24lambda_u241_u242.unaryPlus((IrStatement)ExpressionHelpersKt.irSetField$default((IrBuilder)irBuilder, (IrExpression)irExpression, (IrField)capturedThisField, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)irBuilder3, (IrValueDeclaration)((IrValueDeclaration)irValueParameter3))), null, (int)8, null));
        }
        IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilder)((IrBuilder)$this$addConstructorForNamedFunction_u24lambda_u241_u242), (IrConstructor)superClassConstructor);
        void var21_29 = $this$addConstructorForNamedFunction_u24lambda_u241_u242;
        boolean bl9 = false;
        it.getArguments().set(0, (Object)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$addConstructorForNamedFunction_u24lambda_u241_u242), (IrValueDeclaration)((IrValueDeclaration)completionParameterSymbol)));
        var21_29.unaryPlus((IrStatement)irDelegatingConstructorCall);
        irFactory2.setBody((IrBody)this_$iv$iv.doBuild());
        return irFactory;
    }

    /*
     * WARNING - void declaration
     */
    private final void addInvokeSuspendForNamedFunction(IrClass $this$addInvokeSuspendForNamedFunction, IrFunction irFunction, IrField resultField, IrField labelField, IrField capturedThisField, boolean isStaticSuspendImpl) {
        void $this$single$iv;
        JvmBackendContext backendContext = this.getContext();
        Sequence sequence = IrUtilsKt.getFunctions((IrClass)((IrClass)this.getContext().getSymbols().getContinuationImplClass().getOwner()));
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)Name.identifier((String)"invokeSuspend"))) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction invokeSuspend = single$iv;
        this.addFunctionOverride($this$addInvokeSuspendForNamedFunction, invokeSuspend, irFunction.getStartOffset(), irFunction.getEndOffset(), (Function2<? super IrBlockBodyBuilder, ? super IrFunction, Unit>)((Function2)(arg_0, arg_1) -> AddContinuationLowering.addInvokeSuspendForNamedFunction$lambda$1(resultField, labelField, irFunction, $this$addInvokeSuspendForNamedFunction, capturedThisField, isStaticSuspendImpl, backendContext, arg_0, arg_1)));
    }

    private final Name toSuspendImplementationName(Name $this$toSuspendImplementationName) {
        Name name = Name.guessByFirstCharacter((String)($this$toSuspendImplementationName.asString() + "$suspendImpl"));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"guessByFirstCharacter(...)");
        return name;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createStaticSuspendImpl(IrSimpleFunction irFunction) {
        void $this$mapTo$iv$iv;
        void $this$assignFrom$iv;
        void it;
        void $this$createStaticSuspendImpl_u24lambda_u241;
        IrFunctionAccessExpression irFunctionAccessExpression;
        void this_$iv$iv;
        IrFactory irFactory = this.getContext().getIrFactory();
        IrDeclarationParent irDeclarationParent = irFunction.getParent();
        Name name = this.toSuspendImplementationName(irFunction.getName());
        IrFunction irFunction2 = (IrFunction)irFunction;
        IrDeclarationOrigin irDeclarationOrigin = JvmLoweredDeclarationOrigin.INSTANCE.getSUSPEND_IMPL_STATIC_FUNCTION();
        DescriptorVisibility descriptorVisibility = JvmIrUtilsKt.isJvmInterface(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)irFunction))) ? DescriptorVisibilities.PUBLIC : JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNull((Object)descriptorVisibility);
        IrSimpleFunction irSimpleFunction = IrUtilsKt.createStaticFunctionWithReceivers$default((IrFactory)irFactory, (IrDeclarationParent)irDeclarationParent, (Name)name, (IrFunction)irFunction2, null, (IrDeclarationOrigin)irDeclarationOrigin, (Modality)Modality.OPEN, (DescriptorVisibility)descriptorVisibility, (boolean)false, (boolean)false, (List)IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)((IrDeclarationParent)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)irFunction)))), (Function3)((Function3)new Function3<IrFunction, IrFunction, Map<IrValueParameter, ? extends IrValueParameter>, Unit>((Object)this.getContext()){

            public final void invoke(IrFunction p0, IrFunction p1, Map<IrValueParameter, ? extends IrValueParameter> p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((JvmBackendContext)this.receiver).remapMultiFieldValueClassStructure(p0, p1, p2);
            }
        }), (int)8, null);
        irSimpleFunction.setBody(IrInlineUtilsKt.moveBodyTo((IrFunction)((IrFunction)irFunction), (IrFunction)((IrFunction)irSimpleFunction)));
        if (IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)irFunction)).isInner()) {
            IrValueParameter movedDispatchParameter = (IrValueParameter)irSimpleFunction.getParameters().get(0);
            boolean bl = Intrinsics.areEqual((Object)movedDispatchParameter.getOrigin(), (Object)IrDeclarationOrigin.Companion.getMOVED_DISPATCH_RECEIVER());
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22 = false;
                String $i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22 = "MOVED_DISPATCH_RECEIVER should be the first parameter in " + RenderIrElementKt.render$default((IrElement)((IrElement)irSimpleFunction), null, (int)1, null);
                throw new AssertionError((Object)$i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22);
            }
            IrBody irBody = irSimpleFunction.getBody();
            Intrinsics.checkNotNull((Object)irBody);
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irBody), (IrElementTransformerVoid)new IrElementTransformerVoid(irFunction, movedDispatchParameter, this){
                final /* synthetic */ IrSimpleFunction $irFunction;
                final /* synthetic */ IrValueParameter $movedDispatchParameter;
                final /* synthetic */ AddContinuationLowering this$0;
                {
                    this.$irFunction = $irFunction;
                    this.$movedDispatchParameter = $movedDispatchParameter;
                    this.this$0 = $receiver;
                }

                public IrExpression visitGetValue(IrGetValue expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrValueDeclaration owner = expression2.getSymbol().getOwner();
                    if (owner instanceof IrValueParameter && this.isInstanceReceiverOfOuterClass((IrValueParameter)owner)) {
                        IrClass cursor = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)this.$irFunction));
                        IrExpression value = (IrExpression)BuildersKt.IrGetValueImpl$default((int)expression2.getStartOffset(), (int)expression2.getEndOffset(), (IrValueSymbol)((IrValueSymbol)this.$movedDispatchParameter.getSymbol()), null, (int)8, null);
                        while (!Intrinsics.areEqual((Object)cursor, (Object)((IrValueParameter)owner).getParent())) {
                            IrField outerThisField = this.this$0.getContext().getInnerClassesSupport().getOuterThisField(cursor);
                            value = (IrExpression)BuildersKt.IrGetFieldImpl$default((int)expression2.getStartOffset(), (int)expression2.getEndOffset(), (IrFieldSymbol)outerThisField.getSymbol(), (IrType)outerThisField.getType(), (IrExpression)value, null, null, (int)96, null);
                            cursor = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)cursor));
                        }
                        return value;
                    }
                    return super.visitGetValue(expression2);
                }

                private final boolean isInstanceReceiverOfOuterClass(IrValueParameter param) {
                    if (!Intrinsics.areEqual((Object)param.getOrigin(), (Object)IrDeclarationOrigin.Companion.getINSTANCE_RECEIVER())) {
                        return false;
                    }
                    if (!(param.getParent() instanceof IrClass)) {
                        return false;
                    }
                    IrDeclarationParent cursor = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)this.$irFunction)).getParent();
                    while (cursor instanceof IrClass) {
                        if (Intrinsics.areEqual((Object)cursor, (Object)param.getParent())) {
                            return true;
                        }
                        cursor = ((IrClass)cursor).getParent();
                    }
                    return false;
                }
            });
        }
        IrDeclarationsKt.copyAttributes$default((IrElement)((IrElement)irSimpleFunction), (IrElement)((IrElement)irFunction), (boolean)false, (int)2, null);
        IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((LoweringContext)((LoweringContext)this.getContext()), (IrSymbol)((IrSymbol)irFunction.getSymbol()), (int)0, (int)0, (int)6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var9_11 = this_$iv$iv;
        IrSimpleFunction irSimpleFunction2 = irFunction;
        boolean bl = false;
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$createStaticSuspendImpl_u24lambda_u241), (IrFunction)((IrFunction)irSimpleFunction));
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u241;
        void var14_17 = $this$createStaticSuspendImpl_u24lambda_u241;
        boolean bl2 = false;
        int n = ((Collection)irFunction.getTypeParameters()).size();
        for (int i = 0; i < n; ++i) {
            it.getTypeArguments().set(i, $this$createStaticSuspendImpl_u24lambda_u241.getContext().getIrBuiltIns().getAnyNType());
        }
        List i = (List)it.getArguments();
        Collection other$iv = irFunction.getParameters();
        boolean $i$f$assignFrom = false;
        $this$assignFrom$iv.clear();
        if ($this$assignFrom$iv instanceof ArrayList) {
            ((ArrayList)$this$assignFrom$iv).ensureCapacity(other$iv.size());
        }
        Iterable iterable = other$iv;
        Collection destination$iv$iv = (Collection)$this$assignFrom$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            IrValueDeclaration irValueDeclaration = (IrValueDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$createStaticSuspendImpl_u24lambda_u241), (IrValueDeclaration)p0));
        }
        Unit unit = Unit.INSTANCE;
        var14_17.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)irFunctionAccessExpression)));
        irSimpleFunction2.setBody((IrBody)this_$iv$iv.doBuild());
        JvmIrAttributesKt.setStaticSuspendImplMethod((IrFunction)irFunction, irSimpleFunction);
        return irSimpleFunction;
    }

    private final void addContinuationObjectAndContinuationParameterToSuspendFunctions(IrFile irFile) {
        irFile.accept((IrVisitor)new IrElementTransformerVoid(this){
            final /* synthetic */ AddContinuationLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrStatement visitClass(IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                TransformKt.transformDeclarationsFlat((IrDeclarationContainer)((IrDeclarationContainer)declaration), arg_0 -> addContinuationObjectAndContinuationParameterToSuspendFunctions.1.visitClass$lambda$0(this, arg_0));
                return (IrStatement)declaration;
            }

            public IrExpression visitRichFunctionReference(IrRichFunctionReference expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrSimpleFunction function2 = expression2.getInvokeFunction();
                if (function2.isSuspend()) {
                    expression2.setInvokeFunction((IrSimpleFunction)CollectionsKt.single(this.transformToView(function2)));
                    return (IrExpression)expression2;
                }
                return super.visitRichFunctionReference(expression2);
            }

            /*
             * WARNING - void declaration
             */
            private final List<IrSimpleFunction> transformToView(IrSimpleFunction function2) {
                void $this$transformToView_u24lambda_u246;
                void this_$iv$iv;
                void $this$irBlockBody_u24default$iv;
                IrSimpleFunction irSimpleFunction;
                IrSimpleFunction $this$buildFun$iv;
                IrFunctionBuilder $this$transformToView_u24lambda_u243;
                Collection newType;
                IrFactory $this$filterTo$iv$iv;
                void $this$filter$iv;
                IrSimpleFunction viewForOriginal;
                Object originalForDefaultImplBridge;
                function2.accept((IrVisitor)this, null);
                boolean capturesCrossinline = this.isCapturingCrossinline(function2);
                IrSimpleFunction view = AddContinuationLoweringKt.access$suspendFunctionViewOrStub(function2, this.this$0.getContext());
                IrSimpleFunction irSimpleFunction2 = JvmCachedDeclarationsKt.getOriginalFunctionForDefaultImpl(function2);
                if (irSimpleFunction2 != null) {
                    originalForDefaultImplBridge = irSimpleFunction2;
                    boolean bl = false;
                    viewForOriginal = JvmIrAttributesKt.getViewOfOriginalSuspendFunction((IrFunction)JvmIrUtilsKt.suspendFunctionOriginal(originalForDefaultImplBridge));
                    if (viewForOriginal != null) {
                        JvmCachedDeclarationsKt.setOriginalFunctionForDefaultImpl(view, viewForOriginal);
                    }
                }
                IrValueParameter continuationParameter = JvmIrCoroutineUtilsKt.continuationParameter((IrFunction)view);
                originalForDefaultImplBridge = view.getParameters();
                Iterable iterable = function2.getParameters();
                boolean $i$f$filter22 = false;
                viewForOriginal = $this$filter$iv;
                Object destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)continuationParameter))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Map parameterMap = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)iterable, (Iterable)((List)destination$iv$iv)));
                view.setBody(IrInlineUtilsKt.moveBodyTo((IrFunction)((IrFunction)function2), (IrFunction)((IrFunction)view), (Map)parameterMap));
                Object[] $i$f$filter22 = new IrSimpleFunction[]{view};
                List result = CollectionsKt.mutableListOf((Object[])$i$f$filter22);
                if (function2.getBody() == null || !JvmIrCoroutineUtilsKt.hasContinuation((IrFunction)function2)) {
                    return result;
                }
                if (Intrinsics.areEqual((Object)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)function2)).getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getLAMBDA_IMPL()) || Intrinsics.areEqual((Object)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)function2)).getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getFUNCTION_REFERENCE_IMPL())) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Type type = JvmIrAttributesKt.getLocalClassType((IrElement)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)function2)));
                    Intrinsics.checkNotNull((Object)type);
                    newType = Type.getObjectType((String)stringBuilder.append(type.getInternalName()).append('$').append(function2.getName()).append("$1").toString());
                    JvmIrAttributesKt.setLocalClassType((IrElement)function2, (Type)newType);
                }
                if (capturesCrossinline || function2.isInline()) {
                    DescriptorVisibility descriptorVisibility;
                    newType = result;
                    $this$filterTo$iv$iv = this.this$0.getContext().getIrFactory();
                    destination$iv$iv = this.this$0;
                    boolean $i$f$buildFun = false;
                    IrFunctionBuilder $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
                    boolean bl = false;
                    $this$transformToView_u24lambda_u243 = $this$buildFun_u24lambda_u240$iv;
                    boolean bl2 = false;
                    $this$transformToView_u24lambda_u243.setContainerSource(view.getContainerSource());
                    Name name = Name.identifier((String)(MethodSignatureMapper.mapFunctionName$default(((SuspendLoweringUtils)destination$iv$iv).getContext().getDefaultMethodSignatureMapper(), (IrFunction)view, false, 2, null) + "$$forInline"));
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
                    $this$transformToView_u24lambda_u243.setName(name);
                    $this$transformToView_u24lambda_u243.setModality(view.getModality());
                    $this$transformToView_u24lambda_u243.setSuspend(view.isSuspend());
                    $this$transformToView_u24lambda_u243.setInline(view.isInline());
                    if (view.isInline()) {
                        DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PRIVATE;
                        descriptorVisibility = descriptorVisibility2;
                        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PRIVATE");
                    } else {
                        descriptorVisibility = view.getVisibility();
                    }
                    $this$transformToView_u24lambda_u243.setVisibility(descriptorVisibility);
                    $this$transformToView_u24lambda_u243.setOrigin(view.isInline() ? JvmLoweredDeclarationOrigin.INSTANCE.getFOR_INLINE_STATE_MACHINE_TEMPLATE() : JvmLoweredDeclarationOrigin.INSTANCE.getFOR_INLINE_STATE_MACHINE_TEMPLATE_CAPTURES_CROSSINLINE());
                    $this$buildFun$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u240$iv);
                    destination$iv$iv = this.this$0;
                    IrSimpleFunction $this$transformToView_u24lambda_u244 = $this$buildFun$iv;
                    boolean bl3 = false;
                    IrUtilsKt.copyAnnotationsFrom((IrMutableAnnotationContainer)((IrMutableAnnotationContainer)$this$transformToView_u24lambda_u244), (IrAnnotationContainer)((IrAnnotationContainer)view));
                    IrUtilsKt.copyFunctionSignatureFrom$default((IrFunction)((IrFunction)$this$transformToView_u24lambda_u244), (IrFunction)((IrFunction)view), null, (int)2, null);
                    ((SuspendLoweringUtils)destination$iv$iv).getContext().remapMultiFieldValueClassStructure((IrFunction)view, (IrFunction)$this$transformToView_u24lambda_u244, null);
                    IrDeclarationsKt.copyAttributes$default((IrElement)((IrElement)$this$transformToView_u24lambda_u244), (IrElement)((IrElement)view), (boolean)false, (int)2, null);
                    ((SuspendLoweringUtils)destination$iv$iv).generateErrorForInlineBody($this$transformToView_u24lambda_u244);
                    JvmIrAttributesKt.setOriginalOfSuspendForInline((IrFunction)$this$transformToView_u24lambda_u244, view);
                    newType.add($this$buildFun$iv);
                }
                if (IrUtilsKt.isOverridable((IrSimpleFunction)function2)) {
                    IrSimpleFunction it = $this$buildFun$iv = AddContinuationLowering.access$createStaticSuspendImpl(this.this$0, view);
                    boolean bl = false;
                    ((Collection)result).add(it);
                    irSimpleFunction = $this$buildFun$iv;
                } else {
                    irSimpleFunction = view;
                }
                IrSimpleFunction newFunction = irSimpleFunction;
                $this$buildFun$iv = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((LoweringContext)((LoweringContext)this.this$0.getContext()), (IrSymbol)((IrSymbol)newFunction.getSymbol()), (int)0, (int)0, (int)6, null);
                AddContinuationLowering addContinuationLowering = this.this$0;
                int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                boolean $i$f$irBlockBody = false;
                $this$transformToView_u24lambda_u243 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                boolean $i$f$blockBody = false;
                void var15_22 = this_$iv$iv;
                iterable = newFunction;
                boolean bl = false;
                $this$transformToView_u24lambda_u246.unaryPlus((IrStatement)AddContinuationLowering.access$generateContinuationClassForNamedFunction(addContinuationLowering, (IrFunction)newFunction, view.getDispatchReceiverParameter(), (IrElement)function2, capturesCrossinline));
                if (addContinuationLowering.getContext().getConfig().getEnhancedCoroutinesDebugging()) {
                    for (IrSimpleFunctionSymbol fakeInlineFunction : IrUtilsKt.getFunctions((IrClassSymbol)addContinuationLowering.getContext().getSymbols().getGeneratedCodeMarkersInCoroutinesClass())) {
                        $this$transformToView_u24lambda_u246.unaryPlus((IrStatement)ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$transformToView_u24lambda_u246), (IrSimpleFunctionSymbol)fakeInlineFunction));
                    }
                }
                if (newFunction.getBody() instanceof IrExpressionBody) {
                    IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$transformToView_u24lambda_u246;
                    IrBody irBody = newFunction.getBody();
                    Intrinsics.checkNotNull((Object)irBody);
                    E e = IrUtilsKt.getStatements((IrBody)irBody).get(0);
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                    $this$transformToView_u24lambda_u246.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)e)));
                } else {
                    IrBody irBody = newFunction.getBody();
                    Intrinsics.checkNotNull((Object)irBody);
                    for (IrStatement statement : IrUtilsKt.getStatements((IrBody)irBody)) {
                        $this$transformToView_u24lambda_u246.unaryPlus(statement);
                    }
                }
                iterable.setBody((IrBody)this_$iv$iv.doBuild());
                return result;
            }

            private final boolean isCapturingCrossinline(IrSimpleFunction $this$isCapturingCrossinline) {
                Ref.BooleanRef capturesCrossinline = new Ref.BooleanRef();
                IrVisitorsKt.acceptVoid((IrElement)((IrElement)$this$isCapturingCrossinline), (IrVisitorVoid)new IrVisitorVoid(capturesCrossinline){
                    final /* synthetic */ Ref.BooleanRef $capturesCrossinline;
                    {
                        this.$capturesCrossinline = $capturesCrossinline;
                    }

                    public void visitElement(IrElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        IrVisitorsKt.acceptChildrenVoid((IrElement)element, (IrVisitorVoid)this);
                    }

                    public void visitFieldAccess(IrFieldAccessExpression expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        if (Intrinsics.areEqual((Object)((IrField)expression2.getSymbol().getOwner()).getOrigin(), (Object)LocalDeclarationsLowering.Companion.getDECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE())) {
                            this.$capturesCrossinline.element = true;
                            return;
                        }
                        super.visitFieldAccess(expression2);
                    }

                    public void visitClass(IrClass declaration) {
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    }
                });
                return capturesCrossinline.element;
            }

            private static final List visitClass$lambda$0(addContinuationObjectAndContinuationParameterToSuspendFunctions.1 this$0, IrDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it instanceof IrSimpleFunction && ((IrSimpleFunction)it).isSuspend()) {
                    return this$0.transformToView((IrSimpleFunction)it);
                }
                it.accept((IrVisitor)this$0, null);
                return null;
            }
        }, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit addInvokeSuspendForNamedFunction$lambda$1(IrField $resultField, IrField $labelField, IrFunction $irFunction, IrClass $this_addInvokeSuspendForNamedFunction, IrField $capturedThisField, boolean $isStaticSuspendImpl, JvmBackendContext $backendContext, IrBlockBodyBuilder $this$addFunctionOverride, IrFunction function2) {
        IrGetFieldImpl irGetFieldImpl;
        void it;
        void $this$single$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addFunctionOverride, (String)"$this$addFunctionOverride");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        IrBuilder irBuilder = (IrBuilder)$this$addFunctionOverride;
        IrBuilder irBuilder2 = (IrBuilder)$this$addFunctionOverride;
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        $this$addFunctionOverride.unaryPlus((IrStatement)ExpressionHelpersKt.irSetField$default((IrBuilder)irBuilder, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)irBuilder2, (IrValueDeclaration)((IrValueDeclaration)irValueParameter))), (IrField)$resultField, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$addFunctionOverride), (IrValueDeclaration)((IrValueDeclaration)CollectionsKt.first((List)IrUtilsKt.getNonDispatchParameters((IrFunction)function2))))), null, (int)8, null));
        int signBit = Integer.MIN_VALUE;
        IrBuilder irBuilder3 = (IrBuilder)$this$addFunctionOverride;
        IrBuilder irBuilder4 = (IrBuilder)$this$addFunctionOverride;
        IrValueParameter irValueParameter2 = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter2);
        Sequence sequence = IrUtilsKt.getFunctions((IrClassSymbol)$this$addFunctionOverride.getContext().getIrBuiltIns().getIntClass());
        IrBuilder irBuilder5 = (IrBuilder)$this$addFunctionOverride;
        IrField irField = $labelField;
        IrExpression irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilder)irBuilder4, (IrValueDeclaration)((IrValueDeclaration)irValueParameter2));
        IrBuilder irBuilder6 = irBuilder3;
        IrBlockBodyBuilder irBlockBodyBuilder = $this$addFunctionOverride;
        boolean $i$f$single22 = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunctionSymbol it2 = (IrSimpleFunctionSymbol)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it2.getOwner()).getName(), (Object)OperatorNameConventions.OR)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        Object var23_30 = single$iv;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = var23_30;
        IrType irType = $this$addFunctionOverride.getContext().getIrBuiltIns().getIntType();
        IrBuilder irBuilder7 = (IrBuilder)$this$addFunctionOverride;
        IrBuilder irBuilder8 = (IrBuilder)$this$addFunctionOverride;
        IrValueParameter irValueParameter3 = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter3);
        irBlockBodyBuilder.unaryPlus((IrStatement)ExpressionHelpersKt.irSetField$default((IrBuilder)irBuilder6, (IrExpression)irExpression, (IrField)irField, (IrExpression)((IrExpression)ExpressionHelpersKt.irCallOp$default((IrBuilder)irBuilder5, (IrSimpleFunctionSymbol)irSimpleFunctionSymbol, (IrType)irType, (IrExpression)((IrExpression)ExpressionHelpersKt.irGetField$default((IrBuilder)irBuilder7, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)irBuilder8, (IrValueDeclaration)((IrValueDeclaration)irValueParameter3))), (IrField)$labelField, null, (int)4, null)), (IrExpression)((IrExpression)ExpressionHelpersKt.irInt$default((IrBuilder)((IrBuilder)$this$addFunctionOverride), (int)signBit, null, (int)2, null)), null, (int)16, null)), null, (int)8, null));
        Sequence $i$f$single22 = sequence = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$addFunctionOverride), (IrFunction)$irFunction);
        irBuilder6 = (IrBuilderWithScope)$this$addFunctionOverride;
        irBlockBodyBuilder = $this$addFunctionOverride;
        boolean bl = false;
        int n = ((Collection)$irFunction.getTypeParameters()).size();
        for (int i = 0; i < n; ++i) {
            it.getTypeArguments().set(i, IrTypesKt.getDefaultType((IrTypeParameter)((IrTypeParameter)$this_addInvokeSuspendForNamedFunction.getTypeParameters().get(i))));
        }
        IrField irField2 = $capturedThisField;
        if (irField2 != null) {
            IrField irField3 = irField2;
            boolean bl2 = false;
            IrBuilder irBuilder9 = (IrBuilder)$this$addFunctionOverride;
            IrBuilder irBuilder10 = (IrBuilder)$this$addFunctionOverride;
            IrValueParameter irValueParameter4 = function2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter4);
            irGetFieldImpl = ExpressionHelpersKt.irGetField$default((IrBuilder)irBuilder9, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)irBuilder10, (IrValueDeclaration)((IrValueDeclaration)irValueParameter4))), (IrField)irField3, null, (int)4, null);
        } else {
            irGetFieldImpl = null;
        }
        IrGetFieldImpl capturedThisValue = irGetFieldImpl;
        for (IrValueParameter parameter : $irFunction.getParameters()) {
            IrExpression irExpression2;
            IrMemberAccessExpression.ValueArgumentsList valueArgumentsList = it.getArguments();
            switch (WhenMappings.$EnumSwitchMapping$0[parameter.getKind().ordinal()]) {
                case 1: {
                    irExpression2 = (IrExpression)capturedThisValue;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    IrValueParameter irValueParameter5 = parameter;
                    if (Intrinsics.areEqual((Object)irValueParameter5, (Object)CollectionsKt.first((List)$irFunction.getParameters())) && $isStaticSuspendImpl) {
                        irExpression2 = (IrExpression)capturedThisValue;
                        break;
                    }
                    if (Intrinsics.areEqual((Object)irValueParameter5, (Object)CollectionsKt.last((List)$irFunction.getParameters()))) {
                        IrValueParameter irValueParameter6 = function2.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull((Object)irValueParameter6);
                        irExpression2 = (IrExpression)BuildersKt.IrGetValueImpl$default((int)-1, (int)-1, (IrValueSymbol)((IrValueSymbol)irValueParameter6.getSymbol()), null, (int)8, null);
                        break;
                    }
                    irExpression2 = JvmIrTypeUtilsKt.defaultValue(parameter.getType(), -1, -1, $backendContext);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            valueArgumentsList.set(parameter, irExpression2);
        }
        irExpression = Unit.INSTANCE;
        irBlockBodyBuilder.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)irBuilder6, (IrExpression)((IrExpression)sequence)));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ IrSimpleFunction access$createStaticSuspendImpl(AddContinuationLowering $this, IrSimpleFunction irFunction) {
        return $this.createStaticSuspendImpl(irFunction);
    }

    public static final /* synthetic */ IrClass access$generateContinuationClassForNamedFunction(AddContinuationLowering $this, IrFunction irFunction, IrValueParameter dispatchReceiverParameter, IrElement attributeContainer, boolean capturesCrossinline) {
        return $this.generateContinuationClassForNamedFunction(irFunction, dispatchReceiverParameter, attributeContainer, capturesCrossinline);
    }

    @Metadata(mv={2, 4, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrParameterKind.values().length];
            try {
                nArray[IrParameterKind.DispatchReceiver.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.Context.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.ExtensionReceiver.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.Regular.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

