/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreterKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.CleanBoxedValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.TaintedBoxedValue;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0015\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0004J \u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001bH\u0016J\u0012\u0010\u001c\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\u00110\u001bH\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0011H\u0014J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0018\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0011H\u0016J\u0016\u0010$\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0011J\u0016\u0010%\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0011J \u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001fH\u0002J \u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001fH\u0002J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH$J \u0010+\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u0014H$J \u0010-\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u000bH$J \u00100\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u000bH$J\u0010\u00101\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH$J\u0010\u00102\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH$J\u0018\u00103\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bH$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\tj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter;", "insnList", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "<init>", "(Lorg/jetbrains/org/objectweb/asm/tree/InsnList;Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "boxingPlaces", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue;", "Lkotlin/collections/HashMap;", "progressionIterators", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue;", "createNewBoxing", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "insn", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "progressionIterator", "checkUsedValue", "", "value", "naryOperation", "values", "", "markBoxedArgumentValues", "unaryOperation", "isExactValue", "", "isCastToProgression", "merge", "v", "w", "mergeLocalVariableValues", "mergeStackValues", "isLocalVariable", "mergeBoxedHazardous", "boxed", "other", "onNewBoxedValue", "onUnboxing", "resultType", "onAreEqual", "value1", "value2", "onCompareTo", "onMethodCallWithBoxedValue", "onMergeFail", "onMergeSuccess", "backend"})
@SourceDebugExtension(value={"SMAP\nBoxingInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxingInterpreter.kt\norg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,389:1\n460#2,7:390\n460#2,7:399\n1915#3,2:397\n1#4:406\n*S KotlinDebug\n*F\n+ 1 BoxingInterpreter.kt\norg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter\n*L\n40#1:390,7\n85#1:399,7\n53#1:397,2\n*E\n"})
public abstract class BoxingInterpreter
extends OptimizationBasicInterpreter {
    @NotNull
    private final InsnList insnList;
    @NotNull
    private final GenerationState generationState;
    @NotNull
    private final HashMap<Integer, BoxedBasicValue> boxingPlaces;
    @NotNull
    private final HashMap<AbstractInsnNode, ProgressionIteratorBasicValue> progressionIterators;

    public BoxingInterpreter(@NotNull InsnList insnList, @NotNull GenerationState generationState) {
        Intrinsics.checkNotNullParameter((Object)insnList, (String)"insnList");
        Intrinsics.checkNotNullParameter((Object)generationState, (String)"generationState");
        this.insnList = insnList;
        this.generationState = generationState;
        this.boxingPlaces = new HashMap();
        this.progressionIterators = new HashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected BasicValue createNewBoxing(@NotNull AbstractInsnNode insn, @NotNull Type type, @Nullable ProgressionIteratorBasicValue progressionIterator) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Map map = this.boxingPlaces;
        Integer key$iv = this.insnList.indexOf(insn);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            CleanBoxedValue boxedBasicValue = new CleanBoxedValue(type, insn, progressionIterator, this.generationState);
            this.onNewBoxedValue(boxedBasicValue);
            BoxedBasicValue answer$iv = boxedBasicValue;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (BasicValue)object;
    }

    protected final void checkUsedValue(@NotNull BasicValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof TaintedBoxedValue) {
            this.onMergeFail((BoxedBasicValue)value);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public BasicValue naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends BasicValue> values) {
        BasicValue basicValue;
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Iterable $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicValue it = (BasicValue)element$iv;
            boolean bl = false;
            this.checkUsedValue(it);
        }
        BasicValue value = super.naryOperation(insn, values);
        BasicValue basicValue2 = (BasicValue)CollectionsKt.firstOrNull(values);
        if (basicValue2 == null) {
            return value;
        }
        BasicValue firstArg = basicValue2;
        if (BoxingInterpreterKt.isBoxing(insn, this.generationState)) {
            this.markBoxedArgumentValues(values);
            Type type = value.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
            basicValue = this.createNewBoxing(insn, type, null);
        } else if (BoxingInterpreterKt.isUnboxing(insn, this.generationState) && firstArg instanceof BoxedBasicValue) {
            BoxedBasicValue boxedBasicValue = (BoxedBasicValue)firstArg;
            Type type = value.getType();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
            this.onUnboxing(insn, boxedBasicValue, type);
            basicValue = value;
        } else if (BoxingInterpreterKt.isIteratorMethodCall(insn)) {
            this.markBoxedArgumentValues(values);
            Type firstArgType = firstArg.getType();
            Intrinsics.checkNotNull((Object)firstArgType);
            if (BoxingInterpreterKt.access$isProgressionClass(firstArgType)) {
                Object object;
                void $this$getOrPut$iv;
                Object element$iv;
                element$iv = this.progressionIterators;
                AbstractInsnNode key$iv = insn;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    ProgressionIteratorBasicValue progressionIteratorBasicValue = ProgressionIteratorBasicValue.Companion.byProgressionClassType(insn, firstArgType);
                    Intrinsics.checkNotNull((Object)((Object)progressionIteratorBasicValue));
                    ProgressionIteratorBasicValue answer$iv = progressionIteratorBasicValue;
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                basicValue = (BasicValue)object;
            } else {
                ProgressionIteratorBasicValue progressionIteratorBasicValue = this.progressionIterators.get(insn);
                if (progressionIteratorBasicValue != null) {
                    progressionIteratorBasicValue.taint();
                }
                basicValue = value;
            }
        } else if (BoxingInterpreterKt.isNextMethodCallOfProgressionIterator(insn, values)) {
            ProgressionIteratorBasicValue progressionIteratorBasicValue = firstArg instanceof ProgressionIteratorBasicValue ? (ProgressionIteratorBasicValue)firstArg : null;
            if (progressionIteratorBasicValue == null) {
                throw new AssertionError((Object)"firstArg should be progression iterator");
            }
            ProgressionIteratorBasicValue progressionIterator = progressionIteratorBasicValue;
            basicValue = this.createNewBoxing(insn, progressionIterator.getBoxedElementType(), progressionIterator);
        } else if (BoxingInterpreterKt.isAreEqualIntrinsicForSameTypedBoxedValues(insn, values) && BoxingInterpreterKt.canValuesBeUnboxedForAreEqual(values, this.generationState)) {
            BasicValue basicValue3 = values.get(0);
            Intrinsics.checkNotNull((Object)basicValue3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            BoxedBasicValue boxedBasicValue = (BoxedBasicValue)basicValue3;
            BasicValue basicValue4 = values.get(1);
            Intrinsics.checkNotNull((Object)basicValue4, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            this.onAreEqual(insn, boxedBasicValue, (BoxedBasicValue)basicValue4);
            basicValue = value;
        } else if (BoxingInterpreterKt.isJavaLangComparableCompareToForSameTypedBoxedValues(insn, values)) {
            BasicValue basicValue5 = values.get(0);
            Intrinsics.checkNotNull((Object)basicValue5, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            BoxedBasicValue boxedBasicValue = (BoxedBasicValue)basicValue5;
            BasicValue basicValue6 = values.get(1);
            Intrinsics.checkNotNull((Object)basicValue6, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            this.onCompareTo(insn, boxedBasicValue, (BoxedBasicValue)basicValue6);
            basicValue = value;
        } else {
            this.markBoxedArgumentValues(values);
            basicValue = value;
        }
        return basicValue;
    }

    private final void markBoxedArgumentValues(List<? extends BasicValue> $this$markBoxedArgumentValues) {
        for (BasicValue basicValue : $this$markBoxedArgumentValues) {
            if (!(basicValue instanceof BoxedBasicValue)) continue;
            this.onMethodCallWithBoxedValue((BoxedBasicValue)basicValue);
        }
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.checkUsedValue(value);
        return insn.getOpcode() == 192 && this.isExactValue(value) && !this.isCastToProgression(insn) ? value : super.unaryOperation(insn, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isExactValue(@NotNull BasicValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof ProgressionIteratorBasicValue) return true;
        if (value instanceof CleanBoxedValue) return true;
        if (value.getType() == null) return false;
        Type type = value.getType();
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(...)");
        if (!BoxingInterpreterKt.access$isProgressionClass(type)) return false;
        return true;
    }

    private final boolean isCastToProgression(AbstractInsnNode insn) {
        boolean bl;
        boolean bl2 = bl = insn.getOpcode() == 192;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Expected opcode Opcodes.CHECKCAST, but " + insn.getOpcode() + " found";
            throw new AssertionError((Object)string);
        }
        Intrinsics.checkNotNull((Object)insn, (String)"null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TypeInsnNode");
        String desc = ((TypeInsnNode)insn).desc;
        Object[] objectArray = new String[]{"kotlin/ranges/CharProgression", "kotlin/ranges/IntProgression", "kotlin/ranges/LongProgression"};
        return SetsKt.setOf((Object[])objectArray).contains(desc);
    }

    @Override
    @NotNull
    public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        return this.mergeStackValues(v, w);
    }

    @NotNull
    public final BasicValue mergeLocalVariableValues(@NotNull BasicValue v, @NotNull BasicValue w) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        return this.merge(v, w, true);
    }

    @NotNull
    public final BasicValue mergeStackValues(@NotNull BasicValue v, @NotNull BasicValue w) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        return this.merge(v, w, false);
    }

    private final BasicValue merge(BasicValue v, BasicValue w, boolean isLocalVariable) {
        BasicValue basicValue;
        if (v == StrictBasicValue.UNINITIALIZED_VALUE || w == StrictBasicValue.UNINITIALIZED_VALUE) {
            basicValue = StrictBasicValue.UNINITIALIZED_VALUE;
        } else if (v instanceof BoxedBasicValue) {
            if (w instanceof BoxedBasicValue) {
                this.onMergeSuccess((BoxedBasicValue)v, (BoxedBasicValue)w);
                basicValue = v instanceof TaintedBoxedValue ? v : (w instanceof TaintedBoxedValue ? w : (!Intrinsics.areEqual((Object)((BoxedBasicValue)v).getType(), (Object)((BoxedBasicValue)w).getType()) ? this.mergeBoxedHazardous((BoxedBasicValue)v, w, isLocalVariable) : v));
            } else {
                basicValue = this.mergeBoxedHazardous((BoxedBasicValue)v, w, isLocalVariable);
            }
        } else if (w instanceof BoxedBasicValue) {
            basicValue = this.mergeBoxedHazardous((BoxedBasicValue)w, v, isLocalVariable);
        } else {
            BasicValue basicValue2 = super.merge(v, w);
            basicValue = basicValue2;
            Intrinsics.checkNotNullExpressionValue((Object)basicValue2, (String)"merge(...)");
        }
        return basicValue;
    }

    private final BasicValue mergeBoxedHazardous(BoxedBasicValue boxed, BasicValue other, boolean isLocalVariable) {
        if (isLocalVariable) {
            return boxed.taint();
        }
        this.onMergeFail(boxed);
        if (other instanceof BoxedBasicValue) {
            this.onMergeFail((BoxedBasicValue)other);
        }
        return boxed;
    }

    protected abstract void onNewBoxedValue(@NotNull BoxedBasicValue var1);

    protected abstract void onUnboxing(@NotNull AbstractInsnNode var1, @NotNull BoxedBasicValue var2, @NotNull Type var3);

    protected abstract void onAreEqual(@NotNull AbstractInsnNode var1, @NotNull BoxedBasicValue var2, @NotNull BoxedBasicValue var3);

    protected abstract void onCompareTo(@NotNull AbstractInsnNode var1, @NotNull BoxedBasicValue var2, @NotNull BoxedBasicValue var3);

    protected abstract void onMethodCallWithBoxedValue(@NotNull BoxedBasicValue var1);

    protected abstract void onMergeFail(@NotNull BoxedBasicValue var1);

    protected abstract void onMergeSuccess(@NotNull BoxedBasicValue var1, @NotNull BoxedBasicValue var2);
}

