/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0001H\u0016R\u001e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsSpread;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)V", "value", "getExpression", "()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "accept", "", "visitor", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitor;", "acceptChildren", "traverse", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContext;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "deepCopy", "js.ast"})
public final class JsSpread
extends JsExpression {
    @NotNull
    private JsExpression expression;

    public JsSpread(@NotNull JsExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.expression = expression2;
    }

    @NotNull
    public final JsExpression getExpression() {
        return this.expression;
    }

    @Override
    public void accept(@NotNull JsVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitSpread(this);
    }

    @Override
    public void acceptChildren(@NotNull JsVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.accept((JsNode)this.expression);
    }

    public void traverse(@NotNull JsVisitorWithContext visitor2, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        if (visitor2.visit(this, ctx)) {
            JsNode jsNode = visitor2.accept((JsNode)this.expression);
            Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"accept(...)");
            this.expression = (JsExpression)jsNode;
        }
        visitor2.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsExpression deepCopy() {
        JsExpression jsExpression = this.expression.deepCopy();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"deepCopy(...)");
        HasMetadata hasMetadata = new JsSpread(jsExpression).withMetadataFrom(this);
        Intrinsics.checkNotNullExpressionValue((Object)hasMetadata, (String)"withMetadataFrom(...)");
        return (JsExpression)hasMetadata;
    }
}

