/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.Paths;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.tree.DirectoryEntry;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.FileEntry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VersionManagingFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaGateway {
    private static final Logger LOG = Logger.getInstance(IdeaGateway.class);
    private static final Key<ContentAndTimestamps> SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY = Key.create((String)"LocalHistory.SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY");
    private static final ThreadLocal<VfsEventDispatchContext> ourCurrentEventDispatchContext = new ThreadLocal();

    @NotNull
    public static IdeaGateway getInstance() {
        IdeaGateway ideaGateway = (IdeaGateway)ApplicationManager.getApplication().getService(IdeaGateway.class);
        if (ideaGateway == null) {
            IdeaGateway.$$$reportNull$$$0(0);
        }
        return ideaGateway;
    }

    public boolean isVersioned(@NotNull VirtualFile f) {
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(1);
        }
        return this.isVersioned(f, false);
    }

    public boolean isVersioned(@NotNull VirtualFile f, boolean shouldBeInContent) {
        CharSequence fileName;
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(2);
        }
        if (VersionManagingFileSystem.isDisabled((VirtualFile)f)) {
            return false;
        }
        if (!f.isInLocalFileSystem()) {
            return VersionManagingFileSystem.isEnforcedNonLocal((VirtualFile)f);
        }
        if (!f.isDirectory() && (StringUtil.equals((CharSequence)(fileName = f.getNameSequence()), (CharSequence)"workspace.xml") || StringUtil.endsWith((CharSequence)fileName, (CharSequence)".iws") || StringUtil.endsWith((CharSequence)fileName, (CharSequence)".class"))) {
            return false;
        }
        VersionedFilterData versionedFilterData = IdeaGateway.getVersionedFilterData();
        int numberOfOpenProjects = versionedFilterData.myOpenedProjects.size();
        if (numberOfOpenProjects == 0) {
            if (shouldBeInContent) {
                return false;
            }
            return !FileTypeManager.getInstance().isFileIgnored(f);
        }
        boolean isExcludedFromAll = true;
        boolean isInContent = false;
        for (int i = 0; i < numberOfOpenProjects; ++i) {
            ProjectFileIndex index = versionedFilterData.myProjectFileIndices.get(i);
            if (index.isUnderIgnored(f)) {
                return false;
            }
            isInContent |= index.isInContent(f);
            isExcludedFromAll &= index.isExcluded(f);
        }
        if (isExcludedFromAll) {
            return false;
        }
        return !shouldBeInContent || isInContent;
    }

    @NotNull
    public String getPathOrUrl(@NotNull VirtualFile file) {
        if (file == null) {
            IdeaGateway.$$$reportNull$$$0(3);
        }
        String string = file.isInLocalFileSystem() ? file.getPath() : file.getUrl();
        if (string == null) {
            IdeaGateway.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getNameOrUrlPart(@NotNull VirtualFile file) {
        if (file == null) {
            IdeaGateway.$$$reportNull$$$0(5);
        }
        String name = file.getName();
        if (file.getParent() != null) {
            String string = name;
            if (string == null) {
                IdeaGateway.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (file.isInLocalFileSystem()) {
            String string = "/".equals(name) ? "" : name;
            if (string == null) {
                IdeaGateway.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = VirtualFileManager.constructUrl((String)file.getFileSystem().getProtocol(), (String)StringUtil.trimStart((String)name, (String)"/"));
        if (string == null) {
            IdeaGateway.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    protected static VersionedFilterData getVersionedFilterData() {
        VersionedFilterData versionedFilterData;
        VfsEventDispatchContext vfsEventDispatchContext = ourCurrentEventDispatchContext.get();
        if (vfsEventDispatchContext != null) {
            versionedFilterData = vfsEventDispatchContext.myFilterData;
            if (versionedFilterData == null) {
                versionedFilterData = vfsEventDispatchContext.myFilterData = new VersionedFilterData();
            }
        } else {
            versionedFilterData = new VersionedFilterData();
        }
        VersionedFilterData versionedFilterData2 = versionedFilterData;
        if (versionedFilterData2 == null) {
            IdeaGateway.$$$reportNull$$$0(9);
        }
        return versionedFilterData2;
    }

    public void runWithVfsEventsDispatchContext(List<? extends VFileEvent> events, boolean beforeEvents, @NotNull Runnable action) {
        if (action == null) {
            IdeaGateway.$$$reportNull$$$0(10);
        }
        try (VfsEventDispatchContext ignored = new VfsEventDispatchContext(events, beforeEvents);){
            action.run();
        }
    }

    public boolean areContentChangesVersioned(@NotNull VirtualFile f) {
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(11);
        }
        return this.isVersioned(f) && !f.isDirectory() && (this.areContentChangesVersioned(f.getName()) || ScratchFileService.findRootType((VirtualFile)f) != null);
    }

    public boolean areContentChangesVersioned(@NotNull String fileName) {
        if (fileName == null) {
            IdeaGateway.$$$reportNull$$$0(12);
        }
        return !FileTypeManager.getInstance().getFileTypeByFileName(fileName).isBinary();
    }

    public boolean ensureFilesAreWritable(@NotNull Project p, @NotNull List<? extends VirtualFile> ff) {
        ReadonlyStatusHandler h;
        if (p == null) {
            IdeaGateway.$$$reportNull$$$0(13);
        }
        if (ff == null) {
            IdeaGateway.$$$reportNull$$$0(14);
        }
        return !(h = ReadonlyStatusHandler.getInstance((Project)p)).ensureFilesWritable(ff).hasReadonlyFiles();
    }

    @Nullable
    public VirtualFile findVirtualFile(@NotNull String path) {
        if (path == null) {
            IdeaGateway.$$$reportNull$$$0(15);
        }
        if (path.contains("://")) {
            return VirtualFileManager.getInstance().findFileByUrl(path);
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null && ApplicationManager.getApplication().isUnitTestMode()) {
            return TempFileSystem.getInstance().findFileByPath(path);
        }
        return file;
    }

    @NotNull
    public VirtualFile findOrCreateFileSafely(@NotNull VirtualFile parent, @NotNull String name, boolean isDirectory) throws IOException {
        VirtualFile f;
        if (parent == null) {
            IdeaGateway.$$$reportNull$$$0(16);
        }
        if (name == null) {
            IdeaGateway.$$$reportNull$$$0(17);
        }
        if ((f = parent.findChild(name)) != null && f.isDirectory() != isDirectory) {
            f.delete((Object)this);
            f = null;
        }
        if (f == null) {
            f = isDirectory ? parent.createChildDirectory((Object)this, name) : parent.createChildData((Object)this, name);
        }
        VirtualFile virtualFile = f;
        if (virtualFile == null) {
            IdeaGateway.$$$reportNull$$$0(18);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile findOrCreateFileSafely(@NotNull String path, boolean isDirectory) throws IOException {
        VirtualFile f;
        if (path == null) {
            IdeaGateway.$$$reportNull$$$0(19);
        }
        if ((f = this.findVirtualFile(path)) != null && f.isDirectory() != isDirectory) {
            f.delete((Object)this);
            f = null;
        }
        if (f == null) {
            VirtualFile parent = this.findOrCreateFileSafely(Paths.getParentOf(path), true);
            String name = Paths.getNameOf(path);
            f = isDirectory ? parent.createChildDirectory((Object)this, name) : parent.createChildData((Object)this, name);
        }
        VirtualFile virtualFile = f;
        if (virtualFile == null) {
            IdeaGateway.$$$reportNull$$$0(20);
        }
        return virtualFile;
    }

    @NotNull
    public static Iterable<VirtualFile> iterateDBChildren(VirtualFile f) {
        NewVirtualFile nf;
        block6: {
            block5: {
                if (!(f instanceof NewVirtualFile)) break block5;
                nf = (NewVirtualFile)f;
                if (f.isValid()) break block6;
            }
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                IdeaGateway.$$$reportNull$$$0(21);
            }
            return list;
        }
        Iterable iterable = nf.iterInDbChildrenWithoutLoadingVfsFromOtherProjects();
        if (iterable == null) {
            IdeaGateway.$$$reportNull$$$0(22);
        }
        return iterable;
    }

    @NotNull
    public static Iterable<VirtualFile> loadAndIterateChildren(VirtualFile f) {
        NewVirtualFile nf;
        block6: {
            block5: {
                if (!(f instanceof NewVirtualFile)) break block5;
                nf = (NewVirtualFile)f;
                if (f.isValid()) break block6;
            }
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                IdeaGateway.$$$reportNull$$$0(23);
            }
            return list;
        }
        List<VirtualFile> list = Arrays.asList(nf.getChildren());
        if (list == null) {
            IdeaGateway.$$$reportNull$$$0(24);
        }
        return list;
    }

    @RequiresReadLock
    @NotNull
    public RootEntry createTransientRootEntry() {
        ThreadingAssertions.softAssertReadAccess();
        RootEntry root = new RootEntry();
        this.doCreateChildren(root, IdeaGateway.getLocalRoots(), false, null);
        RootEntry rootEntry = root;
        if (rootEntry == null) {
            IdeaGateway.$$$reportNull$$$0(25);
        }
        return rootEntry;
    }

    @RequiresReadLock
    @NotNull
    public RootEntry createTransientRootEntryForPath(@NotNull String path, boolean includeChildren) {
        if (path == null) {
            IdeaGateway.$$$reportNull$$$0(26);
        }
        ThreadingAssertions.softAssertReadAccess();
        RootEntry root = new RootEntry();
        this.doCreateChildren(root, IdeaGateway.getLocalRoots(), false, new SinglePathVisitor(path, includeChildren));
        RootEntry rootEntry = root;
        if (rootEntry == null) {
            IdeaGateway.$$$reportNull$$$0(27);
        }
        return rootEntry;
    }

    @RequiresReadLock
    @NotNull
    public RootEntry createTransientRootEntryForPaths(@NotNull Collection<String> paths, boolean includeChildren) {
        if (paths == null) {
            IdeaGateway.$$$reportNull$$$0(28);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (paths.isEmpty()) {
            return new RootEntry();
        }
        String singlePath = (String)ContainerUtil.getOnlyItem(paths);
        if (singlePath != null) {
            RootEntry rootEntry = this.createTransientRootEntryForPath(singlePath, includeChildren);
            if (rootEntry == null) {
                IdeaGateway.$$$reportNull$$$0(29);
            }
            return rootEntry;
        }
        RootEntry root = new RootEntry();
        List visitors = ContainerUtil.map(paths, s -> new SinglePathVisitor((String)s, includeChildren));
        this.doCreateChildren(root, IdeaGateway.getLocalRoots(), false, new MergingPathVisitor(visitors));
        RootEntry rootEntry = root;
        if (rootEntry == null) {
            IdeaGateway.$$$reportNull$$$0(30);
        }
        return rootEntry;
    }

    @NotNull
    private static List<VirtualFile> getLocalRoots() {
        SmartList roots = new SmartList();
        for (VirtualFile root : ManagingFS.getInstance().getRoots()) {
            if (!root.isInLocalFileSystem() && !VersionManagingFileSystem.isEnforcedNonLocal((VirtualFile)root) || root.getFileSystem() instanceof TempFileSystem) continue;
            roots.add(root);
        }
        SmartList smartList = roots;
        if (smartList == null) {
            IdeaGateway.$$$reportNull$$$0(31);
        }
        return smartList;
    }

    @RequiresReadLock
    @Nullable
    public Entry createTransientEntry(@NotNull VirtualFile file) {
        if (file == null) {
            IdeaGateway.$$$reportNull$$$0(32);
        }
        ThreadingAssertions.softAssertReadAccess();
        return this.doCreateEntry(file, false, null);
    }

    @RequiresReadLock
    @Nullable
    public Entry createEntryForDeletion(@NotNull VirtualFile file) {
        if (file == null) {
            IdeaGateway.$$$reportNull$$$0(33);
        }
        ThreadingAssertions.softAssertReadAccess();
        return this.doCreateEntry(file, true, null);
    }

    @Nullable
    private Entry doCreateEntry(@NotNull VirtualFile file, boolean forDeletion, @Nullable FileTreeVisitor visitor) {
        if (file == null) {
            IdeaGateway.$$$reportNull$$$0(34);
        }
        if (!file.isDirectory()) {
            if (!this.isVersioned(file)) {
                return null;
            }
            return this.doCreateFileEntry(file, forDeletion);
        }
        DirectoryEntries entries = IdeaGateway.doCreateDirectoryEntries(file);
        if (entries == null) {
            return null;
        }
        this.doCreateChildren(entries.last, IdeaGateway.iterateDBChildren(file), forDeletion, visitor);
        if (!this.isVersioned(file) && entries.last.getChildren().isEmpty()) {
            return null;
        }
        return entries.first;
    }

    @NotNull
    private Entry doCreateFileEntry(@NotNull VirtualFile file, boolean forDeletion) {
        Pair<StoredContent, Long> contentAndStamps;
        if (file == null) {
            IdeaGateway.$$$reportNull$$$0(35);
        }
        if (forDeletion) {
            FileDocumentManager m = FileDocumentManager.getInstance();
            Document d = m.isFileModified(file) ? m.getCachedDocument(file) : null;
            contentAndStamps = this.acquireAndClearCurrentContent(file, d);
        } else {
            contentAndStamps = IdeaGateway.getActualContentNoAcquire(file);
        }
        StoredContent content = (StoredContent)contentAndStamps.first;
        Long timestamp = (Long)contentAndStamps.second;
        if (file instanceof VirtualFileSystemEntry) {
            return new FileEntry(((VirtualFileSystemEntry)file).getNameId(), (Content)content, (long)timestamp, !file.isWritable());
        }
        return new FileEntry(file.getName(), (Content)content, (long)timestamp, !file.isWritable());
    }

    @Nullable
    private static DirectoryEntries doCreateDirectoryEntries(@NotNull VirtualFile file) {
        if (file == null) {
            IdeaGateway.$$$reportNull$$$0(36);
        }
        if (file.isInLocalFileSystem() || file.getParent() != null) {
            int nameId;
            if (file instanceof VirtualFileSystemEntry && (nameId = ((VirtualFileSystemEntry)file).getNameId()) > 0) {
                DirectoryEntry newDir = new DirectoryEntry(nameId);
                return new DirectoryEntries(newDir, newDir);
            }
            DirectoryEntry newDir = new DirectoryEntry(file.getName());
            return new DirectoryEntries(newDir, newDir);
        }
        DirectoryEntry first = null;
        DirectoryEntry last = null;
        for (String item : Paths.split(file.getUrl())) {
            DirectoryEntry current = new DirectoryEntry(item);
            if (first == null) {
                first = current;
            }
            if (last != null) {
                last.addChild(current);
            }
            last = current;
        }
        if (first == null) {
            return null;
        }
        return new DirectoryEntries(first, last);
    }

    private void doCreateChildren(@NotNull DirectoryEntry parent, @NotNull Iterable<? extends VirtualFile> children, boolean forDeletion, @Nullable FileTreeVisitor visitor) {
        if (parent == null) {
            IdeaGateway.$$$reportNull$$$0(37);
        }
        if (children == null) {
            IdeaGateway.$$$reportNull$$$0(38);
        }
        List entries = ContainerUtil.mapNotNull(children, each -> {
            if (visitor != null && !visitor.before((VirtualFile)each)) {
                return null;
            }
            Entry newEntry = null;
            Entry existingEntry = parent.findEntry(each.getName());
            if (existingEntry != null) {
                if (existingEntry instanceof DirectoryEntry) {
                    DirectoryEntry existingDirectoryEntry = (DirectoryEntry)existingEntry;
                    this.doCreateChildren(existingDirectoryEntry, IdeaGateway.iterateDBChildren(each), forDeletion, visitor);
                }
            } else {
                newEntry = this.doCreateEntry((VirtualFile)each, forDeletion, visitor);
            }
            if (visitor != null) {
                visitor.after((VirtualFile)each);
            }
            return newEntry;
        });
        parent.addChildren(entries);
    }

    public void registerUnsavedDocuments(@NotNull LocalHistoryFacade vcs) {
        if (vcs == null) {
            IdeaGateway.$$$reportNull$$$0(39);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            vcs.beginChangeSet();
            for (Document d : FileDocumentManager.getInstance().getUnsavedDocuments()) {
                VirtualFile f = IdeaGateway.getFile(d);
                if (!this.shouldRegisterDocument(f)) continue;
                this.registerDocumentContents(vcs, f, d);
            }
            vcs.endChangeSet(null, null);
        });
    }

    private boolean shouldRegisterDocument(@Nullable VirtualFile f) {
        try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-307668, EA-821075");){
            boolean bl = f != null && f.isValid() && this.areContentChangesVersioned(f);
            return bl;
        }
    }

    private void registerDocumentContents(@NotNull LocalHistoryFacade vcs, @NotNull VirtualFile f, @NotNull Document d) {
        Pair<StoredContent, Long> contentAndStamp;
        if (vcs == null) {
            IdeaGateway.$$$reportNull$$$0(40);
        }
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(41);
        }
        if (d == null) {
            IdeaGateway.$$$reportNull$$$0(42);
        }
        if ((contentAndStamp = this.acquireAndUpdateActualContent(f, d)) != null) {
            vcs.contentChanged(this.getPathOrUrl(f), (Content)contentAndStamp.first, (Long)contentAndStamp.second);
        }
    }

    @Nullable
    public Pair<StoredContent, Long> acquireAndUpdateActualContent(@NotNull VirtualFile f, @NotNull Document d) {
        ContentAndTimestamps contentAndStamp;
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(43);
        }
        if (d == null) {
            IdeaGateway.$$$reportNull$$$0(44);
        }
        if ((contentAndStamp = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY)) == null) {
            IdeaGateway.saveDocumentContent(f, d);
            return Pair.create((Object)StoredContent.acquireContent(f), (Object)f.getTimeStamp());
        }
        if (d.getModificationStamp() == contentAndStamp.documentModificationStamp) {
            return null;
        }
        IdeaGateway.saveDocumentContent(f, d);
        return Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
    }

    @ApiStatus.Internal
    @Nullable
    public Pair<StoredContent, Long> acquireActualContentAndForgetSavedContent(@NotNull VirtualFile f, @Nullable Document d) {
        ContentAndTimestamps contentAndStamp;
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(45);
        }
        if ((contentAndStamp = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY)) == null) {
            return Pair.create((Object)StoredContent.acquireContent(f), (Object)f.getTimeStamp());
        }
        f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, null);
        if (d != null && d.getModificationStamp() == contentAndStamp.documentModificationStamp) {
            return null;
        }
        return Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
    }

    private static void saveDocumentContent(@NotNull VirtualFile f, @NotNull Document d) {
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(46);
        }
        if (d == null) {
            IdeaGateway.$$$reportNull$$$0(47);
        }
        f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, (Object)new ContentAndTimestamps(Clock.getTime(), StoredContent.acquireContent(IdeaGateway.bytesFromDocument(d)), d.getModificationStamp()));
    }

    @NotNull
    public Pair<StoredContent, Long> acquireAndClearCurrentContent(@NotNull VirtualFile f, @Nullable Document d) {
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(48);
        }
        ContentAndTimestamps contentAndStamp = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY);
        f.putUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY, null);
        if (d != null && contentAndStamp != null && d.getModificationStamp() == contentAndStamp.documentModificationStamp) {
            Pair pair = Pair.create((Object)contentAndStamp.content, (Object)contentAndStamp.registeredTimestamp);
            if (pair == null) {
                IdeaGateway.$$$reportNull$$$0(49);
            }
            return pair;
        }
        if (contentAndStamp != null) {
            contentAndStamp.content.release();
        }
        if (d != null) {
            Pair pair = Pair.create((Object)StoredContent.acquireContent(IdeaGateway.bytesFromDocument(d)), (Object)Clock.getTime());
            if (pair == null) {
                IdeaGateway.$$$reportNull$$$0(50);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)StoredContent.acquireContent(f), (Object)f.getTimeStamp());
        if (pair == null) {
            IdeaGateway.$$$reportNull$$$0(51);
        }
        return pair;
    }

    @NotNull
    private static Pair<StoredContent, Long> getActualContentNoAcquire(@NotNull VirtualFile f) {
        ContentAndTimestamps result;
        if (f == null) {
            IdeaGateway.$$$reportNull$$$0(52);
        }
        if ((result = (ContentAndTimestamps)f.getUserData(SAVED_DOCUMENT_CONTENT_AND_STAMP_KEY)) == null) {
            Pair pair = Pair.create((Object)StoredContent.transientContent(f), (Object)f.getTimeStamp());
            if (pair == null) {
                IdeaGateway.$$$reportNull$$$0(53);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)result.content, (Object)result.registeredTimestamp);
        if (pair == null) {
            IdeaGateway.$$$reportNull$$$0(54);
        }
        return pair;
    }

    private static byte @NotNull [] bytesFromDocument(@NotNull Document d) {
        VirtualFile file;
        if (d == null) {
            IdeaGateway.$$$reportNull$$$0(55);
        }
        Charset charset = (file = IdeaGateway.getFile(d)) != null ? file.getCharset() : EncodingRegistry.getInstance().getDefaultCharset();
        byte[] byArray = d.getText().getBytes(charset);
        if (byArray == null) {
            IdeaGateway.$$$reportNull$$$0(56);
        }
        return byArray;
    }

    public String stringFromBytes(byte @NotNull [] bytes, @NotNull String path) {
        VirtualFile file;
        if (path == null) {
            IdeaGateway.$$$reportNull$$$0(57);
        }
        if (bytes == null) {
            IdeaGateway.$$$reportNull$$$0(58);
        }
        Charset charset = (file = this.findVirtualFile(path)) != null ? file.getCharset() : EncodingRegistry.getInstance().getDefaultCharset();
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)charset);
    }

    public void saveAllUnsavedDocuments() {
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    @Nullable
    private static VirtualFile getFile(@NotNull Document d) {
        if (d == null) {
            IdeaGateway.$$$reportNull$$$0(59);
        }
        return FileDocumentManager.getInstance().getFile(d);
    }

    @Nullable
    public Document getDocument(@NotNull String path) {
        VirtualFile file;
        if (path == null) {
            IdeaGateway.$$$reportNull$$$0(60);
        }
        if ((file = this.findVirtualFile(path)) == null) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(file);
    }

    @NotNull
    public FileType getFileType(@NotNull String fileName) {
        if (fileName == null) {
            IdeaGateway.$$$reportNull$$$0(61);
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (fileType == null) {
            IdeaGateway.$$$reportNull$$$0(62);
        }
        return fileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 10, 11, 12, 13, 14, 15, 16, 17, 19, 26, 28, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 52, 55, 57, 58, 59, 60, 61 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/integration/IdeaGateway";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 3: 
            case 5: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 12: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ff";
                break;
            }
            case 15: 
            case 19: 
            case 26: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 42: 
            case 44: 
            case 47: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 26: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 52: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/integration/IdeaGateway";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathOrUrl";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameOrUrlPart";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionedFilterData";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateFileSafely";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateDBChildren";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndIterateChildren";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createTransientRootEntry";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createTransientRootEntryForPath";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createTransientRootEntryForPaths";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRoots";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireAndClearCurrentContent";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualContentNoAcquire";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "bytesFromDocument";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isVersioned";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPathOrUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNameOrUrlPart";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runWithVfsEventsDispatchContext";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "areContentChangesVersioned";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesAreWritable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFile";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateFileSafely";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createTransientRootEntryForPath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createTransientRootEntryForPaths";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createTransientEntry";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createEntryForDeletion";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "doCreateEntry";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "doCreateFileEntry";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "doCreateDirectoryEntries";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "doCreateChildren";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "registerUnsavedDocuments";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "registerDocumentContents";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "acquireAndUpdateActualContent";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "acquireActualContentAndForgetSavedContent";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "saveDocumentContent";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "acquireAndClearCurrentContent";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getActualContentNoAcquire";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "bytesFromDocument";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "stringFromBytes";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 10, 11, 12, 13, 14, 15, 16, 17, 19, 26, 28, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 52, 55, 57, 58, 59, 60, 61 -> new IllegalArgumentException(string);
        };
    }

    protected static final class VersionedFilterData {
        final List<Project> myOpenedProjects = new ArrayList<Project>();
        final List<ProjectFileIndex> myProjectFileIndices = new ArrayList<ProjectFileIndex>();

        VersionedFilterData() {
            Project[] openProjects;
            for (Project each : openProjects = ProjectManager.getInstance().getOpenProjects()) {
                if (each.isDefault() || !each.isInitialized()) continue;
                this.myOpenedProjects.add(each);
                this.myProjectFileIndices.add(ProjectRootManager.getInstance((Project)each).getFileIndex());
            }
        }
    }

    private static final class VfsEventDispatchContext
    implements AutoCloseable {
        final List<? extends VFileEvent> myEvents;
        final boolean myBeforeEvents;
        final VfsEventDispatchContext myPreviousContext;
        VersionedFilterData myFilterData;

        VfsEventDispatchContext(List<? extends VFileEvent> events, boolean beforeEvents) {
            this.myEvents = events;
            this.myBeforeEvents = beforeEvents;
            this.myPreviousContext = ourCurrentEventDispatchContext.get();
            if (this.myPreviousContext != null) {
                this.myFilterData = this.myPreviousContext.myFilterData;
            }
            ourCurrentEventDispatchContext.set(this);
        }

        @Override
        public void close() {
            ourCurrentEventDispatchContext.set(this.myPreviousContext);
            if (this.myPreviousContext != null && this.myPreviousContext.myFilterData == null && this.myFilterData != null) {
                this.myPreviousContext.myFilterData = this.myFilterData;
            }
        }
    }

    private static interface FileTreeVisitor {
        public boolean before(@NotNull VirtualFile var1);

        public void after(@NotNull VirtualFile var1);
    }

    private static class SinglePathVisitor
    implements FileTreeVisitor {
        @NotNull
        private final List<String> myPathsStack;
        private final boolean myIncludeChildren;

        private SinglePathVisitor(@NotNull String path, boolean includeChildren) {
            if (path == null) {
                SinglePathVisitor.$$$reportNull$$$0(0);
            }
            this.myPathsStack = new ArrayList<String>();
            this.myIncludeChildren = includeChildren;
            this.myPathsStack.add(path);
        }

        @Override
        public boolean before(@NotNull VirtualFile child) {
            String targetPath;
            if (child == null) {
                SinglePathVisitor.$$$reportNull$$$0(1);
            }
            if ((targetPath = (String)ContainerUtil.getLastItem(this.myPathsStack)) == null) {
                return false;
            }
            if (this.myIncludeChildren && targetPath.isEmpty()) {
                this.myPathsStack.add("");
                return true;
            }
            String childName = IdeaGateway.getNameOrUrlPart(child);
            if (!targetPath.startsWith(childName)) {
                return false;
            }
            String targetPathRest = targetPath.substring(childName.length());
            if (!targetPathRest.isEmpty() && targetPathRest.charAt(0) != '/') {
                return false;
            }
            if (!targetPathRest.isEmpty() && targetPathRest.charAt(0) == '/') {
                targetPathRest = targetPathRest.substring(1);
            }
            this.myPathsStack.add(targetPathRest);
            return true;
        }

        @Override
        public void after(@NotNull VirtualFile file) {
            if (file == null) {
                SinglePathVisitor.$$$reportNull$$$0(2);
            }
            this.myPathsStack.remove(this.myPathsStack.size() - 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/history/integration/IdeaGateway$SinglePathVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "before";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MergingPathVisitor
    implements FileTreeVisitor {
        private final List<? extends FileTreeVisitor> myVisitors;
        private final int[] myTerminatedAtDepth;
        private int myDepth;

        private MergingPathVisitor(@NotNull List<? extends FileTreeVisitor> visitors) {
            if (visitors == null) {
                MergingPathVisitor.$$$reportNull$$$0(0);
            }
            this.myDepth = 1;
            this.myVisitors = visitors;
            this.myTerminatedAtDepth = new int[visitors.size()];
        }

        @Override
        public boolean before(@NotNull VirtualFile file) {
            int terminatedAt;
            int i;
            if (file == null) {
                MergingPathVisitor.$$$reportNull$$$0(1);
            }
            boolean result = false;
            for (i = 0; i < this.myVisitors.size(); ++i) {
                terminatedAt = this.myTerminatedAtDepth[i];
                if (terminatedAt != 0) continue;
                if (this.myVisitors.get(i).before(file)) {
                    result = true;
                    continue;
                }
                this.myTerminatedAtDepth[i] = this.myDepth;
            }
            if (result) {
                ++this.myDepth;
                return true;
            }
            for (i = 0; i < this.myVisitors.size(); ++i) {
                terminatedAt = this.myTerminatedAtDepth[i];
                if (terminatedAt != this.myDepth) continue;
                this.myTerminatedAtDepth[i] = 0;
            }
            return false;
        }

        @Override
        public void after(@NotNull VirtualFile file) {
            if (file == null) {
                MergingPathVisitor.$$$reportNull$$$0(2);
            }
            --this.myDepth;
            LOG.assertTrue(this.myDepth >= 1);
            for (int i = 0; i < this.myVisitors.size(); ++i) {
                int terminatedAt = this.myTerminatedAtDepth[i];
                if (terminatedAt == this.myDepth) {
                    this.myTerminatedAtDepth[i] = 0;
                    continue;
                }
                if (terminatedAt != 0) continue;
                this.myVisitors.get(i).after(file);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitors";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/history/integration/IdeaGateway$MergingPathVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "before";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record DirectoryEntries(@NotNull DirectoryEntry first, @NotNull DirectoryEntry last) {
        @NotNull
        private final DirectoryEntry first;
        @NotNull
        private final DirectoryEntry last;

        private DirectoryEntries(@NotNull DirectoryEntry first, @NotNull DirectoryEntry last) {
            if (first == null) {
                DirectoryEntries.$$$reportNull$$$0(0);
            }
            if (last == null) {
                DirectoryEntries.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public DirectoryEntry first() {
            DirectoryEntry directoryEntry = this.first;
            if (directoryEntry == null) {
                DirectoryEntries.$$$reportNull$$$0(2);
            }
            return directoryEntry;
        }

        @NotNull
        public DirectoryEntry last() {
            DirectoryEntry directoryEntry = this.last;
            if (directoryEntry == null) {
                DirectoryEntries.$$$reportNull$$$0(3);
            }
            return directoryEntry;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "last";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/history/integration/IdeaGateway$DirectoryEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/history/integration/IdeaGateway$DirectoryEntries";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "first";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "last";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ContentAndTimestamps {
        long registeredTimestamp;
        StoredContent content;
        long documentModificationStamp;

        private ContentAndTimestamps(long registeredTimestamp, StoredContent content, long documentModificationStamp) {
            this.registeredTimestamp = registeredTimestamp;
            this.content = content;
            this.documentModificationStamp = documentModificationStamp;
        }
    }
}

