/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl;

import com.intellij.history.core.Paths;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateEntryChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.MoveChange;
import com.intellij.history.core.changes.RenameChange;
import com.intellij.history.integration.CommonActivity;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ActivityScopeKt;
import com.intellij.platform.lvcs.impl.ChangeSetActivityItem;
import com.intellij.platform.lvcs.impl.ChangeSetActivityItemKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\u000b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001f\u0010\r\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u001b\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/lvcs/impl/ChangeActivityItem;", "Lcom/intellij/platform/lvcs/impl/ChangeSetActivityItem;", "changeSet", "Lcom/intellij/history/core/changes/ChangeSet;", "scope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "<init>", "(Lcom/intellij/history/core/changes/ChangeSet;Lcom/intellij/platform/lvcs/impl/ActivityScope;)V", "name", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getName", "()Ljava/lang/String;", "getNameFromSingleChange", "intellij.platform.lvcs.impl"})
public final class ChangeActivityItem
extends ChangeSetActivityItem {
    @Nullable
    private final String name;

    public ChangeActivityItem(@NotNull ChangeSet changeSet, @NotNull ActivityScope scope) {
        Intrinsics.checkNotNullParameter((Object)changeSet, (String)"changeSet");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(changeSet);
        this.name = this.getName(changeSet, scope);
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    private final String getName(ChangeSet changeSet, ActivityScope scope) {
        String nameFromSingleChange;
        if ((Intrinsics.areEqual((Object)changeSet.getActivityId(), (Object)CommonActivity.ExternalChange) || changeSet.getName() == null) && (nameFromSingleChange = this.getNameFromSingleChange(changeSet, scope)) != null) {
            return nameFromSingleChange;
        }
        if (changeSet.getName() != null) {
            return changeSet.getName();
        }
        if (!ActivityScopeKt.getHasMultipleFiles(scope)) {
            return LocalHistoryBundle.message("activity.item.presentation", new Object[0]);
        }
        return ChangeSetActivityItemKt.access$presentableNameFromPaths(changeSet);
    }

    private final String getNameFromSingleChange(ChangeSet changeSet, ActivityScope scope) {
        String string;
        List<Change> list = changeSet.getChanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getChanges(...)");
        Change change = (Change)CollectionsKt.singleOrNull(list);
        if (change == null) {
            return null;
        }
        Change singleChange = change;
        Change change2 = singleChange;
        if (change2 instanceof CreateEntryChange) {
            Object[] objectArray = new Object[]{Paths.getNameOf(((CreateEntryChange)singleChange).getPath())};
            string = LocalHistoryBundle.message("activity.item.presentation.create.path", objectArray);
        } else if (change2 instanceof DeleteChange) {
            Object[] objectArray = new Object[]{Paths.getNameOf(((DeleteChange)singleChange).getPath())};
            string = LocalHistoryBundle.message("activity.item.presentation.delete.path", objectArray);
        } else if (change2 instanceof RenameChange) {
            Object[] objectArray = new Object[]{((RenameChange)singleChange).getOldName(), Paths.getNameOf(((RenameChange)singleChange).getPath())};
            string = LocalHistoryBundle.message("activity.item.presentation.rename.path", objectArray);
        } else if (change2 instanceof MoveChange) {
            Object[] objectArray = new Object[]{Paths.getNameOf(((MoveChange)singleChange).getPath()), Paths.getNameOf(Paths.getParentOf(((MoveChange)singleChange).getPath()))};
            string = LocalHistoryBundle.message("activity.item.presentation.move.path", objectArray);
        } else if (change2 instanceof ContentChange) {
            if (ActivityScopeKt.getHasMultipleFiles(scope)) {
                Object[] objectArray = new Object[]{Paths.getNameOf(((ContentChange)singleChange).getPath())};
                string = LocalHistoryBundle.message("activity.item.presentation.modify.path", objectArray);
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }
}

