/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MissingClassBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        PsiClass psiClass;
        block10: {
            block9: {
                if (psiElement == null) {
                    MissingClassBodyFixer.$$$reportNull$$$0(0);
                }
                if (psiElement instanceof PsiRecordComponent) {
                    PsiRecordComponent recordComponent = (PsiRecordComponent)psiElement;
                    psiElement = recordComponent.getContainingClass();
                }
                if (!(psiElement instanceof PsiClass)) break block9;
                psiClass = (PsiClass)psiElement;
                if (!(psiElement instanceof PsiTypeParameter)) break block10;
            }
            return;
        }
        if (psiClass.getLBrace() == null) {
            PsiElement lastChild = psiClass.getLastChild();
            int offset = psiClass.getTextRange().getEndOffset();
            if (lastChild instanceof PsiErrorElement) {
                PsiElement previous = lastChild.getPrevSibling();
                offset = previous instanceof PsiWhiteSpace ? previous.getTextRange().getStartOffset() : lastChild.getTextRange().getStartOffset();
            }
            if (psiClass.isRecord() && psiClass.getRecordHeader() == null) {
                editor.getDocument().insertString(offset, (CharSequence)"() {}");
                editor.getCaretModel().moveToOffset(offset + 1);
                processor.setSkipEnter(true);
            } else {
                editor.getDocument().insertString(offset, (CharSequence)"{\n}");
                editor.getCaretModel().moveToOffset(offset);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/MissingClassBodyFixer", "apply"));
    }
}

