/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lang.java.parser.ReferenceParser;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.OldParserWhiteSpaceAndCommentSetHolder;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.BitUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Deprecated
public final class PrattExpressionParser {
    static final int CONDITIONAL_EXPR_PRECEDENCE = 12;
    private static final TokenSet THIS_OR_SUPER = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.THIS_KEYWORD, JavaTokenType.SUPER_KEYWORD});
    private static final TokenSet ID_OR_SUPER = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.SUPER_KEYWORD});
    private static final TokenSet ARGS_LIST_CONTINUE = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.BAD_CHARACTER, JavaTokenType.COMMA, JavaTokenType.INTEGER_LITERAL, JavaTokenType.STRING_LITERAL});
    private static final TokenSet ARGS_LIST_END = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.RPARENTH, JavaTokenType.RBRACE, JavaTokenType.RBRACKET});
    private static final TokenSet POSTFIX_OPS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.PLUSPLUS, JavaTokenType.MINUSMINUS});
    private static final TokenSet PREF_ARITHMETIC_OPS = TokenSet.orSet((TokenSet[])new TokenSet[]{POSTFIX_OPS, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.PLUS, JavaTokenType.MINUS})});
    private static final TokenSet PREFIX_OPS = TokenSet.orSet((TokenSet[])new TokenSet[]{PREF_ARITHMETIC_OPS, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.TILDE, JavaTokenType.EXCL})});
    private static final int MULTIPLICATION_PRECEDENCE = 2;
    private static final int ADDITIVE_PRECEDENCE = 3;
    private static final int SHIFT_PRECEDENCE = 4;
    private static final int COMPARISON_AND_INSTANCEOF_PRECEDENCE = 5;
    private static final int EQUALITY_PRECEDENCE = 6;
    private static final int BITWISE_AND_PRECEDENCE = 7;
    private static final int BITWISE_XOR_PRECEDENCE = 8;
    private static final int BITWISE_OR_PRECEDENCE = 9;
    private static final int LOGICAL_AND_PRECEDENCE = 10;
    private static final int LOGICAL_OR_PRECEDENCE = 11;
    private static final int ASSIGNMENT_PRECEDENCE = 13;
    private final Map<IElementType, ParserData> ourInfixParsers;
    private final TokenSet TYPE_START;
    private final JavaParser myParser;
    private final OldParserWhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder;

    public PrattExpressionParser(@NotNull JavaParser parser) {
        if (parser == null) {
            PrattExpressionParser.$$$reportNull$$$0(0);
        }
        this.TYPE_START = TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.PRIMITIVE_TYPE_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.AT})});
        this.myWhiteSpaceAndCommentSetHolder = OldParserWhiteSpaceAndCommentSetHolder.INSTANCE;
        this.myParser = parser;
        this.ourInfixParsers = new HashMap<IElementType, ParserData>();
        AssignmentParser assignmentParser = new AssignmentParser();
        PolyExprParser polyExprParser = new PolyExprParser();
        InstanceofParser instanceofParser = new InstanceofParser();
        ConditionalExprParser conditionalExprParser = new ConditionalExprParser();
        for (IElementType type : Arrays.asList(JavaTokenType.EQ, JavaTokenType.ASTERISKEQ, JavaTokenType.DIVEQ, JavaTokenType.PERCEQ, JavaTokenType.PLUSEQ, JavaTokenType.MINUSEQ, JavaTokenType.LTLTEQ, JavaTokenType.GTGTEQ, JavaTokenType.GTGTGTEQ, JavaTokenType.ANDEQ, JavaTokenType.OREQ, JavaTokenType.XOREQ)) {
            this.ourInfixParsers.put(type, new ParserData(13, assignmentParser));
        }
        for (IElementType type : Arrays.asList(JavaTokenType.PLUS, JavaTokenType.MINUS)) {
            this.ourInfixParsers.put(type, new ParserData(3, polyExprParser));
        }
        for (IElementType type : Arrays.asList(JavaTokenType.DIV, JavaTokenType.ASTERISK, JavaTokenType.PERC)) {
            this.ourInfixParsers.put(type, new ParserData(2, polyExprParser));
        }
        for (IElementType type : Arrays.asList(JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT)) {
            this.ourInfixParsers.put(type, new ParserData(4, polyExprParser));
        }
        for (IElementType type : Arrays.asList(JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE)) {
            this.ourInfixParsers.put(type, new ParserData(5, polyExprParser));
        }
        this.ourInfixParsers.put(JavaTokenType.INSTANCEOF_KEYWORD, new ParserData(5, instanceofParser));
        for (IElementType type : Arrays.asList(JavaTokenType.EQEQ, JavaTokenType.NE)) {
            this.ourInfixParsers.put(type, new ParserData(6, polyExprParser));
        }
        this.ourInfixParsers.put(JavaTokenType.OR, new ParserData(9, polyExprParser));
        this.ourInfixParsers.put(JavaTokenType.AND, new ParserData(7, polyExprParser));
        this.ourInfixParsers.put(JavaTokenType.XOR, new ParserData(8, polyExprParser));
        this.ourInfixParsers.put(JavaTokenType.ANDAND, new ParserData(10, polyExprParser));
        this.ourInfixParsers.put(JavaTokenType.OROR, new ParserData(11, polyExprParser));
        this.ourInfixParsers.put(JavaTokenType.QUEST, new ParserData(12, conditionalExprParser));
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder) {
        if (builder == null) {
            PrattExpressionParser.$$$reportNull$$$0(1);
        }
        return this.tryParseWithPrecedenceAtMost(builder, 13, 0);
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder, int mode) {
        if (builder == null) {
            PrattExpressionParser.$$$reportNull$$$0(2);
        }
        return this.tryParseWithPrecedenceAtMost(builder, 13, mode);
    }

    @Nullable
    public PsiBuilder.Marker tryParseWithPrecedenceAtMost(@NotNull PsiBuilder builder, int maxPrecedence, int mode) {
        int opPrecedence;
        ParserData data;
        IElementType type;
        PsiBuilder.Marker lhs;
        if (builder == null) {
            PrattExpressionParser.$$$reportNull$$$0(3);
        }
        if ((lhs = this.parseUnary(builder, mode)) == null) {
            return null;
        }
        while ((type = PrattExpressionParser.getBinOpToken(builder)) != null && (data = this.ourInfixParsers.get(type)) != null && maxPrecedence >= (opPrecedence = data.myPrecedence)) {
            PsiBuilder.Marker beforeLhs = lhs.precede();
            data.myParser.parse(this, builder, beforeLhs, type, opPrecedence, mode);
            lhs = beforeLhs;
        }
        return lhs;
    }

    @Nullable
    private PsiBuilder.Marker parseUnary(PsiBuilder builder, int mode) {
        IElementType tokenType = builder.getTokenType();
        if (PREFIX_OPS.contains(tokenType)) {
            PsiBuilder.Marker unary = builder.mark();
            builder.advanceLexer();
            PsiBuilder.Marker operand = this.parseUnary(builder, mode);
            if (operand == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            unary.done(ElementType.PREFIX_EXPRESSION);
            return unary;
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker typeCast = builder.mark();
            builder.advanceLexer();
            ReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, 101);
            if (typeInfo == null || !PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
                typeCast.rollbackTo();
                return this.parsePostfix(builder, mode);
            }
            if (PREF_ARITHMETIC_OPS.contains(builder.getTokenType()) && !typeInfo.isPrimitive) {
                typeCast.rollbackTo();
                return this.parsePostfix(builder, mode);
            }
            PsiBuilder.Marker expr = this.parseUnary(builder, mode);
            if (expr == null) {
                if (!typeInfo.isParameterized) {
                    typeCast.rollbackTo();
                    return this.parsePostfix(builder, mode);
                }
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            typeCast.done(ElementType.TYPE_CAST_EXPRESSION);
            return typeCast;
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.myParser.getStatementParser().parseExprInParenthWithBlock(builder, ElementType.SWITCH_EXPRESSION, true);
        }
        return this.parsePostfix(builder, mode);
    }

    @Nullable
    private PsiBuilder.Marker parsePostfix(PsiBuilder builder, int mode) {
        PsiBuilder.Marker operand = this.parsePrimary(builder, null, -1, mode);
        if (operand == null) {
            return null;
        }
        while (POSTFIX_OPS.contains(builder.getTokenType())) {
            PsiBuilder.Marker postfix = operand.precede();
            builder.advanceLexer();
            postfix.done(ElementType.POSTFIX_EXPRESSION);
            operand = postfix;
        }
        return operand;
    }

    @Nullable
    private PsiBuilder.Marker parsePrimary(PsiBuilder builder, @Nullable BreakPoint breakPoint, int breakOffset, int mode) {
        IElementType tokenType;
        PsiBuilder.Marker startMarker = builder.mark();
        PsiBuilder.Marker expr = this.parsePrimaryExpressionStart(builder, mode);
        if (expr == null) {
            startMarker.drop();
            return null;
        }
        while (true) {
            if ((tokenType = builder.getTokenType()) == JavaTokenType.DOT) {
                PsiBuilder.Marker refExpr;
                int offset;
                PsiBuilder.Marker copy;
                PsiBuilder.Marker dotPos = builder.mark();
                int dotOffset = builder.getCurrentOffset();
                builder.advanceLexer();
                IElementType dotTokenType = builder.getTokenType();
                if (dotTokenType == JavaTokenType.AT) {
                    this.myParser.getDeclarationParser().parseAnnotations(builder);
                    dotTokenType = builder.getTokenType();
                }
                if (dotTokenType == JavaTokenType.CLASS_KEYWORD && JavaParserUtil.exprType(expr) == ElementType.REFERENCE_EXPRESSION) {
                    if (breakPoint == BreakPoint.P1 && builder.getCurrentOffset() == breakOffset) {
                        JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                        PsiBuilderUtil.drop((PsiBuilder.Marker[])new PsiBuilder.Marker[]{startMarker, dotPos});
                        return expr;
                    }
                    copy = startMarker.precede();
                    offset = builder.getCurrentOffset();
                    startMarker.rollbackTo();
                    PsiBuilder.Marker classObjAccess = this.parseClassAccessOrMethodReference(builder);
                    if (classObjAccess == null || builder.getCurrentOffset() < offset) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P1, offset, mode);
                    }
                    startMarker = copy;
                    expr = classObjAccess;
                    continue;
                }
                if (dotTokenType == JavaTokenType.NEW_KEYWORD) {
                    dotPos.drop();
                    expr = this.parseNew(builder, expr);
                    continue;
                }
                if (dotTokenType == JavaTokenType.SUPER_KEYWORD && builder.lookAhead(1) == JavaTokenType.LPARENTH) {
                    dotPos.drop();
                    refExpr = expr.precede();
                    builder.mark().done(ElementType.REFERENCE_PARAMETER_LIST);
                    builder.advanceLexer();
                    refExpr.done(ElementType.REFERENCE_EXPRESSION);
                    expr = refExpr;
                    continue;
                }
                if (dotTokenType == JavaTokenType.STRING_TEMPLATE_BEGIN || dotTokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN) {
                    dotPos.drop();
                    expr = this.parseStringTemplate(builder, expr, dotTokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN);
                    continue;
                }
                if (dotTokenType == JavaTokenType.STRING_LITERAL || dotTokenType == JavaTokenType.TEXT_BLOCK_LITERAL) {
                    dotPos.drop();
                    PsiBuilder.Marker templateExpression = expr.precede();
                    PsiBuilder.Marker literal = builder.mark();
                    builder.advanceLexer();
                    literal.done(ElementType.LITERAL_EXPRESSION);
                    templateExpression.done(ElementType.TEMPLATE_EXPRESSION);
                    expr = templateExpression;
                    continue;
                }
                if (THIS_OR_SUPER.contains(dotTokenType) && JavaParserUtil.exprType(expr) == ElementType.REFERENCE_EXPRESSION) {
                    if (breakPoint == BreakPoint.P2 && builder.getCurrentOffset() == breakOffset) {
                        dotPos.rollbackTo();
                        startMarker.drop();
                        return expr;
                    }
                    copy = startMarker.precede();
                    offset = builder.getCurrentOffset();
                    startMarker.rollbackTo();
                    PsiBuilder.Marker ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, false, true, false, false);
                    if (ref == null || builder.getTokenType() != JavaTokenType.DOT || builder.getCurrentOffset() != dotOffset) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P2, offset, mode);
                    }
                    builder.advanceLexer();
                    if (builder.getTokenType() != dotTokenType) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P2, offset, mode);
                    }
                    builder.advanceLexer();
                    startMarker = copy;
                    expr = ref.precede();
                    expr.done(dotTokenType == JavaTokenType.THIS_KEYWORD ? ElementType.THIS_EXPRESSION : ElementType.SUPER_EXPRESSION);
                    continue;
                }
                refExpr = expr.precede();
                this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
                if (!PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)ID_OR_SUPER)) {
                    dotPos.rollbackTo();
                    builder.advanceLexer();
                    this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                    refExpr.done(ElementType.REFERENCE_EXPRESSION);
                    startMarker.drop();
                    return refExpr;
                }
                dotPos.drop();
                refExpr.done(ElementType.REFERENCE_EXPRESSION);
                expr = refExpr;
                continue;
            }
            if (tokenType == JavaTokenType.LPARENTH) {
                if (JavaParserUtil.exprType(expr) != ElementType.REFERENCE_EXPRESSION) {
                    startMarker.drop();
                    return expr;
                }
                PsiBuilder.Marker callExpr = expr.precede();
                this.parseArgumentList(builder);
                callExpr.done(ElementType.METHOD_CALL_EXPRESSION);
                expr = callExpr;
                continue;
            }
            if (tokenType != JavaTokenType.LBRACKET) break;
            if (breakPoint == BreakPoint.P4) {
                startMarker.drop();
                return expr;
            }
            builder.advanceLexer();
            if (builder.getTokenType() == JavaTokenType.RBRACKET && JavaParserUtil.exprType(expr) == ElementType.REFERENCE_EXPRESSION) {
                int pos = builder.getCurrentOffset();
                PsiBuilder.Marker copy = startMarker.precede();
                startMarker.rollbackTo();
                PsiBuilder.Marker classObjAccess = this.parseClassAccessOrMethodReference(builder);
                if (classObjAccess == null || builder.getCurrentOffset() <= pos) {
                    copy.rollbackTo();
                    return this.parsePrimary(builder, BreakPoint.P4, -1, mode);
                }
                startMarker = copy;
                expr = classObjAccess;
                continue;
            }
            PsiBuilder.Marker arrayAccess = expr.precede();
            PsiBuilder.Marker index = this.parse(builder, mode);
            if (index == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
                arrayAccess.done(ElementType.ARRAY_ACCESS_EXPRESSION);
                startMarker.drop();
                return arrayAccess;
            }
            if (builder.getTokenType() != JavaTokenType.RBRACKET) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rbracket", new Object[0]));
                arrayAccess.done(ElementType.ARRAY_ACCESS_EXPRESSION);
                startMarker.drop();
                return arrayAccess;
            }
            builder.advanceLexer();
            arrayAccess.done(ElementType.ARRAY_ACCESS_EXPRESSION);
            expr = arrayAccess;
        }
        if (tokenType == JavaTokenType.DOUBLE_COLON) {
            return this.parseMethodReference(builder, startMarker);
        }
        startMarker.drop();
        return expr;
    }

    @Nullable
    private PsiBuilder.Marker parsePrimaryExpressionStart(PsiBuilder builder, int mode) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN || tokenType == JavaTokenType.STRING_TEMPLATE_BEGIN) {
            return this.parseStringTemplate(builder, null, tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN);
        }
        if (ElementType.ALL_LITERALS.contains(tokenType)) {
            PsiBuilder.Marker literal = builder.mark();
            builder.advanceLexer();
            literal.done(ElementType.LITERAL_EXPRESSION);
            return literal;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseArrayInitializer(builder);
        }
        if (tokenType == JavaTokenType.NEW_KEYWORD) {
            return this.parseNew(builder, null);
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker lambda;
            if (!BitUtil.isSet((int)mode, (int)1) && (lambda = this.parseLambdaAfterParenth(builder)) != null) {
                return lambda;
            }
            PsiBuilder.Marker parenth = builder.mark();
            builder.advanceLexer();
            PsiBuilder.Marker inner = this.parse(builder, mode);
            if (inner == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH) && inner != null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
            }
            parenth.done(ElementType.PARENTH_EXPRESSION);
            return parenth;
        }
        if (this.TYPE_START.contains(tokenType)) {
            PsiBuilder.Marker mark = builder.mark();
            ReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, 0);
            if (typeInfo != null) {
                PsiBuilder.Marker result;
                boolean optionalClassKeyword;
                boolean bl = optionalClassKeyword = typeInfo.isPrimitive || typeInfo.isArray;
                if ((optionalClassKeyword || !typeInfo.hasErrors && typeInfo.isParameterized) && (result = this.parseClassAccessOrMethodReference(builder, mark, optionalClassKeyword)) != null) {
                    return result;
                }
            }
            mark.rollbackTo();
        }
        PsiBuilder.Marker annotation = null;
        if (tokenType == JavaTokenType.AT) {
            annotation = this.myParser.getDeclarationParser().parseAnnotations(builder);
            tokenType = builder.getTokenType();
        }
        if (tokenType == JavaTokenType.VAR_KEYWORD) {
            tokenType = JavaTokenType.IDENTIFIER;
            builder.remapCurrentToken(tokenType);
        }
        if (tokenType == JavaTokenType.IDENTIFIER) {
            PsiBuilder.Marker refExpr;
            if (!BitUtil.isSet((int)mode, (int)1) && builder.lookAhead(1) == JavaTokenType.ARROW) {
                return this.parseLambdaExpression(builder, false);
            }
            if (annotation != null) {
                PsiBuilder.Marker refParam = annotation.precede();
                refParam.doneBefore(ElementType.REFERENCE_PARAMETER_LIST, annotation);
                refExpr = refParam.precede();
            } else {
                refExpr = builder.mark();
                builder.mark().done(ElementType.REFERENCE_PARAMETER_LIST);
            }
            builder.advanceLexer();
            refExpr.done(ElementType.REFERENCE_EXPRESSION);
            return refExpr;
        }
        if (annotation != null) {
            annotation.rollbackTo();
            tokenType = builder.getTokenType();
        }
        PsiBuilder.Marker expr = null;
        if (tokenType == JavaTokenType.LT) {
            expr = builder.mark();
            if (!this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false)) {
                expr.rollbackTo();
                return null;
            }
            tokenType = builder.getTokenType();
            if (!THIS_OR_SUPER.contains(tokenType)) {
                expr.rollbackTo();
                return null;
            }
        }
        if (THIS_OR_SUPER.contains(tokenType)) {
            if (expr == null) {
                expr = builder.mark();
                builder.mark().done(ElementType.REFERENCE_PARAMETER_LIST);
            }
            builder.advanceLexer();
            expr.done(builder.getTokenType() == JavaTokenType.LPARENTH ? ElementType.REFERENCE_EXPRESSION : (tokenType == JavaTokenType.THIS_KEYWORD ? ElementType.THIS_EXPRESSION : ElementType.SUPER_EXPRESSION));
            return expr;
        }
        return null;
    }

    @Nullable
    private PsiBuilder.Marker parseClassAccessOrMethodReference(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        boolean primitive = ElementType.PRIMITIVE_TYPE_BIT_SET.contains(builder.getTokenType());
        if (this.myParser.getReferenceParser().parseType(builder, 0) == null) {
            expr.drop();
            return null;
        }
        PsiBuilder.Marker result = this.parseClassAccessOrMethodReference(builder, expr, primitive);
        if (result == null) {
            expr.rollbackTo();
        }
        return result;
    }

    @Nullable
    private PsiBuilder.Marker parseClassAccessOrMethodReference(PsiBuilder builder, PsiBuilder.Marker expr, boolean optionalClassKeyword) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.DOT) {
            return PrattExpressionParser.parseClassObjectAccess(builder, expr, optionalClassKeyword);
        }
        if (tokenType == JavaTokenType.DOUBLE_COLON) {
            return this.parseMethodReference(builder, expr);
        }
        return null;
    }

    @NotNull
    private PsiBuilder.Marker parseMethodReference(PsiBuilder builder, PsiBuilder.Marker start) {
        builder.advanceLexer();
        this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER) && !PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.NEW_KEYWORD)) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
        }
        start.done(ElementType.METHOD_REF_EXPRESSION);
        PsiBuilder.Marker marker = start;
        if (marker == null) {
            PrattExpressionParser.$$$reportNull$$$0(4);
        }
        return marker;
    }

    private PsiBuilder.Marker parseStringTemplate(PsiBuilder builder, PsiBuilder.Marker start, boolean textBlock) {
        IElementType tokenType;
        PsiBuilder.Marker templateExpression = start == null ? builder.mark() : start.precede();
        PsiBuilder.Marker template = builder.mark();
        do {
            builder.advanceLexer();
            tokenType = builder.getTokenType();
            if (textBlock ? tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_MID || tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_END : tokenType == JavaTokenType.STRING_TEMPLATE_MID || tokenType == JavaTokenType.STRING_TEMPLATE_END) {
                PrattExpressionParser.emptyExpression(builder);
                continue;
            }
            this.parse(builder);
            tokenType = builder.getTokenType();
        } while (!textBlock ? tokenType == JavaTokenType.STRING_TEMPLATE_MID : tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_MID);
        if (textBlock ? tokenType != JavaTokenType.TEXT_BLOCK_TEMPLATE_END : tokenType != JavaTokenType.STRING_TEMPLATE_END) {
            builder.error(JavaPsiBundle.message("expected.template.fragment", new Object[0]));
        } else {
            builder.advanceLexer();
        }
        template.done(ElementType.TEMPLATE);
        templateExpression.done(ElementType.TEMPLATE_EXPRESSION);
        return templateExpression;
    }

    @NotNull
    private PsiBuilder.Marker parseNew(PsiBuilder builder, @Nullable PsiBuilder.Marker start) {
        int dimCount;
        PsiBuilder.Marker anno;
        PsiBuilder.Marker newExpr;
        block19: {
            PsiBuilder.Marker refOrType;
            newExpr = start != null ? start.precede() : builder.mark();
            builder.advanceLexer();
            this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, true);
            anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.IDENTIFIER) {
                PsiBuilderUtil.rollbackTo((PsiBuilder.Marker)anno);
                refOrType = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, true, true);
                if (refOrType == null) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                    newExpr.done(ElementType.NEW_EXPRESSION);
                    PsiBuilder.Marker marker = newExpr;
                    if (marker == null) {
                        PrattExpressionParser.$$$reportNull$$$0(5);
                    }
                    return marker;
                }
            } else if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) {
                refOrType = null;
                builder.advanceLexer();
            } else {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                newExpr.done(ElementType.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    PrattExpressionParser.$$$reportNull$$$0(6);
                }
                return marker;
            }
            if (refOrType != null && builder.getTokenType() == JavaTokenType.LPARENTH) {
                this.parseArgumentList(builder);
                if (builder.getTokenType() == JavaTokenType.LBRACE) {
                    PsiBuilder.Marker classElement = refOrType.precede();
                    this.myParser.getDeclarationParser().parseClassBodyWithBraces(builder, false, false);
                    classElement.done(ElementType.ANONYMOUS_CLASS);
                }
                newExpr.done(ElementType.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    PrattExpressionParser.$$$reportNull$$$0(7);
                }
                return marker;
            }
            anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
            if (builder.getTokenType() != JavaTokenType.LBRACKET) {
                PsiBuilderUtil.rollbackTo((PsiBuilder.Marker)anno);
                JavaParserUtil.error(builder, JavaPsiBundle.message(refOrType == null ? "expected.lbracket" : "expected.lparen.or.lbracket", new Object[0]));
                newExpr.done(ElementType.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    PrattExpressionParser.$$$reportNull$$$0(8);
                }
                return marker;
            }
            int bracketCount = 0;
            dimCount = 0;
            do {
                PsiBuilder.Marker dimExpr;
                anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
                if (builder.getTokenType() != JavaTokenType.LBRACKET) break block19;
                builder.advanceLexer();
                if (bracketCount == dimCount && (dimExpr = this.parse(builder, 0)) != null) {
                    ++dimCount;
                }
                ++bracketCount;
            } while (JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACKET, "expected.rbracket"));
            newExpr.done(ElementType.NEW_EXPRESSION);
            PsiBuilder.Marker marker = newExpr;
            if (marker == null) {
                PrattExpressionParser.$$$reportNull$$$0(9);
            }
            return marker;
        }
        PsiBuilderUtil.rollbackTo((PsiBuilder.Marker)anno);
        if (dimCount == 0) {
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                this.parseArrayInitializer(builder);
            } else {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.array.initializer", new Object[0]));
            }
        }
        newExpr.done(ElementType.NEW_EXPRESSION);
        PsiBuilder.Marker marker = newExpr;
        if (marker == null) {
            PrattExpressionParser.$$$reportNull$$$0(10);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseArrayInitializer(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseArrayInitializer(builder, ElementType.ARRAY_INITIALIZER_EXPRESSION, this::parse, "expected.expression");
        if (marker == null) {
            PrattExpressionParser.$$$reportNull$$$0(11);
        }
        return marker;
    }

    @NotNull
    public PsiBuilder.Marker parseArrayInitializer(@NotNull PsiBuilder builder, @NotNull IElementType type, @NotNull Function<? super PsiBuilder, PsiBuilder.Marker> elementParser, @NotNull @PropertyKey(resourceBundle="messages.JavaPsiBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaPsiBundle") String missingElementKey) {
        if (builder == null) {
            PrattExpressionParser.$$$reportNull$$$0(12);
        }
        if (type == null) {
            PrattExpressionParser.$$$reportNull$$$0(13);
        }
        if (elementParser == null) {
            PrattExpressionParser.$$$reportNull$$$0(14);
        }
        if (missingElementKey == null) {
            PrattExpressionParser.$$$reportNull$$$0(15);
        }
        PsiBuilder.Marker arrayInit = builder.mark();
        builder.advanceLexer();
        boolean first = true;
        while (true) {
            if (builder.getTokenType() == JavaTokenType.RBRACE) {
                builder.advanceLexer();
                break;
            }
            if (builder.getTokenType() == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rbrace", new Object[0]));
                break;
            }
            if (elementParser.apply((PsiBuilder)builder) == null) {
                if (builder.getTokenType() == JavaTokenType.COMMA) {
                    if (first && builder.lookAhead(1) == JavaTokenType.RBRACE) {
                        PsiBuilderUtil.advance((PsiBuilder)builder, (int)2);
                        break;
                    }
                    builder.error(JavaPsiBundle.message(missingElementKey, new Object[0]));
                } else if (builder.getTokenType() != JavaTokenType.RBRACE) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rbrace", new Object[0]));
                    break;
                }
            }
            first = false;
            IElementType tokenType = builder.getTokenType();
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.COMMA) || tokenType == JavaTokenType.RBRACE) continue;
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.comma", new Object[0]));
        }
        arrayInit.done(type);
        PsiBuilder.Marker marker = arrayInit;
        if (marker == null) {
            PrattExpressionParser.$$$reportNull$$$0(16);
        }
        return marker;
    }

    @NotNull
    public PsiBuilder.Marker parseArgumentList(PsiBuilder builder) {
        PsiBuilder.Marker list = builder.mark();
        builder.advanceLexer();
        boolean first = true;
        while (true) {
            IElementType tokenType = builder.getTokenType();
            if (first && (ARGS_LIST_END.contains(tokenType) || builder.eof()) || !first && !ARGS_LIST_CONTINUE.contains(tokenType)) break;
            boolean hasError = false;
            if (!first) {
                if (builder.getTokenType() == JavaTokenType.COMMA) {
                    builder.advanceLexer();
                } else {
                    hasError = true;
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.comma.or.rparen", new Object[0]));
                    PrattExpressionParser.emptyExpression(builder);
                }
            }
            first = false;
            PsiBuilder.Marker arg = this.parse(builder, 0);
            if (arg != null) continue;
            if (!hasError) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
                PrattExpressionParser.emptyExpression(builder);
            }
            if (!ARGS_LIST_CONTINUE.contains(builder.getTokenType())) break;
            if (builder.getTokenType() == JavaTokenType.COMMA || builder.eof()) continue;
            builder.advanceLexer();
        }
        boolean closed = true;
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
            if (first) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
            } else {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.comma.or.rparen", new Object[0]));
            }
            closed = false;
        }
        list.done(ElementType.EXPRESSION_LIST);
        if (!closed) {
            list.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        PsiBuilder.Marker marker = list;
        if (marker == null) {
            PrattExpressionParser.$$$reportNull$$$0(17);
        }
        return marker;
    }

    @Nullable
    private PsiBuilder.Marker parseLambdaAfterParenth(PsiBuilder builder) {
        boolean isTyped;
        boolean isLambda;
        IElementType nextToken1 = builder.lookAhead(1);
        IElementType nextToken2 = builder.lookAhead(2);
        if (nextToken1 == JavaTokenType.RPARENTH && nextToken2 == JavaTokenType.ARROW) {
            isLambda = true;
            isTyped = false;
        } else if (nextToken1 == JavaTokenType.AT || ElementType.MODIFIER_BIT_SET.contains(nextToken1) || ElementType.PRIMITIVE_TYPE_BIT_SET.contains(nextToken1)) {
            isLambda = true;
            isTyped = true;
        } else if (nextToken1 == JavaTokenType.IDENTIFIER) {
            if (nextToken2 == JavaTokenType.COMMA || nextToken2 == JavaTokenType.RPARENTH && builder.lookAhead(3) == JavaTokenType.ARROW) {
                isLambda = true;
                isTyped = false;
            } else if (nextToken2 == JavaTokenType.ARROW) {
                isLambda = false;
                isTyped = false;
            } else {
                boolean lambda = false;
                PsiBuilder.Marker marker = builder.mark();
                builder.advanceLexer();
                ReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, 6);
                if (typeInfo != null) {
                    IElementType t = builder.getTokenType();
                    lambda = t == JavaTokenType.IDENTIFIER || t == JavaTokenType.THIS_KEYWORD || t == JavaTokenType.RPARENTH && builder.lookAhead(1) == JavaTokenType.ARROW;
                }
                marker.rollbackTo();
                isLambda = lambda;
                isTyped = true;
            }
        } else {
            isLambda = false;
            isTyped = false;
        }
        return isLambda ? this.parseLambdaExpression(builder, isTyped) : null;
    }

    @Nullable
    private PsiBuilder.Marker parseLambdaExpression(PsiBuilder builder, boolean typed) {
        PsiBuilder.Marker start = builder.mark();
        this.myParser.getDeclarationParser().parseLambdaParameterList(builder, typed);
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.ARROW)) {
            start.rollbackTo();
            return null;
        }
        PsiBuilder.Marker body = builder.getTokenType() == JavaTokenType.LBRACE ? this.myParser.getStatementParser().parseCodeBlock(builder) : this.parse(builder, 0);
        if (body == null) {
            builder.error(JavaPsiBundle.message("expected.lbrace", new Object[0]));
        }
        start.done(ElementType.LAMBDA_EXPRESSION);
        return start;
    }

    @Nullable
    private static PsiBuilder.Marker parseClassObjectAccess(PsiBuilder builder, PsiBuilder.Marker expr, boolean optionalClassKeyword) {
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == JavaTokenType.CLASS_KEYWORD) {
            mark.drop();
            builder.advanceLexer();
        } else {
            if (!optionalClassKeyword) {
                return null;
            }
            mark.rollbackTo();
            builder.error(JavaPsiBundle.message("class.literal.expected", new Object[0]));
        }
        expr.done(ElementType.CLASS_OBJECT_ACCESS_EXPRESSION);
        return expr;
    }

    private static void emptyExpression(PsiBuilder builder) {
        JavaParserUtil.emptyElement(builder, ElementType.EMPTY_EXPRESSION);
    }

    private static IElementType getBinOpToken(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType != JavaTokenType.GT) {
            return tokenType;
        }
        if (builder.rawLookup(1) == JavaTokenType.GT) {
            if (builder.rawLookup(2) == JavaTokenType.GT) {
                if (builder.rawLookup(3) == JavaTokenType.EQ) {
                    return JavaTokenType.GTGTGTEQ;
                }
                return JavaTokenType.GTGTGT;
            }
            if (builder.rawLookup(2) == JavaTokenType.EQ) {
                return JavaTokenType.GTGTEQ;
            }
            return JavaTokenType.GTGT;
        }
        if (builder.rawLookup(1) == JavaTokenType.EQ) {
            return JavaTokenType.GE;
        }
        return tokenType;
    }

    private static void advanceBinOpToken(PsiBuilder builder, IElementType type) {
        PsiBuilder.Marker gtToken = builder.mark();
        if (type == JavaTokenType.GTGTGTEQ) {
            PsiBuilderUtil.advance((PsiBuilder)builder, (int)4);
        } else if (type == JavaTokenType.GTGTGT || type == JavaTokenType.GTGTEQ) {
            PsiBuilderUtil.advance((PsiBuilder)builder, (int)3);
        } else if (type == JavaTokenType.GTGT || type == JavaTokenType.GE) {
            PsiBuilderUtil.advance((PsiBuilder)builder, (int)2);
        } else {
            gtToken.drop();
            builder.advanceLexer();
            return;
        }
        gtToken.collapse(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/PrattExpressionParser";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementParser";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingElementKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/PrattExpressionParser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMethodReference";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNew";
                break;
            }
            case 11: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArrayInitializer";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryParseWithPrecedenceAtMost";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseArrayInitializer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class AssignmentParser
    implements InfixParser {
        private AssignmentParser() {
        }

        @Override
        public void parse(PrattExpressionParser parser, PsiBuilder builder, PsiBuilder.Marker beforeLhs, IElementType binOpType, int currentPrecedence, int mode) {
            PrattExpressionParser.advanceBinOpToken(builder, binOpType);
            PsiBuilder.Marker right = parser.tryParseWithPrecedenceAtMost(builder, 13, mode);
            if (right == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            JavaParserUtil.done(beforeLhs, ElementType.ASSIGNMENT_EXPRESSION, builder, PrattExpressionParser.this.myWhiteSpaceAndCommentSetHolder);
        }
    }

    private final class PolyExprParser
    implements InfixParser {
        private PolyExprParser() {
        }

        @Override
        public void parse(PrattExpressionParser parser, PsiBuilder builder, PsiBuilder.Marker beforeLhs, IElementType binOpType, int currentPrecedence, int mode) {
            IElementType nextToken;
            int operandCount = 1;
            do {
                PrattExpressionParser.advanceBinOpToken(builder, binOpType);
                PsiBuilder.Marker rhs = parser.tryParseWithPrecedenceAtMost(builder, currentPrecedence - 1, mode);
                if (rhs == null) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
                }
                ++operandCount;
            } while ((nextToken = PrattExpressionParser.getBinOpToken(builder)) == binOpType);
            JavaParserUtil.done(beforeLhs, operandCount > 2 ? ElementType.POLYADIC_EXPRESSION : ElementType.BINARY_EXPRESSION, builder, PrattExpressionParser.this.myWhiteSpaceAndCommentSetHolder);
        }
    }

    private static final class InstanceofParser
    implements InfixParser {
        private InstanceofParser() {
        }

        @Override
        public void parse(PrattExpressionParser parser, PsiBuilder builder, PsiBuilder.Marker beforeLhs, IElementType binOpType, int currentPrecedence, int mode) {
            builder.advanceLexer();
            JavaParser javaParser = parser.myParser;
            if (!javaParser.getPatternParser().isPattern(builder)) {
                PsiBuilder.Marker type = javaParser.getReferenceParser().parseType(builder, 5);
                if (type == null) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.type", new Object[0]));
                }
            } else {
                javaParser.getPatternParser().parsePrimaryPattern(builder, false);
            }
            beforeLhs.done(ElementType.INSTANCE_OF_EXPRESSION);
        }
    }

    private static final class ConditionalExprParser
    implements InfixParser {
        private ConditionalExprParser() {
        }

        @Override
        public void parse(PrattExpressionParser parser, PsiBuilder builder, PsiBuilder.Marker beforeLhs, IElementType binOpType, int currentPrecedence, int mode) {
            builder.advanceLexer();
            PsiBuilder.Marker truePart = parser.parse(builder, mode);
            if (truePart == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
                beforeLhs.done(ElementType.CONDITIONAL_EXPRESSION);
                return;
            }
            if (builder.getTokenType() != JavaTokenType.COLON) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.colon", new Object[0]));
                beforeLhs.done(ElementType.CONDITIONAL_EXPRESSION);
                return;
            }
            builder.advanceLexer();
            PsiBuilder.Marker falsePart = parser.tryParseWithPrecedenceAtMost(builder, 12, mode);
            if (falsePart == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            beforeLhs.done(ElementType.CONDITIONAL_EXPRESSION);
        }
    }

    private static final class ParserData {
        private final int myPrecedence;
        private final InfixParser myParser;

        private ParserData(int precedence, InfixParser parser) {
            this.myPrecedence = precedence;
            this.myParser = parser;
        }
    }

    private static interface InfixParser {
        public void parse(PrattExpressionParser var1, PsiBuilder var2, PsiBuilder.Marker var3, IElementType var4, int var5, int var6);
    }

    private static enum BreakPoint {
        P1,
        P2,
        P4;

    }
}

