/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.PsiAwareDefaultLineWrapPositionStrategy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaLineWrapPositionStrategy
extends PsiAwareDefaultLineWrapPositionStrategy {
    private static final IElementType[] ALLOWED_TYPES = new IElementType[]{JavaTokenType.C_STYLE_COMMENT, JavaTokenType.END_OF_LINE_COMMENT, JavaTokenType.STRING_LITERAL, JavaDocTokenType.DOC_COMMENT_DATA, JavaTokenType.EQ, JavaTokenType.COMMA, JavaTokenType.QUEST, JavaTokenType.COLON};
    public static final String A_LINK_START = "<a";
    public static final String A_LINK_END = "</a>";
    public static final String PRE_TAG_START = "<pre";
    public static final String PRE_TAG_END = "</pre>";

    public JavaLineWrapPositionStrategy() {
        super(true, ALLOWED_TYPES);
    }

    protected int doCalculateWrapPosition(@NotNull Document document, @Nullable Project project, @NotNull PsiElement element, int startOffset, int endOffset, int maxPreferredOffset, boolean isSoftWrap) {
        if (document == null) {
            JavaLineWrapPositionStrategy.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JavaLineWrapPositionStrategy.$$$reportNull$$$0(1);
        }
        if (element.getNode().getElementType() == JavaDocTokenType.DOC_COMMENT_DATA) {
            CharSequence docChars = document.getCharsSequence();
            if (JavaLineWrapPositionStrategy.isInsidePreTag(element, docChars, startOffset) || JavaLineWrapPositionStrategy.isInsidePreTag(element, docChars, endOffset)) {
                return -2;
            }
            int refStart = CharArrayUtil.indexOf((CharSequence)docChars, (CharSequence)A_LINK_START, (int)startOffset, (int)endOffset);
            if (refStart >= 0 && refStart < maxPreferredOffset) {
                int refEnd = CharArrayUtil.indexOf((CharSequence)docChars, (CharSequence)A_LINK_END, (int)refStart, (int)endOffset);
                if (refEnd >= 0 && refEnd < maxPreferredOffset) {
                    return refEnd + A_LINK_END.length();
                }
                return refStart;
            }
        }
        int wrapPos = super.doCalculateWrapPosition(document, project, element, startOffset, endOffset, maxPreferredOffset, isSoftWrap);
        if (element.getNode().getElementType() == JavaTokenType.STRING_LITERAL) {
            TextRange range = element.getTextRange();
            if (range.getEndOffset() - wrapPos <= 1) {
                wrapPos = range.getEndOffset();
            } else if (wrapPos - range.getStartOffset() <= 1) {
                wrapPos = range.getStartOffset();
            }
        } else if (element.getNode().getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            CharSequence docChars = document.getCharsSequence();
            TextRange range = element.getTextRange();
            int urlOffset = JavaLineWrapPositionStrategy.getUrlOffset(docChars, startOffset, endOffset);
            if (urlOffset >= 0) {
                int urlEnd;
                for (urlEnd = urlOffset; urlEnd < range.getEndOffset() && !StringUtil.isWhiteSpace((char)docChars.charAt(urlEnd)); ++urlEnd) {
                }
                if (urlEnd > wrapPos) {
                    return urlEnd < range.getEndOffset() ? urlEnd : -2;
                }
            }
        }
        return wrapPos;
    }

    private static int getUrlOffset(@NotNull CharSequence chars, int startOffset, int endOffset) {
        String[] URL_PREFIX;
        if (chars == null) {
            JavaLineWrapPositionStrategy.$$$reportNull$$$0(2);
        }
        for (String urlPrefix : URL_PREFIX = new String[]{"http://", "https://", "ftp://"}) {
            int urlOffset = CharArrayUtil.indexOf((CharSequence)chars, (CharSequence)urlPrefix, (int)startOffset, (int)endOffset);
            if (urlOffset < 0) continue;
            return urlOffset;
        }
        return -1;
    }

    private static boolean isInsidePreTag(@NotNull PsiElement element, @NotNull CharSequence chars, int offset) {
        int preStart;
        PsiElement parent;
        if (element == null) {
            JavaLineWrapPositionStrategy.$$$reportNull$$$0(3);
        }
        if (chars == null) {
            JavaLineWrapPositionStrategy.$$$reportNull$$$0(4);
        }
        if ((parent = PsiTreeUtil.findFirstParent((PsiElement)element, e -> JavaDocElementType.DOC_COMMENT_TOKENS.contains(e.getNode().getElementType()))) != null && (preStart = CharArrayUtil.lastIndexOf((CharSequence)chars, (String)PRE_TAG_START, (int)offset)) >= 0) {
            int preEnd = CharArrayUtil.indexOf((CharSequence)chars, (CharSequence)PRE_TAG_END, (int)preStart, (int)chars.length());
            return preEnd > offset;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/formatter/java/JavaLineWrapPositionStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doCalculateWrapPosition";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getUrlOffset";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsidePreTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

