/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.JavaBlock;
import com.intellij.psi.formatter.java.JavaSpacePropertyProcessor;
import com.intellij.psi.formatter.java.LeafBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyntheticCodeBlock
implements Block,
JavaBlock {
    private final List<Block> mySubBlocks;
    private final Alignment myAlignment;
    private final Indent myIndentContent;
    private final CommonCodeStyleSettings mySettings;
    private final JavaCodeStyleSettings myJavaSettings;
    private final Wrap myWrap;
    private static final Logger LOG = Logger.getInstance(SyntheticCodeBlock.class);
    private final TextRange myTextRange;
    private ChildAttributes myChildAttributes;
    private boolean myIsIncomplete;

    public SyntheticCodeBlock(List<Block> subBlocks, Alignment alignment, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, Indent indent, Wrap wrap) {
        this.myJavaSettings = javaSettings;
        this.myIndentContent = indent;
        if (subBlocks.isEmpty()) {
            LOG.assertTrue(false);
        }
        this.mySubBlocks = new ArrayList<Block>(subBlocks);
        this.myAlignment = alignment;
        this.mySettings = settings;
        this.myWrap = wrap;
        this.myTextRange = new TextRange(this.mySubBlocks.getFirst().getTextRange().getStartOffset(), this.mySubBlocks.getLast().getTextRange().getEndOffset());
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            SyntheticCodeBlock.$$$reportNull$$$0(0);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            SyntheticCodeBlock.$$$reportNull$$$0(1);
        }
        return list;
    }

    public Wrap getWrap() {
        return this.myWrap;
    }

    public Indent getIndent() {
        return this.myIndentContent;
    }

    public Alignment getAlignment() {
        return this.myAlignment;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            SyntheticCodeBlock.$$$reportNull$$$0(2);
        }
        return JavaSpacePropertyProcessor.getSpacing(child2, this.mySettings, this.myJavaSettings);
    }

    public String toString() {
        PsiFile file;
        PsiElement psi;
        ASTNode treeNode = null;
        Block child = this.mySubBlocks.getFirst();
        while (treeNode == null) {
            if (child instanceof AbstractBlock) {
                treeNode = ((AbstractBlock)child).getNode();
                continue;
            }
            if (!(child instanceof SyntheticCodeBlock)) break;
            child = ((SyntheticCodeBlock)child).mySubBlocks.getFirst();
        }
        TextRange textRange = this.getTextRange();
        if (treeNode != null && (psi = treeNode.getPsi()) != null && (file = psi.getContainingFile()) != null) {
            return String.valueOf(file.getText().subSequence(textRange.getStartOffset(), textRange.getEndOffset())) + " " + String.valueOf(textRange);
        }
        return this.getClass().getName() + ": " + String.valueOf(textRange);
    }

    @Override
    @Nullable
    public ASTNode getFirstTreeNode() {
        return AbstractJavaBlock.getTreeNode(this.mySubBlocks.getFirst());
    }

    public void setChildAttributes(ChildAttributes childAttributes) {
        this.myChildAttributes = childAttributes;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.myChildAttributes != null) {
            ChildAttributes childAttributes = this.myChildAttributes;
            if (childAttributes == null) {
                SyntheticCodeBlock.$$$reportNull$$$0(3);
            }
            return childAttributes;
        }
        Alignment alignment = null;
        if (this.mySubBlocks.size() > newChildIndex) {
            Block block = this.mySubBlocks.get(newChildIndex);
            alignment = block.getAlignment();
        } else if (this.mySubBlocks.size() == newChildIndex && SyntheticCodeBlock.isRParenth(this.getRightMostBlock())) {
            alignment = this.getDotAlignment();
        }
        return new ChildAttributes(this.getIndent(), alignment);
    }

    private static boolean isRParenth(Block sibling) {
        if (sibling instanceof LeafBlock) {
            ASTNode node = ((LeafBlock)sibling).getNode();
            return node != null && node.getElementType() == JavaTokenType.RPARENTH;
        }
        return false;
    }

    @Nullable
    private Alignment getDotAlignment() {
        Block block;
        if (this.mySubBlocks.size() > 1 && SyntheticCodeBlock.isDotFirst(block = this.mySubBlocks.get(1))) {
            return block.getAlignment();
        }
        return null;
    }

    private static boolean isDotFirst(Block block) {
        Block current = block;
        while (!current.getSubBlocks().isEmpty()) {
            current = (Block)current.getSubBlocks().getFirst();
        }
        ASTNode node = current instanceof LeafBlock ? ((LeafBlock)current).getNode() : null;
        return node != null && node.getElementType() == JavaTokenType.DOT;
    }

    @Nullable
    private Block getRightMostBlock() {
        Block rightMost = null;
        List subBlocks = this.getSubBlocks();
        while (!subBlocks.isEmpty()) {
            rightMost = subBlocks.getLast();
            subBlocks = rightMost.getSubBlocks();
        }
        return rightMost;
    }

    public boolean isIncomplete() {
        if (this.myIsIncomplete) {
            return true;
        }
        return this.getSubBlocks().getLast().isIncomplete();
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIsIncomplete(boolean isIncomplete) {
        this.myIsIncomplete = isIncomplete;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/SyntheticCodeBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/SyntheticCodeBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

