/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.MultiMaplet;
import org.jetbrains.jps.util.Iterators;

public final class MemoryMultiMaplet<K, V, C extends Collection<V>>
implements MultiMaplet<K, V> {
    private final Map<K, C> myMap = new HashMap<K, C>();
    private final Supplier<? extends C> myCollectionFactory;
    private final C myEmptyCollection;

    public MemoryMultiMaplet(Supplier<? extends C> collectionFactory) {
        this.myCollectionFactory = collectionFactory;
        Collection col = (Collection)collectionFactory.get();
        this.myEmptyCollection = col instanceof List ? Collections.emptyList() : (col instanceof Set ? Collections.emptySet() : col);
    }

    @Override
    public boolean containsKey(K key) {
        return this.myMap.containsKey(key);
    }

    @Override
    @NotNull
    public Iterable<V> get(K key) {
        Set col = (Set)this.myMap.get(key);
        Set set = col != null ? col : Collections.emptySet();
        if (set == null) {
            MemoryMultiMaplet.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    public void put(K key, @NotNull Iterable<? extends V> values) {
        if (values == null) {
            MemoryMultiMaplet.$$$reportNull$$$0(1);
        }
        this.myMap.put(key, this.ensureCollection(values));
    }

    private C ensureCollection(Iterable<? extends V> seq) {
        if (this.myEmptyCollection instanceof Set && seq instanceof Set) {
            return (C)((Collection)seq);
        }
        if (this.myEmptyCollection instanceof List && seq instanceof List) {
            return (C)((Collection)seq);
        }
        return (C)Iterators.collect(seq, (Collection)this.myCollectionFactory.get());
    }

    @Override
    public void remove(K key) {
        this.myMap.remove(key);
    }

    @Override
    public void appendValue(K key, V value) {
        Collection values = (Collection)this.myMap.get(key);
        if (values == null) {
            values = (Collection)this.myCollectionFactory.get();
            this.myMap.put(key, values);
        }
        values.add(value);
    }

    @Override
    public void removeValue(K key, V value) {
        Collection values = (Collection)this.myMap.get(key);
        if (values != null) {
            values.remove(value);
        }
    }

    @Override
    @NotNull
    public Iterable<K> getKeys() {
        Set<K> set = this.myMap.keySet();
        if (set == null) {
            MemoryMultiMaplet.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    public void close() {
        this.myMap.clear();
    }

    @Override
    public void flush() throws IOException {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/impl/MemoryMultiMaplet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/impl/MemoryMultiMaplet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

