/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.Graph;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.Usage;
import org.jetbrains.jps.dependency.diff.DiffCapable;
import org.jetbrains.jps.dependency.diff.Difference;
import org.jetbrains.jps.dependency.java.AnnotationUsage;
import org.jetbrains.jps.dependency.java.ClassAsGenericBoundUsage;
import org.jetbrains.jps.dependency.java.ClassNewUsage;
import org.jetbrains.jps.dependency.java.ClassPermitsUsage;
import org.jetbrains.jps.dependency.java.ClassUsage;
import org.jetbrains.jps.dependency.java.ElemType;
import org.jetbrains.jps.dependency.java.FieldUsage;
import org.jetbrains.jps.dependency.java.ImportPackageOnDemandUsage;
import org.jetbrains.jps.dependency.java.InheritanceConstraint;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JVMFlags;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmDifferentiateStrategyImpl;
import org.jetbrains.jps.dependency.java.JvmElementUsage;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.JvmModule;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.MemberUsage;
import org.jetbrains.jps.dependency.java.ModulePackage;
import org.jetbrains.jps.dependency.java.ModuleRequires;
import org.jetbrains.jps.dependency.java.ModuleUsage;
import org.jetbrains.jps.dependency.java.PackageConstraint;
import org.jetbrains.jps.dependency.java.Proto;
import org.jetbrains.jps.dependency.java.TypeRepr;
import org.jetbrains.jps.dependency.java.Utils;
import org.jetbrains.jps.util.Iterators;
import org.jetbrains.jps.util.Pair;

public final class JavaDifferentiateStrategy
extends JvmDifferentiateStrategyImpl {
    @Override
    public boolean isIncremental(DifferentiateContext context, Node<?, ?> affectedNode) {
        if (affectedNode instanceof JvmClass && ((JvmClass)affectedNode).getFlags().isGenerated()) {
            this.debug(context, "Turning non-incremental for the BuildTarget because dependent class is annotation-processor generated: ", affectedNode.getReferenceID());
            return false;
        }
        return true;
    }

    @Override
    public boolean processRemovedClass(DifferentiateContext context, JvmClass removedClass, Utils future, Utils present) {
        this.debug(context, "Adding usages of removed class ", removedClass.getName());
        context.affectUsage(new ClassUsage(removedClass.getReferenceID()));
        return true;
    }

    @Override
    public boolean processAddedClasses(DifferentiateContext context, Iterable<JvmClass> addedClasses, Utils future, Utils present) {
        if (Iterators.isEmpty(addedClasses)) {
            return true;
        }
        this.debug(context, "Processing added classes:");
        for (JvmClass addedClass : addedClasses) {
            this.debug(context, "Class name: ", addedClass.getName());
            if (!addedClass.isAnonymous() && !addedClass.isLocal() && !addedClass.isInnerClass() && this.affectNodeSourcesIfNotCompiled(context, Iterators.asIterable(addedClass.getReferenceID()), present, "Possibly duplicated classes in the same compilation chunk; Scheduling for recompilation sources: ")) {
                this.affectSources(context, context.getDelta().getSources(addedClass.getReferenceID()), "Found conflicting class declarations ", true);
                continue;
            }
            String shortName = addedClass.getShortName();
            String scope = addedClass.isInnerClass() ? addedClass.getOuterFqName().replace('$', '/') : addedClass.getPackageName();
            this.debug(context, "Affecting dependencies importing package/class '", scope, "' on-demand and having class-usages with the same short name: '", shortName, "' ");
            context.affectUsage(new ImportPackageOnDemandUsage(scope), n -> Iterators.find(n.getUsages(), u -> {
                String ownerName;
                return !(!(u instanceof ClassUsage) && !(u instanceof MemberUsage) || !(ownerName = ((JvmElementUsage)u).getElementOwner().getNodeName()).endsWith(shortName) || ownerName.length() != shortName.length() && ownerName.charAt(ownerName.length() - shortName.length() - 1) != '/');
            }) != null);
        }
        this.debug(context, "End of added classes processing.");
        return true;
    }

    @Override
    public boolean processChangedClass(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Utils future, Utils present) {
        block32: {
            boolean isLambdaTarget;
            boolean wasLambdaTarget;
            JvmClass changedClass;
            block31: {
                JVMFlags addedFlags;
                changedClass = change.getPast();
                JvmClass.Diff classDiff = change.getDiff();
                this.debug(context, "Processing changed class ", changedClass.getName());
                if (classDiff.superClassChanged() || classDiff.signatureChanged() || !classDiff.interfaces().unchanged()) {
                    boolean extendsChanged = classDiff.superClassChanged() && !classDiff.extendsAdded();
                    boolean affectUsages = classDiff.signatureChanged() || extendsChanged || !classDiff.interfaces().unchanged();
                    this.affectSubclasses(context, future, change.getNow().getReferenceID(), affectUsages);
                    if (extendsChanged) {
                        TypeRepr.ClassType exClass = new TypeRepr.ClassType(changedClass.getName());
                        for (JvmClass depClass : Iterators.flat(Iterators.map(context.getGraph().getDependingNodes(changedClass.getReferenceID()), dep -> present.getNodes((ReferenceID)dep, JvmClass.class)))) {
                            for (JvmMethod method : depClass.getMethods()) {
                                if (!Iterators.contains(method.getExceptions(), exClass)) continue;
                                context.affectUsage(method.createUsage(depClass.getReferenceID()));
                                this.debug(context, "Affecting usages of methods throwing ", exClass.getJvmName(), " exception; class ", depClass.getName());
                            }
                        }
                    }
                    if (!changedClass.isAnonymous()) {
                        Set parents = Iterators.collect(present.allSupertypes(changedClass.getReferenceID()), new HashSet());
                        parents.removeAll(Iterators.collect(future.allSupertypes(changedClass.getReferenceID()), new HashSet()));
                        Iterator<JvmClass> iterator = parents.iterator();
                        while (iterator.hasNext()) {
                            JvmNodeReferenceID parent = (JvmNodeReferenceID)((Object)iterator.next());
                            this.debug(context, "Affecting usages in generic type parameter bounds of class: ", parent);
                            context.affectUsage(new ClassAsGenericBoundUsage(parent));
                        }
                    }
                } else if (change.getNow().isSealed()) {
                    JvmNodeReferenceID fromClass = change.getNow().getReferenceID();
                    Set permitted = Iterators.collect(Iterators.map(Iterators.filter(change.getNow().getUsages(), u -> u instanceof ClassPermitsUsage), Usage::getElementOwner), new HashSet());
                    this.debug(context, "Affecting non-permitted subclasses of a sealed class: ", fromClass);
                    for (ReferenceID cl : Iterators.filter(future.directSubclasses(fromClass), c -> !permitted.contains(c))) {
                        this.affectNodeSources(context, cl, "Affecting source file of a non-permitted subclass: ", future);
                    }
                }
                if ((addedFlags = classDiff.getAddedFlags()).isInterface() || classDiff.getRemovedFlags().isInterface()) {
                    this.debug(context, "Class-to-interface or interface-to-class conversion detected, added class usage to affected usages");
                    context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
                }
                if (changedClass.isAnnotation() && changedClass.getRetentionPolicy() == RetentionPolicy.SOURCE) {
                    this.debug(context, "Annotation, retention policy = SOURCE => a switch to non-incremental mode requested");
                    if (!this.affectOnNonIncrementalChange(context, changedClass.getReferenceID(), changedClass, present)) {
                        this.debug(context, "End of Differentiate, returning false");
                        return false;
                    }
                }
                if (addedFlags.isProtected()) {
                    this.debug(context, "Introduction of 'protected' modifier detected, adding class usage + inheritance constraint to affected usages");
                    context.affectUsage(new ClassUsage(changedClass.getReferenceID()), new InheritanceConstraint(future, changedClass));
                }
                if (!changedClass.getFlags().isPackageLocal() && change.getNow().getFlags().isPackageLocal()) {
                    this.debug(context, "Introduction of 'package-private' access detected, adding class usage + package constraint to affected usages");
                    context.affectUsage(new ClassUsage(changedClass.getReferenceID()), new PackageConstraint(changedClass.getPackageName()));
                }
                if (addedFlags.isFinal() || addedFlags.isPrivate()) {
                    this.debug(context, "Introduction of 'private' or 'final' modifier(s) detected, adding class usage to affected usages");
                    context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
                }
                if (addedFlags.isAbstract() || addedFlags.isStatic()) {
                    this.debug(context, "Introduction of 'abstract' or 'static' modifier(s) detected, adding class new usage to affected usages");
                    context.affectUsage(new ClassNewUsage(changedClass.getReferenceID()));
                }
                if (!changedClass.isAnonymous() && !changedClass.isPrivate() && classDiff.flagsChanged() && changedClass.isInnerClass()) {
                    this.debug(context, "Some modifiers (access flags) were changed for non-private inner class, adding class usage to affected usages");
                    context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
                }
                if (classDiff.metadataKindChanged()) {
                    this.debug(context, "Some class metadata has been added or removed (=> metadata kind has changed), added class usage to affected usages");
                    context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
                }
                if (changedClass.isAnnotation()) {
                    this.debug(context, "Class is annotation, performing annotation-specific analysis");
                    if (classDiff.retentionPolicyChanged()) {
                        this.debug(context, "Retention policy change detected, adding class usage to affected usages");
                        context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
                    } else if (classDiff.targetAttributeCategoryMightChange()) {
                        this.debug(context, "Annotation's attribute category in bytecode might be affected because of TYPE_USE or RECORD_COMPONENT target, adding class usage to affected usages");
                        context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
                    } else {
                        Difference.Specifier<ElemType, ?> targetsDiff = classDiff.annotationTargets();
                        Set removedTargets = Iterators.collect(targetsDiff.removed(), EnumSet.noneOf(ElemType.class));
                        if (removedTargets.contains((Object)ElemType.LOCAL_VARIABLE)) {
                            this.debug(context, "Removed target contains LOCAL_VARIABLE => a switch to non-incremental mode requested");
                            if (!this.affectOnNonIncrementalChange(context, changedClass.getReferenceID(), changedClass, present)) {
                                this.debug(context, "End of Differentiate, returning false");
                                return false;
                            }
                        }
                        if (!removedTargets.isEmpty()) {
                            this.debug(context, "Removed some annotation targets, adding annotation query");
                            TypeRepr.ClassType classType = new TypeRepr.ClassType(changedClass.getName());
                            context.affectUsage(Iterators.asIterable(changedClass.getReferenceID()), node -> {
                                for (Usage usage : node.getUsages()) {
                                    AnnotationUsage annotUsage;
                                    if (!(usage instanceof AnnotationUsage) || !classType.equals((annotUsage = (AnnotationUsage)usage).getClassType())) continue;
                                    for (ElemType target : annotUsage.getTargets()) {
                                        if (!removedTargets.contains((Object)target)) continue;
                                        return true;
                                    }
                                }
                                return false;
                            });
                        }
                        for (JvmMethod m2 : classDiff.methods().added()) {
                            if (m2.getValue() != null) continue;
                            this.debug(context, "Added method with no default value: ", m2.getName());
                            this.debug(context, "Adding class usage to affected usages");
                            context.affectUsage(new ClassUsage(changedClass.getReferenceID()));
                            break;
                        }
                    }
                    this.debug(context, "End of annotation-specific analysis");
                }
                if (changedClass.getFlags().isEnum() && !Iterators.isEmpty(classDiff.fields().added())) {
                    this.debug(context, "Constants added to enum, affecting class usages " + changedClass.getName());
                    context.affectUsage(new ClassUsage(changedClass.getReferenceID()), n -> n instanceof JVMClassNode && ((JVMClassNode)n).isSynthetic());
                }
                wasLambdaTarget = present.isLambdaTarget(change.getPast());
                isLambdaTarget = future.isLambdaTarget(change.getNow());
                if (!wasLambdaTarget || isLambdaTarget) break block31;
                for (ReferenceID id : present.withAllSubclasses(changedClass.getReferenceID())) {
                    String clsName;
                    if (!id.equals(changedClass.getReferenceID()) && !present.isLambdaTarget(id) || (clsName = present.getNodeName(id)) == null) continue;
                    this.debug(context, "The interface could be not a SAM interface anymore => affecting lambda instantiations for ", clsName);
                    context.affectUsage(new ClassNewUsage(clsName));
                }
                break block32;
            }
            if (wasLambdaTarget || !isLambdaTarget) break block32;
            TypeRepr.ClassType samType = new TypeRepr.ClassType(changedClass.getName());
            for (JvmClass depClass : Iterators.flat(Iterators.map(context.getGraph().getDependingNodes(changedClass.getReferenceID()), dep -> present.getNodes((ReferenceID)dep, JvmClass.class)))) {
                JvmMethod methodWithSAMType = Iterators.find(depClass.getMethods(), m -> Iterators.contains(m.getArgTypes(), samType));
                if (methodWithSAMType == null) continue;
                Iterable<Utils.OverloadDescriptor> overloaded = future.findAllOverloads(depClass, m -> {
                    if (!Objects.equals(methodWithSAMType.getName(), m.getName()) || m.isSame(methodWithSAMType)) {
                        return null;
                    }
                    Iterator<TypeRepr> patternSignatureTypes = methodWithSAMType.getArgTypes().iterator();
                    for (TypeRepr arg : m.getArgTypes()) {
                        if (!patternSignatureTypes.hasNext()) {
                            return null;
                        }
                        TypeRepr patternArg = patternSignatureTypes.next();
                        if (!(patternArg.equals(samType) ? arg.equals(samType) || !(arg instanceof TypeRepr.ClassType) : Boolean.FALSE.equals(future.isSubtypeOf(arg, patternArg)) && Boolean.FALSE.equals(future.isSubtypeOf(patternArg, arg)))) continue;
                        return null;
                    }
                    return patternSignatureTypes.hasNext() ? null : m.getFlags();
                });
                for (Utils.OverloadDescriptor descr : overloaded) {
                    this.debug(context, "Found method ", methodWithSAMType, " that uses SAM interface ", samType.getJvmName(), " in its signature --- affect potential lambda-target usages of overloaded method: ", descr.overloadMethod);
                    this.affectMemberUsages(context, descr.owner.getReferenceID(), descr.overloadMethod, future.collectSubclassesWithoutMethod(descr.owner.getReferenceID(), descr.overloadMethod), n -> n instanceof JvmClass && future.isVisibleIn(depClass, methodWithSAMType, (JvmClass)n));
                }
            }
        }
        return super.processChangedClass(context, change, future, present);
    }

    @Override
    public boolean processChangedMethods(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> clsChange, Iterable<Difference.Change<JvmMethod, JvmMethod.Diff>> methodChanges, Utils future, Utils present) {
        JvmClass changedClass = clsChange.getPast();
        this.debug(context, "Processing changed methods: ");
        for (Difference.Change<JvmMethod, JvmMethod.Diff> change : methodChanges) {
            JvmMethod changedMethod = change.getPast();
            JvmMethod.Diff diff = change.getDiff();
            this.debug(context, "Method: ", changedMethod.getName());
            if (changedClass.isAnnotation()) {
                if (!diff.valueRemoved()) continue;
                this.debug(context, "Class is annotation, default value is removed => adding annotation query");
                String argName = changedMethod.getName();
                Iterator<JvmNodeReferenceID> annotType = new TypeRepr.ClassType(changedClass.getName());
                context.affectUsage(Iterators.asIterable(changedClass.getReferenceID()), arg_0 -> JavaDifferentiateStrategy.lambda$processChangedMethods$11((TypeRepr.ClassType)((Object)annotType), argName, arg_0));
                continue;
            }
            Iterable<JvmNodeReferenceID> propagated = Iterators.lazyIterable(() -> future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), changedMethod));
            if (diff.becamePackageLocal()) {
                this.debug(context, "Method became package-private, affecting method usages outside the package");
                this.affectMemberUsages(context, changedClass.getReferenceID(), changedMethod, propagated, new PackageConstraint(changedClass.getPackageName()));
            }
            if (diff.typeChanged() || diff.signatureChanged() || !diff.exceptions().unchanged()) {
                this.debug(context, "Return type, throws list or signature changed --- affecting method usages");
                this.affectMemberUsages(context, changedClass.getReferenceID(), changedMethod, propagated);
                if (changedMethod.isPrivate() || changedMethod.isConstructor() || changedMethod.isStatic()) continue;
                if (!changedMethod.isFinal()) {
                    for (JvmNodeReferenceID subClass : Iterators.unique(Iterators.map(future.getOverridingMethods(changedClass, changedMethod, changedMethod::isSameByJavaRules), p -> ((JvmClass)p.first).getReferenceID()))) {
                        this.affectNodeSources(context, subClass, "Affect source file of a class which overrides the changed method: ", future);
                    }
                }
                block2: for (JvmNodeReferenceID id : propagated) {
                    for (JvmClass subClass : future.getNodes(id, JvmClass.class)) {
                        Iterable<Pair> overriddenInSubclass = Iterators.filter(future.getOverriddenMethods(subClass, changedMethod::isSameByJavaRules), p -> !Objects.equals(((JvmClass)p.first).getReferenceID(), id));
                        if (Iterators.isEmpty(overriddenInSubclass)) continue;
                        this.debug(context, "Changed method is inherited in some subclass & overrides/implements some interface method which this subclass implements. ", subClass.getName());
                        this.affectNodeSources(context, subClass.getReferenceID(), "Affecting subclass source file: ", future);
                        continue block2;
                    }
                }
                continue;
            }
            if (!diff.flagsChanged()) continue;
            JVMFlags addedFlags = diff.getAddedFlags();
            JVMFlags removedFlags = diff.getRemovedFlags();
            if (addedFlags.isStatic() || addedFlags.isPrivate() || addedFlags.isSynthetic() || addedFlags.isBridge() || removedFlags.isStatic()) {
                this.debug(context, "Added {static | private | synthetic | bridge} specifier or removed static specifier --- affecting method usages");
                this.affectMemberUsages(context, changedClass.getReferenceID(), changedMethod, propagated);
                if (addedFlags.isStatic()) {
                    this.debug(context, "Added static specifier --- affecting subclasses");
                    this.affectSubclasses(context, future, changedClass.getReferenceID(), false);
                    if (changedMethod.isPrivate()) continue;
                    this.debug(context, "Added static modifier --- affecting static member on-demand import usages");
                    this.affectStaticMemberOnDemandUsages(context, changedClass.getReferenceID(), propagated);
                    continue;
                }
                if (!removedFlags.isStatic() || changedMethod.isPrivate()) continue;
                this.debug(context, "Removed static modifier --- affecting static method import usages");
                this.affectStaticMemberImportUsages(context, changedClass.getReferenceID(), changedMethod.getName(), propagated);
                continue;
            }
            if (addedFlags.isFinal() || addedFlags.isPublic() || addedFlags.isAbstract()) {
                this.debug(context, "Added final, public or abstract specifier --- affecting subclasses");
                this.affectSubclasses(context, future, changedClass.getReferenceID(), false);
            }
            if (!addedFlags.isProtected() || removedFlags.isPrivate()) continue;
            this.debug(context, "Added public or package-private method became protected --- affect method usages with protected constraint");
            this.affectMemberUsages(context, changedClass.getReferenceID(), changedMethod, propagated, new InheritanceConstraint(future, changedClass));
        }
        ArrayList moreAccessible = Iterators.collect(Iterators.filter(methodChanges, ch -> ((JvmMethod.Diff)ch.getDiff()).accessExpanded()), new ArrayList());
        if (!Iterators.isEmpty(moreAccessible)) {
            Iterable<Utils.OverloadDescriptor> overloaded = future.findAllOverloads(changedClass, method -> {
                JVMFlags mostAccessible = null;
                for (Difference.Change change : moreAccessible) {
                    JvmMethod m = (JvmMethod)change.getNow();
                    if (!Objects.equals(m.getName(), method.getName()) || m.isSame((DiffCapable<?, ?>)method) || mostAccessible != null && !mostAccessible.isWeakerAccess(m.getFlags())) continue;
                    mostAccessible = m.getFlags();
                }
                return mostAccessible;
            });
            for (Utils.OverloadDescriptor descr : overloaded) {
                this.debug(context, "Method became more accessible --- affect usages of overloading methods: ", descr.overloadMethod.getName());
                Predicate<Object> constr = descr.accessScope.isPackageLocal() ? new PackageConstraint(changedClass.getPackageName()).negate() : (descr.accessScope.isProtected() ? new InheritanceConstraint(future, changedClass).negate() : null);
                this.affectMemberUsages(context, descr.owner.getReferenceID(), descr.overloadMethod, future.collectSubclassesWithoutMethod(descr.owner.getReferenceID(), descr.overloadMethod), constr);
            }
        }
        this.debug(context, "End of changed methods processing");
        return super.processChangedMethods(context, clsChange, methodChanges, future, present);
    }

    @Override
    public boolean processRemovedMethods(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Iterable<JvmMethod> removed, Utils future, Utils present) {
        JvmClass changedClass = change.getPast();
        this.debug(context, "Processing removed methods: ");
        Supplier<Boolean> extendsLibraryClass = Utils.lazyValue(() -> future.inheritsFromLibraryClass(changedClass));
        for (JvmMethod removedMethod : removed) {
            this.debug(context, "Method ", removedMethod.getName());
            Iterable<JvmNodeReferenceID> propagated = Iterators.lazyIterable(() -> future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), removedMethod));
            if (!removedMethod.isPrivate() && removedMethod.isStatic() && !removedMethod.isStaticInitializer()) {
                this.debug(context, "The method was static --- affecting static method import usages");
                this.affectStaticMemberImportUsages(context, changedClass.getReferenceID(), removedMethod.getName(), propagated);
            }
            if (removedMethod.isPackageLocal()) {
                if (!removedMethod.isStaticInitializer()) {
                    this.debug(context, "Removed method is package-local, affecting method usages");
                    this.affectMemberUsages(context, changedClass.getReferenceID(), removedMethod, propagated);
                }
            } else {
                boolean bl;
                List overridden = removedMethod.isConstructor() ? Collections.emptyList() : Iterators.lazyIterable(() -> future.getOverriddenMethods(changedClass, removedMethod::isSameByJavaRules));
                boolean bl2 = bl = removedMethod.getSignature().isEmpty() && extendsLibraryClass.get() == false && !Iterators.isEmpty(overridden) && Iterators.isEmpty(Iterators.filter(overridden, p -> !((JvmMethod)p.second).getType().equals(removedMethod.getType()) || !((JvmMethod)p.second).getSignature().isEmpty() || removedMethod.isMoreAccessibleThan((Proto)p.second)));
                if (!bl) {
                    this.debug(context, "No overridden methods found, affecting method usages");
                    this.affectMemberUsages(context, changedClass.getReferenceID(), removedMethod, propagated);
                }
            }
            if (removedMethod.isOverridable()) {
                for (Pair pair : future.getOverridingMethods(changedClass, removedMethod, removedMethod::isSameByJavaRules)) {
                    this.affectNodeSources(context, ((JvmClass)pair.first).getReferenceID(), "Affecting file by overriding: ", future);
                }
            }
            if (removedMethod.isConstructor() || removedMethod.isAbstract() || removedMethod.isStatic()) continue;
            block2: for (JvmNodeReferenceID jvmNodeReferenceID : propagated) {
                for (JvmClass subClass : future.getNodes(jvmNodeReferenceID, JvmClass.class)) {
                    boolean allOverriddenAbstract;
                    Iterable<Pair> overriddenForSubclass = Iterators.filter(future.getOverriddenMethods(subClass, removedMethod::isSameByJavaRules), p -> ((JvmMethod)p.second).isAbstract() || removedMethod.isSame((DiffCapable)p.second));
                    boolean bl = allOverriddenAbstract = !Iterators.isEmpty(overriddenForSubclass) && Iterators.isEmpty(Iterators.filter(overriddenForSubclass, p -> !((JvmMethod)p.second).isAbstract()));
                    if (!allOverriddenAbstract && !future.inheritsFromLibraryClass(subClass)) continue;
                    this.debug(context, "Removed method is not abstract & overrides some abstract method which is not then over-overridden in subclass ", subClass.getName());
                    this.affectNodeSources(context, subClass.getReferenceID(), "Affecting subclass source file: ", future);
                    continue block2;
                }
            }
        }
        this.debug(context, "End of removed methods processing");
        return true;
    }

    @Override
    public boolean processAddedMethods(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Iterable<JvmMethod> added, Utils future, Utils present) {
        JvmClass changedClass = change.getPast();
        if (changedClass.isAnnotation()) {
            this.debug(context, "Class is annotation, skipping method analysis for added methods");
            return true;
        }
        this.debug(context, "Processing added methods: ");
        for (JvmMethod addedMethod : added) {
            if (addedMethod.isPrivate() || !changedClass.isInterface() && !changedClass.isAbstract() && !addedMethod.isAbstract()) continue;
            this.debug(context, "Method: " + addedMethod.getName());
            this.debug(context, "Class is abstract, or is interface, or added non-private method is abstract => affecting all subclasses");
            this.affectSubclasses(context, future, changedClass.getReferenceID(), false);
            break;
        }
        for (JvmMethod addedMethod : added) {
            JvmClass cls;
            this.debug(context, "Method: ", addedMethod.getName());
            if (addedMethod.isPrivate()) continue;
            Iterable<JvmNodeReferenceID> propagated = Iterators.lazyIterable(() -> future.collectSubclassesWithoutMethod(changedClass.getReferenceID(), addedMethod));
            if (!Iterators.isEmpty(addedMethod.getArgTypes()) && !present.hasOverriddenMethods(changedClass, addedMethod)) {
                this.debug(context, "Conservative case on overriding methods, affecting method usages");
                context.affectUsage(Iterators.asIterable(changedClass.getReferenceID()), addedMethod.createUsageQuery(changedClass.getReferenceID()));
                if (!addedMethod.isConstructor()) {
                    for (JvmNodeReferenceID id : propagated) {
                        context.affectUsage(Iterators.asIterable(id), addedMethod.createUsageQuery(id));
                    }
                }
            }
            if (addedMethod.isStatic() && !addedMethod.isStaticInitializer()) {
                this.affectStaticMemberOnDemandUsages(context, changedClass.getReferenceID(), propagated);
            }
            Predicate<JvmMethod> lessSpecificCond = future.lessSpecific(addedMethod);
            for (JvmMethod jvmMethod : Iterators.filter(changedClass.getMethods(), lessSpecificCond)) {
                this.debug(context, "Found less specific method, affecting method usages; ", jvmMethod.getName(), jvmMethod.getDescriptor());
                this.affectMemberUsages(context, changedClass.getReferenceID(), jvmMethod, present.collectSubclassesWithoutMethod(changedClass.getReferenceID(), jvmMethod));
            }
            this.debug(context, "Processing affected by specificity methods");
            for (Pair pair : future.getOverriddenMethods(changedClass, lessSpecificCond)) {
                cls = (JvmClass)pair.first;
                JvmMethod overriddenMethod = (JvmMethod)pair.second;
                this.debug(context, "Method: ", overriddenMethod.getName());
                this.debug(context, "Class : ", cls.getName());
                this.debug(context, "Affecting method usages for that found");
                this.affectMemberUsages(context, changedClass.getReferenceID(), overriddenMethod, present.collectSubclassesWithoutMethod(changedClass.getReferenceID(), overriddenMethod));
            }
            for (Pair pair : future.getOverridingMethods(changedClass, addedMethod, lessSpecificCond)) {
                cls = (JvmClass)pair.first;
                JvmMethod overridingMethod = (JvmMethod)pair.second;
                this.debug(context, "Method: ", overridingMethod.getName());
                this.debug(context, "Class : ", cls.getName());
                if (overridingMethod.isSameByJavaRules(addedMethod)) {
                    this.debug(context, "Current method overrides the added method");
                    this.affectNodeSources(context, cls.getReferenceID(), "Affecting source ", future);
                    continue;
                }
                this.debug(context, "Current method does not override the added method");
                this.debug(context, "Affecting method usages for the method");
                this.affectMemberUsages(context, cls.getReferenceID(), overridingMethod, present.collectSubclassesWithoutMethod(cls.getReferenceID(), overridingMethod));
            }
            for (ReferenceID referenceID : future.allSubclasses(changedClass.getReferenceID())) {
                Iterable<NodeSource> sources = context.getGraph().getSources(referenceID);
                if (Iterators.isEmpty(Iterators.filter(sources, s -> !context.isCompiled((NodeSource)s)))) continue;
                for (JvmClass outerClass : Iterators.flat(Iterators.map(future.getNodes(referenceID, JvmClass.class), cl -> future.getNodes(new JvmNodeReferenceID(cl.getOuterFqName()), JvmClass.class)))) {
                    if (!future.isMethodVisible(outerClass, addedMethod) && !future.inheritsFromLibraryClass(outerClass)) continue;
                    for (NodeSource nodeSource : Iterators.filter(sources, context.getParams().affectionFilter())) {
                        this.debug(context, "Affecting file due to local overriding: ", nodeSource);
                        context.affectNodeSource(nodeSource);
                    }
                }
            }
        }
        this.debug(context, "End of added methods processing");
        return true;
    }

    @Override
    public boolean processAddedFields(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Iterable<JvmField> added, Utils future, Utils present) {
        if (!Iterators.isEmpty(added)) {
            this.debug(context, "Processing added fields: ");
        }
        return super.processAddedFields(context, change, added, future, present);
    }

    @Override
    public boolean processAddedField(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, JvmField addedField, Utils future, Utils present) {
        JvmClass changedClass = change.getPast();
        this.debug(context, "Field: " + addedField.getName());
        Set<JvmNodeReferenceID> changedClassWithSubclasses = future.collectSubclassesWithoutField(changedClass.getReferenceID(), addedField);
        changedClassWithSubclasses.add(changedClass.getReferenceID());
        for (JvmNodeReferenceID subClass : changedClassWithSubclasses) {
            String affectReason = null;
            if (!addedField.isPrivate()) {
                for (JvmClass cl : future.getNodes(subClass, JvmClass.class)) {
                    ArrayList outerClasses;
                    if (cl.isLocal()) {
                        affectReason = "Affecting local subclass (introduced field can potentially hide surrounding method parameters/local variables): ";
                        break;
                    }
                    String outerClassName = cl.getOuterFqName();
                    if (outerClassName.isEmpty() || !Iterators.isEmpty(outerClasses = Iterators.collect(future.getClassesByName(outerClassName), new ArrayList())) && Iterators.isEmpty(Iterators.filter(outerClasses, ocl -> future.isFieldVisible((JvmClass)ocl, addedField)))) continue;
                    affectReason = "Affecting inner subclass (introduced field can potentially hide surrounding class fields): ";
                    break;
                }
            }
            if (affectReason != null) {
                this.affectNodeSources(context, subClass, affectReason, future);
            }
            if (addedField.isPrivate() || !addedField.isStatic()) continue;
            this.affectStaticMemberOnDemandUsages(context, subClass, Collections.emptyList());
        }
        context.affectUsage(changedClassWithSubclasses, node -> {
            if (node instanceof JvmClass) {
                for (Usage usage : node.getUsages()) {
                    if (!(usage instanceof FieldUsage) || !Objects.equals(((FieldUsage)usage).getName(), addedField.getName()) || !changedClassWithSubclasses.contains(usage.getElementOwner())) continue;
                    return true;
                }
            }
            return false;
        });
        return true;
    }

    @Override
    public boolean processRemovedFields(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, Iterable<JvmField> removed, Utils future, Utils present) {
        if (!Iterators.isEmpty(removed)) {
            this.debug(context, "Process removed fields: ");
        }
        return super.processRemovedFields(context, change, removed, future, present);
    }

    @Override
    public boolean processRemovedField(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> change, JvmField removedField, Utils future, Utils present) {
        JvmClass changedClass = change.getPast();
        this.debug(context, "Field: ", removedField.getName());
        if (!context.getParams().isProcessConstantsIncrementally() && !removedField.isPrivate() && removedField.isInlinable() && removedField.getValue() != null) {
            this.debug(context, "Field had value and was (non-private) final => a switch to non-incremental mode requested");
            if (!this.affectOnNonIncrementalChange(context, changedClass.getReferenceID(), removedField, present)) {
                this.debug(context, "End of Differentiate, returning false");
                return false;
            }
        }
        Set<JvmNodeReferenceID> propagated = present.collectSubclassesWithoutField(changedClass.getReferenceID(), removedField);
        this.affectMemberUsages(context, changedClass.getReferenceID(), removedField, propagated);
        if (!removedField.isPrivate() && removedField.isStatic()) {
            this.debug(context, "The field was static --- affecting static field import usages");
            this.affectStaticMemberImportUsages(context, changedClass.getReferenceID(), removedField.getName(), propagated);
        }
        return true;
    }

    @Override
    public boolean processChangedFields(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> chng, Iterable<Difference.Change<JvmField, JvmField.Diff>> fieldChanges, Utils future, Utils present) {
        if (!Iterators.isEmpty(fieldChanges)) {
            this.debug(context, "Process changed fields: ");
        }
        return super.processChangedFields(context, chng, fieldChanges, future, present);
    }

    @Override
    public boolean processChangedField(DifferentiateContext context, Difference.Change<JvmClass, JvmClass.Diff> clsChange, Difference.Change<JvmField, JvmField.Diff> fieldChange, Utils future, Utils present) {
        JvmClass changedClass = clsChange.getPast();
        JvmField changedField = fieldChange.getPast();
        JvmField.Diff diff = fieldChange.getDiff();
        this.debug(context, "Field: ", changedField.getName());
        Iterable<JvmNodeReferenceID> propagated = Iterators.lazyIterable(() -> future.collectSubclassesWithoutField(changedClass.getReferenceID(), changedField));
        JVMFlags addedFlags = diff.getAddedFlags();
        JVMFlags removedFlags = diff.getRemovedFlags();
        if (!changedField.isPrivate() && changedField.isInlinable() && changedField.getValue() != null) {
            boolean harmful;
            boolean bl = harmful = Iterators.find(List.of(addedFlags, removedFlags), f -> f.isStatic() || f.isFinal()) != null;
            if (harmful || diff.valueChanged() || diff.accessRestricted()) {
                if (context.getParams().isProcessConstantsIncrementally()) {
                    this.debug(context, "Potentially inlined field changed its access or value => affecting field usages and static member import usages");
                    this.affectMemberUsages(context, changedClass.getReferenceID(), changedField, propagated);
                    this.affectStaticMemberImportUsages(context, changedClass.getReferenceID(), changedField.getName(), propagated);
                } else {
                    this.debug(context, "Potentially inlined field changed its access or value => a switch to non-incremental mode requested");
                    if (!this.affectOnNonIncrementalChange(context, changedClass.getReferenceID(), changedField, present)) {
                        this.debug(context, "End of Differentiate, returning false");
                        return false;
                    }
                }
            }
        }
        if (diff.typeChanged() || diff.signatureChanged()) {
            this.debug(context, "Type or signature changed --- affecting field usages");
            this.affectMemberUsages(context, changedClass.getReferenceID(), changedField, propagated);
        } else if (diff.flagsChanged()) {
            if (addedFlags.isStatic() || removedFlags.isStatic() || addedFlags.isPrivate() || addedFlags.isVolatile()) {
                this.debug(context, "Added/removed static modifier or added private/volatile modifier --- affecting field usages");
                this.affectMemberUsages(context, changedClass.getReferenceID(), changedField, propagated);
                if (!changedField.isPrivate()) {
                    if (addedFlags.isStatic()) {
                        this.debug(context, "Added static modifier --- affecting static member on-demand import usages");
                        this.affectStaticMemberOnDemandUsages(context, changedClass.getReferenceID(), propagated);
                    } else if (removedFlags.isStatic()) {
                        this.debug(context, "Removed static modifier --- affecting static field import usages");
                        this.affectStaticMemberImportUsages(context, changedClass.getReferenceID(), changedField.getName(), propagated);
                    }
                }
            } else {
                PackageConstraint constraint = null;
                if (removedFlags.isPublic()) {
                    this.debug(context, "Removed public modifier, affecting field usages with appropriate constraint");
                    constraint = addedFlags.isProtected() ? new InheritanceConstraint(future, changedClass) : new PackageConstraint(changedClass.getPackageName());
                    this.affectMemberUsages(context, changedClass.getReferenceID(), changedField, propagated, constraint);
                } else if (removedFlags.isProtected() && diff.accessRestricted()) {
                    this.debug(context, "Removed protected modifier and the field became less accessible, affecting field usages with package constraint");
                    constraint = new PackageConstraint(changedClass.getPackageName());
                    this.affectMemberUsages(context, changedClass.getReferenceID(), changedField, propagated, constraint);
                }
                if (addedFlags.isFinal()) {
                    this.debug(context, "Added final modifier --- affecting field assign usages");
                    this.affectUsages(context, "field assign", Iterators.flat(Iterators.asIterable(changedClass.getReferenceID()), propagated), id -> changedField.createAssignUsage(id.getNodeName()), constraint);
                }
            }
        }
        return super.processChangedField(context, clsChange, fieldChange, future, present);
    }

    @Override
    public boolean processAddedModule(DifferentiateContext context, JvmModule addedModule, Utils future, Utils present) {
        if (!addedModule.isLibrary()) {
            this.affectModule(context, future, addedModule);
        }
        return true;
    }

    @Override
    public boolean processRemovedModule(DifferentiateContext context, JvmModule removedModule, Utils future, Utils present) {
        this.affectDependentModules(context, present, removedModule, true, null);
        return true;
    }

    @Override
    public boolean processChangedModule(DifferentiateContext context, Difference.Change<JvmModule, JvmModule.Diff> change, Utils future, Utils present) {
        JvmModule changedModule = change.getPast();
        JvmModule.Diff diff = change.getDiff();
        boolean affectSelf = false;
        boolean affectDeps = false;
        HashSet constraintPackageNames = new HashSet();
        if (diff.versionChanged()) {
            String version = changedModule.getVersion();
            Iterator<Difference.Change<ModuleRequires, ModuleRequires.Diff>> moduleName = changedModule.getName();
            this.affectDependentModules(context, present, changedModule, false, arg_0 -> JavaDifferentiateStrategy.lambda$processChangedModule$32((String)((Object)moduleName), version, arg_0));
        }
        Difference.Specifier<ModuleRequires, ModuleRequires.Diff> requiresDiff = diff.requires();
        for (ModuleRequires removedRequires : requiresDiff.removed()) {
            affectSelf = true;
            if (!removedRequires.isTransitive()) continue;
            affectDeps = true;
            break;
        }
        for (Difference.Change<ModuleRequires, ModuleRequires.Diff> rChange : requiresDiff.changed()) {
            affectSelf |= rChange.getDiff().versionChanged();
            if (!rChange.getDiff().becameNonTransitive()) continue;
            affectDeps = true;
        }
        Difference.Specifier<ModulePackage, ModulePackage.Diff> exportsDiff = diff.exports();
        if (!affectDeps && !Iterators.isEmpty(exportsDiff.removed())) {
            affectDeps = true;
            if (Iterators.isEmpty(Iterators.filter(exportsDiff.removed(), modPackage -> !modPackage.isQualified()))) {
                Iterators.collect(Iterators.flat(Iterators.map(exportsDiff.removed(), modPackage -> modPackage.getModules())), constraintPackageNames);
            }
        }
        if (!affectDeps || !constraintPackageNames.isEmpty()) {
            for (Difference.Change<ModulePackage, ModulePackage.Diff> exportChange : exportsDiff.changed()) {
                Iterable<String> removedModuleNames = exportChange.getDiff().targetModules().removed();
                if (!(affectDeps |= !Iterators.isEmpty(removedModuleNames))) continue;
                Iterators.collect(removedModuleNames, constraintPackageNames);
            }
        }
        if (affectSelf && !change.getNow().isLibrary()) {
            this.affectModule(context, present, changedModule);
        }
        if (affectDeps) {
            this.affectDependentModules(context, present, changedModule, true, constraintPackageNames.isEmpty() ? null : node -> node instanceof JvmModule && constraintPackageNames.contains(((JvmModule)node).getName()));
        }
        return true;
    }

    @Override
    public boolean processNodesWithErrors(DifferentiateContext context, Iterable<JVMClassNode<?, ?>> nodes, Utils present) {
        for (JvmClass jvmClass : Graph.getNodesOfType(nodes, JvmClass.class)) {
            for (JvmField field : Iterators.filter(jvmClass.getFields(), f -> !f.isPrivate() && f.isInlinable() && f.getValue() != null)) {
                if (context.getParams().isProcessConstantsIncrementally()) {
                    this.debug(context, "Potentially inlined field is contained in a source compiled with errors => affecting field usages and static member import usages");
                    Set<JvmNodeReferenceID> propagated = present.collectSubclassesWithoutField(jvmClass.getReferenceID(), field);
                    this.affectMemberUsages(context, jvmClass.getReferenceID(), field, propagated);
                    this.affectStaticMemberImportUsages(context, jvmClass.getReferenceID(), field.getName(), propagated);
                    continue;
                }
                this.debug(context, "Potentially inlined field is contained in a source compiled with errors => a switch to non-incremental mode requested");
                if (this.affectOnNonIncrementalChange(context, jvmClass.getReferenceID(), field, present)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean affectOnNonIncrementalChange(DifferentiateContext context, JvmNodeReferenceID owner, Proto proto, Utils utils) {
        if (proto.isPublic()) {
            this.debug(context, "Public access, switching to a non-incremental mode");
            return false;
        }
        if (proto.isProtected()) {
            this.debug(context, "Protected access, softening non-incremental decision: adding all relevant subclasses for a recompilation");
            this.debug(context, "Root class: ", owner);
            for (ReferenceID id2 : proto instanceof JvmField ? utils.collectSubclassesWithoutField(owner, (JvmField)proto) : utils.allSubclasses(owner)) {
                this.affectNodeSources(context, id2, "Adding ", utils);
            }
        }
        String packageName = JvmClass.getPackageName(owner.getNodeName());
        this.debug(context, "Softening non-incremental decision: adding all package classes for a recompilation");
        this.debug(context, "Package name: ", packageName);
        for (ReferenceID nodeWithinPackage : Iterators.filter(context.getGraph().getRegisteredNodes(), id -> id instanceof JvmNodeReferenceID && packageName.equals(JvmClass.getPackageName(((JvmNodeReferenceID)id).getNodeName())))) {
            this.affectNodeSources(context, nodeWithinPackage, "Adding ", utils);
        }
        return true;
    }

    private void affectModule(DifferentiateContext context, Utils utils, JvmModule mod) {
        this.debug(context, "Affecting module ", mod.getName());
        for (NodeSource source : utils.getNodeSources(mod.getReferenceID())) {
            context.affectNodeSource(source);
            this.debug(context, "Affected source ", source);
        }
    }

    public void affectDependentModules(DifferentiateContext context, Utils utils, JvmModule fromModule, boolean checkTransitive, @Nullable Predicate<Node<?, ?>> constraint) {
        List dependent = !checkTransitive ? Collections.emptyList() : Iterators.recurseDepth(fromModule, mod -> Iterators.filter(Iterators.flat(Iterators.map(context.getGraph().getDependingNodes(mod.getReferenceID()), id -> utils.getNodes((ReferenceID)id, JvmModule.class))), m -> m.requiresTransitively(mod.getName())), false);
        for (JvmModule mod2 : Iterators.flat(Iterators.asIterable(fromModule), dependent)) {
            this.debug(context, "Affecting modules depending on module ", mod2.getName());
            ModuleUsage usage = new ModuleUsage(mod2.getReferenceID());
            if (constraint != null) {
                context.affectUsage(usage, constraint);
                continue;
            }
            context.affectUsage(usage);
        }
    }

    private static /* synthetic */ boolean lambda$processChangedModule$32(String moduleName, String version, Node mod) {
        return mod instanceof JvmModule && !Iterators.isEmpty(Iterators.filter(((JvmModule)mod).getRequires(), req -> Objects.equals(moduleName, req.getName()) && Objects.equals(version, req.getVersion())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static /* synthetic */ boolean lambda$processChangedMethods$11(TypeRepr.ClassType annotType, String argName, Node node) {
        Usage usage;
        Iterator<Usage> iterator = node.getUsages().iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!((usage = iterator.next()) instanceof AnnotationUsage));
        AnnotationUsage au = (AnnotationUsage)usage;
        if (!annotType.equals(au.getClassType())) return false;
        if (!Iterators.isEmpty(Iterators.filter(au.getUsedArgNames(), argName::equals))) return false;
        return true;
    }
}

