/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BusyObject {
    @NotNull
    public ActionCallback getReady(@NotNull Object var1);

    public static abstract class Impl
    implements BusyObject {
        private final Map<Object, ActionCallback> myReadyCallbacks = new WeakHashMap<Object, ActionCallback>();

        public abstract boolean isReady();

        public final void onReady() {
            this.onReady(null);
        }

        public final void onReady(@Nullable Object readyRequestor) {
            if (!this.isReady()) {
                return;
            }
            if (readyRequestor == null) {
                for (ActionCallback each : this.getReadyCallbacks()) {
                    each.setDone();
                }
            } else {
                Pair<ActionCallback, List<ActionCallback>> callbacks = this.getReadyCallbacks(readyRequestor);
                ((ActionCallback)callbacks.getFirst()).setDone();
                for (ActionCallback each : (List)callbacks.getSecond()) {
                    each.setRejected();
                }
            }
            this.onReadyWasSent();
        }

        protected void onReadyWasSent() {
        }

        @Override
        @NotNull
        public final ActionCallback getReady(@NotNull Object requestor) {
            if (requestor == null) {
                Impl.$$$reportNull$$$0(0);
            }
            return this.isReady() ? ActionCallback.DONE : this.addReadyCallback(requestor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        private ActionCallback addReadyCallback(Object requestor) {
            Map<Object, ActionCallback> map = this.myReadyCallbacks;
            // MONITORENTER : map
            ActionCallback cb = this.myReadyCallbacks.get(requestor);
            if (cb == null) {
                cb = new ActionCallback();
                this.myReadyCallbacks.put(requestor, cb);
            }
            ActionCallback actionCallback = cb;
            // MONITOREXIT : map
            if (actionCallback != null) return actionCallback;
            Impl.$$$reportNull$$$0(1);
            return actionCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private ActionCallback @NotNull [] getReadyCallbacks() {
            Map<Object, ActionCallback> map = this.myReadyCallbacks;
            // MONITORENTER : map
            ActionCallback[] result = this.myReadyCallbacks.values().toArray(new ActionCallback[0]);
            this.myReadyCallbacks.clear();
            // MONITOREXIT : map
            if (result != null) return result;
            Impl.$$$reportNull$$$0(2);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NotNull
        private Pair<ActionCallback, List<ActionCallback>> getReadyCallbacks(Object readyRequestor) {
            Map<Object, ActionCallback> map = this.myReadyCallbacks;
            // MONITORENTER : map
            ActionCallback done = this.myReadyCallbacks.get(readyRequestor);
            if (done == null) {
                done = new ActionCallback();
            }
            this.myReadyCallbacks.remove(readyRequestor);
            ArrayList<ActionCallback> rejected = new ArrayList<ActionCallback>(this.myReadyCallbacks.values());
            this.myReadyCallbacks.clear();
            Pair pair = new Pair((Object)done, rejected);
            // MONITOREXIT : map
            if (pair != null) return pair;
            Impl.$$$reportNull$$$0(3);
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestor";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/BusyObject$Impl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/BusyObject$Impl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addReadyCallback";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadyCallbacks";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReady";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

