/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.scale.ScaleType;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBCachingScalableIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class OffsetIcon
extends JBCachingScalableIcon<OffsetIcon> {
    public static final int REGULAR_OFFSET = 20;
    private int myWidth;
    private int myHeight;
    private final int myOffset;
    private final Icon myIcon;
    private Icon myScaledIcon;
    private int myScaledOffset;

    @Contract(value="null->null;!null->!null")
    public static Icon getOriginalIcon(Icon icon) {
        return icon instanceof OffsetIcon ? ((OffsetIcon)((Object)icon)).myIcon : icon;
    }

    public OffsetIcon(@NotNull Icon icon) {
        if (icon == null) {
            OffsetIcon.$$$reportNull$$$0(0);
        }
        this(20, icon);
    }

    public OffsetIcon(int offset, @NotNull Icon icon) {
        if (icon == null) {
            OffsetIcon.$$$reportNull$$$0(1);
        }
        this.getScaleContext().addUpdateListener(this::updateSize);
        this.setAutoUpdateScaleContext(false);
        this.myOffset = offset;
        this.myIcon = icon;
        this.updateSize();
    }

    private OffsetIcon(@NotNull OffsetIcon icon) {
        if (icon == null) {
            OffsetIcon.$$$reportNull$$$0(2);
        }
        super((JBCachingScalableIcon)icon);
        this.getScaleContext().addUpdateListener(this::updateSize);
        this.setAutoUpdateScaleContext(false);
        this.myWidth = icon.myWidth;
        this.myHeight = icon.myHeight;
        this.myOffset = icon.myOffset;
        this.myIcon = icon.myIcon;
        this.myScaledIcon = null;
        this.myScaledOffset = icon.myScaledOffset;
    }

    @NotNull
    public OffsetIcon copy() {
        return new OffsetIcon(this);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            OffsetIcon.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @ApiStatus.Internal
    public int getOffset() {
        return this.myOffset;
    }

    public int hashCode() {
        return this.myOffset + this.myIcon.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OffsetIcon) {
            OffsetIcon icon = (OffsetIcon)((Object)obj);
            return icon.myOffset == this.myOffset && Objects.equals(icon.myIcon, this.myIcon);
        }
        return false;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getScaleContext().update();
        if (this.myScaledIcon == null) {
            float scale2 = this.getScale();
            this.myScaledIcon = scale2 == 1.0f ? this.myIcon : IconUtil.scale(this.myIcon, null, scale2);
        }
        this.myScaledIcon.paintIcon(c, g, this.myScaledOffset + x, y);
    }

    public int getIconWidth() {
        this.getScaleContext().update();
        return (int)Math.ceil(this.scaleVal(this.myWidth, ScaleType.OBJ_SCALE)) + this.myScaledOffset;
    }

    public int getIconHeight() {
        this.getScaleContext().update();
        return (int)Math.ceil(this.scaleVal(this.myHeight, ScaleType.OBJ_SCALE));
    }

    private void updateSize() {
        this.myWidth = this.myIcon.getIconWidth();
        this.myHeight = this.myIcon.getIconHeight();
        this.myScaledOffset = (int)Math.ceil(this.scaleVal(this.myOffset));
    }

    public String toString() {
        return "OffsetIcon: offset=" + this.myOffset + "; icon=" + String.valueOf(this.myIcon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/OffsetIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/OffsetIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

